/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.metering;

import com.sap.sse.common.Duration;
import java.util.HashMap;
import java.util.Map;

public interface CPUMetrics {
    public Map<String, Duration> getTotalCPUTimesByKey();

    public Map<String, Duration> getTotalCPUTimesInUserModeByKey();

    default public Duration getTotalCPUTime() {
        Duration result = Duration.NULL;
        for (Duration d : this.getTotalCPUTimesByKey().values()) {
            result = result.plus(d);
        }
        return result;
    }

    default public Duration getTotalCPUTimeInUserMode() {
        Duration result = Duration.NULL;
        for (Duration d : this.getTotalCPUTimesInUserModeByKey().values()) {
            result = result.plus(d);
        }
        return result;
    }

    default public Duration getTotalCPUTimeInSystemMode() {
        return this.getTotalCPUTime().minus(this.getTotalCPUTimeInUserMode());
    }

    default public Map<String, Duration> getTotalCPUTimesInSystemModeByKey() {
        HashMap<String, Duration> result = new HashMap<String, Duration>();
        for (Map.Entry<String, Duration> e : this.getTotalCPUTimesByKey().entrySet()) {
            result.put(e.getKey(), e.getValue().minus(this.getTotalCPUTimeInUserMode(e.getKey())));
        }
        return result;
    }

    default public Duration getTotalCPUTime(String key) {
        return this.getTotalCPUTimesByKey().get(key);
    }

    default public Duration getTotalCPUTimeInUserMode(String key) {
        return this.getTotalCPUTimesInUserModeByKey().get(key);
    }

    default public Duration getTotalCPUTimeInSystemMode(String key) {
        return this.getTotalCPUTime().minus(this.getTotalCPUTimeInUserMode());
    }
}

