/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.landscape.ui.client.LandscapeDialogUtil;
import com.sap.sailing.landscape.ui.client.LandscapeManagementWriteServiceAsync;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sailing.landscape.ui.shared.AvailabilityZoneDTO;
import com.sap.sailing.landscape.ui.shared.ReverseProxyDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CreateReverseProxyInClusterDialog
extends DataEntryDialog<CreateReverseProxyInstructions> {
    private final TextBox proxyName;
    private final ListBox dedicatedInstanceTypeListBox;
    private final ListBox availabilityZoneNameListBox;
    private final Map<String, String> availabilityZoneNameToId;
    private final String region;
    private final Label nameLabel;
    private final Label instanceTypeLabel;
    private final Label availabilityZoneLabel;
    private Label instancesIdLabel;
    private ArrayList<Label> labels;

    public CreateReverseProxyInClusterDialog(final StringMessages stringMessages, ErrorReporter errorReporter, LandscapeManagementWriteServiceAsync landscapeManagementService, String region, List<ReverseProxyDTO> existingReverseProxies, List<AvailabilityZoneDTO> availabilityZones, DataEntryDialog.DialogCallback<CreateReverseProxyInstructions> callback) {
        super(stringMessages.reverseProxies(), stringMessages.reverseProxies(), stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new DataEntryDialog.Validator<CreateReverseProxyInstructions>(){

            public String getErrorMessage(CreateReverseProxyInstructions valueToValidate) {
                if (!Util.hasLength((String)valueToValidate.getName())) {
                    return stringMessages.pleaseProvideNonEmptyNameAndAZ();
                }
                if (valueToValidate.availabilityZoneDTO == null) {
                    return stringMessages.pleaseProvideNonEmptyNameAndAZ();
                }
                return null;
            }
        }, callback);
        this.region = region;
        this.availabilityZoneNameToId = availabilityZones.stream().collect(Collectors.toMap(entry -> entry.getAzName(), entry -> entry.getAzId()));
        this.availabilityZoneNameListBox = this.setupAZChoiceListBox(landscapeManagementService, errorReporter, existingReverseProxies);
        this.proxyName = this.createTextBox("", 20);
        this.proxyName.setValue((Object)"DisposableReverseProxy");
        this.dedicatedInstanceTypeListBox = LandscapeDialogUtil.createInstanceTypeListBox(this, landscapeManagementService, stringMessages, "T3_MEDIUM", errorReporter, true);
        this.nameLabel = new Label(stringMessages.instanceName());
        this.instanceTypeLabel = new Label(stringMessages.instanceType());
        this.availabilityZoneLabel = new Label(stringMessages.availabilityZone());
        this.instancesIdLabel = new Label(stringMessages.instanceId());
        this.labels = new ArrayList(4);
        this.labels.add(this.nameLabel);
        this.labels.add(this.instanceTypeLabel);
        this.labels.add(this.availabilityZoneLabel);
        this.labels.add(this.instancesIdLabel);
        this.instancesIdLabel.setVisible(false);
        this.validateAndUpdate();
    }

    private ListBox setupAZChoiceListBox(LandscapeManagementWriteServiceAsync landscapeManagementService, ErrorReporter errorReporter, List<ReverseProxyDTO> existingReverseProxies) {
        ListBox availabilityZoneBox = this.createListBox(false);
        if (!this.availabilityZoneNameToId.isEmpty()) {
            Map<String, Long> azCounts = existingReverseProxies.stream().collect(Collectors.groupingBy(w -> w.getAvailabilityZoneName(), Collectors.counting()));
            this.availabilityZoneNameToId.keySet().forEach(azName -> {
                Long l = azCounts.merge((String)azName, 0L, (a, b) -> a + b);
            });
            String leastPopulatedAzName = (String)((Map.Entry)azCounts.entrySet().stream().min((a, b) -> Long.compare((Long)a.getValue(), (Long)b.getValue())).get()).getKey();
            int i = 0;
            for (String az : this.availabilityZoneNameToId.keySet().stream().sorted().collect(Collectors.toList())) {
                availabilityZoneBox.addItem(az, az);
                if (az.equals(leastPopulatedAzName)) {
                    availabilityZoneBox.setSelectedIndex(i);
                }
                ++i;
            }
        }
        return availabilityZoneBox;
    }

    protected Widget getAdditionalWidget() {
        FormPanel result = new FormPanel();
        VerticalPanel verticalPanel = new VerticalPanel();
        result.add((Widget)verticalPanel);
        verticalPanel.add((Widget)this.nameLabel);
        verticalPanel.add((Widget)this.proxyName);
        verticalPanel.add((Widget)this.instanceTypeLabel);
        verticalPanel.add((Widget)this.dedicatedInstanceTypeListBox);
        verticalPanel.add((Widget)this.availabilityZoneLabel);
        verticalPanel.add((Widget)this.availabilityZoneNameListBox);
        return result;
    }

    protected Focusable getInitialFocusWidget() {
        return this.proxyName;
    }

    protected CreateReverseProxyInstructions getResult() {
        return new CreateReverseProxyInstructions(this.proxyName.getValue(), this.dedicatedInstanceTypeListBox.getSelectedValue(), this.region, new AvailabilityZoneDTO(this.availabilityZoneNameListBox.getSelectedValue(), this.region, this.availabilityZoneNameToId.get(this.availabilityZoneNameListBox.getSelectedValue())));
    }

    public static class CreateReverseProxyInstructions
    implements IsSerializable {
        private final String instanceType;
        private final String name;
        private final String region;
        private String keyName;
        private final AvailabilityZoneDTO availabilityZoneDTO;

        public CreateReverseProxyInstructions(String name, String instanceType, String region, AvailabilityZoneDTO availabilityZoneDTO) {
            this.name = name;
            this.instanceType = instanceType;
            this.region = region;
            this.availabilityZoneDTO = availabilityZoneDTO;
        }

        public String getName() {
            return this.name;
        }

        public String getInstanceType() {
            return this.instanceType;
        }

        public String getRegion() {
            return this.region;
        }

        public String getKey() {
            return this.keyName;
        }

        public void setKey(String key) {
            this.keyName = key;
        }

        public AvailabilityZoneDTO getAvailabilityZoneDTO() {
            return this.availabilityZoneDTO;
        }
    }
}

