/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.xrr.resultimport.impl;

import com.sap.sailing.domain.resultimport.ResultUrlProvider;
import com.sap.sailing.resultimport.ResultDocumentDescriptor;
import com.sap.sailing.resultimport.ResultDocumentProvider;
import com.sap.sailing.xrr.resultimport.Parser;
import com.sap.sailing.xrr.resultimport.ParserFactory;
import com.sap.sailing.xrr.schema.RegattaResults;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class UrlBasedXRRResultDocumentProvider
implements ResultDocumentProvider {
    private static final Logger logger = Logger.getLogger(UrlBasedXRRResultDocumentProvider.class.getName());
    private final ResultUrlProvider resultUrlProvider;
    private final ParserFactory parserFactory;

    public UrlBasedXRRResultDocumentProvider(ResultUrlProvider resultUrlProvider, ParserFactory parserFactory) {
        this.resultUrlProvider = resultUrlProvider;
        this.parserFactory = parserFactory;
    }

    public Iterable<ResultDocumentDescriptor> getResultDocumentDescriptors() throws IOException, SAXException, ParserConfigurationException {
        ArrayList<ResultDocumentDescriptor> result = new ArrayList<ResultDocumentDescriptor>();
        for (URL url : this.resultUrlProvider.getReadableUrls()) {
            URLConnection eventResultConn = HttpUrlConnectionHelper.redirectConnection((URL)url);
            InputStream is = (InputStream)eventResultConn.getContent();
            Parser parser = this.parserFactory.createParser(is, url.toString());
            try {
                List<ResultDocumentDescriptor> resultDocumentDescriptors;
                RegattaResults xrrParserResult = parser.parse();
                if (xrrParserResult == null || (resultDocumentDescriptors = this.resolveResultDocumentDescriptors(xrrParserResult, url)) == null) continue;
                result.addAll(resultDocumentDescriptors);
            }
            catch (JAXBException e) {
                logger.severe("Could not parse XRR document from URL: " + url.toString());
                e.printStackTrace();
            }
        }
        return result;
    }

    public abstract List<ResultDocumentDescriptor> resolveResultDocumentDescriptors(RegattaResults var1, URL var2);
}

