/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.freg.resultimport.impl;

import com.sap.sailing.resultimport.CompetitorEntry;
import com.sap.sailing.resultimport.CompetitorRow;
import com.sap.sailing.resultimport.RegattaResults;
import com.sap.sailing.resultimport.impl.CompetitorRowImpl;
import com.sap.sailing.resultimport.impl.DefaultCompetitorEntryImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FregHtmlParser {
    private static final Logger logger = Logger.getLogger(FregHtmlParser.class.getName());

    public List<String> getRowContents(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        Pattern tr = Pattern.compile("<(tr|TR)([^<>]*)>");
        Pattern slashTr = Pattern.compile("</(tr|TR)([^<>]*)>");
        boolean inTr = false;
        StringBuilder trContents = new StringBuilder();
        ArrayList<String> tableRows = new ArrayList<String>();
        String readLine = br.readLine();
        int start = 0;
        int end = 0;
        while (readLine != null) {
            if (!inTr) {
                Matcher trMatcher = tr.matcher(readLine);
                boolean foundTr = trMatcher.find(end);
                if (foundTr) {
                    start = trMatcher.end(0);
                    inTr = true;
                    continue;
                }
                readLine = br.readLine();
                end = 0;
                continue;
            }
            Matcher slashTrMatcher = slashTr.matcher(readLine);
            boolean foundSlashTr = slashTrMatcher.find(start);
            if (foundSlashTr) {
                end = slashTrMatcher.start();
                inTr = false;
            } else {
                end = readLine.length();
            }
            trContents.append(readLine.substring(start, end));
            if (!foundSlashTr) {
                trContents.append('\n');
                readLine = br.readLine();
                start = 0;
                continue;
            }
            tableRows.add(trContents.toString());
            trContents.delete(0, trContents.length());
        }
        return tableRows;
    }

    public List<String> getTagContents(String s, String tag) {
        Pattern tagPattern = Pattern.compile("<(" + tag.toLowerCase() + "|" + tag.toUpperCase() + ")([^<>]*)>");
        Pattern slashTag = Pattern.compile("</(" + tag.toLowerCase() + "|" + tag.toUpperCase() + ")([^<>]*)>");
        boolean inTag = false;
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int end = 0;
        boolean finished = false;
        while (!finished) {
            if (!inTag) {
                Matcher tagMatcher = tagPattern.matcher(s);
                boolean foundTag = tagMatcher.find(end);
                if (foundTag) {
                    start = tagMatcher.end(0);
                    inTag = true;
                    continue;
                }
                finished = true;
                continue;
            }
            Matcher slashTagMatcher = slashTag.matcher(s);
            boolean foundSlashTag = slashTagMatcher.find(start);
            if (foundSlashTag) {
                end = slashTagMatcher.start();
                inTag = false;
                result.add(s.substring(start, end).trim());
                continue;
            }
            result.add(s.substring(start).trim());
            finished = true;
            logger.warning("unclosed " + tag + " tag in string \"" + s + "\"");
        }
        return result;
    }

    public RegattaResults getRegattaResults(InputStream is) throws IOException {
        try {
            final ArrayList<CompetitorRow> result = new ArrayList<CompetitorRow>();
            List<String> rowContents = this.getRowContents(is);
            is.close();
            final HashMap<String, String> metadata = new HashMap<String, String>();
            List<String> tagContents = this.getTagContents(rowContents.get(0), "b");
            int j = 1;
            for (String metaInfo : tagContents) {
                metadata.put("info" + j++, metaInfo);
            }
            int i = 2;
            while (i < rowContents.size() - 1) {
                List<String> tdContent = this.getTagContents(rowContents.get(i), "td");
                result.add(this.createCompetitorRow(tdContent));
                ++i;
            }
            RegattaResults regattaResults = new RegattaResults(){

                public Map<String, String> getMetadata() {
                    return metadata;
                }

                public List<CompetitorRow> getCompetitorResults() {
                    return result;
                }
            };
            return regattaResults;
        }
        finally {
            is.close();
        }
    }

    private CompetitorRow createCompetitorRow(List<String> tdContent) {
        List<String> bold = this.getTagContents(tdContent.get(0), "b");
        Integer totalRank = bold != null && !bold.isEmpty() ? this.getInt(bold.get(0).trim()) : this.getInt(tdContent.get(0).trim());
        String sailID = this.getSailID(tdContent.get(1).trim()).replace("&nbsp;", " ").trim();
        List<String> names = this.getNames(tdContent.get(2).trim());
        Double scoreAfterDiscarding = this.getScore(tdContent.get(3).trim());
        Double totalPointsBeforeDiscarding = this.getScore(tdContent.get(4).trim());
        ArrayList<CompetitorEntry> rankAndMaxPointsReasonAndPointsAndDiscarded = new ArrayList<CompetitorEntry>();
        int i = 5;
        while (i < tdContent.size() - 1) {
            CompetitorEntry rankAndMaxPointsReasonAndPointsAndDiscardedForOnceRace = this.getRankAndMaxPointsReasonAndPointsAndDiscardedForOnceRace(tdContent.get(i).trim());
            rankAndMaxPointsReasonAndPointsAndDiscarded.add(rankAndMaxPointsReasonAndPointsAndDiscardedForOnceRace);
            ++i;
        }
        return new CompetitorRowImpl(totalRank, sailID, names, scoreAfterDiscarding, totalPointsBeforeDiscarding, rankAndMaxPointsReasonAndPointsAndDiscarded);
    }

    private CompetitorEntry getRankAndMaxPointsReasonAndPointsAndDiscardedForOnceRace(String cell) {
        String maxPointsReason;
        Integer rank;
        boolean isDiscarded;
        String results;
        List<String> discarded = this.getTagContents(cell = cell.replace("&nbsp;", ""), "strike");
        if (discarded.isEmpty()) {
            List<String> colorized = this.getTagContents(cell, "span");
            results = colorized.isEmpty() ? cell : colorized.get(0);
            isDiscarded = false;
        } else {
            results = discarded.get(0);
            isDiscarded = true;
        }
        String[] lines = results.split("<(br|BR)>");
        try {
            rank = Integer.valueOf(lines[0]);
            maxPointsReason = null;
        }
        catch (NumberFormatException nfe) {
            rank = null;
            maxPointsReason = lines.length == 0 || lines[0].trim().length() == 0 || lines[0].trim().contains("--") ? "DNC" : lines[0];
        }
        Double points = lines.length < 2 ? null : Double.valueOf(this.getTagContents(lines[1], "i").get(0));
        return new DefaultCompetitorEntryImpl(rank, maxPointsReason, points, isDiscarded);
    }

    private Double getScore(String cell) {
        List<String> boldScore = this.getTagContents(cell, "b");
        String scoreAsString = boldScore.isEmpty() ? cell.trim() : boldScore.get(0);
        return Double.valueOf(scoreAsString);
    }

    private List<String> getNames(String cell) {
        List<String> pContentsList = this.getTagContents(cell, "p");
        String pContents = pContentsList.isEmpty() ? cell : pContentsList.get(0);
        List<String> names = this.getTagContents(pContents, "span");
        ArrayList<String> result = new ArrayList<String>(names.size());
        for (String name : names) {
            result.add(name.replace("&nbsp;", " ").trim());
        }
        return result;
    }

    private String getSailID(String cell) {
        String imgAndSailID = this.getTagContents(cell, "p").get(0);
        String sailID = this.getTagContents(String.valueOf(imgAndSailID) + "</img>", "img").get(0);
        return sailID;
    }

    private Integer getInt(String cell) {
        Integer result;
        try {
            result = Integer.valueOf(cell);
        }
        catch (NumberFormatException nfe) {
            List<String> contents = this.getTagContents(cell, "b");
            result = !contents.isEmpty() ? Integer.valueOf(contents.get(0)) : null;
        }
        return result;
    }
}

