/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.yellowbrickadapter.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogCourseDesignChangedEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.impl.BaseRaceLogEventVisitor;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.impl.CourseImpl;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitorWithBoat;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.domain.base.impl.PersonImpl;
import com.sap.sailing.domain.base.impl.TeamImpl;
import com.sap.sailing.domain.common.BoatClassMasterdata;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.leaderboard.LeaderboardGroupResolver;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprintRegistry;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.shared.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.shared.tracking.impl.TrackingConnectorInfoImpl;
import com.sap.sailing.domain.tracking.AbstractRaceTrackerImpl;
import com.sap.sailing.domain.tracking.DynamicRaceDefinitionSet;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.RaceChangeListener;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.RaceTracker;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.TrackingDataLoader;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sailing.domain.tracking.impl.TrackedRaceStatusImpl;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickRace;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickRaceTrackingConnectivityParams;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickTrackingAdapter;
import com.sap.sailing.domain.yellowbrickadapter.impl.PositionsDocument;
import com.sap.sailing.domain.yellowbrickadapter.impl.TeamPosition;
import com.sap.sailing.domain.yellowbrickadapter.impl.TeamPositions;
import com.sap.sailing.domain.yellowbrickadapter.impl.YellowBrickTrackingAdapterImpl;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.parser.ParseException;

public class YellowBrickRaceTrackerImpl
extends AbstractRaceTrackerImpl<YellowBrickRaceTrackingConnectivityParams>
implements TrackingDataLoader {
    private static final Logger logger = Logger.getLogger(YellowBrickRaceTrackerImpl.class.getName());
    private static final Duration STOP_AFTER_NOT_RECEIVING_NEW_FIXES_FOR_THIS_LONG = Duration.ONE_DAY;
    private final String DEFAULT_REGATTA_NAME_PREFIX = "YellowBrick ";
    private final Regatta regatta;
    private final RaceDefinition race;
    private final WindStore windStore;
    private final TrackedRegattaRegistry trackedRegattaRegistry;
    private final YellowBrickTrackingAdapter trackingAdapter;
    private final DynamicTrackedRace trackedRace;
    private final Map<RaceLog, RaceLogEventVisitor> visitors = new HashMap<RaceLog, RaceLogEventVisitor>();
    private volatile boolean stop;
    private final Map<Integer, TimePoint> timePointOfLastFixPerDeviceSerialNumber = new HashMap<Integer, TimePoint>();
    private final Map<Integer, Competitor> competitorByDeviceSerialNumber = new HashMap<Integer, Competitor>();

    public YellowBrickRaceTrackerImpl(YellowBrickRaceTrackingConnectivityParams connectivityParams, Regatta regatta, TrackedRegattaRegistry trackedRegattaRegistry, WindStore windStore, RaceLogAndTrackedRaceResolver raceLogResolver, LeaderboardGroupResolver leaderboardGroupResolver, long timeoutInMilliseconds, RaceTrackingHandler raceTrackingHandler, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, DomainFactory baseDomainFactory, YellowBrickTrackingAdapter yellowBrickTrackingAdapter, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry, ManeuverRaceFingerprintRegistry maneuverRaceFingerprintRegistry) throws IOException, ParseException {
        super((RaceTrackingConnectivityParameters)connectivityParams);
        this.trackingAdapter = yellowBrickTrackingAdapter;
        this.windStore = windStore;
        this.trackedRegattaRegistry = trackedRegattaRegistry;
        this.regatta = this.getOrCreateEffectiveRegatta("YellowBrick " + connectivityParams.getRaceUrl(), trackedRegattaRegistry, regatta);
        this.race = this.createRaceDefinition(this.regatta, yellowBrickTrackingAdapter, raceTrackingHandler, baseDomainFactory.getCompetitorAndBoatStore());
        this.trackedRace = raceTrackingHandler.createTrackedRace((TrackedRegatta)this.getTrackedRegatta(), this.race, Collections.emptyList(), windStore, ((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getDelayToLiveInMillis(), 30000L, this.race.getBoatClass().getApproximateManeuverDurationInMilliseconds(), new DynamicRaceDefinitionSet(){

            public void addRaceDefinition(RaceDefinition race, DynamicTrackedRace trackedRace) {
                if (!$assertionsDisabled && YellowBrickRaceTrackerImpl.this.race != race) {
                    throw new AssertionError();
                }
            }
        }, true, raceLogResolver, Optional.empty(), (TrackingConnectorInfo)new TrackingConnectorInfoImpl("YellowBrick", "https://www.ybtracking.com/", null), markPassingRaceFingerprintRegistry, maneuverRaceFingerprintRegistry);
        this.addRaceLogListenerForCourseUpdates();
        this.loadStoredData();
        this.schedulePeriodicPollingTask();
    }

    private void addRaceLogListenerForCourseUpdates() {
        for (RaceLog raceLog : this.trackedRace.getAttachedRaceLogs()) {
            this.createAndAddRaceLogListenerForCourseChanges(raceLog);
        }
        this.trackedRace.addListener((RaceChangeListener)new AbstractRaceChangeListener(){

            public void raceLogAttached(RaceLog raceLog) {
                YellowBrickRaceTrackerImpl.this.createAndAddRaceLogListenerForCourseChanges(raceLog);
            }

            public void raceLogDetached(RaceLog raceLog) {
                raceLog.removeListener((Object)((RaceLogEventVisitor)YellowBrickRaceTrackerImpl.this.visitors.remove(raceLog)));
            }
        });
    }

    private void createAndAddRaceLogListenerForCourseChanges(final RaceLog raceLog) {
        BaseRaceLogEventVisitor visitor = new BaseRaceLogEventVisitor(){

            public void visit(RaceLogCourseDesignChangedEvent event) {
                YellowBrickRaceTrackerImpl.this.onCourseDesignChangedEvent(event, raceLog, ((YellowBrickRaceTrackingConnectivityParams)YellowBrickRaceTrackerImpl.this.getConnectivityParams()).getBaseDomainFactory(), (TrackedRace)YellowBrickRaceTrackerImpl.this.trackedRace);
            }
        };
        this.visitors.put(raceLog, (RaceLogEventVisitor)visitor);
        raceLog.addListener((Object)visitor);
        raceLog.lockForRead();
        try {
            for (RaceLogEvent e : raceLog.getFixes()) {
                e.accept((Object)visitor);
            }
        }
        finally {
            raceLog.unlockAfterRead();
        }
    }

    private void loadStoredData() throws MalformedURLException, IOException, ParseException {
        this.trackedRace.onStatusChanged((TrackingDataLoader)this, (TrackedRaceStatus)new TrackedRaceStatusImpl(TrackedRaceStatusEnum.LOADING, 0.0));
        PositionsDocument storedData = this.trackingAdapter.getStoredData(((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getRaceUrl(), Optional.ofNullable(((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getUsername()), Optional.ofNullable(((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getPassword()));
        this.insertFixesIntoTrackedRace(storedData, Optional.of(progress -> this.trackedRace.onStatusChanged((TrackingDataLoader)this, (TrackedRaceStatus)new TrackedRaceStatusImpl(TrackedRaceStatusEnum.LOADING, progress.doubleValue()))));
        this.trackedRace.onStatusChanged((TrackingDataLoader)this, (TrackedRaceStatus)new TrackedRaceStatusImpl(TrackedRaceStatusEnum.TRACKING, 1.0));
    }

    private void insertFixesIntoTrackedRace(PositionsDocument storedData, Optional<Consumer<Double>> progressCallback) {
        int numberOfTeams = Util.size(storedData.getTeams());
        int[] i = new int[1];
        for (TeamPositions teamPositions : storedData.getTeams()) {
            progressCallback.ifPresent(cb -> {
                int n2 = i[0];
                nArray[0] = n2 + 1;
                cb.accept((double)n2 / (double)numberOfTeams);
            });
            for (TeamPosition position : teamPositions.getPositions()) {
                GPSFixMovingImpl fix = new GPSFixMovingImpl(position.getPosition(), position.getTimePoint(), position.getMotionVector(), null);
                int deviceSerialNumber = teamPositions.getDeviceSerialNumber();
                this.trackedRace.getTrack(this.competitorByDeviceSerialNumber.get(deviceSerialNumber)).add((Timed)fix);
                this.updateTimePointOfLastFixPerDeviceSerialNumber(deviceSerialNumber, position.getTimePoint());
                this.updateStartOfTrackingToEarliestTimePoint(position.getTimePoint());
            }
        }
    }

    private void updateStartOfTrackingToEarliestTimePoint(TimePoint timePoint) {
        if (this.trackedRace.getStartOfTracking() == null || this.trackedRace.getStartOfTracking().after(timePoint)) {
            this.trackedRace.setStartOfTrackingReceived(timePoint);
        }
    }

    private void updateTimePointOfLastFixPerDeviceSerialNumber(int deviceSerialNumber, TimePoint timePoint) {
        this.timePointOfLastFixPerDeviceSerialNumber.compute(deviceSerialNumber, (serial, oldLastFixTimePoint) -> oldLastFixTimePoint == null ? timePoint : (timePoint.after(oldLastFixTimePoint) ? timePoint : oldLastFixTimePoint));
    }

    private void schedulePeriodicPollingTask() {
        logger.info("Scheduling regular polling at interval " + YellowBrickTrackingAdapterImpl.DEFAULT_POLLING_INTERVAL + " for YB race " + ((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getRaceUrl());
        ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor().scheduleAtFixedRate(this::pollNewPositions, YellowBrickTrackingAdapterImpl.DEFAULT_POLLING_INTERVAL.asMillis(), YellowBrickTrackingAdapterImpl.DEFAULT_POLLING_INTERVAL.asMillis(), TimeUnit.MILLISECONDS);
    }

    private void pollNewPositions() {
        if (this.stop) {
            logger.info("Terminating polling for YB race " + ((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getRaceUrl() + " upon explicit request.");
            throw new RuntimeException("Terminated");
        }
        TimePoint timePointStartingFromWhichToPoll = this.computeBestTimePointSinceWhichToPollForNewPositions();
        if (timePointStartingFromWhichToPoll.plus(STOP_AFTER_NOT_RECEIVING_NEW_FIXES_FOR_THIS_LONG).before(TimePoint.now())) {
            logger.info("Terminating polling for YB race " + ((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getRaceUrl() + " because we would ask for more than " + STOP_AFTER_NOT_RECEIVING_NEW_FIXES_FOR_THIS_LONG + " worth of data.");
        }
        logger.info("Polling YB fixes for race " + ((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getRaceUrl() + " since " + timePointStartingFromWhichToPoll);
        try {
            PositionsDocument storedData = this.trackingAdapter.getPositionsSince(((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getRaceUrl(), timePointStartingFromWhichToPoll, Optional.ofNullable(((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getUsername()), Optional.ofNullable(((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getPassword()));
            logger.fine(() -> "Obtained " + storedData.getNumberOfFixes() + " fixes for " + Util.size(storedData.getTeams()) + " teams");
            this.insertFixesIntoTrackedRace(storedData, Optional.empty());
        }
        catch (IOException | ParseException e) {
            logger.log(Level.SEVERE, "Fetching YB positions for race " + ((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getRaceUrl() + " failed. Keeping trying.", e);
        }
    }

    private TimePoint computeBestTimePointSinceWhichToPollForNewPositions() {
        long sum = 0L;
        int count = 0;
        for (TimePoint lastTimePointOfTeam : this.timePointOfLastFixPerDeviceSerialNumber.values()) {
            sum += lastTimePointOfTeam.asMillis();
            ++count;
        }
        return TimePoint.of((long)(sum / (long)count));
    }

    protected void onStop(boolean preemptive, boolean willBeRemoved) throws MalformedURLException, IOException, InterruptedException {
        logger.info("Stopping tracking for YB race " + ((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getRaceUrl());
        this.stop = true;
        double oldLoadingProgress = this.trackedRace.getStatus().getLoadingProgress();
        this.trackedRace.onStatusChanged((TrackingDataLoader)this, (TrackedRaceStatus)new TrackedRaceStatusImpl(TrackedRaceStatusEnum.FINISHED, oldLoadingProgress));
        for (Map.Entry<RaceLog, RaceLogEventVisitor> e : this.visitors.entrySet()) {
            e.getKey().removeListener((Object)e.getValue());
        }
    }

    private RaceDefinition createRaceDefinition(Regatta regatta, YellowBrickTrackingAdapter yellowBrickTrackingAdapter, RaceTrackingHandler raceTrackingHandler, CompetitorAndBoatStore competitorAndBoatStore) throws IOException, ParseException {
        CourseImpl domainCourse = new CourseImpl("Course for " + this.getRegatta().getName(), Collections.emptySet());
        Map<Competitor, Boat> competitorsAndBoats = this.createCompetitorsAndBoats(yellowBrickTrackingAdapter, regatta.getBoatClass(), raceTrackingHandler, competitorAndBoatStore);
        logger.info("Creating RaceDefinitionImpl for YellowBrick race " + ((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getRaceUrl());
        RaceDefinition result = raceTrackingHandler.createRaceDefinition(regatta, ((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getRaceUrl(), (Course)domainCourse, regatta.getBoatClass(), competitorsAndBoats, this.getRaceId());
        regatta.addRace(result);
        return result;
    }

    private Map<Competitor, Boat> createCompetitorsAndBoats(YellowBrickTrackingAdapter yellowBrickTrackingAdapter, BoatClass boatClass, RaceTrackingHandler raceTrackingHandler, CompetitorAndBoatStore competitorAndBoatStore) throws IOException, ParseException {
        HashMap<Competitor, Boat> result = new HashMap<Competitor, Boat>();
        YellowBrickRace raceMetadata = yellowBrickTrackingAdapter.getRaceMetadata(((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getRaceUrl(), Optional.ofNullable(((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getUsername()), Optional.ofNullable(((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getPassword()));
        for (TeamPositions teamPositions : raceMetadata.getTeamsPositions()) {
            String competitorId = YellowBrickTrackingAdapter.getCompetitorId(teamPositions.getCompetitorName(), ((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getRaceUrl());
            String boatId = YellowBrickTrackingAdapter.getBoatId(teamPositions.getCompetitorName());
            ArrayList<PersonImpl> teamMembers = new ArrayList<PersonImpl>();
            String[] stringArray = teamPositions.getCompetitorName().split("[-+&]");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String teamMemberName = stringArray[n2];
                teamMembers.add(new PersonImpl(teamMemberName.trim(), null, null, teamMemberName.trim()));
                ++n2;
            }
            TeamImpl team = new TeamImpl(teamPositions.getCompetitorName(), teamMembers, null);
            DynamicBoat boat = raceTrackingHandler.getOrCreateBoat(competitorAndBoatStore, (Serializable)((Object)boatId), teamPositions.getCompetitorName(), boatClass, competitorId, null);
            DynamicCompetitorWithBoat competitor = raceTrackingHandler.getOrCreateCompetitorWithBoat(competitorAndBoatStore, (Serializable)((Object)competitorId), teamPositions.getCompetitorName(), null, null, null, null, (DynamicTeam)team, Double.valueOf(1.0), Duration.NULL, null, boat);
            result.put((Competitor)competitor, (Boat)competitor.getBoat());
            this.competitorByDeviceSerialNumber.put(teamPositions.getDeviceSerialNumber(), (Competitor)competitor);
        }
        return result;
    }

    private Serializable getRaceId() {
        return "YB-" + ((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getRaceUrl();
    }

    private Regatta getOrCreateEffectiveRegatta(String name, TrackedRegattaRegistry trackedRegattaRegistry, Regatta regatta) {
        Regatta rememberedRegattaForRaceId;
        Regatta result = regatta != null ? regatta : ((rememberedRegattaForRaceId = trackedRegattaRegistry.getRememberedRegattaForRace(this.getRaceId())) == null ? trackedRegattaRegistry.getOrCreateDefaultRegatta(name, BoatClassMasterdata.IRC.name(), (Serializable)UUID.randomUUID()) : rememberedRegattaForRaceId);
        return result;
    }

    public Regatta getRegatta() {
        return this.regatta;
    }

    public RaceDefinition getRace() {
        return this.race;
    }

    public RaceHandle getRaceHandle() {
        return new RaceHandle(){

            public DynamicTrackedRegatta getTrackedRegatta() {
                return YellowBrickRaceTrackerImpl.this.getTrackedRegatta();
            }

            public Regatta getRegatta() {
                return YellowBrickRaceTrackerImpl.this.regatta;
            }

            public RaceTracker getRaceTracker() {
                return YellowBrickRaceTrackerImpl.this;
            }

            public RaceDefinition getRace(long timeoutInMilliseconds) {
                return YellowBrickRaceTrackerImpl.this.race;
            }

            public RaceDefinition getRace() {
                return YellowBrickRaceTrackerImpl.this.race;
            }
        };
    }

    public DynamicTrackedRegatta getTrackedRegatta() {
        return this.trackedRegattaRegistry.getOrCreateTrackedRegatta(this.regatta);
    }

    public WindStore getWindStore() {
        return this.windStore;
    }

    public Object getID() {
        return new Util.Pair((Object)"YellowBrick", (Object)((YellowBrickRaceTrackingConnectivityParams)this.getConnectivityParams()).getRaceUrl());
    }
}

