/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared.databylogo;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.shared.TrackingConnectorInfoDTO;
import com.sap.sailing.gwt.ui.shared.databylogo.DataByLogo;
import com.sap.sailing.gwt.ui.shared.databylogo.DataByLogoResources;
import com.sap.sse.gwt.shared.ClientConfiguration;
import java.util.Set;

public class DataByLogo
extends Widget {
    private static DataByLogoUiBinder uiBinder = (DataByLogoUiBinder)GWT.create(DataByLogoUiBinder.class);
    @UiField
    AnchorElement dataByContainer;
    @UiField
    ImageElement logo;

    public DataByLogo() {
        DataByLogoResources.INSTANCE.css().ensureInjected();
        this.setElement((Element)uiBinder.createAndBindUi((Object)this));
        if (!ClientConfiguration.getInstance().isBrandingActive()) {
            this.dataByContainer.getStyle().setDisplay(Style.Display.NONE);
        }
        this.dataByContainer.setAttribute("selenium-id", "dataByContainer");
    }

    public void setUp(Set<TrackingConnectorInfoDTO> trackingConnectorInfos, boolean colorIfPossible, boolean enforceTextColor) {
        if (ClientConfiguration.getInstance().isBrandingActive()) {
            TrackingConnectorInfoDTO mostProminentConnectorInfo = this.selectMostProminentConnectorInfo(trackingConnectorInfos);
            if (mostProminentConnectorInfo == null) {
                this.setVisible(false);
            } else {
                this.setUpForConnectorType(colorIfPossible, enforceTextColor, mostProminentConnectorInfo);
            }
        }
    }

    private TrackingConnectorInfoDTO selectMostProminentConnectorInfo(Set<TrackingConnectorInfoDTO> trackingConnectorInfos) {
        TrackingConnectorInfoDTO potentialConnectorInfo = null;
        if (trackingConnectorInfos != null && !trackingConnectorInfos.isEmpty()) {
            for (TrackingConnectorInfoDTO trackingConnectorInfo : trackingConnectorInfos) {
                if (!trackingConnectorInfo.getTrackingConnectorName().equals("TracTrac") && !trackingConnectorInfo.getTrackingConnectorName().equals("YellowBrick")) continue;
                potentialConnectorInfo = trackingConnectorInfo;
                String webUrl = trackingConnectorInfo.getWebUrl();
                if (webUrl != null && !webUrl.isEmpty()) break;
            }
        }
        return potentialConnectorInfo;
    }

    private void setUpForConnectorType(boolean colorIfPossible, boolean enforceTextColor, TrackingConnectorInfoDTO trackingConnectorInfo) {
        if (trackingConnectorInfo.getTrackingConnectorName().equals("TracTrac")) {
            this.setUpTracTracLogo(colorIfPossible, enforceTextColor);
        } else if (trackingConnectorInfo.getTrackingConnectorName().equals("YellowBrick")) {
            this.setUpYellowBrickLogo(colorIfPossible, enforceTextColor);
        }
        this.setUrl(trackingConnectorInfo);
    }

    private void setUpTracTracLogo(boolean colorIfPossible, boolean enforceTextColor) {
        DataByLogoResources resources = DataByLogoResources.INSTANCE;
        DataResource imageToSet = colorIfPossible ? resources.tractracColor() : resources.tractracWhite();
        this.logo.setSrc(imageToSet.getSafeUri().asString());
        if (enforceTextColor) {
            this.addStyleName(colorIfPossible ? resources.css().databylogo_black_text() : resources.css().databylogo_white_text());
        }
    }

    private void setUpYellowBrickLogo(boolean colorIfPossible, boolean enforceTextColor) {
        DataByLogoResources resources = DataByLogoResources.INSTANCE;
        DataResource imageToSet = colorIfPossible ? resources.yellowBrickColor() : resources.yellowBrickWhite();
        this.logo.setSrc(imageToSet.getSafeUri().asString());
        if (enforceTextColor) {
            this.addStyleName(colorIfPossible ? resources.css().databylogo_black_text() : resources.css().databylogo_white_text());
        }
    }

    private void setUrl(TrackingConnectorInfoDTO trackingConnectorInfo) {
        String webUrl;
        String string = webUrl = trackingConnectorInfo.getWebUrl() == null ? trackingConnectorInfo.getTrackingConnectorDefaultUrl() : trackingConnectorInfo.getWebUrl();
        if (webUrl != null) {
            this.dataByContainer.setHref(webUrl);
        }
    }
}

