/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.server;

import com.sap.sailing.gwt.ui.server.StoredDataMiningReportPersister;
import com.sap.sailing.server.impl.preferences.model.StoredDataMiningReportPreference;
import com.sap.sailing.server.impl.preferences.model.StoredDataMiningReportPreferences;
import com.sap.sse.datamining.DataMiningServer;
import com.sap.sse.datamining.shared.dto.DataMiningReportDTO;
import com.sap.sse.datamining.shared.impl.dto.StoredDataMiningReportDTOImpl;
import com.sap.sse.gwt.dispatch.shared.exceptions.ServerDispatchException;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.serialization.Base64SerializerDeserializer;
import com.sap.sse.shared.classloading.JoinedClassLoader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.shiro.authz.AuthorizationException;
import org.osgi.util.tracker.ServiceTracker;

public class StoredDataMiningReportPersisterImpl
implements StoredDataMiningReportPersister {
    private final SecurityService securityService;
    private final ServiceTracker<DataMiningServer, DataMiningServer> dataMiningServerTracker;

    public StoredDataMiningReportPersisterImpl(SecurityService securityService, ServiceTracker<DataMiningServer, DataMiningServer> dataMiningServerTracker) {
        this.securityService = securityService;
        this.dataMiningServerTracker = dataMiningServerTracker;
    }

    public ArrayList<StoredDataMiningReportDTOImpl> getStoredReports() {
        StoredDataMiningReportPreferences reportPreferences = this.getUserPreferences();
        if (reportPreferences == null) {
            return new ArrayList<StoredDataMiningReportDTOImpl>();
        }
        Stream<StoredDataMiningReportPreference> preferenceStream = StreamSupport.stream(reportPreferences.getStoredReports().spliterator(), false);
        return new ArrayList<StoredDataMiningReportDTOImpl>(preferenceStream.map(arg_0 -> this.transform(arg_0)).collect(Collectors.toList()));
    }

    public StoredDataMiningReportDTOImpl updateOrCreateStoredReport(StoredDataMiningReportDTOImpl report) {
        StoredDataMiningReportPreferences reportPreferences = this.getUserPreferences();
        Collection updatedReports = this.filterReport(report, reportPreferences);
        updatedReports.add(this.transform(report));
        StoredDataMiningReportPreferences updatedPreferences = new StoredDataMiningReportPreferences();
        updatedPreferences.setStoredReports((Iterable)updatedReports);
        this.setUserPreferences(updatedPreferences);
        return report;
    }

    public StoredDataMiningReportDTOImpl removeStoredReport(StoredDataMiningReportDTOImpl report) {
        StoredDataMiningReportPreferences reportPreferences = this.getUserPreferences();
        Collection updatedReports = this.filterReport(report, reportPreferences);
        StoredDataMiningReportPreferences updatedPreferences = new StoredDataMiningReportPreferences();
        updatedPreferences.setStoredReports((Iterable)updatedReports);
        this.setUserPreferences(updatedPreferences);
        return report;
    }

    private Collection<StoredDataMiningReportPreference> filterReport(StoredDataMiningReportDTOImpl report, StoredDataMiningReportPreferences prefs) {
        ArrayList<Object> result;
        if (prefs == null) {
            result = new ArrayList<StoredDataMiningReportPreference>();
        } else {
            Stream<StoredDataMiningReportPreference> preferenceStream = StreamSupport.stream(prefs.getStoredReports().spliterator(), false);
            result = new ArrayList(preferenceStream.filter(r -> !r.getId().equals(report.getId())).collect(Collectors.toList()));
        }
        return result;
    }

    private void setUserPreferences(StoredDataMiningReportPreferences preferences) {
        User currentUser = this.securityService.getCurrentUser();
        if (currentUser != null) {
            try {
                this.securityService.setPreferenceObject(currentUser.getName(), "sailing.datamining.storedreports", (Object)preferences);
            }
            catch (AuthorizationException e) {
                throw new ServerDispatchException((Throwable)e);
            }
        }
    }

    private StoredDataMiningReportDTOImpl transform(StoredDataMiningReportPreference pref) {
        JoinedClassLoader joinedClassLoader = ((DataMiningServer)this.dataMiningServerTracker.getService()).getJoinedClassLoader();
        DataMiningReportDTO report = (DataMiningReportDTO)Base64SerializerDeserializer.fromBase64((String)pref.getSerializedReport(), (JoinedClassLoader)joinedClassLoader);
        return new StoredDataMiningReportDTOImpl(pref.getId(), pref.getName(), report);
    }

    private StoredDataMiningReportPreference transform(StoredDataMiningReportDTOImpl dto) {
        String serializedQuery = Base64SerializerDeserializer.toBase64((Serializable)dto.getReport());
        return new StoredDataMiningReportPreference(dto.getName(), dto.getId(), serializedQuery);
    }

    private StoredDataMiningReportPreferences getUserPreferences() {
        User currentUser = this.securityService.getCurrentUser();
        StoredDataMiningReportPreferences result = currentUser != null ? (StoredDataMiningReportPreferences)this.securityService.getPreferenceObject(currentUser.getName(), "sailing.datamining.storedreports") : null;
        return result;
    }
}

