/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.server;

import com.google.gwt.thirdparty.json.JSONArray;
import com.google.gwt.thirdparty.json.JSONException;
import com.google.gwt.thirdparty.json.JSONObject;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.VideoMetadataDTO;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.common.media.MediaTrackWithSecurityDTO;
import com.sap.sailing.gwt.ui.client.MediaService;
import com.sap.sailing.gwt.ui.server.Activator;
import com.sap.sailing.media.mp4.MP4MediaParser;
import com.sap.sailing.media.mp4.MP4ParserFakeFile;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.server.SecurityDTOUtil;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.mp4parser.BoxParser;
import org.mp4parser.IsoFile;
import org.mp4parser.PropertyBoxParserImpl;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.SAXException;

public class MediaServiceImpl
extends RemoteServiceServlet
implements MediaService {
    private static final Logger logger = Logger.getLogger(MediaServiceImpl.class.getName());
    private static final int METADATA_CONNECTION_TIMEOUT = 10000;
    private ServiceTracker<RacingEventService, RacingEventService> racingEventServiceTracker;
    private static final long serialVersionUID = -8917349579281305977L;

    public MediaServiceImpl() {
        BundleContext context = Activator.getDefault();
        this.racingEventServiceTracker = new ServiceTracker(context, RacingEventService.class.getName(), null);
        this.racingEventServiceTracker.open();
    }

    protected RacingEventService racingEventService() {
        return (RacingEventService)this.racingEventServiceTracker.getService();
    }

    public Iterable<MediaTrackWithSecurityDTO> getMediaTracksForRace(RegattaAndRaceIdentifier regattaAndRaceIdentifier) {
        return this.mapMediaTracksToDTOsWithSecurityInformationAndFilterByReadPermission(this.racingEventService().getMediaTracksForRace(regattaAndRaceIdentifier));
    }

    public Iterable<MediaTrackWithSecurityDTO> getMediaTracksInTimeRange(RegattaAndRaceIdentifier regattaAndRaceIdentifier) {
        return this.mapMediaTracksToDTOsWithSecurityInformationAndFilterByReadPermission(this.racingEventService().getMediaTracksInTimeRange(regattaAndRaceIdentifier));
    }

    public Iterable<MediaTrackWithSecurityDTO> getAllMediaTracks() {
        return this.mapMediaTracksToDTOsWithSecurityInformationAndFilterByReadPermission(this.racingEventService().getAllMediaTracks());
    }

    private List<MediaTrackWithSecurityDTO> mapMediaTracksToDTOsWithSecurityInformationAndFilterByReadPermission(Iterable<MediaTrack> mediaTracksToFilter) {
        return this.racingEventService().getSecurityService().mapAndFilterByReadPermissionForCurrentUser(mediaTracksToFilter, mediaTrack -> {
            MediaTrackWithSecurityDTO securedMediaTrack = new MediaTrackWithSecurityDTO(mediaTrack);
            SecurityDTOUtil.addSecurityInformation((SecurityService)this.racingEventService().getSecurityService(), (SecuredDTO)securedMediaTrack);
            return securedMediaTrack;
        });
    }

    public VideoMetadataDTO checkMetadata(String url) {
        VideoMetadataDTO response = null;
        try {
            URL input = new URL(url);
            long fileSize = this.determineFileSize(input);
            response = fileSize > 20000000L ? this.checkMetadataByPartialDownloads(input, fileSize) : this.checkMetadataByFullFileDownload(input);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error in video analysis ", e);
            response = new VideoMetadataDTO(false, null, false, null, "");
        }
        return response;
    }

    private long determineFileSize(URL input) throws IOException, ProtocolException {
        InputStream inStream;
        Object var6_7;
        Throwable throwable;
        HttpURLConnection connection = (HttpURLConnection)input.openConnection();
        connection.setConnectTimeout(10000);
        connection.setRequestMethod("HEAD");
        long fileSize = -1L;
        try {
            throwable = null;
            var6_7 = null;
            try {
                inStream = connection.getInputStream();
                try {
                    fileSize = connection.getContentLengthLong();
                }
                finally {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            connection.disconnect();
        }
        connection = (HttpURLConnection)input.openConnection();
        connection.setConnectTimeout(10000);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Range", "bytes=0-100");
        try {
            throwable = null;
            var6_7 = null;
            try {
                inStream = connection.getInputStream();
                try {
                    if (connection.getResponseCode() != 206) {
                        fileSize = -1L;
                    }
                }
                finally {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            connection.disconnect();
        }
        return fileSize;
    }

    private VideoMetadataDTO checkMetadataByPartialDownloads(URL input, long fileSize) throws IOException, ProtocolException {
        byte[] start = new byte[10000000];
        byte[] end = new byte[10000000];
        this.downloadPartOfFile(input, start, "bytes=0-10000000");
        this.downloadPartOfFile(input, end, "bytes=" + (fileSize - 10000000L) + "-");
        long skipped = fileSize - (long)start.length - (long)end.length;
        return this.checkMetadata(start, end, Long.valueOf(skipped));
    }

    private void downloadPartOfFile(URL input, byte[] store, String range) throws IOException, ProtocolException {
        HttpURLConnection connection = (HttpURLConnection)input.openConnection();
        connection.setConnectTimeout(10000);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Range", range);
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream inStream = connection.getInputStream();){
                Throwable throwable2 = null;
                Object var9_12 = null;
                try (DataInputStream dataInStream = new DataInputStream(inStream);){
                    dataInStream.readFully(store);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            connection.disconnect();
        }
    }

    private VideoMetadataDTO checkMetadataByFullFileDownload(URL input) throws ParserConfigurationException, SAXException, IOException {
        VideoMetadataDTO result;
        File tmp = File.createTempFile("upload", "metadataCheck");
        try {
            Throwable throwable = null;
            Object var5_5 = null;
            try (ReadableByteChannel rbc = Channels.newChannel(input.openStream());){
                try {
                    Throwable throwable2 = null;
                    Object var8_11 = null;
                    try (FileOutputStream fos = new FileOutputStream(tmp);){
                        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                        try {
                            Throwable throwable3 = null;
                            Object var11_17 = null;
                            try (MP4ParserFakeFile inputFile = new MP4ParserFakeFile(tmp);){
                                Files.delete(tmp.toPath());
                                result = this.checkMetadata(inputFile);
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Exception e) {
                            result = new VideoMetadataDTO(true, null, false, null, e.getMessage());
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Exception e) {
                    result = new VideoMetadataDTO(false, null, false, null, e.getMessage());
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        finally {
            tmp.delete();
        }
        return result;
    }

    public VideoMetadataDTO checkMetadata(byte[] start, byte[] end, Long skipped) {
        VideoMetadataDTO result;
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (MP4ParserFakeFile input = new MP4ParserFakeFile(start, end, skipped);){
                result = this.checkMetadata(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error in video analysis ", e);
            result = new VideoMetadataDTO(true, null, false, null, e.getMessage());
        }
        return result;
    }

    private VideoMetadataDTO checkMetadata(MP4ParserFakeFile input) throws ParserConfigurationException, SAXException, IOException {
        PropertyBoxParserImpl boxParserImpl = new PropertyBoxParserImpl(new String[0]);
        boxParserImpl.skippingBoxes(new String[]{"mdat"});
        Throwable throwable = null;
        Object var4_5 = null;
        try (IsoFile isof = new IsoFile((ReadableByteChannel)input, (BoxParser)boxParserImpl);){
            Date recordStartedTimer = MP4MediaParser.determineRecordingStart((IsoFile)isof);
            boolean spherical = MP4MediaParser.determine360((IsoFile)isof);
            MillisecondsDurationImpl duration = new MillisecondsDurationImpl(MP4MediaParser.determineDurationInMillis((IsoFile)isof));
            return new VideoMetadataDTO(true, (Duration)duration, spherical, recordStartedTimer, "");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public MediaTrack getMediaTrackByUrl(String url) {
        MediaTrack result = null;
        for (MediaTrack mtrack : this.racingEventService().getAllMediaTracks()) {
            if (!this.racingEventService().getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)mtrack) || !url.equals(mtrack.url)) continue;
            result = mtrack;
            break;
        }
        return result;
    }

    public VideoMetadataDTO checkYoutubeMetadata(String videoId) throws UnsupportedEncodingException {
        boolean canDownload = false;
        String message = "";
        MillisecondsDurationImpl duration = null;
        if (videoId.isEmpty()) {
            message = "Empty id";
        } else {
            videoId = URLEncoder.encode(videoId, StandardCharsets.UTF_8.name());
            try {
                URL apiURL = new URL("https://www.googleapis.com/youtube/v3/videos?id=" + videoId + "&key=" + Activator.getInstance().getYoutubeApiKey() + "&part=snippet,contentDetails&fields=items(snippet/title,contentDetails/duration)");
                URLConnection connection = apiURL.openConnection();
                connection.setRequestProperty("Referer", "http://mediaservice.sapsailing.com/");
                connection.setConnectTimeout(10000);
                try {
                    Throwable throwable = null;
                    Object var8_11 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                        String pageText = reader.lines().collect(Collectors.joining("\n"));
                        JSONObject jsonAnswer = new JSONObject(pageText);
                        JSONArray dataArray = jsonAnswer.getJSONArray("items");
                        if (dataArray.length() > 0) {
                            JSONObject item = dataArray.getJSONObject(0);
                            message = item.getJSONObject("snippet").getString("title");
                            String rawDuration = item.getJSONObject("contentDetails").getString("duration");
                            duration = new MillisecondsDurationImpl(java.time.Duration.parse(rawDuration).toMillis());
                        }
                        canDownload = true;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (JSONException e) {
                    message = e.getMessage();
                    logger.log(Level.WARNING, "Error in youtube metadata call", e);
                }
            }
            catch (IOException e) {
                message = e.getMessage();
                logger.log(Level.WARNING, "Error in youtube metadata call", e);
            }
        }
        return new VideoMetadataDTO(canDownload, duration, false, null, message);
    }
}

