/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.sap.sailing.domain.common.RaceCompetitorIdsAsStringWithMD5Hash;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionChangeListener;
import com.sap.sailing.gwt.ui.client.RaceCompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceCompetitorSet;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class RaceCompetitorSet
extends RaceCompetitorIdsAsStringWithMD5Hash {
    private static final long serialVersionUID = 3357742414149799988L;
    private RaceCompetitorSelectionProvider competitorSelection;
    private Iterable<CompetitorDTO> competitorsParticipatingInRace;
    private Set<CompetitorsForRaceDefinedListener> competitorsForRaceDefinedListeners;

    RaceCompetitorSet() {
    }

    public RaceCompetitorSet(RaceCompetitorSelectionProvider competitorSelection) {
        this.competitorsForRaceDefinedListeners = new HashSet();
        this.competitorSelection = competitorSelection;
        this.competitorsParticipatingInRace = competitorSelection.getAllCompetitors();
        competitorSelection.addCompetitorSelectionChangeListener((CompetitorSelectionChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addCompetitorsForRaceDefinedListener(CompetitorsForRaceDefinedListener listener) {
        this.competitorsForRaceDefinedListeners.add(listener);
    }

    public void removeCompetitorsForRaceDefinedListener(CompetitorsForRaceDefinedListener listener) {
        this.competitorsForRaceDefinedListeners.remove(listener);
    }

    public void setIdsAsStringsOfCompetitorsInRace(Set<String> idsAsStringsOfCompetitorsInRace) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        super.setIdsAsStringsOfCompetitorsInRace(idsAsStringsOfCompetitorsInRace);
        this.competitorsParticipatingInRace = this.computeCompetitorsFromIDs(this.competitorSelection.getAllCompetitors());
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (CompetitorsForRaceDefinedListener listener : this.competitorsForRaceDefinedListeners) {
            listener.competitorsForRaceDefined(this.competitorsParticipatingInRace);
        }
    }

    public Iterable<CompetitorDTO> getCompetitorsParticipatingInRace() {
        return this.competitorsParticipatingInRace;
    }

    private Set<CompetitorDTO> computeCompetitorsFromIDs(Iterable<CompetitorDTO> competitors) {
        HashSet<CompetitorDTO> result;
        if (this.getIdsOfCompetitorsParticipatingInRaceAsStrings() == null) {
            result = null;
        } else {
            HashMap<String, CompetitorDTO> competitorsByIdAsString = new HashMap<String, CompetitorDTO>();
            for (CompetitorDTO c : competitors) {
                competitorsByIdAsString.put(c.getIdAsString(), c);
            }
            result = new HashSet<CompetitorDTO>();
            for (String id : this.getIdsOfCompetitorsParticipatingInRaceAsStrings()) {
                CompetitorDTO c = (CompetitorDTO)competitorsByIdAsString.get(id);
                if (c == null) continue;
                result.add(c);
            }
        }
        return result;
    }

    static /* synthetic */ Set access$0(RaceCompetitorSet raceCompetitorSet, Iterable iterable) {
        return raceCompetitorSet.computeCompetitorsFromIDs(iterable);
    }

    static /* synthetic */ void access$1(RaceCompetitorSet raceCompetitorSet, Iterable iterable) {
        raceCompetitorSet.competitorsParticipatingInRace = iterable;
    }

    static /* synthetic */ void access$2(RaceCompetitorSet raceCompetitorSet) {
        raceCompetitorSet.notifyListeners();
    }
}

