/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.core.client.GWT;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.gwt.ui.client.NumberFormatterFactory;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.CompetitorInfoOverlay;
import com.sap.sailing.gwt.ui.client.shared.racemap.QuickFlagDataProvider;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sailing.gwt.ui.shared.GPSFixDTOWithSpeedWindTackAndLegType;
import com.sap.sailing.gwt.ui.shared.QuickRankDTO;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CompetitorInfoOverlays
implements QuickFlagDataProvider.QuickFlagDataListener {
    private final RaceMap raceMap;
    private final Map<String, CompetitorInfoOverlay> competitorInfoOverlays = new HashMap();
    private final Map<String, Integer> ranks = new HashMap();
    private final Map<String, Double> speedsInKnots = new HashMap();
    private final StringMessages stringMessages;

    public CompetitorInfoOverlays(RaceMap raceMap, StringMessages stringMessages) {
        this.stringMessages = stringMessages;
        this.raceMap = raceMap;
    }

    public CompetitorInfoOverlay createCompetitorInfoOverlay(int zIndex, CompetitorDTO competitorDTO, GPSFixDTOWithSpeedWindTackAndLegType gpsFixDTO, Integer rank, Double speed, long timeForPositionTransitionMillis) {
        CompetitorInfoOverlay result = new CompetitorInfoOverlay(this.raceMap.getMap(), zIndex, this.raceMap.getCompetitorSelection().getColor(competitorDTO, this.raceMap.getRaceIdentifier()), "", this.raceMap.getCoordinateSystem());
        this.competitorInfoOverlays.put(competitorDTO.getIdAsString(), result);
        this.updatePosition(competitorDTO, gpsFixDTO, timeForPositionTransitionMillis);
        this.updateFlagData(competitorDTO, rank, speed);
        result.setInfoText(this.createInfoText(competitorDTO));
        return result;
    }

    public void remove(CompetitorWithBoatDTO competitorDTO) {
        this.remove(competitorDTO.getIdAsString());
    }

    public void remove(String competitorIdAsString) {
        CompetitorInfoOverlay overlay = (CompetitorInfoOverlay)this.competitorInfoOverlays.remove(competitorIdAsString);
        if (overlay != null) {
            overlay.removeFromMap();
        }
        this.ranks.remove(competitorIdAsString);
        this.speedsInKnots.remove(competitorIdAsString);
    }

    public CompetitorInfoOverlay get(CompetitorDTO competitorDTO) {
        return (CompetitorInfoOverlay)this.competitorInfoOverlays.get(competitorDTO.getIdAsString());
    }

    public Iterable<CompetitorInfoOverlay> getCompetitorInfoOverlays() {
        return this.competitorInfoOverlays.values();
    }

    private void updateFlagData(CompetitorDTO competitorDTO, Integer rank, Double speedInKnots) {
        CompetitorInfoOverlay overlay = (CompetitorInfoOverlay)this.competitorInfoOverlays.get(competitorDTO.getIdAsString());
        if (overlay != null) {
            this.ranks.put(competitorDTO.getIdAsString(), rank);
            this.speedsInKnots.put(competitorDTO.getIdAsString(), speedInKnots);
            overlay.setInfoText(this.createInfoText(competitorDTO));
            overlay.draw();
        }
    }

    private Double getLastSpeedInKnots(CompetitorDTO competitorDTO) {
        return (Double)this.speedsInKnots.get(competitorDTO.getIdAsString());
    }

    public void removeTransitions() {
        for (CompetitorInfoOverlay infoOverlay : this.getCompetitorInfoOverlays()) {
            infoOverlay.removeCanvasPositionAndRotationTransition();
        }
    }

    public void updatePosition(CompetitorDTO competitorDTO, GPSFixDTOWithSpeedWindTackAndLegType gpsFixDTO, long timeForPositionTransitionMillis) {
        CompetitorInfoOverlay overlay = (CompetitorInfoOverlay)this.competitorInfoOverlays.get(competitorDTO.getIdAsString());
        if (overlay != null) {
            overlay.setPosition(gpsFixDTO.position, timeForPositionTransitionMillis);
            overlay.draw();
        }
    }

    private String createInfoText(CompetitorDTO competitorDTO) {
        StringBuilder infoText = new StringBuilder();
        infoText.append(competitorDTO.getShortInfo()).append("\n");
        Double lastSpeedInKnots = this.getLastSpeedInKnots(competitorDTO);
        if (lastSpeedInKnots != null) {
            infoText.append(NumberFormatterFactory.getDecimalFormat((int)1).format((Number)lastSpeedInKnots)).append(" ").append(this.stringMessages.knotsUnit()).append("\n");
        } else {
            GWT.log((String)("Warning: no speed could be determined for competitor " + competitorDTO.getName()));
        }
        Integer rank = (Integer)this.ranks.get(competitorDTO.getIdAsString());
        if (rank != null && rank != 0) {
            infoText.append(this.stringMessages.rank()).append(" : ").append(rank);
        }
        return infoText.toString();
    }

    public Iterable<String> getCompetitorIdsAsStrings() {
        return Collections.unmodifiableCollection(this.competitorInfoOverlays.keySet());
    }

    public void clear() {
        Iterator i = this.competitorInfoOverlays.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            ((CompetitorInfoOverlay)e.getValue()).removeFromMap();
            i.remove();
        }
        this.speedsInKnots.clear();
        this.ranks.clear();
    }

    public void rankChanged(String competitorIdAsString, QuickRankDTO oldQuickRank, QuickRankDTO quickRanks) {
        CompetitorInfoOverlay competitorInfoOverlay = (CompetitorInfoOverlay)this.competitorInfoOverlays.get(competitorIdAsString);
        this.ranks.put(competitorIdAsString, quickRanks.oneBasedRank);
        if (competitorInfoOverlay != null) {
            competitorInfoOverlay.setInfoText(this.createInfoText(quickRanks.competitor));
            competitorInfoOverlay.draw();
        }
    }

    public void speedInKnotsChanged(CompetitorDTO competitorDTO, Double quickSpeedInKnots) {
        String competitorId = competitorDTO.getIdAsString();
        this.speedsInKnots.put(competitorId, quickSpeedInKnots);
        CompetitorInfoOverlay competitorInfoOverlay = (CompetitorInfoOverlay)this.competitorInfoOverlays.get(competitorId);
        if (competitorInfoOverlay != null) {
            competitorInfoOverlay.setInfoText(this.createInfoText(competitorDTO));
            competitorInfoOverlay.draw();
        }
    }
}

