/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.gwt.ui.adminconsole.ControlPointTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.WaypointCreationDialog;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.ControlPointDTO;
import com.sap.sailing.gwt.ui.shared.WaypointDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.List;

public class WaypointCreationDialog
extends DataEntryDialog<WaypointDTO> {
    private final ControlPointTableWrapper<RefreshableSingleSelectionModel<ControlPointDTO>> controlPointsWrapper;
    private final ListBox passingInstructions;
    private final StringMessages stringMessages;

    public WaypointCreationDialog(SailingServiceWriteAsync sailingServiceWrite, ErrorReporter errorReporter, StringMessages stringMessages, AdminConsoleTableResources tableRes, List<ControlPointDTO> controlPoints, DefaultPassingInstructionProvider defaultPassingInstructionProvider, DataEntryDialog.DialogCallback<WaypointDTO> callback) {
        super(stringMessages.waypoint(), stringMessages.waypoint(), stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new /* Unavailable Anonymous Inner Class!! */, false, callback);
        this.stringMessages = stringMessages;
        this.controlPointsWrapper = new ControlPointTableWrapper(false, sailingServiceWrite, stringMessages, errorReporter);
        this.controlPointsWrapper.getDataProvider().getList().addAll(controlPoints);
        this.passingInstructions = this.createListBox(false);
        this.updatePassingInstructions(defaultPassingInstructionProvider);
        ((RefreshableSingleSelectionModel)this.controlPointsWrapper.getSelectionModel()).addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updatePassingInstructions(DefaultPassingInstructionProvider defaultPassingInstructionProvider) {
        this.passingInstructions.clear();
        ControlPointDTO controlPoint = (ControlPointDTO)((RefreshableSingleSelectionModel)this.controlPointsWrapper.getSelectionModel()).getSelectedObject();
        int numMarks = controlPoint != null ? Util.size((Iterable)controlPoint.getMarks()) : 0;
        PassingInstruction defaultPassingInstruction = defaultPassingInstructionProvider.getDefaultPassingInstruction(numMarks, controlPoint == null ? null : controlPoint.getIdAsString());
        int i = 0;
        this.passingInstructions.insertItem(PassingInstruction.None.name(), i++);
        PassingInstruction[] passingInstructionArray = PassingInstruction.relevantValues();
        int n = passingInstructionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PassingInstruction pi = passingInstructionArray[n2];
            int[] nArray = pi.applicability;
            int n3 = pi.applicability.length;
            int n4 = 0;
            while (n4 < n3) {
                int numApplicableMarks = nArray[n4];
                if (numApplicableMarks == numMarks) {
                    this.passingInstructions.insertItem(pi.name(), i);
                    this.passingInstructions.setItemSelected(i, pi == defaultPassingInstruction);
                    ++i;
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected WaypointDTO getResult() {
        PassingInstruction pi = this.passingInstructions.getSelectedIndex() > 0 ? PassingInstruction.valueOf((String)this.passingInstructions.getItemText(this.passingInstructions.getSelectedIndex())) : PassingInstruction.None;
        ControlPointDTO controlPoint = (ControlPointDTO)((RefreshableSingleSelectionModel)this.controlPointsWrapper.getSelectionModel()).getSelectedObject();
        String name = null;
        if (controlPoint != null) {
            name = controlPoint.getName();
        }
        return new WaypointDTO(name, controlPoint, pi);
    }

    protected Widget getAdditionalWidget() {
        Grid grid = new Grid(2, 1);
        grid.setWidget(0, 0, (IsWidget)this.controlPointsWrapper);
        HorizontalPanel passingInstructionsRow = new HorizontalPanel();
        grid.setWidget(1, 0, (Widget)passingInstructionsRow);
        passingInstructionsRow.add((Widget)new Label(String.valueOf(this.stringMessages.passingInstructions()) + ":"));
        passingInstructionsRow.add((Widget)this.passingInstructions);
        return grid;
    }

    static /* synthetic */ void access$1(WaypointCreationDialog waypointCreationDialog, DefaultPassingInstructionProvider defaultPassingInstructionProvider) {
        waypointCreationDialog.updatePassingInstructions(defaultPassingInstructionProvider);
    }

    static /* synthetic */ void access$2(WaypointCreationDialog waypointCreationDialog) {
        waypointCreationDialog.validateAndUpdate();
    }
}

