/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.SeriesDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

class RegattaStructure {
    private final Iterable<String> seriesNamesInOrder;
    private final Map<String, LinkedHashSet<String>> seriesNamesToFleetNames = new HashMap();
    private final RankingMetrics rankingMetricType;

    public RegattaStructure(RegattaDTO regatta) {
        ArrayList<String> mySeriesNamesInOrder;
        this.seriesNamesInOrder = mySeriesNamesInOrder = new ArrayList<String>();
        for (SeriesDTO series : regatta.series) {
            mySeriesNamesInOrder.add(series.getName());
            LinkedHashSet<String> fleetNames = new LinkedHashSet<String>();
            this.seriesNamesToFleetNames.put(series.getName(), fleetNames);
            for (FleetDTO fleet : series.getFleets()) {
                fleetNames.add(fleet.getName());
            }
        }
        this.rankingMetricType = regatta.rankingMetricType;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String seriesName : this.seriesNamesInOrder) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(seriesName);
            result.append(this.seriesNamesToFleetNames.get(seriesName));
        }
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rankingMetricType == null ? 0 : this.rankingMetricType.hashCode());
        result = 31 * result + (this.seriesNamesInOrder == null ? 0 : this.seriesNamesInOrder.hashCode());
        result = 31 * result + (this.seriesNamesToFleetNames == null ? 0 : this.seriesNamesToFleetNames.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegattaStructure other = (RegattaStructure)obj;
        if (this.rankingMetricType != other.rankingMetricType) {
            return false;
        }
        if (this.seriesNamesInOrder == null ? other.seriesNamesInOrder != null : !this.seriesNamesInOrder.equals(other.seriesNamesInOrder)) {
            return false;
        }
        return !(this.seriesNamesToFleetNames == null ? other.seriesNamesToFleetNames != null : !this.seriesNamesToFleetNames.equals(other.seriesNamesToFleetNames));
    }
}

