/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.ui.adminconsole.RaceColumnInLeaderboardDialog;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DoubleBox;

public class RaceColumnInLeaderboardDialog
extends DataEntryDialog<RaceColumnDescriptor> {
    private final TextBox raceNameBox;
    private final DoubleBox explicitFactorBox;
    private final CheckBox isMedalRace;
    private final StringMessages stringMessages;
    private final boolean isRegattaLeaderboard;

    public RaceColumnInLeaderboardDialog(Iterable<RaceColumnDTO> existingRaces, RaceColumnDTO raceColumnToEdit, boolean isRegattaLeaderboard, StringMessages stringMessages, DataEntryDialog.DialogCallback<RaceColumnDescriptor> callback) {
        super(stringMessages.actionRaceEdit(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new RaceDialogValidator(stringMessages, existingRaces), callback);
        this.isRegattaLeaderboard = isRegattaLeaderboard;
        this.stringMessages = stringMessages;
        this.raceNameBox = this.createTextBox(raceColumnToEdit.getRaceColumnName());
        this.raceNameBox.setEnabled(!isRegattaLeaderboard);
        this.explicitFactorBox = raceColumnToEdit.getExplicitFactor() == null ? this.createDoubleBox(4) : this.createDoubleBox(raceColumnToEdit.getExplicitFactor(), 4);
        this.isMedalRace = this.createCheckbox(stringMessages.medalRace());
        this.isMedalRace.setValue(Boolean.valueOf(raceColumnToEdit.isMedalRace()));
        this.isMedalRace.setEnabled(!isRegattaLeaderboard);
    }

    protected RaceColumnDescriptor getResult() {
        return new RaceColumnDescriptor(this.raceNameBox.getValue(), this.isMedalRace.getValue().booleanValue(), this.explicitFactorBox.getText().trim().length() == 0 ? null : (Double)this.explicitFactorBox.getValue());
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel mainPanel = new VerticalPanel();
        HorizontalPanel raceNamePanel = new HorizontalPanel();
        raceNamePanel.setSpacing(3);
        mainPanel.add((Widget)raceNamePanel);
        raceNamePanel.add((Widget)new Label(String.valueOf(this.stringMessages.name()) + ":"));
        raceNamePanel.add((Widget)this.raceNameBox);
        HorizontalPanel factorPanel = new HorizontalPanel();
        factorPanel.setSpacing(3);
        mainPanel.add((Widget)factorPanel);
        factorPanel.add((Widget)new Label(String.valueOf(this.stringMessages.factor()) + ":"));
        factorPanel.add((Widget)this.explicitFactorBox);
        this.alignAllPanelWidgetsVertically(raceNamePanel, HasVerticalAlignment.ALIGN_MIDDLE);
        mainPanel.add((Widget)this.isMedalRace);
        return mainPanel;
    }

    protected Focusable getInitialFocusWidget() {
        Object result = this.isRegattaLeaderboard ? this.explicitFactorBox : this.raceNameBox;
        return result;
    }

    public void show() {
        super.show();
        if (this.isRegattaLeaderboard) {
            this.explicitFactorBox.selectAll();
        }
    }
}

