/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTOImpl;
import com.sap.sailing.gwt.common.client.suggestion.BoatClassMasterdataSuggestOracle;
import com.sap.sailing.gwt.ui.adminconsole.AbstractCompetitorWithBoatDialog;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorEditDialog;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Distance;
import com.sap.sse.gwt.client.ColorTextBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;

public abstract class AbstractCompetitorWithBoatDialog
extends CompetitorEditDialog<CompetitorWithBoatDTO> {
    protected final SuggestBox boatClassNameTextBox;
    protected final TextBox sailIdTextBox;
    protected final TextBox boatNameTextBox;
    protected final ColorTextBox boatDisplayColorTextBox;

    public AbstractCompetitorWithBoatDialog(String dialogTitle, StringMessages stringMessages, CompetitorWithBoatDTO competitorWithBoat, DataEntryDialog.DialogCallback<CompetitorWithBoatDTO> callback, String boatClass, CompetitorEditDialog.CompetitorWithoutBoatValidator<CompetitorWithBoatDTO> validator) {
        super(dialogTitle, stringMessages, (CompetitorDTO)competitorWithBoat, validator, callback);
        BoatDTO boat = competitorWithBoat.getBoat();
        this.boatClassNameTextBox = this.createSuggestBox((SuggestOracle)new BoatClassMasterdataSuggestOracle());
        this.boatClassNameTextBox.ensureDebugId("BoatClassNameSuggestBox");
        if (boat.getBoatClass() != null) {
            this.boatClassNameTextBox.setValue(boat.getBoatClass().getName());
            this.setBoatClassNameEnabled(this.boatClassNameTextBox, false);
        } else {
            this.boatClassNameTextBox.setValue(boatClass);
        }
        this.boatNameTextBox = this.createTextBox(boat.getName());
        this.boatNameTextBox.ensureDebugId("BoatNameTextBox");
        this.boatDisplayColorTextBox = this.createColorTextBox(boat.getColor());
        this.sailIdTextBox = this.createTextBox(boat.getSailId());
        this.sailIdTextBox.ensureDebugId("SailIdTextBox");
    }

    public AbstractCompetitorWithBoatDialog(String dialogTitle, StringMessages stringMessages, CompetitorWithBoatDTO competitorWithBoat, DataEntryDialog.DialogCallback<CompetitorWithBoatDTO> callback, String boatClass) {
        this(dialogTitle, stringMessages, competitorWithBoat, callback, boatClass, (CompetitorEditDialog.CompetitorWithoutBoatValidator)new CompetitorWithBoatValidator(stringMessages, competitorWithBoat.getBoat()));
    }

    protected Focusable getInitialFocusWidget() {
        return super.getInitialFocusWidget();
    }

    protected BoatDTO getBoat() {
        BoatDTO result = null;
        Object boatColor = this.boatDisplayColorTextBox.isValid() ? this.boatDisplayColorTextBox.getColor() : new CompetitorEditDialog.InvalidColor((Exception)new IllegalArgumentException(this.boatDisplayColorTextBox.getValue()), this.getStringMessages());
        BoatClassDTO boatClass = new BoatClassDTO(this.boatClassNameTextBox.getValue(), (Distance)Distance.NULL, (Distance)Distance.NULL);
        result = new BoatDTO(((CompetitorWithBoatDTO)this.getCompetitorToEdit()).getBoat().getIdAsString(), this.boatNameTextBox.getValue(), boatClass, this.sailIdTextBox.getValue(), boatColor);
        return result;
    }

    protected CompetitorWithBoatDTO getResult() {
        CompetitorDTO c = this.getBaseResult();
        BoatDTO boat = this.getBoat();
        CompetitorWithBoatDTOImpl result = new CompetitorWithBoatDTOImpl(c.getName(), c.getShortName(), c.getColor(), c.getEmail(), c.getTwoLetterIsoCountryCode(), c.getThreeLetterIocCountryCode(), c.getCountryName(), ((CompetitorWithBoatDTO)this.getCompetitorToEdit()).getIdAsString(), c.getImageURL(), c.getFlagImageURL(), c.getTimeOnTimeFactor(), c.getTimeOnDistanceAllowancePerNauticalMile(), c.getSearchTag(), boat);
        return result;
    }

    protected void setBoatClassNameEnabled(SuggestBox boatClassNameTextBox, boolean enabled) {
        boatClassNameTextBox.setEnabled(enabled);
    }
}

