/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.settings.client.whatsnew;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.gwt.settings.client.whatsnew.AbstractWhatsNewDialogFactory;
import com.sap.sailing.gwt.settings.client.whatsnew.AbstractWhatsNewSettings;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.settings.SettingsToJsonSerializerGWT;
import com.sap.sse.gwt.shared.ClientConfiguration;
import com.sap.sse.security.ui.client.UserService;
import java.util.function.IntConsumer;
import java.util.logging.Logger;

public abstract class AbstractWhatsNewDialogFactory<S extends AbstractWhatsNewSettings> {
    private static final long THRESHOLD_WHATS_NEW = 10L;
    private static final Logger LOG = Logger.getLogger(AbstractWhatsNewDialogFactory.class.getName());
    private final UserService userService;

    protected AbstractWhatsNewDialogFactory(UserService userService) {
        this.userService = userService;
    }

    protected void register() {
        this.userService.addUserStatusEventHandler((user, preAuth) -> {
            if (user != null) {
                this.showWhatsNewDialogIfNecessaryAndUpdatePreference();
            }
        }, false);
    }

    protected final void showWhatsNewDialogIfNecessaryAndUpdatePreference() {
        if (!this.isUserAlreadyNotified() && ClientConfiguration.getInstance().isBrandingActive()) {
            this.currentCharacterCount(charCount -> this.userService.getPreference(this.getPrefName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    private void updateOrCreatePreference(long charCount, SettingsToJsonSerializerGWT serializer, ServiceCallback<Void> callback) {
        String serializedSetting = serializer.serializeToString((GenericSerializableSettings)this.getInstanceForSerialization(Long.valueOf(charCount)));
        this.userService.setPreference(this.getPrefName(), serializedSetting, callback);
    }

    protected abstract void currentCharacterCount(IntConsumer var1);

    protected abstract String getPrefName();

    protected abstract S getInstanceForDeserialization();

    protected abstract S getInstanceForSerialization(Long var1);

    protected abstract boolean isUserAlreadyNotified();

    protected abstract void showDialog(DataEntryDialog.DialogCallback<Void> var1);

    protected abstract void openReleaseNotes();

    static /* synthetic */ Logger access$0() {
        return LOG;
    }

    static /* synthetic */ void access$1(AbstractWhatsNewDialogFactory abstractWhatsNewDialogFactory, long l, SettingsToJsonSerializerGWT settingsToJsonSerializerGWT, ServiceCallback serviceCallback) {
        abstractWhatsNewDialogFactory.updateOrCreatePreference(l, settingsToJsonSerializerGWT, serviceCallback);
    }
}

