/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.places.event;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.home.communication.SailingDispatchSystem;
import com.sap.sailing.gwt.home.communication.event.EventAndLeaderboardReferenceWithStateDTO;
import com.sap.sailing.gwt.home.communication.event.EventState;
import com.sap.sailing.gwt.home.communication.event.news.LeaderboardNewsEntryDTO;
import com.sap.sailing.gwt.home.communication.event.news.NewsEntryDTO;
import com.sap.sailing.gwt.home.communication.eventview.EventViewDTO;
import com.sap.sailing.gwt.home.communication.eventview.RegattaMetadataDTO;
import com.sap.sailing.gwt.home.communication.eventview.SeriesReferenceWithEventsDTO;
import com.sap.sailing.gwt.home.communication.media.GetMediaForEventAction;
import com.sap.sailing.gwt.home.communication.race.RaceMetadataDTO;
import com.sap.sailing.gwt.home.communication.race.SimpleRaceMetadataDTO;
import com.sap.sailing.gwt.home.desktop.partials.racelist.RaceListDataUtil;
import com.sap.sailing.gwt.home.desktop.places.event.multiregatta.mediatab.MultiregattaMediaPlace;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.leaderboardtab.RegattaLeaderboardPlace;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.mediatab.RegattaMediaPlace;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.overviewtab.RegattaOverviewPlace;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.racestab.RegattaRacesPlace;
import com.sap.sailing.gwt.home.mobile.app.MobileApplicationClientFactory;
import com.sap.sailing.gwt.home.mobile.places.event.AbstractEventActivity;
import com.sap.sailing.gwt.home.mobile.places.event.EventViewBase;
import com.sap.sailing.gwt.home.mobile.places.event.latestnews.LatestNewsPlace;
import com.sap.sailing.gwt.home.mobile.places.event.minileaderboard.MiniLeaderboardPlace;
import com.sap.sailing.gwt.home.mobile.places.event.overview.AbstractEventOverview;
import com.sap.sailing.gwt.home.mobile.places.series.minileaderboard.SeriesMiniOverallLeaderboardPlace;
import com.sap.sailing.gwt.home.shared.app.NavigationPathDisplay;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.places.event.AbstractEventPlace;
import com.sap.sailing.gwt.home.shared.places.event.EventContext;
import com.sap.sailing.gwt.home.shared.places.event.EventDefaultPlace;
import com.sap.sailing.gwt.home.shared.places.fakeseries.AbstractSeriesPlace;
import com.sap.sailing.gwt.home.shared.places.fakeseries.SeriesContext;
import com.sap.sailing.gwt.home.shared.places.fakeseries.SeriesDefaultPlace;
import com.sap.sailing.gwt.settings.client.EntryPointWithSettingsLinkFactory;
import com.sap.sailing.gwt.settings.client.raceboard.RaceBoardPerspectiveOwnSettings;
import com.sap.sailing.gwt.settings.client.raceboard.RaceboardContextDefinition;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.refresh.ErrorAndBusyClientFactory;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.common.util.NaturalComparator;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.gwt.dispatch.shared.commands.Action;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.subscription.SubscriptionServiceFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;

public abstract class AbstractEventActivity<PLACE extends AbstractEventPlace>
extends AbstractActivity
implements EventViewBase.Presenter {
    private final MobileApplicationClientFactory clientFactory;
    protected final PLACE place;
    protected final EventViewDTO eventDTO;
    private AcceptsOneWidget panel;

    protected AbstractEventActivity(PLACE place, EventViewDTO eventDTO, MobileApplicationClientFactory clientFactory) {
        this.eventDTO = eventDTO;
        this.clientFactory = clientFactory;
        this.place = place;
    }

    public final void start(AcceptsOneWidget panel, EventBus eventBus) {
        this.panel = panel;
        EventViewBase view = this.initView();
        panel.setWidget((IsWidget)view.asWidget());
    }

    public com.google.web.bindery.event.shared.EventBus getEventBus() {
        return this.clientFactory.getEventBus();
    }

    public UserService getUserService() {
        return this.clientFactory.getUserService();
    }

    public SubscriptionServiceFactory getSubscriptionServiceFactory() {
        return this.clientFactory.getSubscriptionServiceFactory();
    }

    protected abstract EventViewBase initView();

    protected final void initSeriesNavigation(EventViewBase view) {
        RegattaMetadataDTO regatta = this.getRegatta();
        Object seriesData = this.isRegattaLevel() ? (regatta != null ? regatta.getSeriesReference() : null) : this.eventDTO.getSeriesData();
        if (seriesData != null) {
            UUID seriesLeaderboardGroupId = seriesData.getSeriesLeaderboardGroupId();
            PlaceNavigation navigation = this.clientFactory.getNavigator().getEventSeriesNavigation(SeriesContext.createWithLeaderboardGroupId((UUID)seriesLeaderboardGroupId), null, false);
            view.setSeriesNavigation(seriesData.getSeriesDisplayName(), navigation);
        }
    }

    protected final void initSailorInfo(EventViewBase view) {
        String sailorInfoUrl = this.eventDTO.getSailorsInfoWebsiteURL();
        if (sailorInfoUrl != null && !sailorInfoUrl.isEmpty()) {
            view.setSailorInfos(StringMessages.INSTANCE.sailorInfoLongText(), StringMessages.INSTANCE.sailorInfo(), sailorInfoUrl);
        }
    }

    protected final void initWindfinderNavigations(EventViewBase view) {
        Iterable spots = this.eventDTO.getAllWindFinderSpotIdsUsedByEvent();
        if (spots != null && !Util.isEmpty((Iterable)spots)) {
            view.setWindfinderNavigations(spots);
        }
    }

    protected final void initQuickfinder(EventViewBase view, boolean showQuickfinder) {
        EventViewDTO event = this.eventDTO;
        SeriesReferenceWithEventsDTO seriesData = event.getSeriesData();
        if (showQuickfinder && event.isMultiRegatta()) {
            view.setQuickFinderValues(this.getRegattasByLeaderboardGroupName());
        } else if (showQuickfinder && seriesData != null) {
            List eventsOfSeriesSorted = seriesData.getEventsOfSeries();
            ArrayList<EventAndLeaderboardReferenceWithStateDTO> seriesEventToShow = new ArrayList<EventAndLeaderboardReferenceWithStateDTO>(eventsOfSeriesSorted.size());
            for (EventAndLeaderboardReferenceWithStateDTO seriesEvent : eventsOfSeriesSorted) {
                if (seriesEvent.getState() == EventState.PLANNED) continue;
                seriesEventToShow.add(seriesEvent);
            }
            view.setQuickFinderValues(seriesData.getSeriesDisplayName(), seriesEventToShow);
        } else {
            view.hideQuickfinder();
        }
    }

    private Map<String, Set<RegattaMetadataDTO>> getRegattasByLeaderboardGroupName() {
        TreeMap<String, Set<RegattaMetadataDTO>> regattasByLeaderboardGroupName = new TreeMap<String, Set<RegattaMetadataDTO>>((Comparator<String>)new NaturalComparator(false));
        for (RegattaMetadataDTO regatta : this.eventDTO.getRegattas()) {
            if (Util.isEmpty((Iterable)regatta.getLeaderboardGroupNames())) {
                this.addRegattaToLeaderboardGroup(regattasByLeaderboardGroupName, null, regatta);
            }
            for (String leaderboardGroupName : regatta.getLeaderboardGroupNames()) {
                this.addRegattaToLeaderboardGroup(regattasByLeaderboardGroupName, leaderboardGroupName, regatta);
            }
        }
        return regattasByLeaderboardGroupName;
    }

    private void addRegattaToLeaderboardGroup(Map<String, Set<RegattaMetadataDTO>> regattasByLeaderboardGroupName, String leaderboardGroupName, RegattaMetadataDTO regatta) {
        Set<RegattaMetadataDTO> regattasForLg = regattasByLeaderboardGroupName.get(leaderboardGroupName);
        if (regattasForLg == null) {
            regattasForLg = new TreeSet<RegattaMetadataDTO>();
            regattasByLeaderboardGroupName.put(leaderboardGroupName, regattasForLg);
        }
        regattasForLg.add(regatta);
    }

    protected final void initMedia(AbstractEventOverview view) {
        this.initMedia((MediaCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected final void initMedia(MediaCallback callback) {
        if (this.eventDTO.isHasMedia() || this.getUserService().hasPermission((SecuredDTO)this.eventDTO, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE)) {
            this.clientFactory.getDispatch().execute((Action)new GetMediaForEventAction(this.eventDTO.getId()), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected final PLACE getPlace() {
        return (PLACE)this.place;
    }

    public EventContext getCtx() {
        return this.getPlace().getCtx();
    }

    public SailingDispatchSystem getDispatch() {
        return this.clientFactory.getDispatch();
    }

    public ErrorAndBusyClientFactory getErrorAndBusyClientFactory() {
        return this.clientFactory;
    }

    public PlaceNavigation<?> getRegattaLeaderboardNavigation(String leaderboardName) {
        EventContext ctx = new EventContext(this.getCtx()).withRegattaId(leaderboardName).withRegattaAnalyticsManager(null);
        return this.clientFactory.getNavigator().getEventNavigation((AbstractEventPlace)new RegattaLeaderboardPlace(ctx), null, false);
    }

    public PlaceNavigation<?> getRegattaMiniLeaderboardNavigation(String leaderboardName) {
        EventContext ctx = new EventContext(this.getCtx()).withRegattaId(leaderboardName).withRegattaAnalyticsManager(null);
        return this.clientFactory.getNavigator().getEventNavigation((AbstractEventPlace)new MiniLeaderboardPlace(ctx), null, false);
    }

    public PlaceNavigation<?> getMiniOverallLeaderboardNavigation() {
        SeriesReferenceWithEventsDTO seriesReference = this.getEventDTO().getSeriesData();
        if (seriesReference != null) {
            return this.clientFactory.getNavigator().getSeriesNavigation((AbstractSeriesPlace)new SeriesMiniOverallLeaderboardPlace(SeriesContext.createWithLeaderboardGroupId((UUID)seriesReference.getSeriesLeaderboardGroupId())), null, false);
        }
        return null;
    }

    public PlaceNavigation<?> getMiniLeaderboardNavigation(UUID eventId, String leaderboardName) {
        return this.clientFactory.getNavigator().getEventNavigation((AbstractEventPlace)new MiniLeaderboardPlace(eventId.toString(), leaderboardName), null, false);
    }

    public PlaceNavigation<?> getEventNavigation() {
        return this.clientFactory.getNavigator().getEventNavigation((AbstractEventPlace)new EventDefaultPlace(this.getCtx()), null, false);
    }

    public PlaceNavigation<?> getMediaPageNavigation() {
        if (this.eventDTO.isMultiRegatta()) {
            return this.clientFactory.getNavigator().getEventNavigation((AbstractEventPlace)new MultiregattaMediaPlace(this.getCtx()), null, false);
        }
        return this.clientFactory.getNavigator().getEventNavigation((AbstractEventPlace)new RegattaMediaPlace(this.getCtx()), null, false);
    }

    public PlaceNavigation<?> getNewsPlaceNavigation(List<NewsEntryDTO> values) {
        return this.clientFactory.getNavigator().getEventLastestNewsNavigation(this.getCtx(), values, null, false);
    }

    public PlaceNavigation<?> getNewsEntryPlaceNavigation(NewsEntryDTO entry) {
        if (entry instanceof LeaderboardNewsEntryDTO) {
            LeaderboardNewsEntryDTO dto = (LeaderboardNewsEntryDTO)entry;
            return this.getRegattaMiniLeaderboardNavigation(dto.getLeaderboardName());
        }
        return null;
    }

    public PlaceNavigation<?> getRegattaOverviewNavigation(String regattaId) {
        EventContext ctx = new EventContext(this.getCtx()).withRegattaId(regattaId).withRegattaAnalyticsManager(null);
        return this.clientFactory.getNavigator().getEventNavigation((AbstractEventPlace)new RegattaOverviewPlace(ctx), null, false);
    }

    public PlaceNavigation<?> getSeriesEventLeaderboardOverviewNavigation(UUID eventId, String leaderboardName) {
        return this.clientFactory.getNavigator().getEventNavigation((AbstractEventPlace)new RegattaOverviewPlace(eventId.toString(), leaderboardName), null, false);
    }

    public PlaceNavigation<?> getSeriesNavigationForCurrentEvent() {
        SeriesReferenceWithEventsDTO seriesData = this.getEventDTO().getSeriesData();
        if (seriesData != null) {
            SeriesContext seriesCTX = SeriesContext.createWithLeaderboardGroupId((UUID)seriesData.getSeriesLeaderboardGroupId());
            return this.clientFactory.getNavigator().getSeriesNavigation((AbstractSeriesPlace)new SeriesDefaultPlace(seriesCTX), null, false);
        }
        return null;
    }

    public PlaceNavigation<?> getRegattaRacesNavigation(String regattaId) {
        EventContext ctx = new EventContext(this.getCtx()).withRegattaId(regattaId).withRegattaAnalyticsManager(null);
        return this.clientFactory.getNavigator().getEventNavigation((AbstractEventPlace)new RegattaRacesPlace(ctx), null, false);
    }

    public PlaceNavigation<?> getRegattaRacesNavigation(String regattaId, String prefSeriesName) {
        EventContext ctx = new EventContext(this.getCtx()).withRegattaId(regattaId).withRegattaAnalyticsManager(null);
        return this.clientFactory.getNavigator().getEventNavigation((AbstractEventPlace)new RegattaRacesPlace(ctx, prefSeriesName), null, false);
    }

    public PlaceNavigation<?> getLatesNewsNavigation() {
        EventContext ctx = new EventContext(this.getCtx()).withRegattaId(null).withRegattaAnalyticsManager(null);
        return this.clientFactory.getNavigator().getEventNavigation((AbstractEventPlace)new LatestNewsPlace(ctx), null, false);
    }

    public PlaceNavigation<?> getSeriesEventRacesNavigation(UUID eventId) {
        return this.clientFactory.getNavigator().getEventNavigation((AbstractEventPlace)new RegattaRacesPlace(eventId.toString(), null), null, false);
    }

    public String getRaceViewerURL(SimpleRaceMetadataDTO raceMetadata, String mode) {
        RegattaAndRaceIdentifier raceid = raceMetadata.getRegattaAndRaceIdentifier();
        return this.getRaceViewerURL(raceMetadata.getLeaderboardName(), raceMetadata.getLeaderboardGroupName(), raceMetadata.getLeaderboardGroupId(), raceid, mode);
    }

    private String getRaceViewerURL(String leaderboardName, String leaderboardGroupName, UUID leaderboardGroupId, RegattaAndRaceIdentifier raceIdentifier, String mode) {
        RaceboardContextDefinition raceboardContext = new RaceboardContextDefinition(raceIdentifier.getRegattaName(), raceIdentifier.getRaceName(), leaderboardName, leaderboardGroupName, leaderboardGroupId, UUID.fromString(this.getCtx().getEventId()), mode);
        RaceBoardPerspectiveOwnSettings perspectiveOwnSettings = new RaceBoardPerspectiveOwnSettings();
        HashMap<String, RaceMapSettings> innerSettings = new HashMap<String, RaceMapSettings>();
        innerSettings.put("rm", RaceMapSettings.getDefaultWithShowMapControls((boolean)true));
        PerspectiveCompositeSettings settings = new PerspectiveCompositeSettings((Settings)perspectiveOwnSettings, innerSettings);
        return EntryPointWithSettingsLinkFactory.createRaceBoardLink((RaceboardContextDefinition)raceboardContext, (PerspectiveCompositeSettings)settings);
    }

    public String getMapAndWindChartUrl(String leaderboardName, String raceName, String fleetName) {
        return EntryPointWithSettingsLinkFactory.createEmbeddedMapAndWindChartLink((String)leaderboardName, (String)raceName, (String)fleetName);
    }

    public String getMapAndWindChartUrl(RaceMetadataDTO<?> metadata) {
        return EntryPointWithSettingsLinkFactory.createEmbeddedMapAndWindChartLink((String)metadata.getLeaderboardName(), (String)metadata.getRaceName(), (String)RaceListDataUtil.getFleetName(metadata));
    }

    public String getRegattaId() {
        String regattaId = this.place.getRegattaId();
        if (regattaId != null) {
            return regattaId;
        }
        if (!this.eventDTO.getRegattas().isEmpty() && !this.eventDTO.isMultiRegatta()) {
            return ((RegattaMetadataDTO)this.eventDTO.getRegattas().iterator().next()).getId();
        }
        return null;
    }

    public RegattaMetadataDTO getRegatta() {
        String regattaId = this.getRegattaId();
        if (regattaId == null) {
            return null;
        }
        for (RegattaMetadataDTO regatta : this.eventDTO.getRegattas()) {
            if (!regattaId.equals(regatta.getId())) continue;
            return regatta;
        }
        return null;
    }

    public EventViewDTO getEventDTO() {
        return this.eventDTO;
    }

    public boolean isMultiRegattaEvent() {
        return this.getEventDTO().isMultiRegatta();
    }

    protected boolean isRegattaLevel() {
        return true;
    }

    protected List<NavigationPathDisplay.NavigationItem> getNavigationPathToEventLevel() {
        ArrayList<NavigationPathDisplay.NavigationItem> navigationItems = new ArrayList<NavigationPathDisplay.NavigationItem>();
        SeriesReferenceWithEventsDTO seriesData = this.getEventDTO().getSeriesData();
        if (seriesData != null) {
            navigationItems.add(new NavigationPathDisplay.NavigationItem(seriesData.getSeriesDisplayName(), this.getSeriesNavigationForCurrentEvent()));
        }
        navigationItems.add(new NavigationPathDisplay.NavigationItem(this.getEventDTO().getLocationOrDisplayName(), this.getEventNavigation()));
        return navigationItems;
    }

    protected List<NavigationPathDisplay.NavigationItem> getNavigationPathToRegattaLevel() {
        List navigationItems = this.getNavigationPathToEventLevel();
        if (this.getEventDTO().isMultiRegatta()) {
            navigationItems.add(new NavigationPathDisplay.NavigationItem(this.getRegatta().getDisplayName(), this.getRegattaOverviewNavigation(this.getRegattaId())));
        }
        return navigationItems;
    }
}

