/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.declination.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.Named;
import com.sap.sse.common.TimePoint;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

class Geomagnetism
implements Named {
    private static final long serialVersionUID = -2814152697634383730L;
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private final TimePoint startOfValidity;
    private final String name;
    private final TimePoint issueTimePoint;
    private static final double IAU66_RADIUS = 6371.2;
    private static final double WGS84_A = 6378.137;
    private static final double WGS84_B = 6356.7523142;
    private static final int MAX_DEG = 12;
    private double[][] c = new double[300][300];
    private double[][] cd = new double[300][300];
    private double[][] tc = new double[13][13];
    private double[][] dp = new double[13][13];
    private double[] snorm = new double[169];
    private double[] sp = new double[13];
    private double[] cp = new double[13];
    private double[] fn = new double[13];
    private double[] fm = new double[13];
    private int maxord = 12;
    private double[] pp = new double[13];
    private double[][] k = new double[13][13];
    private double epoch;
    private double r;
    private double d;
    private double ca;
    private double sa;
    private double ct;
    private double st;

    Geomagnetism(BufferedReader cofReader) throws IOException, ParseException {
        String line;
        this.sp[0] = 0.0;
        this.pp[0] = 1.0;
        this.snorm[0] = 1.0;
        this.cp[0] = 1.0;
        this.dp[0][0] = 0.0;
        this.c[0][0] = 0.0;
        this.cd[0][0] = 0.0;
        String headerLine = cofReader.readLine();
        String[] headerFields = headerLine.trim().split("\\s+");
        this.epoch = Double.parseDouble(headerFields[0]);
        this.startOfValidity = TimePoint.of((long)new GregorianCalendar((int)this.epoch, 1, 1, 0, 0, 0).getTimeInMillis()).plus(Duration.ONE_HOUR.times(8760.0 * (this.epoch - (double)((int)this.epoch))));
        this.name = headerFields[1];
        this.issueTimePoint = TimePoint.of((Date)simpleDateFormat.parse(headerFields[2]));
        while (!(line = cofReader.readLine()).startsWith("999999")) {
            String[] tokens = line.trim().split("\\s+");
            int n = Integer.parseInt(tokens[0]);
            int m = Integer.parseInt(tokens[1]);
            double gnm = Double.parseDouble(tokens[2]);
            double hnm = Double.parseDouble(tokens[3]);
            double dgnm = Double.parseDouble(tokens[4]);
            double dhnm = Double.parseDouble(tokens[5]);
            if (m > n) continue;
            this.c[m][n] = gnm;
            this.cd[m][n] = dgnm;
            if (m == 0) continue;
            this.c[n][m - 1] = hnm;
            this.cd[n][m - 1] = dhnm;
        }
        this.snorm[0] = 1.0;
        int n = 1;
        while (n <= this.maxord) {
            this.snorm[n] = this.snorm[n - 1] * (double)(2 * n - 1) / (double)n;
            int j = 2;
            int m = 0;
            int d1 = 1;
            int d2 = (n - m + d1) / d1;
            while (d2 > 0) {
                this.k[m][n] = (double)((n - 1) * (n - 1) - m * m) / (double)((2 * n - 1) * (2 * n - 3));
                if (m > 0) {
                    double flnmj = (double)((n - m + 1) * j) / (double)(n + m);
                    this.snorm[n + m * 13] = this.snorm[n + (m - 1) * 13] * Math.sqrt(flnmj);
                    j = 1;
                    this.c[n][m - 1] = this.snorm[n + m * 13] * this.c[n][m - 1];
                    this.cd[n][m - 1] = this.snorm[n + m * 13] * this.cd[n][m - 1];
                }
                this.c[m][n] = this.snorm[n + m * 13] * this.c[m][n];
                this.cd[m][n] = this.snorm[n + m * 13] * this.cd[m][n];
                --d2;
                m += d1;
            }
            this.fn[n] = n + 1;
            this.fm[n] = n;
            ++n;
        }
        this.k[1][1] = 0.0;
        this.fm[0] = 0.0;
    }

    Result calculate(double longitude, double latitude, double altitude, GregorianCalendar calendar) {
        double rlon = Math.toRadians(longitude);
        double rlat = Math.toRadians(latitude);
        double altitudeKm = Double.isNaN(altitude) ? 0.0 : altitude / 1000.0;
        double yearFraction = (double)calendar.get(1) + (double)calendar.get(6) / (double)calendar.getActualMaximum(6);
        double dt = yearFraction - this.epoch;
        double srlon = Math.sin(rlon);
        double srlat = Math.sin(rlat);
        double crlon = Math.cos(rlon);
        double crlat = Math.cos(rlat);
        double srlat2 = srlat * srlat;
        double crlat2 = crlat * crlat;
        double a2 = 4.068063159076899E7;
        double b2 = 4.040829998408706E7;
        double c2 = a2 - b2;
        double a4 = a2 * a2;
        double b4 = b2 * b2;
        double c4 = a4 - b4;
        this.sp[1] = srlon;
        this.cp[1] = crlon;
        double q = Math.sqrt(a2 - c2 * srlat2);
        double q1 = altitudeKm * q;
        double q2 = (q1 + a2) / (q1 + b2) * ((q1 + a2) / (q1 + b2));
        double r2 = altitudeKm * altitudeKm + 2.0 * q1 + (a4 - c4 * srlat2) / (q * q);
        this.ct = srlat / Math.sqrt(q2 * crlat2 + srlat2);
        this.st = Math.sqrt(1.0 - this.ct * this.ct);
        this.r = Math.sqrt(r2);
        this.d = Math.sqrt(a2 * crlat2 + b2 * srlat2);
        this.ca = (altitudeKm + this.d) / this.r;
        this.sa = c2 * crlat * srlat / (this.r * this.d);
        int m = 2;
        while (m <= this.maxord) {
            this.sp[m] = this.sp[1] * this.cp[m - 1] + this.cp[1] * this.sp[m - 1];
            this.cp[m] = this.cp[1] * this.cp[m - 1] - this.sp[1] * this.sp[m - 1];
            ++m;
        }
        double aor = 6371.2 / this.r;
        double ar = aor * aor;
        double br = 0.0;
        double bt = 0.0;
        double bp = 0.0;
        double bpp = 0.0;
        int n = 1;
        while (n <= this.maxord) {
            ar *= aor;
            int m2 = 0;
            int d3 = 1;
            int d4 = (n + m2 + d3) / d3;
            while (d4 > 0) {
                double temp2;
                double temp1;
                if (n == m2) {
                    this.snorm[n + m2 * 13] = this.st * this.snorm[n - 1 + (m2 - 1) * 13];
                    this.dp[m2][n] = this.st * this.dp[m2 - 1][n - 1] + this.ct * this.snorm[n - 1 + (m2 - 1) * 13];
                }
                if (n == 1 && m2 == 0) {
                    this.snorm[n + m2 * 13] = this.ct * this.snorm[n - 1 + m2 * 13];
                    this.dp[m2][n] = this.ct * this.dp[m2][n - 1] - this.st * this.snorm[n - 1 + m2 * 13];
                }
                if (n > 1 && n != m2) {
                    if (m2 > n - 2) {
                        this.snorm[n - 2 + m2 * 13] = 0.0;
                    }
                    if (m2 > n - 2) {
                        this.dp[m2][n - 2] = 0.0;
                    }
                    this.snorm[n + m2 * 13] = this.ct * this.snorm[n - 1 + m2 * 13] - this.k[m2][n] * this.snorm[n - 2 + m2 * 13];
                    this.dp[m2][n] = this.ct * this.dp[m2][n - 1] - this.st * this.snorm[n - 1 + m2 * 13] - this.k[m2][n] * this.dp[m2][n - 2];
                }
                this.tc[m2][n] = this.c[m2][n] + dt * this.cd[m2][n];
                if (m2 != 0) {
                    this.tc[n][m2 - 1] = this.c[n][m2 - 1] + dt * this.cd[n][m2 - 1];
                }
                double par = ar * this.snorm[n + m2 * 13];
                if (m2 == 0) {
                    temp1 = this.tc[m2][n] * this.cp[m2];
                    temp2 = this.tc[m2][n] * this.sp[m2];
                } else {
                    temp1 = this.tc[m2][n] * this.cp[m2] + this.tc[n][m2 - 1] * this.sp[m2];
                    temp2 = this.tc[m2][n] * this.sp[m2] - this.tc[n][m2 - 1] * this.cp[m2];
                }
                bt -= ar * temp1 * this.dp[m2][n];
                bp += this.fm[m2] * temp2 * par;
                br += this.fn[n] * temp1 * par;
                if (this.st == 0.0 && m2 == 1) {
                    this.pp[n] = n == 1 ? this.pp[n - 1] : this.ct * this.pp[n - 1] - this.k[m2][n] * this.pp[n - 2];
                    double parp = ar * this.pp[n];
                    bpp += this.fm[m2] * temp2 * parp;
                }
                --d4;
                m2 += d3;
            }
            ++n;
        }
        bp = this.st == 0.0 ? bpp : (bp /= this.st);
        double bx = -bt * this.ca - br * this.sa;
        double by = bp;
        double bz = bt * this.sa - br * this.ca;
        double bh = Math.sqrt(bx * bx + by * by);
        double intensity = Math.sqrt(bh * bh + bz * bz);
        double declination = Math.toDegrees(Math.atan2(by, bx));
        double inclination = Math.toDegrees(Math.atan2(bz, bh));
        return new Result(declination, inclination, intensity, bh, bz, bx, by);
    }

    Result calculate(double longitude, double latitude, double altitude) {
        return this.calculate(longitude, latitude, altitude, new GregorianCalendar());
    }

    Result calculate(double longitude, double latitude) {
        return this.calculate(longitude, latitude, 0.0);
    }

    public double getEpoch() {
        return this.epoch;
    }

    public TimePoint getStartOfValidity() {
        return this.startOfValidity;
    }

    public String getName() {
        return this.name;
    }

    public TimePoint getIssueTimePoint() {
        return this.issueTimePoint;
    }

    class Result {
        private final double declination;
        private final double inclination;
        private final double intensity;
        private final double bh;
        private final double bz;
        private final double bx;
        private final double by;

        public Result(double declination, double inclination, double intensity, double bh, double bz, double bx, double by) {
            this.declination = declination;
            this.inclination = inclination;
            this.intensity = intensity;
            this.bh = bh;
            this.bz = bz;
            this.bx = bx;
            this.by = by;
        }

        double getDeclination() {
            return this.declination;
        }

        double getInclination() {
            return this.inclination;
        }

        double getIntensity() {
            return this.intensity;
        }

        double getHorizontalIntensity() {
            return this.bh;
        }

        double getVerticalIntensity() {
            return this.bz;
        }

        double getNorthIntensity() {
            return this.bx;
        }

        double getEastIntensity() {
            return this.by;
        }

        String getModelName() {
            return Geomagnetism.this.getName();
        }

        TimePoint getModelIssueTimePoint() {
            return Geomagnetism.this.getIssueTimePoint();
        }
    }
}

