/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.data.HasTrackedLegContext;
import com.sap.sailing.datamining.data.HasTrackedRaceContext;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;

public class TrackedLegWithContext
implements HasTrackedLegContext {
    private final HasTrackedRaceContext trackedRaceContext;
    private final TrackedLeg trackedLeg;
    private final int legNumber;
    private LegType legType;
    private boolean legTypeHasBeenInitialized;

    public TrackedLegWithContext(HasTrackedRaceContext trackedRaceContext, TrackedLeg trackedLeg, int legNumber) {
        this.trackedRaceContext = trackedRaceContext;
        this.trackedLeg = trackedLeg;
        this.legNumber = legNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.trackedLeg == null ? 0 : this.trackedLeg.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrackedLegWithContext other = (TrackedLegWithContext)obj;
        return !(this.trackedLeg == null ? other.trackedLeg != null : !this.trackedLeg.equals(other.trackedLeg));
    }

    @Override
    public HasTrackedRaceContext getTrackedRaceContext() {
        return this.trackedRaceContext;
    }

    @Override
    public TrackedLeg getTrackedLeg() {
        return this.trackedLeg;
    }

    @Override
    public LegType getLegType() {
        if (!this.legTypeHasBeenInitialized) {
            this.initializeLegType();
        }
        return this.legType;
    }

    @Override
    public int getLegNumber() {
        return this.legNumber;
    }

    private void initializeLegType() {
        try {
            this.legType = this.getTrackedLeg() == null ? null : this.getTrackedLeg().getLegType(this.getTimePointForLegType());
        }
        catch (NoWindException e) {
            this.legType = null;
        }
        this.legTypeHasBeenInitialized = true;
    }

    private TimePoint getTimePointForLegType() {
        MillisecondsTimePoint at = null;
        for (TrackedLegOfCompetitor trackedLegOfCompetitor : this.getTrackedLeg().getTrackedLegsOfCompetitors()) {
            TimePoint start = trackedLegOfCompetitor.getStartTime();
            TimePoint finish = trackedLegOfCompetitor.getFinishTime();
            if (start == null || finish == null) continue;
            at = new MillisecondsTimePoint((start.asMillis() + finish.asMillis()) / 2L);
            break;
        }
        return at;
    }

    @Override
    public Distance getLegLength() {
        return this.getTrackedLeg().getWindwardDistance();
    }
}

