/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.datamining.data.HasFoilingSegmentContext;
import com.sap.sailing.datamining.data.HasRaceOfCompetitorContext;
import com.sap.sailing.datamining.impl.data.BravoFixTrackWithContext;
import com.sap.sailing.datamining.impl.data.FoilingSegmentWithContext;
import com.sap.sailing.datamining.shared.FoilingSegmentsDataMiningSettings;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.tracking.BravoFix;
import com.sap.sailing.domain.tracking.BravoFixTrack;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class FoilingSegmentRetrievalProcessor
extends AbstractRetrievalProcessor<HasRaceOfCompetitorContext, HasFoilingSegmentContext> {
    private final FoilingSegmentsDataMiningSettings settings;

    public FoilingSegmentRetrievalProcessor(ExecutorService executor, Collection<Processor<HasFoilingSegmentContext, ?>> resultReceivers, FoilingSegmentsDataMiningSettings settings, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasRaceOfCompetitorContext.class, HasFoilingSegmentContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
        this.settings = settings;
    }

    protected Iterable<HasFoilingSegmentContext> retrieveData(HasRaceOfCompetitorContext element) {
        ArrayList<HasFoilingSegmentContext> foilingSegments = new ArrayList<HasFoilingSegmentContext>();
        TrackedRace trackedRace = element.getTrackedRaceContext().getTrackedRace();
        TimePoint startOfRace = element.getTrackedRaceContext().getTrackedRace().getStartOfRace();
        if (startOfRace != null) {
            TimePoint endOfTracking;
            TimePoint endOfRace = element.getTrackedRaceContext().getTrackedRace().getEndOfRace();
            TimePoint end = endOfRace == null ? ((endOfTracking = element.getTrackedRaceContext().getTrackedRace().getEndOfTracking()) == null ? MillisecondsTimePoint.now() : endOfTracking) : endOfRace;
            BravoFixTrack bravoFixTrack = (BravoFixTrack)trackedRace.getSensorTrack(element.getCompetitor(), "BravoFixTrack");
            if (bravoFixTrack != null) {
                boolean isFoiling = false;
                TimePoint last = null;
                TimePoint startOfSegment = null;
                bravoFixTrack.lockForRead();
                try {
                    for (BravoFix bravoFix : bravoFixTrack.getFixes(startOfRace, true, end, false)) {
                        boolean currentFixIsFoiling;
                        if (this.isAborted()) {
                            break;
                        }
                        boolean bl = currentFixIsFoiling = bravoFix.isFoiling(this.settings.getMinimumRideHeight()) && (this.settings.getMinimumSpeedForFoiling() == null || this.settings.getMinimumSpeedForFoiling().compareTo((Object)element.getTrackedRaceContext().getTrackedRace().getTrack(element.getCompetitor()).getEstimatedSpeed(bravoFix.getTimePoint())) <= 0) || this.settings.getMaximumSpeedNotFoiling() != null && this.settings.getMaximumSpeedNotFoiling().compareTo((Object)element.getTrackedRaceContext().getTrackedRace().getTrack(element.getCompetitor()).getEstimatedSpeed(bravoFix.getTimePoint())) <= 0;
                        if (currentFixIsFoiling != isFoiling) {
                            if (currentFixIsFoiling) {
                                startOfSegment = bravoFix.getTimePoint();
                            } else {
                                if (this.settings.getMinimumFoilingSegmentDuration() == null || startOfSegment.until(last).compareTo((Object)this.settings.getMinimumFoilingSegmentDuration()) >= 0) {
                                    this.addOrMergeFoilingSegment(element, foilingSegments, (BravoFixTrack<Competitor>)bravoFixTrack, startOfSegment, last);
                                }
                                startOfSegment = null;
                            }
                            isFoiling = currentFixIsFoiling;
                        }
                        last = bravoFix.getTimePoint();
                    }
                }
                finally {
                    bravoFixTrack.unlockAfterRead();
                }
                if (isFoiling) {
                    this.addOrMergeFoilingSegment(element, foilingSegments, (BravoFixTrack<Competitor>)bravoFixTrack, startOfSegment, end);
                }
            }
        }
        return foilingSegments;
    }

    private void addOrMergeFoilingSegment(HasRaceOfCompetitorContext element, List<HasFoilingSegmentContext> foilingSegments, BravoFixTrack<Competitor> bravoFixTrack, TimePoint startOfSegment, TimePoint endOfSegment) {
        if (foilingSegments.isEmpty() || this.settings.getMinimumDurationBetweenAdjacentFoilingSegments() == null) {
            foilingSegments.add(this.createFoilingSegment(startOfSegment, endOfSegment, element, bravoFixTrack));
        } else {
            HasFoilingSegmentContext previousSegment = foilingSegments.get(foilingSegments.size() - 1);
            TimePoint previousEnd = previousSegment.getEndOfFoilingSegment();
            if (previousEnd.until(startOfSegment).compareTo((Object)this.settings.getMinimumDurationBetweenAdjacentFoilingSegments()) < 0) {
                foilingSegments.set(foilingSegments.size() - 1, this.createFoilingSegment(previousSegment.getStartOfFoilingSegment(), endOfSegment, element, bravoFixTrack));
            } else {
                foilingSegments.add(this.createFoilingSegment(startOfSegment, endOfSegment, element, bravoFixTrack));
            }
        }
    }

    private HasFoilingSegmentContext createFoilingSegment(TimePoint startOfSegment, TimePoint endOfSegment, HasRaceOfCompetitorContext raceOfCompetitorContext, BravoFixTrack<Competitor> bravoFixTrack) {
        return new FoilingSegmentWithContext(new BravoFixTrackWithContext(raceOfCompetitorContext, bravoFixTrack), startOfSegment, endOfSegment);
    }
}

