/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.classifier;

import com.sap.sailing.windestimation.model.AbstractModelCache;
import com.sap.sailing.windestimation.model.ModelContext;
import com.sap.sailing.windestimation.model.classifier.ClassificationResultMapper;
import com.sap.sailing.windestimation.model.classifier.ClassifierModelFactory;
import com.sap.sailing.windestimation.model.classifier.TrainableClassificationModel;
import com.sap.sailing.windestimation.model.exception.ModelLoadingException;
import com.sap.sailing.windestimation.model.store.ModelStore;

public abstract class AbstractClassifiersCache<InstanceType, MC extends ModelContext<InstanceType>, ClassificationResultType>
extends AbstractModelCache<InstanceType, MC, TrainableClassificationModel<InstanceType, MC>> {
    private final ClassificationResultMapper<InstanceType, MC, ClassificationResultType> classificationResultMapper;

    public AbstractClassifiersCache(ModelStore modelStore, boolean preloadAllModels, long preserveLoadedModelsMillis, ClassifierModelFactory<InstanceType, MC> modelFactory, ClassificationResultMapper<InstanceType, MC, ClassificationResultType> classificationResultMapper) {
        super(modelStore, preloadAllModels, preserveLoadedModelsMillis, modelFactory);
        this.classificationResultMapper = classificationResultMapper;
    }

    public ClassificationResultType classifyInstance(InstanceType instance) {
        Object modelContext = this.getModelContext(instance);
        TrainableClassificationModel bestClassifierModel = (TrainableClassificationModel)this.getBestModel(modelContext);
        if (bestClassifierModel == null) {
            throw new ModelLoadingException("No model available for: " + modelContext);
        }
        double[] likelihoods = bestClassifierModel.classifyWithProbabilities(instance);
        ClassificationResultType result = this.classificationResultMapper.mapToClassificationResult(likelihoods, instance, modelContext);
        return result;
    }
}

