/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.graph;

import com.sap.sailing.windestimation.aggregator.graph.ElementWithQuality;
import com.sap.sailing.windestimation.aggregator.graph.GroupOutOfWhichToPickTheBestElement;
import com.sap.sailing.windestimation.aggregator.graph.Tree;
import com.sap.sse.common.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public class InnerGraphSuccessorSupplier<T extends ElementWithQuality, G extends GroupOutOfWhichToPickTheBestElement<T, G>>
implements Function<T, Iterable<T>> {
    private final Map<T, Set<T>> successors = new HashMap<T, Set<T>>();
    private final T artificialRoot;
    private final Map<G, T> artificialLeaves;
    private final Function<Supplier<String>, T> artificialInnerNodeConstructor;

    public InnerGraphSuccessorSupplier(Tree<G> overarchingTree, Function<Supplier<String>, T> artificialInnerNodeConstructor) {
        this.artificialInnerNodeConstructor = artificialInnerNodeConstructor;
        this.artificialRoot = (ElementWithQuality)((Object)artificialInnerNodeConstructor.apply(() -> "End Node at Root"));
        this.artificialLeaves = new HashMap<G, T>();
        if (overarchingTree.getRoot() != null) {
            for (ElementWithQuality innerRootElement : ((GroupOutOfWhichToPickTheBestElement)overarchingTree.getRoot()).getElements()) {
                Util.addToValueSet(this.successors, (Object)innerRootElement, this.artificialRoot);
            }
            this.addAllEdges((GroupOutOfWhichToPickTheBestElement)overarchingTree.getRoot());
        }
    }

    private void addAllEdges(G node) {
        Set<ElementWithQuality> innerChildElements;
        if (Util.isEmpty(node.getChildren())) {
            ElementWithQuality artificialLeaf = (ElementWithQuality)this.artificialInnerNodeConstructor.apply(() -> "Start Node for " + node);
            this.artificialLeaves.put(node, artificialLeaf);
            innerChildElements = Collections.singleton(artificialLeaf);
        } else {
            HashSet<ElementWithQuality> allInnerChildNodes = new HashSet<ElementWithQuality>();
            for (GroupOutOfWhichToPickTheBestElement child : node.getChildren()) {
                for (ElementWithQuality innerChildElement : child.getElements()) {
                    allInnerChildNodes.add(innerChildElement);
                }
                this.addAllEdges(child);
            }
            innerChildElements = allInnerChildNodes;
        }
        for (ElementWithQuality innerChildElement : innerChildElements) {
            for (ElementWithQuality innerParentElement : node.getElements()) {
                Util.addToValueSet(this.successors, (Object)innerChildElement, (Object)innerParentElement);
            }
        }
    }

    @Override
    public Iterable<T> apply(T t) {
        return this.successors.get(t);
    }

    public T getArtificialRoot() {
        return this.artificialRoot;
    }

    public T getArtificialLeaf(G treeLeafNode) {
        return (T)((ElementWithQuality)this.artificialLeaves.get(treeLeafNode));
    }
}

