/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.impl;

import com.mongodb.BasicDBList;
import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoCommandException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCCertificateAssignmentEvent;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCImpliedWindSourceEvent;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCLegDataEvent;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCScratchBoatEvent;
import com.sap.sailing.domain.abstractlog.orc.RegattaLogORCCertificateAssignmentEvent;
import com.sap.sailing.domain.abstractlog.race.CompetitorResult;
import com.sap.sailing.domain.abstractlog.race.CompetitorResults;
import com.sap.sailing.domain.abstractlog.race.RaceLogCourseAreaSpecification;
import com.sap.sailing.domain.abstractlog.race.RaceLogCourseDesignChangedEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogDependentStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEndOfTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogExcludeWindSourcesEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFinishPositioningConfirmedEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFinishPositioningListChangedEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFixedMarkPassingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFlagEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogGateLineOpeningTimeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogPassChangeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogPathfinderEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogProtestStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogRaceStatusEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogResultsAreOfficialEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartOfTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartProcedureChangedEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogSuppressedMarkPassingsEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogTagEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogWindFixEvent;
import com.sap.sailing.domain.abstractlog.race.SimpleRaceLogIdentifier;
import com.sap.sailing.domain.abstractlog.race.scoring.RaceLogAdditionalScoringInformationEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogDenoteForTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogRegisterCompetitorEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogStartTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogUseCompetitorsFromRaceLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogCloseOpenEndedDeviceMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDefineMarkEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceBoatMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceBoatSensorDataMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceCompetitorMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceCompetitorSensorDataMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceMarkMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRegisterBoatEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRegisterCompetitorEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogSetCompetitorTimeOnDistanceAllowancePerNauticalMileEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogSetCompetitorTimeOnTimeFactorEvent;
import com.sap.sailing.domain.anniversary.DetailedRaceInfo;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.ControlPointWithTwoMarks;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.RemoteSailingServerReference;
import com.sap.sailing.domain.base.SailingServerConfiguration;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.Venue;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.domain.base.impl.FleetImpl;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.Positioned;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.dto.AnniversaryType;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.leaderboard.FlexibleLeaderboard;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithEliminations;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithOtherTieBreakingLeaderboard;
import com.sap.sailing.domain.leaderboard.ResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.SettableScoreCorrection;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprint;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprint;
import com.sap.sailing.domain.persistence.FieldNames;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.impl.CollectionNames;
import com.sap.sailing.domain.persistence.impl.DomainObjectFactoryImpl;
import com.sap.sailing.domain.persistence.impl.MongoUtils;
import com.sap.sailing.domain.persistence.impl.MongoWindListener;
import com.sap.sailing.domain.persistence.impl.TripleSerializer;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifier;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sailing.domain.tracking.ManeuverLoss;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParametersHandler;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.WindListener;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.server.gateway.serialization.impl.BoatClassJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.BoatJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorWithBoatRefJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.DeviceConfigurationJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.RegattaConfigurationJsonSerializer;
import com.sap.sailing.server.gateway.serialization.racelog.impl.ImpliedWindSourceSerializer;
import com.sap.sailing.server.gateway.serialization.racelog.impl.ORCCertificateJsonSerializer;
import com.sap.sailing.shared.persistence.device.DeviceIdentifierMongoHandler;
import com.sap.sailing.shared.persistence.device.impl.PlaceHolderDeviceIdentifierMongoHandler;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.common.Util;
import com.sap.sse.shared.json.JsonSerializer;
import com.sap.sse.shared.media.ImageDescriptor;
import com.sap.sse.shared.media.VideoDescriptor;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.json.simple.JSONObject;

public class MongoObjectFactoryImpl
implements MongoObjectFactory {
    private static Logger logger = Logger.getLogger(MongoObjectFactoryImpl.class.getName());
    private final MongoDatabase database;
    private final CompetitorWithBoatRefJsonSerializer competitorWithBoatRefSerializer = CompetitorWithBoatRefJsonSerializer.create((boolean)true);
    private final CompetitorJsonSerializer competitorSerializer = CompetitorJsonSerializer.create((boolean)true, (boolean)true, (boolean)false);
    private final BoatJsonSerializer boatSerializer = new BoatJsonSerializer((JsonSerializer)new BoatClassJsonSerializer(false));
    private final TypeBasedServiceFinder<DeviceIdentifierMongoHandler> deviceIdentifierServiceFinder;
    private final TypeBasedServiceFinder<RaceTrackingConnectivityParametersHandler> raceTrackingConnectivityParamsServiceFinder;

    public MongoObjectFactoryImpl(MongoDatabase database) {
        this(database, null);
    }

    public MongoObjectFactoryImpl(MongoDatabase database, TypeBasedServiceFinderFactory serviceFinderFactory) {
        this.database = database;
        if (serviceFinderFactory != null) {
            this.deviceIdentifierServiceFinder = serviceFinderFactory.createServiceFinder(DeviceIdentifierMongoHandler.class);
            this.deviceIdentifierServiceFinder.setFallbackService((Object)new PlaceHolderDeviceIdentifierMongoHandler());
            this.raceTrackingConnectivityParamsServiceFinder = serviceFinderFactory.createServiceFinder(RaceTrackingConnectivityParametersHandler.class);
        } else {
            this.deviceIdentifierServiceFinder = null;
            this.raceTrackingConnectivityParamsServiceFinder = null;
        }
    }

    @Override
    public MongoDatabase getDatabase() {
        return this.database;
    }

    @Override
    public Document storeWind(Wind wind) {
        Document result = new Document();
        this.storePositioned((Positioned)wind, result);
        this.storeTimed((Timed)wind, result);
        this.storeSpeedWithBearing((SpeedWithBearing)wind, result);
        return result;
    }

    public static void storeTimePoint(TimePoint timePoint, Document result, String fieldName) {
        if (timePoint != null) {
            result.put(fieldName, (Object)timePoint.asMillis());
        }
    }

    public static void storeTimePoint(TimePoint timePoint, Document result, FieldNames field) {
        MongoObjectFactoryImpl.storeTimePoint(timePoint, result, field.name());
    }

    public static void storeTimeRange(TimeRange timeRange, Document result, FieldNames field) {
        if (timeRange != null) {
            Document timeRangeObj = new Document();
            MongoObjectFactoryImpl.storeTimePoint(timeRange.from(), timeRangeObj, FieldNames.FROM_MILLIS);
            MongoObjectFactoryImpl.storeTimePoint(timeRange.to(), timeRangeObj, FieldNames.TO_MILLIS);
            result.put(field.name(), (Object)timeRangeObj);
        }
    }

    public void storeTimed(Timed timed, Document result) {
        if (timed.getTimePoint() != null) {
            MongoObjectFactoryImpl.storeTimePoint(timed.getTimePoint(), result, FieldNames.TIME_AS_MILLIS);
        }
    }

    public void storeSpeedWithBearing(SpeedWithBearing speedWithBearing, Document result) {
        this.storeSpeed((Speed)speedWithBearing, result);
        this.storeBearing(speedWithBearing.getBearing(), result);
    }

    public void storeOptionalTrueHeading(Bearing optionalTrueHeading, Document result) {
        if (optionalTrueHeading != null) {
            result.put(FieldNames.TRUE_HEADING_DEG.name(), (Object)optionalTrueHeading.getDegrees());
        }
    }

    public void storeBearing(Bearing bearing, Document result) {
        result.put(FieldNames.DEGREE_BEARING.name(), (Object)bearing.getDegrees());
    }

    public void storeSpeed(Speed speed, Document result) {
        result.put(FieldNames.KNOT_SPEED.name(), (Object)speed.getKnots());
    }

    public void storePositioned(Positioned positioned, Document result) {
        if (positioned.getPosition() != null) {
            result.put(FieldNames.LAT_DEG.name(), (Object)positioned.getPosition().getLatDeg());
            result.put(FieldNames.LNG_DEG.name(), (Object)positioned.getPosition().getLngDeg());
        }
    }

    @Override
    public void addWindTrackDumper(TrackedRegatta trackedRegatta, TrackedRace trackedRace, WindSource windSource) {
        WindTrack windTrack = trackedRace.getOrCreateWindTrack(windSource);
        windTrack.addListener((WindListener)new MongoWindListener(trackedRace, trackedRegatta.getRegatta().getName(), windSource, this, this.database));
    }

    public MongoCollection<Document> getWindTrackCollection() {
        MongoCollection result = this.database.getCollection(CollectionNames.WIND_TRACKS.name());
        DomainObjectFactoryImpl.ensureIndicesOnWindTracks((MongoCollection<Document>)result);
        return result;
    }

    public MongoCollection<Document> getGPSFixCollection(ClientSession clientSession) {
        MongoCollection gpsFixCollection = this.database.getCollection(CollectionNames.GPS_FIXES.name());
        this.dropIndexSafe((MongoCollection<Document>)gpsFixCollection, "DEVICE_ID.DEVICE_TYPE_SPECIFIC_ID_1_GPSFIX.TIME_AS_MILLIS_1");
        this.dropIndexSafe((MongoCollection<Document>)gpsFixCollection, "DEVICE_ID_1_GPSFIX.TIME_AS_MILLIS_1");
        this.dropIndexSafe((MongoCollection<Document>)gpsFixCollection, "fixbytimeanddev");
        Document index = new Document();
        index.put(String.valueOf(FieldNames.DEVICE_ID.name()) + "." + com.sap.sailing.shared.persistence.impl.FieldNames.DEVICE_STRING_REPRESENTATION.name(), (Object)"hashed");
        index.put(FieldNames.TIME_AS_MILLIS.name(), (Object)1);
        index.put(String.valueOf(FieldNames.DEVICE_ID.name()) + "." + com.sap.sailing.shared.persistence.impl.FieldNames.DEVICE_TYPE.name(), (Object)1);
        index.put(String.valueOf(FieldNames.DEVICE_ID.name()) + "." + com.sap.sailing.shared.persistence.impl.FieldNames.DEVICE_TYPE_SPECIFIC_ID.name(), (Object)1);
        IndexOptions indexOptions = new IndexOptions().name("fixbydevandtime").background(false);
        if (clientSession == null) {
            gpsFixCollection.createIndex((Bson)index, indexOptions);
        } else {
            gpsFixCollection.createIndex(clientSession, (Bson)index, indexOptions);
        }
        return gpsFixCollection;
    }

    private void dropIndexSafe(MongoCollection<Document> collection, String indexName) {
        collection.listIndexes().forEach(indexInfo -> {
            if (indexName.equals(indexInfo.get((Object)"name"))) {
                collection.dropIndex(indexName);
            }
        });
    }

    public MongoCollection<Document> getGPSFixMetadataCollection() {
        MongoCollection collection = this.database.getCollection(CollectionNames.GPS_FIXES_METADATA.name());
        Document index = new Document();
        index.put(FieldNames.DEVICE_ID.name(), (Object)1);
        collection.createIndex((Bson)index);
        return collection;
    }

    public Document storeWindTrackEntry(RaceDefinition race, String regattaName, WindSource windSource, Wind wind) {
        Document result = new Document();
        result.put(FieldNames.RACE_ID.name(), (Object)race.getId());
        result.put(FieldNames.REGATTA_NAME.name(), (Object)regattaName);
        result.put(FieldNames.WIND_SOURCE_NAME.name(), (Object)windSource.name());
        if (windSource.getId() != null) {
            result.put(FieldNames.WIND_SOURCE_ID.name(), windSource.getId());
        }
        result.put(FieldNames.WIND.name(), (Object)this.storeWind(wind));
        return result;
    }

    private void storeRaceIdentifiers(RaceColumn raceColumn, Document dbObject) {
        Document raceIdentifiersPerFleet = new Document();
        for (Fleet fleet : raceColumn.getFleets()) {
            RaceIdentifier raceIdentifier = raceColumn.getRaceIdentifier(fleet);
            if (raceIdentifier == null) continue;
            Document raceIdentifierForFleet = new Document();
            this.storeRaceIdentifier(raceIdentifierForFleet, raceIdentifier);
            raceIdentifiersPerFleet.put(MongoUtils.escapeDollarAndDot(fleet.getName()), (Object)raceIdentifierForFleet);
        }
        dbObject.put(FieldNames.RACE_IDENTIFIERS.name(), (Object)raceIdentifiersPerFleet);
    }

    private void storeRaceIdentifier(Document dbObject, RaceIdentifier raceIdentifier) {
        if (raceIdentifier != null) {
            dbObject.put(FieldNames.EVENT_NAME.name(), (Object)raceIdentifier.getRegattaName());
            dbObject.put(FieldNames.RACE_NAME.name(), (Object)raceIdentifier.getRaceName());
        }
    }

    @Override
    public void storeLeaderboard(Leaderboard leaderboard) {
        MongoCollection leaderboardCollection = this.database.getCollection(CollectionNames.LEADERBOARDS.name()).withWriteConcern(WriteConcern.MAJORITY);
        try {
            leaderboardCollection.createIndex((Bson)new Document(FieldNames.LEADERBOARD_NAME.name(), (Object)1));
        }
        catch (NullPointerException npe) {
            logger.log(Level.SEVERE, "storeLeaderboard", npe);
        }
        Document query = new Document(FieldNames.LEADERBOARD_NAME.name(), (Object)leaderboard.getName());
        Document dbLeaderboard = new Document();
        dbLeaderboard.put(FieldNames.LEADERBOARD_NAME.name(), (Object)leaderboard.getName());
        if (leaderboard.getDisplayName() != null) {
            dbLeaderboard.put(FieldNames.LEADERBOARD_DISPLAY_NAME.name(), (Object)leaderboard.getDisplayName());
        }
        if (leaderboard instanceof RegattaLeaderboardWithEliminations) {
            dbLeaderboard.put(FieldNames.WRAPPED_REGATTA_LEADERBOARD_NAME.name(), (Object)((RegattaLeaderboardWithEliminations)leaderboard).getRegatta().getName());
            BasicDBList eliminatedCompetitorIds = new BasicDBList();
            for (Competitor c : ((RegattaLeaderboardWithEliminations)leaderboard).getEliminatedCompetitors()) {
                eliminatedCompetitorIds.add((Object)c.getId());
            }
            dbLeaderboard.put(FieldNames.ELMINATED_COMPETITORS.name(), (Object)eliminatedCompetitorIds);
        } else {
            BasicDBList dbSuppressedCompetitorIds = new BasicDBList();
            for (Competitor suppressedCompetitor : leaderboard.getSuppressedCompetitors()) {
                dbSuppressedCompetitorIds.add((Object)suppressedCompetitor.getId());
            }
            dbLeaderboard.put(FieldNames.LEADERBOARD_SUPPRESSED_COMPETITOR_IDS.name(), (Object)dbSuppressedCompetitorIds);
            if (leaderboard instanceof FlexibleLeaderboard) {
                this.storeFlexibleLeaderboard((FlexibleLeaderboard)leaderboard, dbLeaderboard);
            } else if (leaderboard instanceof RegattaLeaderboard) {
                this.storeRegattaLeaderboard((RegattaLeaderboard)leaderboard, dbLeaderboard);
            } else {
                dbLeaderboard.put(FieldNames.SCORING_SCHEME_TYPE.name(), (Object)leaderboard.getScoringScheme().getType().name());
            }
            BasicDBList courseAreaIdsAsStrings = new BasicDBList();
            Util.addAll((Iterable)Util.map((Iterable)leaderboard.getCourseAreas(), ca -> ca.getId().toString()), (Collection)courseAreaIdsAsStrings);
            dbLeaderboard.put(FieldNames.COURSE_AREA_IDS.name(), (Object)courseAreaIdsAsStrings);
            this.storeColumnFactors(leaderboard, dbLeaderboard);
            this.storeLeaderboardCorrectionsAndDiscards(leaderboard, dbLeaderboard);
        }
        leaderboardCollection.replaceOne((Bson)query, (Object)dbLeaderboard, new ReplaceOptions().upsert(true));
    }

    private void storeColumnFactors(Leaderboard leaderboard, Document dbLeaderboard) {
        Document raceColumnFactors = new Document();
        for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            Double explicitFactor = raceColumn.getExplicitFactor();
            if (explicitFactor == null) continue;
            raceColumnFactors.put(MongoUtils.escapeDollarAndDot(raceColumn.getName()), (Object)explicitFactor);
        }
        dbLeaderboard.put(FieldNames.LEADERBOARD_COLUMN_FACTORS.name(), (Object)raceColumnFactors);
    }

    private void storeRegattaLeaderboard(RegattaLeaderboard leaderboard, Document dbLeaderboard) {
        dbLeaderboard.put(FieldNames.REGATTA_NAME.name(), (Object)leaderboard.getRegatta().getName());
        if (leaderboard instanceof RegattaLeaderboardWithOtherTieBreakingLeaderboard) {
            dbLeaderboard.put(FieldNames.OTHER_TIEBREAKING_LEADERBOARD_NAME.name(), (Object)((RegattaLeaderboardWithOtherTieBreakingLeaderboard)leaderboard).getOtherTieBreakingLeaderboard().getName());
        }
    }

    private void storeFlexibleLeaderboard(FlexibleLeaderboard leaderboard, Document dbLeaderboard) {
        BasicDBList dbRaceColumns = new BasicDBList();
        dbLeaderboard.put(FieldNames.SCORING_SCHEME_TYPE.name(), (Object)leaderboard.getScoringScheme().getType().name());
        dbLeaderboard.put(FieldNames.LEADERBOARD_COLUMNS.name(), (Object)dbRaceColumns);
        for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            Document dbRaceColumn = this.storeRaceColumn(raceColumn);
            dbRaceColumns.add((Object)dbRaceColumn);
        }
    }

    private void storeLeaderboardCorrectionsAndDiscards(Leaderboard leaderboard, Document dbLeaderboard) {
        if (leaderboard.hasCarriedPoints()) {
            BasicDBList dbCarriedPoints = new BasicDBList();
            dbLeaderboard.put(FieldNames.LEADERBOARD_CARRIED_POINTS_BY_ID.name(), (Object)dbCarriedPoints);
            for (Map.Entry competitorWithCarriedPoints : leaderboard.getCompetitorsForWhichThereAreCarriedPoints().entrySet()) {
                double carriedPoints = (Double)competitorWithCarriedPoints.getValue();
                Competitor competitor = (Competitor)competitorWithCarriedPoints.getKey();
                Document dbCarriedPointsForCompetitor = new Document();
                dbCarriedPointsForCompetitor.put(FieldNames.COMPETITOR_ID.name(), (Object)competitor.getId());
                dbCarriedPointsForCompetitor.put(FieldNames.LEADERBOARD_CARRIED_POINTS.name(), (Object)carriedPoints);
                dbCarriedPoints.add((Object)dbCarriedPointsForCompetitor);
            }
        }
        Document dbScoreCorrections = new Document();
        this.storeScoreCorrections(leaderboard, dbScoreCorrections);
        dbLeaderboard.put(FieldNames.LEADERBOARD_SCORE_CORRECTIONS.name(), (Object)dbScoreCorrections);
        ResultDiscardingRule resultDiscardingRule = leaderboard.getResultDiscardingRule();
        this.storeResultDiscardingRule(dbLeaderboard, resultDiscardingRule, FieldNames.LEADERBOARD_DISCARDING_THRESHOLDS);
        BasicDBList competitorDisplayNames = new BasicDBList();
        for (Competitor competitor : leaderboard.getCompetitors()) {
            String displayNameForCompetitor = leaderboard.getDisplayName(competitor);
            if (displayNameForCompetitor == null) continue;
            Document dbDisplayName = new Document();
            dbDisplayName.put(FieldNames.COMPETITOR_ID.name(), (Object)competitor.getId());
            dbDisplayName.put(FieldNames.COMPETITOR_DISPLAY_NAME.name(), (Object)displayNameForCompetitor);
            competitorDisplayNames.add((Object)dbDisplayName);
        }
        dbLeaderboard.put(FieldNames.LEADERBOARD_COMPETITOR_DISPLAY_NAMES.name(), (Object)competitorDisplayNames);
    }

    private void storeResultDiscardingRule(Document dbObject, ResultDiscardingRule resultDiscardingRule, FieldNames field) {
        if (resultDiscardingRule != null && resultDiscardingRule instanceof ThresholdBasedResultDiscardingRule) {
            BasicDBList dbResultDiscardingThresholds = new BasicDBList();
            int[] nArray = ((ThresholdBasedResultDiscardingRule)resultDiscardingRule).getDiscardIndexResultsStartingWithHowManyRaces();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int threshold = nArray[n2];
                dbResultDiscardingThresholds.add((Object)threshold);
                ++n2;
            }
            dbObject.put(field.name(), (Object)dbResultDiscardingThresholds);
        }
    }

    private Document storeRaceColumn(RaceColumn raceColumn) {
        Document dbRaceColumn = new Document();
        dbRaceColumn.put(FieldNames.LEADERBOARD_COLUMN_NAME.name(), (Object)raceColumn.getName());
        dbRaceColumn.put(FieldNames.LEADERBOARD_IS_MEDAL_RACE_COLUMN.name(), (Object)raceColumn.isMedalRace());
        this.storeRaceIdentifiers(raceColumn, dbRaceColumn);
        return dbRaceColumn;
    }

    private void storeScoreCorrections(Leaderboard leaderboard, Document dbScoreCorrections) {
        TimePoint now = TimePoint.now();
        SettableScoreCorrection scoreCorrection = leaderboard.getScoreCorrection();
        for (RaceColumn raceColumn : scoreCorrection.getRaceColumnsThatHaveCorrections()) {
            BasicDBList dbCorrectionForRace = new BasicDBList();
            for (Competitor competitor : scoreCorrection.getCompetitorsThatHaveCorrectionsIn(raceColumn)) {
                Double incrementalScoreCorrectionInPoints;
                Double explicitScoreCorrection;
                if (!scoreCorrection.isScoreCorrected(competitor, raceColumn, now)) continue;
                Document dbCorrectionForCompetitor = new Document();
                dbCorrectionForCompetitor.put(FieldNames.COMPETITOR_ID.name(), (Object)competitor.getId());
                MaxPointsReason maxPointsReason = scoreCorrection.getMaxPointsReason(competitor, raceColumn, now);
                if (maxPointsReason != MaxPointsReason.NONE) {
                    dbCorrectionForCompetitor.put(FieldNames.LEADERBOARD_SCORE_CORRECTION_MAX_POINTS_REASON.name(), (Object)maxPointsReason.name());
                }
                if ((explicitScoreCorrection = scoreCorrection.getExplicitScoreCorrection(competitor, raceColumn)) != null) {
                    dbCorrectionForCompetitor.put(FieldNames.LEADERBOARD_CORRECTED_SCORE.name(), (Object)explicitScoreCorrection);
                }
                if ((incrementalScoreCorrectionInPoints = scoreCorrection.getIncementalScoreCorrectionInPoints(competitor, raceColumn)) != null) {
                    dbCorrectionForCompetitor.put(FieldNames.LEADERBOARD_INCREMENTAL_SCORE_CORRECTION_IN_POINTS.name(), (Object)incrementalScoreCorrectionInPoints);
                }
                dbCorrectionForRace.add((Object)dbCorrectionForCompetitor);
            }
            if (dbCorrectionForRace.isEmpty()) continue;
            dbScoreCorrections.put(MongoUtils.escapeDollarAndDot(raceColumn.getName()), (Object)dbCorrectionForRace);
        }
        TimePoint timePointOfLastCorrectionsValidity = scoreCorrection.getTimePointOfLastCorrectionsValidity();
        if (timePointOfLastCorrectionsValidity != null) {
            dbScoreCorrections.put(FieldNames.LEADERBOARD_SCORE_CORRECTION_TIMESTAMP.name(), (Object)timePointOfLastCorrectionsValidity.asMillis());
        }
        if (scoreCorrection.getComment() != null) {
            dbScoreCorrections.put(FieldNames.LEADERBOARD_SCORE_CORRECTION_COMMENT.name(), (Object)scoreCorrection.getComment());
        }
    }

    @Override
    public void removeLeaderboard(String leaderboardName) {
        MongoCollection leaderboardCollection = this.database.getCollection(CollectionNames.LEADERBOARDS.name());
        Document query = new Document(FieldNames.LEADERBOARD_NAME.name(), (Object)leaderboardName);
        leaderboardCollection.deleteOne((Bson)query);
    }

    @Override
    public void storeLeaderboardGroup(LeaderboardGroup leaderboardGroup) {
        MongoCollection leaderboardGroupCollection = this.database.getCollection(CollectionNames.LEADERBOARD_GROUPS.name());
        MongoCollection leaderboardCollection = this.database.getCollection(CollectionNames.LEADERBOARDS.name()).withReadConcern(ReadConcern.MAJORITY);
        try {
            leaderboardGroupCollection.createIndex((Bson)new Document(FieldNames.LEADERBOARD_GROUP_NAME.name(), (Object)1));
        }
        catch (NullPointerException npe) {
            logger.log(Level.SEVERE, "storeLeaderboardGroup", npe);
        }
        Document query = new Document(FieldNames.LEADERBOARD_GROUP_NAME.name(), (Object)leaderboardGroup.getName());
        Document dbLeaderboardGroup = new Document();
        dbLeaderboardGroup.put(FieldNames.LEADERBOARD_GROUP_UUID.name(), (Object)leaderboardGroup.getId());
        dbLeaderboardGroup.put(FieldNames.LEADERBOARD_GROUP_NAME.name(), (Object)leaderboardGroup.getName());
        dbLeaderboardGroup.put(FieldNames.LEADERBOARD_GROUP_DESCRIPTION.name(), (Object)leaderboardGroup.getDescription());
        dbLeaderboardGroup.put(FieldNames.LEADERBOARD_GROUP_DISPLAY_NAME.name(), (Object)leaderboardGroup.getDisplayName());
        dbLeaderboardGroup.put(FieldNames.LEADERBOARD_GROUP_DISPLAY_IN_REVERSE_ORDER.name(), (Object)leaderboardGroup.isDisplayGroupsInReverseOrder());
        Leaderboard overallLeaderboard = leaderboardGroup.getOverallLeaderboard();
        if (overallLeaderboard != null) {
            Document overallLeaderboardQuery = new Document(FieldNames.LEADERBOARD_NAME.name(), (Object)overallLeaderboard.getName());
            Document dbOverallLeaderboard = (Document)leaderboardCollection.find((Bson)overallLeaderboardQuery).first();
            if (dbOverallLeaderboard == null) {
                this.storeLeaderboard(overallLeaderboard);
                dbOverallLeaderboard = (Document)leaderboardCollection.withReadPreference(ReadPreference.primary()).find((Bson)overallLeaderboardQuery).first();
            }
            ObjectId dbOverallLeaderboardId = (ObjectId)dbOverallLeaderboard.get((Object)"_id");
            dbLeaderboardGroup.put(FieldNames.LEADERBOARD_GROUP_OVERALL_LEADERBOARD.name(), (Object)dbOverallLeaderboardId);
        }
        BasicDBList dbLeaderboardIds = new BasicDBList();
        for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
            Document leaderboardQuery = new Document(FieldNames.LEADERBOARD_NAME.name(), (Object)leaderboard.getName());
            Document dbLeaderboard = (Document)leaderboardCollection.find((Bson)leaderboardQuery).first();
            if (dbLeaderboard == null) {
                this.storeLeaderboard(leaderboard);
                dbLeaderboard = (Document)leaderboardCollection.find((Bson)leaderboardQuery).first();
            }
            ObjectId dbLeaderboardId = (ObjectId)dbLeaderboard.get((Object)"_id");
            dbLeaderboardIds.add((Object)dbLeaderboardId);
        }
        dbLeaderboardGroup.put(FieldNames.LEADERBOARD_GROUP_LEADERBOARDS.name(), (Object)dbLeaderboardIds);
        leaderboardGroupCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)dbLeaderboardGroup, new ReplaceOptions().upsert(true));
    }

    @Override
    public void removeLeaderboardGroup(UUID leaderboardGroupId) {
        MongoCollection leaderboardGroupCollection = this.database.getCollection(CollectionNames.LEADERBOARD_GROUPS.name());
        Document query = new Document(FieldNames.LEADERBOARD_GROUP_UUID.name(), (Object)leaderboardGroupId);
        leaderboardGroupCollection.deleteOne((Bson)query);
    }

    @Override
    public void renameLeaderboardGroup(UUID leaderboardGroupId, String newName) {
        MongoCollection leaderboardGroupCollection = this.database.getCollection(CollectionNames.LEADERBOARD_GROUPS.name());
        Document query = new Document(FieldNames.LEADERBOARD_GROUP_UUID.name(), (Object)leaderboardGroupId);
        Document update = new Document("$set", (Object)new Document(FieldNames.LEADERBOARD_GROUP_NAME.name(), (Object)newName));
        leaderboardGroupCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
    }

    @Override
    public void storeServerConfiguration(SailingServerConfiguration serverConfiguration) {
        MongoCollection serverCollection = this.database.getCollection(CollectionNames.SERVER_CONFIGURATION.name());
        Document newServerConfig = new Document();
        newServerConfig.put(FieldNames.SERVER_IS_STANDALONE.name(), (Object)serverConfiguration.isStandaloneServer());
        Document currentServerConfig = (Document)serverCollection.find().first();
        if (currentServerConfig != null) {
            serverCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)currentServerConfig, (Object)newServerConfig, new ReplaceOptions().upsert(true));
        } else {
            serverCollection.insertOne((Object)newServerConfig);
        }
    }

    @Override
    public void storeSailingServer(RemoteSailingServerReference server) {
        MongoCollection serverCollection = this.database.getCollection(CollectionNames.SAILING_SERVERS.name());
        serverCollection.createIndex((Bson)new Document(FieldNames.SERVER_NAME.name(), (Object)1));
        Document query = new Document();
        query.put(FieldNames.SERVER_NAME.name(), (Object)server.getName());
        Document serverDBObject = new Document();
        serverDBObject.put(FieldNames.SERVER_NAME.name(), (Object)server.getName());
        serverDBObject.put(FieldNames.SERVER_URL.name(), (Object)server.getURL().toExternalForm());
        serverDBObject.put(FieldNames.INCLUDE.name(), (Object)server.isInclude());
        serverDBObject.put(FieldNames.SELECTED_EVENT_IDS.name(), (Object)server.getSelectedEventIds());
        serverCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)serverDBObject, new ReplaceOptions().upsert(true));
    }

    @Override
    public void updateSailingServer(String serverName, boolean include, Set<UUID> selectedEventIds) {
        MongoCollection serverCollection = this.database.getCollection(CollectionNames.SAILING_SERVERS.name());
        Document query = new Document();
        query.put(FieldNames.SERVER_NAME.name(), (Object)serverName);
        Document serverDBObject = new Document();
        serverDBObject.put(FieldNames.INCLUDE.name(), (Object)include);
        serverDBObject.put(FieldNames.SELECTED_EVENT_IDS.name(), selectedEventIds);
        serverCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)serverDBObject, new ReplaceOptions().upsert(true));
    }

    @Override
    public void removeSailingServer(String name) {
        MongoCollection serverCollection = this.database.getCollection(CollectionNames.SAILING_SERVERS.name());
        Document query = new Document(FieldNames.SERVER_NAME.name(), (Object)name);
        serverCollection.deleteOne((Bson)query);
    }

    @Override
    public void storeEvent(Event event) {
        MongoCollection eventCollection = this.database.getCollection(CollectionNames.EVENTS.name());
        eventCollection.createIndex((Bson)new Document(FieldNames.EVENT_ID.name(), (Object)1));
        Document query = new Document();
        query.put(FieldNames.EVENT_ID.name(), (Object)event.getId());
        Document eventDBObject = new Document();
        eventDBObject.put(FieldNames.EVENT_NAME.name(), (Object)event.getName());
        eventDBObject.put(FieldNames.EVENT_DESCRIPTION.name(), (Object)event.getDescription());
        eventDBObject.put(FieldNames.EVENT_ID.name(), (Object)event.getId());
        eventDBObject.put(FieldNames.EVENT_OFFICIAL_WEBSITE_URL.name(), event.getOfficialWebsiteURL() != null ? event.getOfficialWebsiteURL().toString() : null);
        eventDBObject.put(FieldNames.EVENT_BASE_URL.name(), event.getBaseURL() != null ? event.getBaseURL().toString() : null);
        MongoObjectFactoryImpl.storeTimePoint(event.getStartDate(), eventDBObject, FieldNames.EVENT_START_DATE);
        MongoObjectFactoryImpl.storeTimePoint(event.getEndDate(), eventDBObject, FieldNames.EVENT_END_DATE);
        eventDBObject.put(FieldNames.EVENT_IS_PUBLIC.name(), (Object)event.isPublic());
        BasicDBList windFinderSpotCollectionIds = new BasicDBList();
        for (String windFinderSpotCollectionId : event.getWindFinderReviewedSpotsCollectionIds()) {
            windFinderSpotCollectionIds.add((Object)windFinderSpotCollectionId);
        }
        eventDBObject.put(FieldNames.EVENT_WINDFINDER_SPOT_COLLECTION_IDS.name(), (Object)windFinderSpotCollectionIds);
        Document venueDBObject = this.getVenueAsDBObject(event.getVenue());
        eventDBObject.put(FieldNames.VENUE.name(), (Object)venueDBObject);
        BasicDBList images = new BasicDBList();
        for (ImageDescriptor image : event.getImages()) {
            Document document = this.createImageObject(image);
            images.add((Object)document);
        }
        eventDBObject.put(FieldNames.EVENT_IMAGES.name(), (Object)images);
        BasicDBList videos = new BasicDBList();
        for (VideoDescriptor video : event.getVideos()) {
            Document videoObject = this.createVideoObject(video);
            videos.add((Object)videoObject);
        }
        eventDBObject.put(FieldNames.EVENT_VIDEOS.name(), (Object)videos);
        BasicDBList sailorsInfoWebsiteURLs = new BasicDBList();
        for (Map.Entry entry : event.getSailorsInfoWebsiteURLs().entrySet()) {
            Document sailorsInfoWebsiteObject = this.createSailorsInfoWebsiteObject((Locale)entry.getKey(), (URL)entry.getValue());
            sailorsInfoWebsiteURLs.add((Object)sailorsInfoWebsiteObject);
        }
        eventDBObject.put(FieldNames.EVENT_SAILORS_INFO_WEBSITES.name(), (Object)sailorsInfoWebsiteURLs);
        eventCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)eventDBObject, new ReplaceOptions().upsert(true));
        MongoCollection mongoCollection = this.database.getCollection(CollectionNames.LEADERBOARD_GROUP_LINKS_FOR_EVENTS.name());
        mongoCollection.createIndex((Bson)new Document(FieldNames.EVENT_ID.name(), (Object)1));
        BasicDBList lgUUIDs = new BasicDBList();
        for (LeaderboardGroup lg : event.getLeaderboardGroups()) {
            lgUUIDs.add((Object)lg.getId());
        }
        Document dbLinks = new Document();
        dbLinks.put(FieldNames.EVENT_ID.name(), (Object)event.getId());
        dbLinks.put(FieldNames.LEADERBOARD_GROUP_UUID.name(), (Object)lgUUIDs);
        mongoCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)dbLinks, new ReplaceOptions().upsert(true));
    }

    @Override
    public void renameEvent(Serializable id, String newName) {
        MongoCollection eventCollection = this.database.getCollection(CollectionNames.EVENTS.name());
        Document query = new Document(FieldNames.EVENT_ID.name(), (Object)id);
        Document renameUpdate = new Document("$set", (Object)new Document(FieldNames.EVENT_NAME.name(), (Object)newName));
        eventCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).updateOne((Bson)query, (Bson)renameUpdate, new UpdateOptions().upsert(true));
    }

    @Override
    public void removeEvent(Serializable id) {
        MongoCollection eventsCollection = this.database.getCollection(CollectionNames.EVENTS.name());
        Document query = new Document(FieldNames.EVENT_ID.name(), (Object)id);
        eventsCollection.deleteOne((Bson)query);
    }

    private Document getVenueAsDBObject(Venue venue) {
        Document result = new Document();
        result.put(FieldNames.VENUE_NAME.name(), (Object)venue.getName());
        BasicDBList courseAreaList = new BasicDBList();
        result.put(FieldNames.COURSE_AREAS.name(), (Object)courseAreaList);
        for (CourseArea courseArea : venue.getCourseAreas()) {
            Document courseAreaCenterPosition;
            Document dbCourseArea = new Document();
            courseAreaList.add((Object)dbCourseArea);
            dbCourseArea.put(FieldNames.COURSE_AREA_NAME.name(), (Object)courseArea.getName());
            dbCourseArea.put(FieldNames.COURSE_AREA_ID.name(), (Object)courseArea.getId());
            if (courseArea.getCenterPosition() != null) {
                courseAreaCenterPosition = new Document();
                this.storePositioned((Positioned)courseArea, courseAreaCenterPosition);
            } else {
                courseAreaCenterPosition = null;
            }
            dbCourseArea.put(FieldNames.COURSE_AREA_CENTER_POSITION.name(), (Object)courseAreaCenterPosition);
            Distance courseAreaRadius = courseArea.getRadius();
            if (courseAreaRadius == null) continue;
            dbCourseArea.put(FieldNames.COURSE_AREA_RADIUS_IN_METERS.name(), (Object)courseAreaRadius.getMeters());
        }
        return result;
    }

    @Override
    public void storeRegatta(Regatta regatta) {
        MongoCollection regattasCollection = this.database.getCollection(CollectionNames.REGATTAS.name());
        Document regattaByNameIndexKey = new Document(FieldNames.REGATTA_NAME.name(), (Object)1);
        try {
            regattasCollection.createIndex((Bson)regattaByNameIndexKey, new IndexOptions().unique(true).background(false));
        }
        catch (MongoCommandException e) {
            regattasCollection.dropIndex((Bson)regattaByNameIndexKey);
            regattasCollection.createIndex((Bson)regattaByNameIndexKey, new IndexOptions().unique(true).background(false));
        }
        Document regattaByIdIndexKey = new Document(FieldNames.REGATTA_ID.name(), (Object)1);
        try {
            regattasCollection.createIndex((Bson)regattaByIdIndexKey, new IndexOptions().unique(true).background(false));
        }
        catch (MongoCommandException e) {
            regattasCollection.dropIndex((Bson)regattaByIdIndexKey);
            regattasCollection.createIndex((Bson)regattaByIdIndexKey, new IndexOptions().unique(true).background(false));
        }
        Document dbRegatta = new Document();
        Document query = new Document(FieldNames.REGATTA_NAME.name(), (Object)regatta.getName());
        dbRegatta.put(FieldNames.REGATTA_NAME.name(), (Object)regatta.getName());
        dbRegatta.put(FieldNames.REGATTA_ID.name(), (Object)regatta.getId());
        MongoObjectFactoryImpl.storeTimePoint(regatta.getStartDate(), dbRegatta, FieldNames.REGATTA_START_DATE);
        MongoObjectFactoryImpl.storeTimePoint(regatta.getEndDate(), dbRegatta, FieldNames.REGATTA_END_DATE);
        dbRegatta.put(FieldNames.SCORING_SCHEME_TYPE.name(), (Object)regatta.getScoringScheme().getType().name());
        if (regatta.getBoatClass() != null) {
            dbRegatta.put(FieldNames.BOAT_CLASS_NAME.name(), (Object)regatta.getBoatClass().getName());
            dbRegatta.put(FieldNames.BOAT_CLASS_TYPICALLY_STARTS_UPWIND.name(), (Object)regatta.getBoatClass().typicallyStartsUpwind());
        }
        dbRegatta.put(FieldNames.REGATTA_SERIES.name(), (Object)this.storeSeries(regatta.getSeries()));
        BasicDBList courseAreaIdsAsStrings = new BasicDBList();
        Util.addAll((Iterable)Util.map((Iterable)regatta.getCourseAreas(), ca -> ca.getId().toString()), (Collection)courseAreaIdsAsStrings);
        dbRegatta.put(FieldNames.COURSE_AREA_IDS.name(), (Object)courseAreaIdsAsStrings);
        if (regatta.getRegattaConfiguration() != null) {
            RegattaConfigurationJsonSerializer serializer = RegattaConfigurationJsonSerializer.create();
            JSONObject json = serializer.serialize((Object)regatta.getRegattaConfiguration());
            Document configurationObject = Document.parse((String)json.toString());
            dbRegatta.put(FieldNames.REGATTA_REGATTA_CONFIGURATION.name(), (Object)configurationObject);
        }
        dbRegatta.put(FieldNames.REGATTA_BUOY_ZONE_RADIUS_IN_HULL_LENGTHS.name(), (Object)regatta.getBuoyZoneRadiusInHullLengths());
        dbRegatta.put(FieldNames.REGATTA_USE_START_TIME_INFERENCE.name(), (Object)regatta.useStartTimeInference());
        dbRegatta.put(FieldNames.REGATTA_CONTROL_TRACKING_FROM_START_AND_FINISH_TIMES.name(), (Object)regatta.isControlTrackingFromStartAndFinishTimes());
        dbRegatta.put(FieldNames.REGATTA_AUTO_RESTART_TRACKING_UPON_COMPETITOR_SET_CHANGE.name(), (Object)regatta.isAutoRestartTrackingUponCompetitorSetChange());
        dbRegatta.put(FieldNames.REGATTA_CAN_BOATS_OF_COMPETITORS_CHANGE_PER_RACE.name(), (Object)regatta.canBoatsOfCompetitorsChangePerRace());
        dbRegatta.put(FieldNames.REGATTA_COMPETITOR_REGISTRATION_TYPE.name(), (Object)regatta.getCompetitorRegistrationType().name());
        dbRegatta.put(FieldNames.REGATTA_REGISTRATION_LINK_SECRET.name(), (Object)regatta.getRegistrationLinkSecret());
        dbRegatta.put(FieldNames.REGATTA_RANKING_METRIC.name(), (Object)this.storeRankingMetric(regatta));
        boolean success = false;
        int MAX_TRIES = 3;
        int i = 0;
        while (i < 3 && !success) {
            block9: {
                try {
                    regattasCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)dbRegatta, new ReplaceOptions().upsert(true));
                    success = true;
                }
                catch (DuplicateKeyException e) {
                    if (i + 1 != 3) break block9;
                    throw e;
                }
            }
            ++i;
        }
    }

    private Document storeRankingMetric(Regatta regatta) {
        Document rankingMetricJson = new Document();
        String rankingMetricTypeName = regatta.getRankingMetricType().name();
        rankingMetricJson.put(FieldNames.REGATTA_RANKING_METRIC_TYPE.name(), (Object)rankingMetricTypeName);
        return rankingMetricJson;
    }

    @Override
    public void removeRegatta(Regatta regatta) {
        MongoCollection regattasCollection = this.database.getCollection(CollectionNames.REGATTAS.name());
        Document query = new Document(FieldNames.REGATTA_NAME.name(), (Object)regatta.getName());
        regattasCollection.deleteOne((Bson)query);
    }

    private BasicDBList storeSeries(Iterable<? extends Series> series) {
        BasicDBList dbSeries = new BasicDBList();
        for (Series series2 : series) {
            dbSeries.add((Object)this.storeSeries(series2));
        }
        return dbSeries;
    }

    private Document storeSeries(Series s) {
        Document dbSeries = new Document();
        dbSeries.put(FieldNames.SERIES_NAME.name(), (Object)s.getName());
        dbSeries.put(FieldNames.SERIES_IS_MEDAL.name(), (Object)s.isMedal());
        dbSeries.put(FieldNames.SERIES_IS_FLEETS_CAN_RUN_IN_PARALLEL.name(), (Object)s.isFleetsCanRunInParallel());
        dbSeries.put(FieldNames.SERIES_MAXIMUM_NUMBER_OF_DISCARDS.name(), (Object)s.getMaximumNumberOfDiscards());
        dbSeries.put(FieldNames.SERIES_HAS_SPLIT_FLEET_CONTIGUOUS_SCORING.name(), (Object)s.hasSplitFleetContiguousScoring());
        dbSeries.put(FieldNames.SERIES_HAS_CROSS_FLEET_MERGED_RANKING.name(), (Object)s.hasCrossFleetMergedRanking());
        dbSeries.put(FieldNames.SERIES_STARTS_WITH_ZERO_SCORE.name(), (Object)s.isStartsWithZeroScore());
        dbSeries.put(FieldNames.SERIES_STARTS_WITH_NON_DISCARDABLE_CARRY_FORWARD.name(), (Object)s.isFirstColumnNonDiscardableCarryForward());
        dbSeries.put(FieldNames.SERIES_ONE_ALWAYS_STAYS_ONE.name(), (Object)s.isOneAlwaysStaysOne());
        BasicDBList dbFleets = new BasicDBList();
        for (Fleet fleet : s.getFleets()) {
            dbFleets.add((Object)this.storeFleet(fleet));
        }
        dbSeries.put(FieldNames.SERIES_FLEETS.name(), (Object)dbFleets);
        BasicDBList dbRaceColumns = new BasicDBList();
        for (RaceColumn raceColumn : s.getRaceColumns()) {
            dbRaceColumns.add((Object)this.storeRaceColumn(raceColumn));
        }
        dbSeries.put(FieldNames.SERIES_RACE_COLUMNS.name(), (Object)dbRaceColumns);
        if (s.getResultDiscardingRule() != null) {
            this.storeResultDiscardingRule(dbSeries, (ResultDiscardingRule)s.getResultDiscardingRule(), FieldNames.SERIES_DISCARDING_THRESHOLDS);
        }
        return dbSeries;
    }

    private Document storeFleet(Fleet fleet) {
        Document dbFleet = new Document(FieldNames.FLEET_NAME.name(), (Object)fleet.getName());
        if (fleet instanceof FleetImpl) {
            dbFleet.put(FieldNames.FLEET_ORDERING.name(), (Object)((FleetImpl)fleet).getOrdering());
            if (fleet.getColor() != null) {
                Util.Triple colorAsRGB = fleet.getColor().getAsRGB();
                int colorAsInt = 65536 * (Integer)colorAsRGB.getC() + (Integer)colorAsRGB.getB() * 256 + (Integer)colorAsRGB.getA();
                dbFleet.put(FieldNames.FLEET_COLOR.name(), (Object)colorAsInt);
            } else {
                dbFleet.put(FieldNames.FLEET_COLOR.name(), null);
            }
        }
        return dbFleet;
    }

    @Override
    public void storeRegattaForRaceID(String raceIDAsString, Regatta regatta) {
        MongoCollection regattaForRaceIDCollection = this.database.getCollection(CollectionNames.REGATTA_FOR_RACE_ID.name());
        Document query = new Document(FieldNames.RACE_ID_AS_STRING.name(), (Object)raceIDAsString);
        Document entry = new Document(FieldNames.RACE_ID_AS_STRING.name(), (Object)raceIDAsString);
        entry.put(FieldNames.REGATTA_NAME.name(), (Object)regatta.getName());
        regattaForRaceIDCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)entry, new ReplaceOptions().upsert(true));
    }

    @Override
    public void removeRegattaForRaceID(String raceIDAsString, Regatta regatta) {
        MongoCollection regattaForRaceIDCollection = this.database.getCollection(CollectionNames.REGATTA_FOR_RACE_ID.name());
        Document query = new Document(FieldNames.RACE_ID_AS_STRING.name(), (Object)raceIDAsString);
        regattaForRaceIDCollection.deleteOne((Bson)query);
    }

    public MongoCollection<Document> getRaceLogCollection() {
        MongoCollection result = this.database.getCollection(CollectionNames.RACE_LOGS.name());
        result.createIndex((Bson)new Document(FieldNames.RACE_LOG_IDENTIFIER.name(), (Object)1));
        return result;
    }

    private void storeRaceLogEventAuthor(Document dbObject, AbstractLogEventAuthor author) {
        if (author != null) {
            dbObject.put(FieldNames.RACE_LOG_EVENT_AUTHOR_NAME.name(), (Object)author.getName());
            dbObject.put(FieldNames.RACE_LOG_EVENT_AUTHOR_PRIORITY.name(), (Object)author.getPriority());
        }
    }

    private void storeRegattaLogEventAuthor(Document dbObject, AbstractLogEventAuthor author) {
        if (author != null) {
            dbObject.put(FieldNames.REGATTA_LOG_EVENT_AUTHOR_NAME.name(), (Object)author.getName());
            dbObject.put(FieldNames.REGATTA_LOG_EVENT_AUTHOR_PRIORITY.name(), (Object)author.getPriority());
        }
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogFlagEvent flagEvent) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), (Object)this.storeRaceLogFlagEvent(flagEvent));
        return result;
    }

    private void storeRaceLogIdentifier(SimpleRaceLogIdentifier raceLogIdentifier, Document result) {
        result.put(FieldNames.RACE_LOG_IDENTIFIER.name(), (Object)TripleSerializer.serialize((Util.Triple<String, String, String>)raceLogIdentifier.getIdentifier()));
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogStartTimeEvent startTimeEvent) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), (Object)this.storeRaceLogStartTimeEvent(startTimeEvent));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogPassChangeEvent passChangeEvent) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), (Object)this.storeRaceLogPassChangeEvent(passChangeEvent));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogRaceStatusEvent raceStatusEvent) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), (Object)this.storeRaceLogRaceStatusEvent(raceStatusEvent));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogCourseDesignChangedEvent courseDesignChangedEvent) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), (Object)this.storeRaceLogCourseDesignChangedEvent(courseDesignChangedEvent));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogFinishPositioningListChangedEvent finishPositioningListChangedEvent) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogFinishPositioningListChangedEvent(finishPositioningListChangedEvent));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogFinishPositioningConfirmedEvent finishPositioningConfirmedEvent) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogFinishPositioningConfirmedEvent(finishPositioningConfirmedEvent));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogPathfinderEvent pathfinderEvent) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogPathfinderEvent(pathfinderEvent));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogGateLineOpeningTimeEvent gateLineOpeningTimeEvent) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogGateLineOpeningTimeEvent(gateLineOpeningTimeEvent));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogStartProcedureChangedEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogStartProcedureChangedEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogProtestStartTimeEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogProtestStartTimeEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogWindFixEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogWindFix(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogResultsAreOfficialEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogResultsAreOfficialEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogExcludeWindSourcesEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogExcludeWindSourceEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogDenoteForTrackingEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogDenoteForTrackingEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogStartTrackingEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogStartTrackingEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogRevokeEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogRevokeEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogRegisterCompetitorEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogRegisterCompetitorEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogEndOfTrackingEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogEndOfTrackingEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogStartOfTrackingEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogStartOfTrackingEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogAdditionalScoringInformationEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeAdditionalScoringInformation(event));
        return result;
    }

    private Object storeAdditionalScoringInformation(RaceLogAdditionalScoringInformationEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogAdditionalScoringInformationEvent.class.getSimpleName());
        result.put(FieldNames.RACE_LOG_ADDITIONAL_SCORING_INFORMATION_TYPE.name(), (Object)event.getType().name());
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogFixedMarkPassingEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogFixedMarkPassingEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogSuppressedMarkPassingsEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), this.storeRaceLogSuppressedMarkPassingsEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogORCLegDataEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), (Object)this.storeORCLegDataEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogORCCertificateAssignmentEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), (Object)this.storeORCCertificateAssignmentEvent(event));
        return result;
    }

    private Document storeORCCertificateAssignmentEvent(RaceLogORCCertificateAssignmentEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogORCCertificateAssignmentEvent.class.getSimpleName());
        result.append(FieldNames.RACE_LOG_BOAT_ID.name(), (Object)event.getBoatId());
        result.append(FieldNames.ORC_CERTIFICATE.name(), (Object)this.createORCCertificateObject(event.getCertificate()));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogORCScratchBoatEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), (Object)this.storeORCScratchBoatEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogORCImpliedWindSourceEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), (Object)this.storeORCImpliedWindSourceEvent(event));
        return result;
    }

    private Document storeORCImpliedWindSourceEvent(RaceLogORCImpliedWindSourceEvent event) {
        Document impliedWindSourceDocument;
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogORCImpliedWindSourceEvent.class.getSimpleName());
        if (event.getImpliedWindSource() == null) {
            impliedWindSourceDocument = null;
        } else {
            JSONObject jsonSerializedImpliedWindSource = new ImpliedWindSourceSerializer().serialize(event.getImpliedWindSource());
            impliedWindSourceDocument = Document.parse((String)jsonSerializedImpliedWindSource.toString());
        }
        result.put(FieldNames.ORC_IMPLIED_WIND_SOURCE.name(), impliedWindSourceDocument);
        return result;
    }

    private Document storeORCScratchBoatEvent(RaceLogORCScratchBoatEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogORCScratchBoatEvent.class.getSimpleName());
        return result;
    }

    private Document storeORCLegDataEvent(RaceLogORCLegDataEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogORCLegDataEvent.class.getSimpleName());
        result.put(FieldNames.ORC_LEG_NR.name(), (Object)event.getOneBasedLegNumber());
        result.put(FieldNames.ORC_LEG_LENGTH_IN_NAUTICAL_MILES.name(), event.getLength() == null ? null : Double.valueOf(event.getLength().getNauticalMiles()));
        result.put(FieldNames.ORC_LEG_TWA_IN_DEG.name(), event.getTwa() == null ? null : Double.valueOf(event.getTwa().getDegrees()));
        result.put(FieldNames.ORC_LEG_TYPE.name(), (Object)event.getType().name());
        return result;
    }

    private Object storeRaceLogWindFix(RaceLogWindFixEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogWindFixEvent.class.getSimpleName());
        result.put(FieldNames.WIND.name(), (Object)this.storeWind(event.getWindFix()));
        result.put(FieldNames.IS_MAGNETIC.name(), (Object)event.isMagnetic());
        return result;
    }

    private Object storeRaceLogProtestStartTimeEvent(RaceLogProtestStartTimeEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogProtestStartTimeEvent.class.getSimpleName());
        MongoObjectFactoryImpl.storeTimePoint(event.getProtestTime().from(), result, FieldNames.RACE_LOG_PROTEST_START_TIME);
        MongoObjectFactoryImpl.storeTimePoint(event.getProtestTime().to(), result, FieldNames.RACE_LOG_PROTEST_END_TIME);
        return result;
    }

    private Object storeRaceLogEndOfTrackingEvent(RaceLogEndOfTrackingEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogEndOfTrackingEvent.class.getSimpleName());
        return result;
    }

    private Object storeRaceLogStartOfTrackingEvent(RaceLogStartOfTrackingEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogStartOfTrackingEvent.class.getSimpleName());
        return result;
    }

    private Object storeRaceLogStartProcedureChangedEvent(RaceLogStartProcedureChangedEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogStartProcedureChangedEvent.class.getSimpleName());
        result.put(FieldNames.RACE_LOG_START_PROCEDURE_TYPE.name(), (Object)event.getStartProcedureType().name());
        return result;
    }

    private Object storeRaceLogPathfinderEvent(RaceLogPathfinderEvent pathfinderEvent) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)pathfinderEvent, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogPathfinderEvent.class.getSimpleName());
        result.put(FieldNames.RACE_LOG_PATHFINDER_ID.name(), (Object)pathfinderEvent.getPathfinderId());
        return result;
    }

    private void storeDeviceMappingEvent(RegattaLogDeviceMappingEvent<?> event, Document result, FieldNames fromField, FieldNames toField) {
        try {
            result.put(FieldNames.DEVICE_ID.name(), (Object)com.sap.sailing.shared.persistence.impl.MongoObjectFactoryImpl.storeDeviceId(this.deviceIdentifierServiceFinder, (DeviceIdentifier)event.getDevice()));
        }
        catch (NoCorrespondingServiceRegisteredException | TransformationException e) {
            logger.log(Level.WARNING, "Could not store device identifier for mappng event", e);
        }
        if (event.getFrom() != null) {
            MongoObjectFactoryImpl.storeTimePoint(event.getFrom(), result, fromField);
        }
        if (event.getToInclusive() != null) {
            MongoObjectFactoryImpl.storeTimePoint(event.getToInclusive(), result, toField);
        }
    }

    private Object storeRaceLogResultsAreOfficialEvent(RaceLogResultsAreOfficialEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogResultsAreOfficialEvent.class.getSimpleName());
        return result;
    }

    private Object storeRaceLogExcludeWindSourceEvent(RaceLogExcludeWindSourcesEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogExcludeWindSourcesEvent.class.getSimpleName());
        BasicDBList dbWindSourcesToExclude = new BasicDBList();
        for (WindSource windSourceToExclude : event.getWindSourcesToExclude()) {
            Document dbWindSourceToExclude = new Document();
            dbWindSourceToExclude.put(FieldNames.WIND_SOURCE_NAME.name(), (Object)windSourceToExclude.name());
            if (windSourceToExclude.getId() != null) {
                dbWindSourceToExclude.put(FieldNames.WIND_SOURCE_ID.name(), windSourceToExclude.getId());
            }
            dbWindSourcesToExclude.add((Object)dbWindSourceToExclude);
        }
        result.put(FieldNames.WIND_SOURCES_TO_EXCLUDE.name(), (Object)dbWindSourcesToExclude);
        return result;
    }

    private Object storeRaceLogDenoteForTrackingEvent(RaceLogDenoteForTrackingEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogDenoteForTrackingEvent.class.getSimpleName());
        result.put(FieldNames.RACE_NAME.name(), (Object)event.getRaceName());
        result.put(FieldNames.BOAT_CLASS_NAME.name(), event.getBoatClass() == null ? null : event.getBoatClass().getName());
        result.put(FieldNames.RACE_ID.name(), (Object)event.getRaceId());
        return result;
    }

    private Object storeRaceLogStartTrackingEvent(RaceLogStartTrackingEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogStartTrackingEvent.class.getSimpleName());
        return result;
    }

    private Object storeRaceLogRevokeEvent(RaceLogRevokeEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogRevokeEvent.class.getSimpleName());
        result.put(FieldNames.RACE_LOG_REVOKED_EVENT_ID.name(), (Object)event.getRevokedEventId());
        result.put(FieldNames.RACE_LOG_REVOKED_EVENT_TYPE.name(), (Object)event.getRevokedEventType());
        result.put(FieldNames.RACE_LOG_REVOKED_EVENT_SHORT_INFO.name(), (Object)event.getRevokedEventShortInfo());
        result.put(FieldNames.RACE_LOG_REVOKED_REASON.name(), (Object)event.getReason());
        return result;
    }

    private Object storeRaceLogRegisterCompetitorEvent(RaceLogRegisterCompetitorEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogRegisterCompetitorEvent.class.getSimpleName());
        result.put(FieldNames.RACE_LOG_COMPETITOR_ID.name(), (Object)event.getCompetitor().getId());
        result.put(FieldNames.RACE_LOG_BOAT_ID.name(), (Object)event.getBoat().getId());
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogUseCompetitorsFromRaceLogEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), (Object)this.storeRaceLogUseCompetitorsFromRaceLogEvent(event));
        return result;
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogTagEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), (Object)this.storeRaceLogTagEvent(event));
        return result;
    }

    public Document storeRaceLogTagEvent(RaceLogTagEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogTagEvent.class.getSimpleName());
        result.put(FieldNames.RACE_LOG_TAG.name(), (Object)event.getTag());
        result.put(FieldNames.RACE_LOG_COMMENT.name(), (Object)event.getComment());
        result.put(FieldNames.RACE_LOG_HIDDEN_INFO.name(), (Object)event.getHiddenInfo());
        result.put(FieldNames.RACE_LOG_IMAGE_URL.name(), (Object)event.getImageURL());
        result.put(FieldNames.RACE_LOG_RESIZED_IMAGE_URL.name(), (Object)event.getResizedImageURL());
        return result;
    }

    public Document storeRaceLogUseCompetitorsFromRaceLogEvent(RaceLogUseCompetitorsFromRaceLogEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogUseCompetitorsFromRaceLogEvent.class.getSimpleName());
        return result;
    }

    private Object storeRaceLogFixedMarkPassingEvent(RaceLogFixedMarkPassingEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogFixedMarkPassingEvent.class.getSimpleName());
        result.put(FieldNames.INDEX_OF_PASSED_WAYPOINT.name(), (Object)event.getZeroBasedIndexOfPassedWaypoint());
        result.put(FieldNames.TIMEPOINT_OF_FIXED_MARKPASSING.name(), (Object)event.getTimePointOfFixedPassing().asMillis());
        return result;
    }

    private Object storeRaceLogSuppressedMarkPassingsEvent(RaceLogSuppressedMarkPassingsEvent event) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)event, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogSuppressedMarkPassingsEvent.class.getSimpleName());
        result.put(FieldNames.INDEX_OF_FIRST_SUPPRESSED_WAYPOINT.name(), (Object)event.getZeroBasedIndexOfFirstSuppressedWaypoint());
        return result;
    }

    public Document storeRaceLogFlagEvent(RaceLogFlagEvent flagEvent) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)flagEvent, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogFlagEvent.class.getSimpleName());
        result.put(FieldNames.RACE_LOG_EVENT_FLAG_UPPER.name(), (Object)(flagEvent.getUpperFlag() == null ? Flags.NONE.name() : flagEvent.getUpperFlag().name()));
        result.put(FieldNames.RACE_LOG_EVENT_FLAG_LOWER.name(), (Object)(flagEvent.getLowerFlag() == null ? Flags.NONE.name() : flagEvent.getLowerFlag().name()));
        result.put(FieldNames.RACE_LOG_EVENT_FLAG_DISPLAYED.name(), (Object)String.valueOf(flagEvent.isDisplayed()));
        return result;
    }

    private Document storeRaceLogStartTimeEvent(RaceLogStartTimeEvent startTimeEvent) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)startTimeEvent, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogStartTimeEvent.class.getSimpleName());
        MongoObjectFactoryImpl.storeTimePoint(startTimeEvent.getStartTime(), result, FieldNames.RACE_LOG_EVENT_START_TIME);
        this.storeCourseAreaToStartTimeEvent((RaceLogCourseAreaSpecification)startTimeEvent, result);
        result.put(FieldNames.RACE_LOG_EVENT_NEXT_STATUS.name(), (Object)startTimeEvent.getNextStatus().name());
        return result;
    }

    private void storeCourseAreaToStartTimeEvent(RaceLogCourseAreaSpecification startTimeEvent, Document result) {
        result.put(FieldNames.RACE_LOG_EVENT_COURSE_AREA_ID_AS_STRING.name(), startTimeEvent.getCourseAreaId() == null ? null : startTimeEvent.getCourseAreaId().toString());
    }

    private void storeRaceLogEventProperties(RaceLogEvent event, Document result) {
        MongoObjectFactoryImpl.storeTimePoint(event.getLogicalTimePoint(), result, FieldNames.TIME_AS_MILLIS);
        MongoObjectFactoryImpl.storeTimePoint(event.getCreatedAt(), result, FieldNames.RACE_LOG_EVENT_CREATED_AT);
        result.put(FieldNames.RACE_LOG_EVENT_ID.name(), (Object)event.getId());
        result.put(FieldNames.RACE_LOG_EVENT_PASS_ID.name(), (Object)event.getPassId());
        result.put(FieldNames.RACE_LOG_EVENT_INVOLVED_BOATS.name(), (Object)this.storeInvolvedCompetitorsForRaceLogEvent(event.getInvolvedCompetitors()));
        this.storeRaceLogEventAuthor(result, event.getAuthor());
    }

    private BasicDBList storeInvolvedCompetitorsForRaceLogEvent(List<Competitor> competitors) {
        BasicDBList dbInvolvedCompetitorIds = new BasicDBList();
        for (Competitor competitor : competitors) {
            dbInvolvedCompetitorIds.add((Object)competitor.getId());
        }
        return dbInvolvedCompetitorIds;
    }

    private Document storeRaceLogPassChangeEvent(RaceLogPassChangeEvent passChangeEvent) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)passChangeEvent, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogPassChangeEvent.class.getSimpleName());
        return result;
    }

    private Document storeRaceLogDependentStartTimeEvent(RaceLogDependentStartTimeEvent dependentStartTimeEvent) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)dependentStartTimeEvent, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogDependentStartTimeEvent.class.getSimpleName());
        result.put(FieldNames.RACE_LOG_DEPDENDENT_ON_REGATTALIKE.name(), (Object)dependentStartTimeEvent.getDependentOnRaceIdentifier().getRegattaLikeParentName());
        result.put(FieldNames.RACE_LOG_DEPDENDENT_ON_RACECOLUMN.name(), (Object)dependentStartTimeEvent.getDependentOnRaceIdentifier().getRaceColumnName());
        result.put(FieldNames.RACE_LOG_DEPDENDENT_ON_FLEET.name(), (Object)dependentStartTimeEvent.getDependentOnRaceIdentifier().getFleetName());
        this.storeDuration(dependentStartTimeEvent.getStartTimeDifference(), result, FieldNames.RACE_LOG_START_TIME_DIFFERENCE_IN_MS);
        this.storeCourseAreaToStartTimeEvent((RaceLogCourseAreaSpecification)dependentStartTimeEvent, result);
        result.put(FieldNames.RACE_LOG_EVENT_NEXT_STATUS.name(), (Object)dependentStartTimeEvent.getNextStatus().name());
        return result;
    }

    private void storeDuration(Duration duration, Document result, FieldNames fieldName) {
        if (duration != null) {
            result.put(fieldName.name(), (Object)duration.asMillis());
        }
    }

    private Document storeRaceLogRaceStatusEvent(RaceLogRaceStatusEvent raceStatusEvent) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)raceStatusEvent, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogRaceStatusEvent.class.getSimpleName());
        result.put(FieldNames.RACE_LOG_EVENT_NEXT_STATUS.name(), (Object)raceStatusEvent.getNextStatus().name());
        return result;
    }

    private Document storeRaceLogCourseDesignChangedEvent(RaceLogCourseDesignChangedEvent courseDesignChangedEvent) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)courseDesignChangedEvent, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogCourseDesignChangedEvent.class.getSimpleName());
        result.put(FieldNames.RACE_LOG_COURSE_DESIGN_NAME.name(), (Object)courseDesignChangedEvent.getCourseDesign().getName());
        result.put(FieldNames.RACE_LOG_COURSE_ORIGINATING_TEMPLATE_ID.name(), (Object)courseDesignChangedEvent.getCourseDesign().getOriginatingCourseTemplateIdOrNull());
        result.put(FieldNames.RACE_LOG_COURSE_DESIGNER_MODE.name(), courseDesignChangedEvent.getCourseDesignerMode() == null ? null : courseDesignChangedEvent.getCourseDesignerMode().name());
        result.put(FieldNames.RACE_LOG_COURSE_DESIGN.name(), (Object)this.storeCourseBase(courseDesignChangedEvent.getCourseDesign()));
        BasicDBList roleMap = new BasicDBList();
        courseDesignChangedEvent.getCourseDesign().getAssociatedRoles().forEach((mark, role) -> {
            Document mapping = new Document();
            mapping.put(FieldNames.RACE_LOG_COURSE_ASSOCIATED_ROLES_MARK_ID.name(), (Object)mark.getId().toString());
            mapping.put(FieldNames.RACE_LOG_COURSE_ASSOCIATED_ROLES_ROLE_ID.name(), (Object)role.toString());
            roleMap.add((Object)mapping);
        });
        if (!roleMap.isEmpty()) {
            result.put(FieldNames.RACE_LOG_COURSE_ASSOCIATED_ROLES.name(), (Object)roleMap);
        }
        return result;
    }

    private Object storeRaceLogFinishPositioningListChangedEvent(RaceLogFinishPositioningListChangedEvent finishPositioningListChangedEvent) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)finishPositioningListChangedEvent, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogFinishPositioningListChangedEvent.class.getSimpleName());
        result.put(FieldNames.RACE_LOG_POSITIONED_COMPETITORS.name(), (Object)this.storePositionedCompetitors(finishPositioningListChangedEvent.getPositionedCompetitorsIDsNamesMaxPointsReasons()));
        return result;
    }

    private Object storeRaceLogFinishPositioningConfirmedEvent(RaceLogFinishPositioningConfirmedEvent finishPositioningConfirmedEvent) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)finishPositioningConfirmedEvent, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogFinishPositioningConfirmedEvent.class.getSimpleName());
        result.put(FieldNames.RACE_LOG_POSITIONED_COMPETITORS.name(), (Object)this.storePositionedCompetitors(finishPositioningConfirmedEvent.getPositionedCompetitorsIDsNamesMaxPointsReasons()));
        return result;
    }

    private Object storeRaceLogGateLineOpeningTimeEvent(RaceLogGateLineOpeningTimeEvent gateLineOpeningTimeEvent) {
        Document result = new Document();
        this.storeRaceLogEventProperties((RaceLogEvent)gateLineOpeningTimeEvent, result);
        result.put(FieldNames.RACE_LOG_EVENT_CLASS.name(), (Object)RaceLogGateLineOpeningTimeEvent.class.getSimpleName());
        result.put(FieldNames.RACE_LOG_GATE_LINE_OPENING_TIME.name(), (Object)gateLineOpeningTimeEvent.getGateLineOpeningTimes().getGateLaunchStopTime());
        result.put(FieldNames.RACE_LOG_GOLF_DOWN_TIME.name(), (Object)gateLineOpeningTimeEvent.getGateLineOpeningTimes().getGolfDownTime());
        return result;
    }

    private BasicDBList storePositionedCompetitors(CompetitorResults positionedCompetitors) {
        BasicDBList dbList = new BasicDBList();
        if (positionedCompetitors != null) {
            for (CompetitorResult competitorPair : positionedCompetitors) {
                dbList.add((Object)this.storePositionedCompetitor(competitorPair));
            }
        }
        return dbList;
    }

    private Document storePositionedCompetitor(CompetitorResult competitorResult) {
        Document result = new Document();
        result.put(FieldNames.COMPETITOR_ID.name(), (Object)competitorResult.getCompetitorId());
        result.put(FieldNames.COMPETITOR_DISPLAY_NAME.name(), (Object)competitorResult.getName());
        result.put(FieldNames.COMPETITOR_SHORT_NAME.name(), (Object)competitorResult.getShortName());
        result.put(FieldNames.COMPETITOR_BOAT_NAME.name(), (Object)competitorResult.getBoatName());
        result.put(FieldNames.COMPETITOR_BOAT_SAIL_ID.name(), (Object)competitorResult.getBoatSailId());
        result.put(FieldNames.LEADERBOARD_SCORE_CORRECTION_MAX_POINTS_REASON.name(), competitorResult.getMaxPointsReason() == null ? null : competitorResult.getMaxPointsReason().name());
        result.put(FieldNames.LEADERBOARD_CORRECTED_SCORE.name(), (Object)competitorResult.getScore());
        result.put(FieldNames.RACE_LOG_FINISHING_TIME_AS_MILLIS.name(), competitorResult.getFinishingTime() == null ? null : Long.valueOf(competitorResult.getFinishingTime().asMillis()));
        result.put(FieldNames.LEADERBOARD_RANK.name(), (Object)competitorResult.getOneBasedRank());
        result.put(FieldNames.LEADERBOARD_SCORE_CORRECTION_COMMENT.name(), (Object)competitorResult.getComment());
        result.put(FieldNames.LEADERBOARD_SCORE_CORRECTION_MERGE_STATE.name(), (Object)competitorResult.getMergeState().name());
        return result;
    }

    private BasicDBList storeCourseBase(CourseBase courseData) {
        BasicDBList dbList = new BasicDBList();
        for (Waypoint waypoint : courseData.getWaypoints()) {
            dbList.add((Object)this.storeWaypoint(waypoint));
        }
        return dbList;
    }

    private Document storeWaypoint(Waypoint waypoint) {
        Document result = new Document();
        result.put(FieldNames.WAYPOINT_PASSINGINSTRUCTIONS.name(), (Object)com.sap.sailing.shared.persistence.impl.MongoObjectFactoryImpl.getPassingInstructions((PassingInstruction)waypoint.getPassingInstructions()));
        result.put(FieldNames.CONTROLPOINT.name(), (Object)this.storeControlPoint(waypoint.getControlPoint()));
        return result;
    }

    private Document storeControlPoint(ControlPoint controlPoint) {
        Document result = new Document();
        if (controlPoint instanceof Mark) {
            result.put(FieldNames.CONTROLPOINT_CLASS.name(), (Object)Mark.class.getSimpleName());
            result.put(FieldNames.CONTROLPOINT_VALUE.name(), (Object)this.storeMark((Mark)controlPoint));
        } else if (controlPoint instanceof ControlPointWithTwoMarks) {
            result.put(FieldNames.CONTROLPOINT_CLASS.name(), (Object)ControlPointWithTwoMarks.class.getSimpleName());
            result.put(FieldNames.CONTROLPOINT_VALUE.name(), (Object)this.storeControlPointWithTwoMarks((ControlPointWithTwoMarks)controlPoint));
        }
        return result;
    }

    private Document storeControlPointWithTwoMarks(ControlPointWithTwoMarks cpwtm) {
        Document result = new Document();
        result.put(FieldNames.CONTROLPOINTWITHTWOMARKS_ID.name(), (Object)cpwtm.getId());
        result.put(FieldNames.CONTROLPOINTWITHTWOMARKS_NAME.name(), (Object)cpwtm.getName());
        result.put(FieldNames.CONTROLPOINTWITHTWOMARKS_SHORT_NAME.name(), (Object)cpwtm.getShortName());
        result.put(FieldNames.CONTROLPOINTWITHTWOMARKS_LEFT.name(), (Object)this.storeMark(cpwtm.getLeft()));
        result.put(FieldNames.CONTROLPOINTWITHTWOMARKS_RIGHT.name(), (Object)this.storeMark(cpwtm.getRight()));
        return result;
    }

    private Document storeMark(Mark mark) {
        Document result = new Document();
        result.put(FieldNames.MARK_ID.name(), (Object)mark.getId());
        result.put(FieldNames.MARK_COLOR.name(), mark.getColor() == null ? null : mark.getColor().getAsHtml());
        result.put(FieldNames.MARK_NAME.name(), (Object)mark.getName());
        result.put(FieldNames.MARK_SHORT_NAME.name(), (Object)mark.getShortName());
        result.put(FieldNames.MARK_PATTERN.name(), (Object)mark.getPattern());
        result.put(FieldNames.MARK_SHAPE.name(), (Object)mark.getShape());
        result.put(FieldNames.MARK_TYPE.name(), mark.getType() == null ? null : mark.getType().name());
        result.put(FieldNames.MARK_ORIGINATING_MARK_TEMPLATE_ID.name(), (Object)mark.getOriginatingMarkTemplateIdOrNull());
        result.put(FieldNames.MARK_ORIGINATING_MARK_PROPERTIES_ID.name(), (Object)mark.getOriginatingMarkPropertiesIdOrNull());
        return result;
    }

    @Override
    public void storeCompetitor(Competitor competitor) {
        if (competitor.hasBoat()) {
            this.storeCompetitorWithBoat((CompetitorWithBoat)competitor);
            this.storeBoat(((CompetitorWithBoat)competitor).getBoat());
        } else {
            this.storeCompetitorWithoutBoat(competitor);
        }
    }

    private void storeCompetitorWithoutBoat(Competitor competitor) {
        MongoCollection collection = this.database.getCollection(CollectionNames.COMPETITORS.name());
        JSONObject json = this.competitorSerializer.serialize(competitor);
        Document query = Document.parse((String)CompetitorJsonSerializer.getCompetitorIdQuery((Competitor)competitor).toJSONString());
        Document entry = Document.parse((String)json.toJSONString());
        collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)entry, new ReplaceOptions().upsert(true));
    }

    private void storeCompetitorWithBoat(CompetitorWithBoat competitor) {
        MongoCollection collection = this.database.getCollection(CollectionNames.COMPETITORS.name());
        JSONObject json = this.competitorWithBoatRefSerializer.serialize(competitor);
        Document query = Document.parse((String)CompetitorJsonSerializer.getCompetitorIdQuery((Competitor)competitor).toString());
        Document entry = Document.parse((String)json.toString());
        collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)entry, new ReplaceOptions().upsert(true));
    }

    @Override
    public void storeCompetitors(Iterable<? extends Competitor> competitors) {
        if (competitors != null && !Util.isEmpty(competitors)) {
            ArrayList<Competitor> competitorsWithoutBoat = new ArrayList<Competitor>();
            ArrayList<CompetitorWithBoat> competitorsWithBoat = new ArrayList<CompetitorWithBoat>();
            for (Competitor competitor : competitors) {
                if (competitor.hasBoat()) {
                    competitorsWithBoat.add((CompetitorWithBoat)competitor);
                    continue;
                }
                competitorsWithoutBoat.add(competitor);
            }
            this.storeCompetitorsWithBoat(competitorsWithBoat);
            this.storeCompetitorsWithoutBoat(competitorsWithoutBoat);
        }
    }

    private void storeCompetitorsWithoutBoat(Iterable<Competitor> competitors) {
        if (!Util.isEmpty(competitors)) {
            MongoCollection collection = this.database.getCollection(CollectionNames.COMPETITORS.name());
            ArrayList<Document> competitorsDB = new ArrayList<Document>();
            for (Competitor competitor : competitors) {
                JSONObject json = this.competitorSerializer.serialize(competitor);
                Document entry = Document.parse((String)json.toString());
                competitorsDB.add(entry);
            }
            collection.insertMany(competitorsDB);
        }
    }

    private void storeCompetitorsWithBoat(Iterable<CompetitorWithBoat> competitors) {
        if (!Util.isEmpty(competitors)) {
            MongoCollection collection = this.database.getCollection(CollectionNames.COMPETITORS.name());
            ArrayList<Document> competitorsDB = new ArrayList<Document>();
            for (CompetitorWithBoat competitor : competitors) {
                JSONObject json = this.competitorWithBoatRefSerializer.serialize(competitor);
                Document entry = Document.parse((String)json.toString());
                competitorsDB.add(entry);
            }
            collection.insertMany(competitorsDB);
        }
    }

    @Override
    public void removeAllCompetitors() {
        logger.info("Removing all persistent competitors");
        MongoCollection collection = this.database.getCollection(CollectionNames.COMPETITORS.name());
        collection.drop();
    }

    @Override
    public void removeCompetitor(Competitor competitor) {
        logger.info("Removing persistent competitor info for competitor " + competitor.getName() + " with ID " + competitor.getId());
        MongoCollection collection = this.database.getCollection(CollectionNames.COMPETITORS.name());
        Document query = Document.parse((String)CompetitorJsonSerializer.getCompetitorIdQuery((Competitor)competitor).toString());
        collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).deleteOne((Bson)query);
    }

    @Override
    public void storeBoat(Boat boat) {
        MongoCollection collection = this.database.getCollection(CollectionNames.BOATS.name());
        JSONObject json = this.boatSerializer.serialize(boat);
        Document query = Document.parse((String)BoatJsonSerializer.getBoatIdQuery((Boat)boat).toString());
        Document entry = Document.parse((String)json.toString());
        collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)entry, new ReplaceOptions().upsert(true));
    }

    @Override
    public void storeBoats(Iterable<? extends Boat> boats) {
        if (boats != null && !Util.isEmpty(boats)) {
            MongoCollection collection = this.database.getCollection(CollectionNames.BOATS.name());
            ArrayList<Document> boatsDB = new ArrayList<Document>();
            for (Boat boat : boats) {
                JSONObject json = this.boatSerializer.serialize(boat);
                Document entry = Document.parse((String)json.toString());
                boatsDB.add(entry);
            }
            collection.insertMany(boatsDB);
        }
    }

    @Override
    public void removeAllBoats() {
        logger.info("Removing all persistent boats");
        MongoCollection collection = this.database.getCollection(CollectionNames.BOATS.name());
        collection.drop();
    }

    @Override
    public void removeBoat(Boat boat) {
        logger.info("Removing persistent boat " + boat.getName() + " with ID " + boat.getId());
        MongoCollection collection = this.database.getCollection(CollectionNames.BOATS.name());
        Document query = Document.parse((String)BoatJsonSerializer.getBoatIdQuery((Boat)boat).toString());
        collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).deleteOne((Bson)query);
    }

    @Override
    public void storeDeviceConfiguration(DeviceConfiguration configuration) {
        MongoCollection configurationsCollections = this.database.getCollection(CollectionNames.CONFIGURATIONS.name());
        Document configDocument = this.createDeviceConfigurationObject(configuration);
        configDocument.put(FieldNames.CONFIGURATION_ID_AS_STRING.name(), (Object)configuration.getId().toString());
        Document query = new Document();
        query.put(FieldNames.CONFIGURATION_ID_AS_STRING.name(), (Object)configuration.getId().toString());
        configurationsCollections.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)configDocument, new ReplaceOptions().upsert(true));
    }

    private Document createDeviceConfigurationObject(DeviceConfiguration configuration) {
        DeviceConfigurationJsonSerializer serializer = DeviceConfigurationJsonSerializer.create();
        JSONObject json = serializer.serialize((Object)configuration);
        Document entry = Document.parse((String)json.toString());
        return entry;
    }

    @Override
    public void removeDeviceConfiguration(UUID id) {
        MongoCollection configurationsCollections = this.database.getCollection(CollectionNames.CONFIGURATIONS.name());
        Document query = new Document(FieldNames.CONFIGURATION_ID_AS_STRING.name(), (Object)id.toString());
        configurationsCollections.deleteOne((Bson)query);
    }

    void storeRaceLogEventEvent(Document eventEntry) {
        this.getRaceLogCollection().insertOne((Object)eventEntry);
    }

    @Override
    public void removeRaceLog(RaceLogIdentifier identifier) {
        Document query = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)identifier, query);
        this.getRaceLogCollection().deleteMany((Bson)query);
    }

    @Override
    public void removeAllRaceLogs() {
        this.getRaceLogCollection().drop();
    }

    @Override
    public void removeRegattaLog(RegattaLikeIdentifier identifier) {
        Document query = new Document();
        this.addRegattaLikeIdentifier(identifier, query);
        this.getRegattaLogCollection().deleteOne((Bson)query);
    }

    @Override
    public void removeAllRegattaLogs() {
        this.getRegattaLogCollection().drop();
    }

    @Override
    public void storeResultUrl(String resultProviderName, URL url) {
        MongoCollection resultUrlsCollection = this.database.getCollection(CollectionNames.RESULT_URLS.name());
        Document query = new Document(FieldNames.RESULT_PROVIDERNAME.name(), (Object)resultProviderName);
        Document entry = new Document(FieldNames.RESULT_PROVIDERNAME.name(), (Object)resultProviderName);
        entry.put(FieldNames.RESULT_URL.name(), (Object)url.toString());
        resultUrlsCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)entry, new ReplaceOptions().upsert(true));
    }

    @Override
    public void removeResultUrl(String resultProviderName, URL url) {
        MongoCollection resultUrlsCollection = this.database.getCollection(CollectionNames.RESULT_URLS.name());
        Document query = new Document().append(FieldNames.RESULT_PROVIDERNAME.name(), (Object)resultProviderName).append(FieldNames.RESULT_URL.name(), (Object)url.toString());
        resultUrlsCollection.deleteOne((Bson)query);
    }

    public MongoCollection<Document> getRegattaLogCollection() {
        MongoCollection result = this.database.getCollection(CollectionNames.REGATTA_LOGS.name());
        Document index = new Document(FieldNames.REGATTA_LOG_IDENTIFIER_TYPE.name(), (Object)1);
        index.put(FieldNames.REGATTA_LOG_IDENTIFIER_NAME.name(), (Object)1);
        result.createIndex((Bson)index, new IndexOptions().name("regattaLogById").background(false));
        return result;
    }

    private Document createBasicRegattaLogEventDBObject(RegattaLogEvent event) {
        Document result = new Document();
        MongoObjectFactoryImpl.storeTimePoint(event.getLogicalTimePoint(), result, FieldNames.TIME_AS_MILLIS);
        MongoObjectFactoryImpl.storeTimePoint(event.getCreatedAt(), result, FieldNames.REGATTA_LOG_EVENT_CREATED_AT);
        this.storeRegattaLogEventAuthor(result, event.getAuthor());
        result.put(FieldNames.REGATTA_LOG_EVENT_ID.name(), (Object)event.getId());
        return result;
    }

    private void addRegattaLikeIdentifier(RegattaLikeIdentifier regattaLikeId, Document toObject) {
        toObject.put(FieldNames.REGATTA_LOG_IDENTIFIER_TYPE.name(), (Object)regattaLikeId.getIdentifierType());
        toObject.put(FieldNames.REGATTA_LOG_IDENTIFIER_NAME.name(), (Object)regattaLikeId.getName());
    }

    private Document storeRegattaLogEvent(RegattaLikeIdentifier regattaLikeId, Document innerObject) {
        Document result = new Document(FieldNames.REGATTA_LOG_EVENT.name(), (Object)innerObject);
        this.addRegattaLikeIdentifier(regattaLikeId, result);
        this.getRegattaLogCollection().insertOne((Object)result);
        return result;
    }

    public Document storeRegattaLogEvent(RegattaLikeIdentifier regattaLikeId, RegattaLogDeviceCompetitorMappingEvent event) {
        Document result = this.createBasicRegattaLogEventDBObject((RegattaLogEvent)event);
        result.put(FieldNames.REGATTA_LOG_EVENT_CLASS.name(), (Object)RegattaLogDeviceCompetitorMappingEvent.class.getSimpleName());
        this.storeDeviceMappingEvent((RegattaLogDeviceMappingEvent<?>)event, result, FieldNames.REGATTA_LOG_FROM, FieldNames.REGATTA_LOG_TO);
        result.put(FieldNames.COMPETITOR_ID.name(), (Object)((Competitor)event.getMappedTo()).getId());
        return this.storeRegattaLogEvent(regattaLikeId, result);
    }

    public Document storeRegattaLogEvent(RegattaLikeIdentifier regattaLikeId, RegattaLogDeviceBoatMappingEvent event) {
        Document result = this.createBasicRegattaLogEventDBObject((RegattaLogEvent)event);
        result.put(FieldNames.REGATTA_LOG_EVENT_CLASS.name(), (Object)RegattaLogDeviceBoatMappingEvent.class.getSimpleName());
        this.storeDeviceMappingEvent((RegattaLogDeviceMappingEvent<?>)event, result, FieldNames.REGATTA_LOG_FROM, FieldNames.REGATTA_LOG_TO);
        result.put(FieldNames.RACE_LOG_BOAT_ID.name(), (Object)((Boat)event.getMappedTo()).getId());
        return this.storeRegattaLogEvent(regattaLikeId, result);
    }

    public Document storeRegattaLogEvent(RegattaLikeIdentifier regattaLikeId, RegattaLogDeviceCompetitorSensorDataMappingEvent event) {
        Document result = this.createBasicRegattaLogEventDBObject((RegattaLogEvent)event);
        result.put(FieldNames.REGATTA_LOG_EVENT_CLASS.name(), (Object)event.getClass().getSimpleName());
        this.storeDeviceMappingEvent((RegattaLogDeviceMappingEvent<?>)event, result, FieldNames.REGATTA_LOG_FROM, FieldNames.REGATTA_LOG_TO);
        result.put(FieldNames.COMPETITOR_ID.name(), (Object)((Competitor)event.getMappedTo()).getId());
        return this.storeRegattaLogEvent(regattaLikeId, result);
    }

    public Document storeRegattaLogEvent(RegattaLikeIdentifier regattaLikeId, RegattaLogDeviceBoatSensorDataMappingEvent event) {
        Document result = this.createBasicRegattaLogEventDBObject((RegattaLogEvent)event);
        result.put(FieldNames.REGATTA_LOG_EVENT_CLASS.name(), (Object)event.getClass().getSimpleName());
        this.storeDeviceMappingEvent((RegattaLogDeviceMappingEvent<?>)event, result, FieldNames.REGATTA_LOG_FROM, FieldNames.REGATTA_LOG_TO);
        result.put(FieldNames.RACE_LOG_BOAT_ID.name(), (Object)((Boat)event.getMappedTo()).getId());
        return this.storeRegattaLogEvent(regattaLikeId, result);
    }

    public Document storeRegattaLogEvent(RegattaLikeIdentifier regattaLikeId, RegattaLogDeviceMarkMappingEvent event) {
        Document result = this.createBasicRegattaLogEventDBObject((RegattaLogEvent)event);
        result.put(FieldNames.REGATTA_LOG_EVENT_CLASS.name(), (Object)RegattaLogDeviceMarkMappingEvent.class.getSimpleName());
        this.storeDeviceMappingEvent((RegattaLogDeviceMappingEvent<?>)event, result, FieldNames.REGATTA_LOG_FROM, FieldNames.REGATTA_LOG_TO);
        result.put(FieldNames.MARK.name(), (Object)this.storeMark((Mark)event.getMappedTo()));
        return this.storeRegattaLogEvent(regattaLikeId, result);
    }

    public Document storeRegattaLogEvent(RegattaLikeIdentifier regattaLikeId, RegattaLogRevokeEvent event) {
        Document result = this.createBasicRegattaLogEventDBObject((RegattaLogEvent)event);
        result.put(FieldNames.REGATTA_LOG_EVENT_CLASS.name(), (Object)RegattaLogRevokeEvent.class.getSimpleName());
        result.put(FieldNames.REGATTA_LOG_REVOKED_EVENT_ID.name(), (Object)event.getRevokedEventId());
        result.put(FieldNames.REGATTA_LOG_REVOKED_EVENT_TYPE.name(), (Object)event.getRevokedEventType());
        result.put(FieldNames.REGATTA_LOG_REVOKED_EVENT_SHORT_INFO.name(), (Object)event.getRevokedEventShortInfo());
        result.put(FieldNames.REGATTA_LOG_REVOKED_REASON.name(), (Object)event.getReason());
        return this.storeRegattaLogEvent(regattaLikeId, result);
    }

    public Document storeRegattaLogEvent(RegattaLikeIdentifier regattaLikeId, RegattaLogRegisterBoatEvent event) {
        Document result = this.createBasicRegattaLogEventDBObject((RegattaLogEvent)event);
        result.put(FieldNames.REGATTA_LOG_EVENT_CLASS.name(), (Object)RegattaLogRegisterBoatEvent.class.getSimpleName());
        result.put(FieldNames.REGATTA_LOG_BOAT_ID.name(), (Object)event.getBoat().getId());
        return this.storeRegattaLogEvent(regattaLikeId, result);
    }

    public Document storeRegattaLogEvent(RegattaLikeIdentifier regattaLikeId, RegattaLogRegisterCompetitorEvent event) {
        Document result = this.createBasicRegattaLogEventDBObject((RegattaLogEvent)event);
        result.put(FieldNames.REGATTA_LOG_EVENT_CLASS.name(), (Object)RegattaLogRegisterCompetitorEvent.class.getSimpleName());
        result.put(FieldNames.REGATTA_LOG_COMPETITOR_ID.name(), (Object)event.getCompetitor().getId());
        return this.storeRegattaLogEvent(regattaLikeId, result);
    }

    public Document storeRegattaLogEvent(RegattaLikeIdentifier regattaLikeId, RegattaLogCloseOpenEndedDeviceMappingEvent event) {
        Document result = this.createBasicRegattaLogEventDBObject((RegattaLogEvent)event);
        result.put(FieldNames.REGATTA_LOG_EVENT_CLASS.name(), (Object)RegattaLogCloseOpenEndedDeviceMappingEvent.class.getSimpleName());
        result.put(FieldNames.REGATTA_LOG_DEVICE_MAPPING_EVENT_ID.name(), (Object)event.getDeviceMappingEventId());
        MongoObjectFactoryImpl.storeTimePoint(event.getClosingTimePointInclusive(), result, FieldNames.REGATTA_LOG_CLOSING_TIMEPOINT);
        return this.storeRegattaLogEvent(regattaLikeId, result);
    }

    public Document storeRegattaLogEvent(RegattaLikeIdentifier regattaLikeId, RegattaLogSetCompetitorTimeOnTimeFactorEvent event) {
        Document result = this.createBasicRegattaLogEventDBObject((RegattaLogEvent)event);
        result.put(FieldNames.REGATTA_LOG_EVENT_CLASS.name(), (Object)RegattaLogSetCompetitorTimeOnTimeFactorEvent.class.getSimpleName());
        result.put(FieldNames.REGATTA_LOG_COMPETITOR_ID.name(), (Object)event.getCompetitor().getId());
        result.put(FieldNames.REGATTA_LOG_TIME_ON_TIME_FACTOR.name(), (Object)event.getTimeOnTimeFactor());
        return this.storeRegattaLogEvent(regattaLikeId, result);
    }

    public Document storeRaceLogEntry(RaceLogIdentifier raceLogIdentifier, RaceLogDependentStartTimeEvent event) {
        Document result = new Document();
        this.storeRaceLogIdentifier((SimpleRaceLogIdentifier)raceLogIdentifier, result);
        result.put(FieldNames.RACE_LOG_EVENT.name(), (Object)this.storeRaceLogDependentStartTimeEvent(event));
        return result;
    }

    public Document storeRegattaLogEvent(RegattaLikeIdentifier regattaLikeId, RegattaLogSetCompetitorTimeOnDistanceAllowancePerNauticalMileEvent event) {
        Document result = this.createBasicRegattaLogEventDBObject((RegattaLogEvent)event);
        result.put(FieldNames.REGATTA_LOG_EVENT_CLASS.name(), (Object)RegattaLogSetCompetitorTimeOnDistanceAllowancePerNauticalMileEvent.class.getSimpleName());
        result.put(FieldNames.REGATTA_LOG_COMPETITOR_ID.name(), (Object)event.getCompetitor().getId());
        result.put(FieldNames.REGATTA_LOG_TIME_ON_DISTANCE_SECONDS_ALLOWANCE_PER_NAUTICAL_MILE.name(), (Object)event.getTimeOnDistanceAllowancePerNauticalMile().asSeconds());
        return this.storeRegattaLogEvent(regattaLikeId, result);
    }

    public Document storeRegattaLogEvent(RegattaLikeIdentifier regattaLikeIdentifier, RegattaLogDefineMarkEvent event) {
        Document result = this.createBasicRegattaLogEventDBObject((RegattaLogEvent)event);
        result.put(FieldNames.REGATTA_LOG_EVENT_CLASS.name(), (Object)RegattaLogDefineMarkEvent.class.getSimpleName());
        result.put(FieldNames.REGATTA_LOG_MARK.name(), (Object)this.storeMark(event.getMark()));
        return this.storeRegattaLogEvent(regattaLikeIdentifier, result);
    }

    private Document createImageObject(ImageDescriptor image) {
        Document result = new Document();
        result.put(FieldNames.IMAGE_URL.name(), (Object)image.getURL().toString());
        result.put(FieldNames.IMAGE_LOCALE.name(), image.getLocale() != null ? image.getLocale().toLanguageTag() : null);
        result.put(FieldNames.IMAGE_TITLE.name(), (Object)image.getTitle());
        result.put(FieldNames.IMAGE_SUBTITLE.name(), (Object)image.getSubtitle());
        result.put(FieldNames.IMAGE_COPYRIGHT.name(), (Object)image.getCopyright());
        result.put(FieldNames.IMAGE_WIDTH_IN_PX.name(), (Object)image.getWidthInPx());
        result.put(FieldNames.IMAGE_HEIGHT_IN_PX.name(), (Object)image.getHeightInPx());
        MongoObjectFactoryImpl.storeTimePoint(image.getCreatedAtDate(), result, FieldNames.IMAGE_CREATEDATDATE);
        BasicDBList tags = new BasicDBList();
        for (String tag : image.getTags()) {
            tags.add((Object)tag);
        }
        result.put(FieldNames.IMAGE_TAGS.name(), (Object)tags);
        return result;
    }

    private Document createVideoObject(VideoDescriptor video) {
        Document result = new Document();
        result.put(FieldNames.VIDEO_URL.name(), (Object)video.getURL().toString());
        result.put(FieldNames.VIDEO_LOCALE.name(), video.getLocale() != null ? video.getLocale().toLanguageTag() : null);
        result.put(FieldNames.VIDEO_THUMBNAIL_URL.name(), video.getThumbnailURL() != null ? video.getThumbnailURL().toString() : null);
        result.put(FieldNames.VIDEO_TITLE.name(), (Object)video.getTitle());
        result.put(FieldNames.VIDEO_SUBTITLE.name(), (Object)video.getSubtitle());
        result.put(FieldNames.VIDEO_MIMETYPE.name(), video.getMimeType() != null ? video.getMimeType().name() : null);
        result.put(FieldNames.VIDEO_COPYRIGHT.name(), (Object)video.getCopyright());
        result.put(FieldNames.VIDEO_LENGTH_IN_SECONDS.name(), (Object)video.getLengthInSeconds());
        MongoObjectFactoryImpl.storeTimePoint(video.getCreatedAtDate(), result, FieldNames.VIDEO_CREATEDATDATE);
        BasicDBList tags = new BasicDBList();
        for (String tag : video.getTags()) {
            tags.add((Object)tag);
        }
        result.put(FieldNames.VIDEO_TAGS.name(), (Object)tags);
        return result;
    }

    private Document createSailorsInfoWebsiteObject(Locale locale, URL url) {
        Document result = new Document();
        result.put(FieldNames.SAILORS_INFO_URL.name(), (Object)url.toString());
        result.put(FieldNames.SAILORS_INFO_LOCALE.name(), (Object)(locale != null ? locale.toLanguageTag() : null));
        return result;
    }

    @Override
    public void removeConnectivityParametersForRaceToRestore(RaceTrackingConnectivityParameters params) throws MalformedURLException {
        if (this.raceTrackingConnectivityParamsServiceFinder != null) {
            String typeIdentifier = params.getTypeIdentifier();
            RaceTrackingConnectivityParametersHandler paramsPersistenceService = (RaceTrackingConnectivityParametersHandler)this.raceTrackingConnectivityParamsServiceFinder.findService(typeIdentifier);
            if (paramsPersistenceService != null) {
                MongoCollection collection = this.database.getCollection(CollectionNames.CONNECTIVITY_PARAMS_FOR_RACES_TO_BE_RESTORED.name());
                Document key = new Document();
                key.putAll(paramsPersistenceService.getKey(params));
                DeleteResult deleteResult = collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).deleteOne((Bson)key);
                if (deleteResult.getDeletedCount() != 1L) {
                    logger.warning("Tried to delete connectivity params " + params + " from restore list but delete count was " + deleteResult.getDeletedCount());
                }
            } else {
                logger.warning("Couldn't find a persistence service for connectivity parameters of type " + typeIdentifier);
            }
        } else {
            logger.warning("No connectivity parameters service finder set; unable to remove connectivity parameters from persistent store for " + params + " of type " + params.getTypeIdentifier());
        }
    }

    @Override
    public void addConnectivityParametersForRaceToRestore(RaceTrackingConnectivityParameters params) {
        String typeIdentifier = params.getTypeIdentifier();
        if (this.raceTrackingConnectivityParamsServiceFinder == null) {
            logger.warning("No service finder has been configured to find connectivity parameter persistence services. Can't add connectivity parameters to DB for restore.");
        } else {
            try {
                RaceTrackingConnectivityParametersHandler paramsPersistenceService = (RaceTrackingConnectivityParametersHandler)this.raceTrackingConnectivityParamsServiceFinder.findService(typeIdentifier);
                MongoCollection collection = this.database.getCollection(CollectionNames.CONNECTIVITY_PARAMS_FOR_RACES_TO_BE_RESTORED.name());
                Document key = new Document();
                key.putAll(paramsPersistenceService.getKey(params));
                Document dbObject = new Document();
                dbObject.putAll(paramsPersistenceService.mapFrom(params));
                collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)key, (Object)dbObject, new ReplaceOptions().upsert(true));
            }
            catch (NoCorrespondingServiceRegisteredException e) {
                logger.log(Level.WARNING, "Couldn't find a persistence service for connectivity parameters of type " + typeIdentifier + ". Couldn't store race " + params.getTrackerID() + " for restoring.", e);
            }
            catch (MalformedURLException e) {
                logger.log(Level.WARNING, "Issue with reading a URL from the tracking params for tracker " + params.getTrackerID() + " for restoring.", e);
            }
        }
    }

    @Override
    public void removeAllConnectivityParametersForRacesToRestore() {
        this.database.getCollection(CollectionNames.CONNECTIVITY_PARAMS_FOR_RACES_TO_BE_RESTORED.name()).drop();
    }

    @Override
    public void storeAnniversaryData(ConcurrentHashMap<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>> knownAnniversaries) {
        try {
            MongoCollection anniversarysStored = this.database.getCollection(CollectionNames.ANNIVERSARIES.name());
            for (Map.Entry<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>> anniversary : knownAnniversaries.entrySet()) {
                Document currentProxy = new Document(FieldNames.ANNIVERSARY_NUMBER.name(), (Object)anniversary.getKey());
                Document newValue = new Document(FieldNames.ANNIVERSARY_NUMBER.name(), (Object)anniversary.getKey());
                DetailedRaceInfo raceInfo = (DetailedRaceInfo)anniversary.getValue().getA();
                newValue.append(FieldNames.RACE_NAME.name(), (Object)raceInfo.getIdentifier().getRaceName());
                newValue.append(FieldNames.REGATTA_NAME.name(), (Object)raceInfo.getIdentifier().getRegattaName());
                newValue.append(FieldNames.LEADERBOARD_NAME.name(), (Object)raceInfo.getLeaderboardName());
                newValue.append(FieldNames.LEADERBOARD_DISPLAY_NAME.name(), (Object)raceInfo.getLeaderboardDisplayName());
                MongoObjectFactoryImpl.storeTimePoint(raceInfo.getStartOfRace(), newValue, FieldNames.START_OF_RACE.name());
                newValue.append(FieldNames.EVENT_ID.name(), (Object)raceInfo.getEventID().toString());
                newValue.append(FieldNames.EVENT_NAME.name(), (Object)raceInfo.getEventName());
                newValue.append(FieldNames.EVENT_TYPE.name(), raceInfo.getEventType() == null ? null : raceInfo.getEventType().name());
                URL remoteUrl = raceInfo.getRemoteUrl();
                newValue.append(FieldNames.REMOTE_URL.name(), (Object)(remoteUrl == null ? null : remoteUrl.toExternalForm()));
                newValue.append(FieldNames.ANNIVERSARY_TYPE.name(), (Object)((AnniversaryType)anniversary.getValue().getB()).toString());
                anniversarysStored.replaceOne((Bson)currentProxy, (Object)newValue, new ReplaceOptions().upsert(true));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Document createORCCertificateObject(ORCCertificate certificate) {
        ORCCertificateJsonSerializer serializer = new ORCCertificateJsonSerializer();
        Document result = Document.parse((String)serializer.serialize(certificate).toString());
        return result;
    }

    public Document storeRegattaLogEvent(RegattaLikeIdentifier regattaLikeIdentifier, RegattaLogORCCertificateAssignmentEvent event) {
        Document document = this.createBasicRegattaLogEventDBObject((RegattaLogEvent)event);
        document.put(FieldNames.REGATTA_LOG_EVENT_CLASS.name(), (Object)RegattaLogORCCertificateAssignmentEvent.class.getSimpleName());
        document.append(FieldNames.RACE_LOG_BOAT_ID.name(), (Object)event.getBoatId());
        document.append(FieldNames.ORC_CERTIFICATE.name(), (Object)this.createORCCertificateObject(event.getCertificate()));
        return this.storeRegattaLogEvent(regattaLikeIdentifier, document);
    }

    private List<Document> storeMarkPassings(Map<Competitor, Map<Waypoint, MarkPassing>> markPassings, Course course) {
        ArrayList<Document> result = new ArrayList<Document>();
        for (Map.Entry<Competitor, Map<Waypoint, MarkPassing>> e : markPassings.entrySet()) {
            Document competitorMarkPassings = new Document();
            competitorMarkPassings.put(FieldNames.COMPETITOR_ID.name(), (Object)e.getKey().getId());
            ArrayList<Document> markPassingsList = new ArrayList<Document>();
            for (Map.Entry<Waypoint, MarkPassing> f : e.getValue().entrySet()) {
                Document markPassingDoc = new Document();
                markPassingDoc.put(FieldNames.INDEX_OF_PASSED_WAYPOINT.name(), (Object)course.getIndexOfWaypoint(f.getKey()));
                markPassingDoc.put(FieldNames.TIME_AS_MILLIS.name(), (Object)f.getValue().getTimePoint().asMillis());
                markPassingsList.add(markPassingDoc);
            }
            competitorMarkPassings.put(FieldNames.MARK_PASSINGS.name(), markPassingsList);
            result.add(competitorMarkPassings);
        }
        return result;
    }

    @Override
    public void storeMarkPassings(RaceIdentifier raceIdentifier, MarkPassingRaceFingerprint fingerprint, Map<Competitor, Map<Waypoint, MarkPassing>> markPassings, Course course) {
        MongoCollection markPassingCollection = this.database.getCollection(CollectionNames.MARKPASSINGS.name());
        JSONObject fingerprintjson = fingerprint.toJson();
        Document query = new Document();
        DomainObjectFactoryImpl.addRaceIdentifierToQuery(query, raceIdentifier);
        Document result = new Document();
        Document fingerprintDoc = Document.parse((String)fingerprintjson.toString());
        result.put(FieldNames.MARK_PASSINGS_FINGERPRINT.name(), (Object)fingerprintDoc);
        this.storeRaceIdentifier(result, raceIdentifier);
        List<Document> markPassingsDoc = this.storeMarkPassings(markPassings, course);
        result.put(FieldNames.MARK_PASSINGS.name(), markPassingsDoc);
        markPassingCollection.replaceOne((Bson)query, (Object)result, new ReplaceOptions().upsert(true));
    }

    @Override
    public void removeMarkPassings(RaceIdentifier raceIdentifier) {
        MongoCollection markPassingCollection = this.database.getCollection(CollectionNames.MARKPASSINGS.name());
        Document query = new Document();
        DomainObjectFactoryImpl.addRaceIdentifierToQuery(query, raceIdentifier);
        markPassingCollection.deleteOne((Bson)query);
    }

    private List<Document> storeManeuvers(Map<Competitor, List<Maneuver>> maneuvers, RaceIdentifier raceIdentifier, Course course) {
        ArrayList<Document> result = new ArrayList<Document>();
        for (Map.Entry<Competitor, List<Maneuver>> e : maneuvers.entrySet()) {
            Document competitorManeuver = new Document();
            competitorManeuver.put(FieldNames.COMPETITOR_ID.name(), (Object)e.getKey().getId());
            ArrayList<Document> maneuverList = new ArrayList<Document>();
            if (e.getValue() == null) continue;
            for (Maneuver maneuver : e.getValue()) {
                Document maneuverDoc = new Document();
                maneuverDoc.put(FieldNames.TYPE.name(), (Object)maneuver.getType().name());
                maneuverDoc.put(FieldNames.TACK.name(), (Object)maneuver.getNewTack().name());
                maneuverDoc.put(FieldNames.POSITION_LAT_RAD.name(), (Object)maneuver.getPosition().getLatRad());
                maneuverDoc.put(FieldNames.POSITION_LNG_RAD.name(), (Object)maneuver.getPosition().getLngRad());
                maneuverDoc.put(FieldNames.TIMEPOINT.name(), (Object)maneuver.getTimePoint().asMillis());
                Document mainCurveBoundariesDoc = new Document();
                maneuverDoc.put(FieldNames.MAIN_CURVE_BOUNDARIES.name(), (Object)this.storeMainCurveBoundaries(maneuver.getMainCurveBoundaries(), mainCurveBoundariesDoc));
                Document maeuverCurveWithStableSpeedAndBoundariesDoc = new Document();
                maneuverDoc.put(FieldNames.MANEUVER_CURVE_WITH_STABLE_SPEED_AND_COURSE_BOUNDERIES.name(), (Object)this.storeMainCurveBoundaries(maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries(), maeuverCurveWithStableSpeedAndBoundariesDoc));
                maneuverDoc.put(FieldNames.MAX_TURNING_RATE_IN_DEGREE_PER_SECOUND.name(), (Object)maneuver.getMaxTurningRateInDegreesPerSecond());
                maneuverDoc.put(FieldNames.INDEX_OF_PASSED_WAYPOINT.name(), (Object)(maneuver.getMarkPassing() == null ? -1 : course.getIndexOfWaypoint(maneuver.getMarkPassing().getWaypoint())));
                maneuverDoc.put(FieldNames.TIME_AS_MILLIS.name(), (Object)maneuver.getDuration().asMillis());
                maneuverDoc.put(FieldNames.MANEUVER_LOSS.name(), maneuver.getManeuverLoss() == null ? null : this.storeManeuverLoss(maneuver.getManeuverLoss()));
                maneuverList.add(maneuverDoc);
            }
            competitorManeuver.put(FieldNames.MANEUVERS.name(), maneuverList);
            result.add(competitorManeuver);
        }
        return result;
    }

    private Document storeManeuverLoss(ManeuverLoss maneuverLoss) {
        Document maneuverLossDoc = new Document();
        maneuverLossDoc.put(FieldNames.MANEUVER_DISTANCE_SAILED_POMA.name(), (Object)maneuverLoss.getDistanceSailedIfNotManeuveringProjectedOnMiddleManeuverAngle().getMeters());
        maneuverLossDoc.put(FieldNames.MANEUVER_DISTANCE_SAILED_INMPOMA.name(), (Object)maneuverLoss.getDistanceSailedIfNotManeuveringProjectedOnMiddleManeuverAngle().getMeters());
        maneuverLossDoc.put(FieldNames.MANEUVER_START_POSITION_LAT_RAD.name(), (Object)maneuverLoss.getManeuverStartPosition().getLatRad());
        maneuverLossDoc.put(FieldNames.MANEUVER_START_POSITION_LNG_RAD.name(), (Object)maneuverLoss.getManeuverStartPosition().getLngRad());
        maneuverLossDoc.put(FieldNames.MANEUVER_END_POSITION_LAT_RAD.name(), (Object)maneuverLoss.getManeuverStartPosition().getLngRad());
        maneuverLossDoc.put(FieldNames.MANEUVER_END_POSITION_LNG_RAD.name(), (Object)maneuverLoss.getManeuverStartPosition().getLngRad());
        maneuverLossDoc.put(FieldNames.MANEUVER_SPEED_WITH_BEARING_BEFORE_DEGREES.name(), (Object)maneuverLoss.getSpeedWithBearingBefore().getBearing().getDegrees());
        maneuverLossDoc.put(FieldNames.MANEUVER_SPEED_WITH_BEARING_BEFORE_SPEED.name(), (Object)maneuverLoss.getSpeedWithBearingBefore().getKnots());
        maneuverLossDoc.put(FieldNames.MIDDLE_MAEUVER_ANGLE.name(), (Object)maneuverLoss.getMiddleManeuverAngle().getDegrees());
        maneuverLossDoc.put(FieldNames.MANEUVER_LOSS_DURATION.name(), (Object)maneuverLoss.getManeuverDuration().asMillis());
        return maneuverLossDoc;
    }

    private Document storeMainCurveBoundaries(ManeuverCurveBoundaries f, Document d) {
        d.put(FieldNames.MANEUVER_TIMEPOINT_BEFORE.name(), (Object)f.getTimePointBefore().asMillis());
        d.put(FieldNames.MANEUVER_TIMEPOINT_AFTER.name(), (Object)f.getTimePointAfter().asMillis());
        d.put(FieldNames.MANEUVER_SPEED_WITH_BEARING_BEFORE_DEGREES.name(), (Object)f.getSpeedWithBearingBefore().getBearing().getDegrees());
        d.put(FieldNames.MANEUVER_SPEED_WITH_BEARING_BEFORE_SPEED.name(), (Object)f.getSpeedWithBearingBefore().getKnots());
        d.put(FieldNames.MANEUVER_SPEED_WITH_BEARING_AFTER_DEGREES.name(), (Object)f.getSpeedWithBearingAfter().getBearing().getDegrees());
        d.put(FieldNames.MANEUVER_SPEED_WITH_BEARING_AFTER_SPEED.name(), (Object)f.getSpeedWithBearingAfter().getKnots());
        d.put(FieldNames.MANEUVER_DIRECTION_CHANGE_IN_DEGREES.name(), (Object)f.getDirectionChangeInDegrees());
        d.put(FieldNames.MANEUVER_LOWEST_SPEED.name(), (Object)f.getLowestSpeed().getKnots());
        d.put(FieldNames.MANEUVER_HIGHEST_SPEED.name(), (Object)f.getHighestSpeed().getKnots());
        return d;
    }

    @Override
    public void storeManeuvers(RaceIdentifier raceIdentifier, ManeuverRaceFingerprint fingerprint, Course course, Map<Competitor, List<Maneuver>> maneuvers) {
        MongoCollection maneuverCollection = this.database.getCollection(CollectionNames.MANEUVERS.name());
        JSONObject fingerprintjson = fingerprint.toJson();
        Document query = new Document();
        DomainObjectFactoryImpl.addRaceIdentifierToQuery(query, raceIdentifier);
        Document result = new Document();
        Document fingerprintDoc = Document.parse((String)fingerprintjson.toString());
        result.put(FieldNames.MANEUVER_FINGERPRINT.name(), (Object)fingerprintDoc);
        this.storeRaceIdentifier(result, raceIdentifier);
        List<Document> maneuverDoc = this.storeManeuvers(maneuvers, raceIdentifier, course);
        result.put(FieldNames.MANEUVERS.name(), maneuverDoc);
        maneuverCollection.replaceOne((Bson)query, (Object)result, new ReplaceOptions().upsert(true));
    }

    @Override
    public void removeManeuvers(RaceIdentifier raceIdentifier) {
        MongoCollection maneuverCollection = this.database.getCollection(CollectionNames.MANEUVERS.name());
        Document query = new Document();
        DomainObjectFactoryImpl.addRaceIdentifierToQuery(query, raceIdentifier);
        maneuverCollection.deleteOne((Bson)query);
    }
}

