/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.impl;

import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.result.DeleteResult;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.impl.LogEventAuthorImpl;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCCertificateAssignmentEvent;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCImpliedWindSourceEvent;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCLegDataEvent;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCScratchBoatEvent;
import com.sap.sailing.domain.abstractlog.orc.RegattaLogORCCertificateAssignmentEvent;
import com.sap.sailing.domain.abstractlog.orc.impl.RaceLogORCCertificateAssignmentEventImpl;
import com.sap.sailing.domain.abstractlog.orc.impl.RaceLogORCImpliedWindSourceEventImpl;
import com.sap.sailing.domain.abstractlog.orc.impl.RaceLogORCLegDataEventImpl;
import com.sap.sailing.domain.abstractlog.orc.impl.RaceLogORCScratchBoatEventImpl;
import com.sap.sailing.domain.abstractlog.orc.impl.RegattaLogORCCertificateAssignmentEventImpl;
import com.sap.sailing.domain.abstractlog.race.CompetitorResult;
import com.sap.sailing.domain.abstractlog.race.CompetitorResults;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogCourseDesignChangedEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogDependentStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEndOfTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogExcludeWindSourcesEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFinishPositioningConfirmedEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFinishPositioningListChangedEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFixedMarkPassingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFlagEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogGateLineOpeningTimeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogPassChangeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogPathfinderEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogProtestStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogRaceStatusEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogResultsAreOfficialEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartOfTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartProcedureChangedEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogSuppressedMarkPassingsEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogTagEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogWindFixEvent;
import com.sap.sailing.domain.abstractlog.race.SimpleRaceLogIdentifier;
import com.sap.sailing.domain.abstractlog.race.impl.CompetitorResultImpl;
import com.sap.sailing.domain.abstractlog.race.impl.CompetitorResultsImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogCourseDesignChangedEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogDependentStartTimeEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogEndOfTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogExcludeWindSourcesEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogFinishPositioningConfirmedEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogFinishPositioningListChangedEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogFixedMarkPassingEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogFlagEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogGateLineOpeningTimeEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogPassChangeEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogPathfinderEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogProtestStartTimeEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogRaceStatusEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogResultsAreOfficialEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogRevokeEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogStartOfTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogStartProcedureChangedEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogStartTimeEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogSuppressedMarkPassingsEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogTagEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogWindFixEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.SimpleRaceLogIdentifierImpl;
import com.sap.sailing.domain.abstractlog.race.scoring.AdditionalScoringInformationType;
import com.sap.sailing.domain.abstractlog.race.scoring.RaceLogAdditionalScoringInformationEvent;
import com.sap.sailing.domain.abstractlog.race.scoring.impl.RaceLogAdditionalScoringInformationEventImpl;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogDenoteForTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogRegisterCompetitorEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogStartTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogUseCompetitorsFromRaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.impl.RaceLogDenoteForTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.tracking.impl.RaceLogRegisterCompetitorEventImpl;
import com.sap.sailing.domain.abstractlog.race.tracking.impl.RaceLogStartTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.tracking.impl.RaceLogUseCompetitorsFromRaceLogEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogCloseOpenEndedDeviceMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDefineMarkEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceBoatMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceBoatSensorDataMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceCompetitorMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceCompetitorSensorDataMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceMarkMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRegisterBoatEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRegisterCompetitorEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogSetCompetitorTimeOnDistanceAllowancePerNauticalMileEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogSetCompetitorTimeOnTimeFactorEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogCloseOpenEndedDeviceMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDefineMarkEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceBoatBravoExtendedMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceBoatBravoMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceBoatExpeditionExtendedMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceBoatMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceCompetitorBravoExtendedMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceCompetitorBravoMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceCompetitorExpeditionExtendedMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceCompetitorMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceMarkMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogRegisterBoatEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogRegisterCompetitorEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogRevokeEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogSetCompetitorTimeOnDistanceAllowancePerNauticalMileEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogSetCompetitorTimeOnTimeFactorEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.impl.RegattaLogImpl;
import com.sap.sailing.domain.anniversary.DetailedRaceInfo;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorFactory;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.ControlPointWithTwoMarks;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.RegattaRegistry;
import com.sap.sailing.domain.base.RemoteSailingServerReference;
import com.sap.sailing.domain.base.SailingServerConfiguration;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.Venue;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.domain.base.configuration.RegattaConfiguration;
import com.sap.sailing.domain.base.impl.CourseDataImpl;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.EventImpl;
import com.sap.sailing.domain.base.impl.FleetImpl;
import com.sap.sailing.domain.base.impl.RegattaImpl;
import com.sap.sailing.domain.base.impl.RemoteSailingServerReferenceImpl;
import com.sap.sailing.domain.base.impl.SailingServerConfigurationImpl;
import com.sap.sailing.domain.base.impl.SeriesImpl;
import com.sap.sailing.domain.base.impl.VenueImpl;
import com.sap.sailing.domain.base.impl.WaypointImpl;
import com.sap.sailing.domain.common.BoatClassMasterdata;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.CourseDesignerMode;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.MarkType;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.dto.AnniversaryType;
import com.sap.sailing.domain.common.dto.EventType;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.impl.NauticalMileDistance;
import com.sap.sailing.domain.common.impl.RadianPosition;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.impl.WindSourceImpl;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import com.sap.sailing.domain.common.orc.ImpliedWindSource;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLegTypes;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.common.racelog.RaceLogRaceStatus;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sailing.domain.leaderboard.DelayedLeaderboardCorrections;
import com.sap.sailing.domain.leaderboard.EventResolver;
import com.sap.sailing.domain.leaderboard.FlexibleLeaderboard;
import com.sap.sailing.domain.leaderboard.FlexibleRaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.LeaderboardGroupResolver;
import com.sap.sailing.domain.leaderboard.LeaderboardRegistry;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithEliminations;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.SettableScoreCorrection;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.impl.DelayedLeaderboardCorrectionsImpl;
import com.sap.sailing.domain.leaderboard.impl.DelegatingRegattaLeaderboardWithCompetitorElimination;
import com.sap.sailing.domain.leaderboard.impl.FlexibleLeaderboardImpl;
import com.sap.sailing.domain.leaderboard.impl.LeaderboardGroupImpl;
import com.sap.sailing.domain.leaderboard.impl.RegattaLeaderboardImpl;
import com.sap.sailing.domain.leaderboard.impl.RegattaLeaderboardWithOtherTieBreakingLeaderboardImpl;
import com.sap.sailing.domain.leaderboard.impl.ThresholdBasedResultDiscardingRuleImpl;
import com.sap.sailing.domain.leaderboard.meta.LeaderboardGroupMetaLeaderboard;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprint;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprintFactory;
import com.sap.sailing.domain.maneuverhash.MarkPassingProxy;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprint;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintFactory;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.FieldNames;
import com.sap.sailing.domain.persistence.MongoRaceLogStoreFactory;
import com.sap.sailing.domain.persistence.MongoRegattaLogStoreFactory;
import com.sap.sailing.domain.persistence.impl.CollectionNames;
import com.sap.sailing.domain.persistence.impl.MigratableRegattaImpl;
import com.sap.sailing.domain.persistence.impl.MongoObjectFactoryImpl;
import com.sap.sailing.domain.persistence.impl.MongoUtils;
import com.sap.sailing.domain.persistence.impl.TripleSerializer;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.ranking.OneDesignRankingMetric;
import com.sap.sailing.domain.ranking.RankingMetricConstructor;
import com.sap.sailing.domain.ranking.RankingMetricsFactory;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifier;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sailing.domain.tracking.ManeuverLoss;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParametersHandler;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.impl.ManeuverCurveBoundariesImpl;
import com.sap.sailing.domain.tracking.impl.ManeuverWithMainCurveBoundariesImpl;
import com.sap.sailing.domain.tracking.impl.MarkPassingImpl;
import com.sap.sailing.domain.tracking.impl.WindTrackImpl;
import com.sap.sailing.server.gateway.deserialization.impl.BoatJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.CompetitorWithBoatRefJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.DeviceConfigurationJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.gateway.deserialization.impl.LegacyCompetitorWithContainedBoatJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.RegattaConfigurationJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.racelog.impl.ImpliedWindSourceDeserializer;
import com.sap.sailing.server.gateway.deserialization.racelog.impl.ORCCertificateJsonDeserializer;
import com.sap.sailing.shared.persistence.device.DeviceIdentifierMongoHandler;
import com.sap.sailing.shared.persistence.device.impl.PlaceHolderDeviceIdentifierMongoHandler;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Color;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.common.Util;
import com.sap.sse.common.WithID;
import com.sap.sse.common.impl.AbstractColor;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.RGBColor;
import com.sap.sse.common.impl.TimeRangeImpl;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.media.ImageDescriptor;
import com.sap.sse.shared.media.VideoDescriptor;
import com.sap.sse.shared.media.impl.ImageDescriptorImpl;
import com.sap.sse.shared.media.impl.VideoDescriptorImpl;
import com.sap.sse.shared.util.impl.UUIDHelper;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.bson.types.ObjectId;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class DomainObjectFactoryImpl
implements DomainObjectFactory {
    private static final Logger logger = Logger.getLogger(DomainObjectFactoryImpl.class.getName());
    private final LegacyCompetitorWithContainedBoatJsonDeserializer legacyCompetitorWithBoatDeserializer;
    private final CompetitorWithBoatRefJsonDeserializer competitorWithBoatRefDeserializer;
    private final BoatJsonDeserializer boatDeserializer;
    private final MongoDatabase database;
    private final DomainFactory baseDomainFactory;
    private final TypeBasedServiceFinderFactory serviceFinderFactory;
    private final TypeBasedServiceFinder<DeviceIdentifierMongoHandler> deviceIdentifierServiceFinder;
    private final TypeBasedServiceFinder<RaceTrackingConnectivityParametersHandler> raceTrackingConnectivityParamsServiceFinder;
    private int secondLeagueBoatCounter = 0;

    public DomainObjectFactoryImpl(MongoDatabase db, DomainFactory baseDomainFactory) {
        this(db, baseDomainFactory, null);
    }

    public DomainObjectFactoryImpl(MongoDatabase db, DomainFactory baseDomainFactory, TypeBasedServiceFinderFactory serviceFinderFactory) {
        this.serviceFinderFactory = serviceFinderFactory;
        if (serviceFinderFactory != null) {
            this.deviceIdentifierServiceFinder = serviceFinderFactory.createServiceFinder(DeviceIdentifierMongoHandler.class);
            this.deviceIdentifierServiceFinder.setFallbackService((Object)new PlaceHolderDeviceIdentifierMongoHandler());
            this.raceTrackingConnectivityParamsServiceFinder = serviceFinderFactory.createServiceFinder(RaceTrackingConnectivityParametersHandler.class);
        } else {
            this.deviceIdentifierServiceFinder = null;
            this.raceTrackingConnectivityParamsServiceFinder = null;
        }
        this.baseDomainFactory = baseDomainFactory;
        this.legacyCompetitorWithBoatDeserializer = LegacyCompetitorWithContainedBoatJsonDeserializer.create((SharedDomainFactory)baseDomainFactory);
        this.competitorWithBoatRefDeserializer = CompetitorWithBoatRefJsonDeserializer.create((SharedDomainFactory)baseDomainFactory);
        this.boatDeserializer = BoatJsonDeserializer.create((SharedDomainFactory)baseDomainFactory, (boolean)false);
        this.database = db;
    }

    @Override
    public DomainFactory getBaseDomainFactory() {
        return this.baseDomainFactory;
    }

    @Override
    public Wind loadWind(Document object) {
        return new WindImpl(com.sap.sailing.shared.persistence.impl.DomainObjectFactoryImpl.loadPosition((Document)object), this.loadTimePoint(object), this.loadSpeedWithBearing(object));
    }

    public static TimePoint loadTimePoint(Document object, String fieldName) {
        Number timePointAsNumber = (Number)object.get((Object)fieldName);
        MillisecondsTimePoint result = timePointAsNumber != null ? new MillisecondsTimePoint(timePointAsNumber.longValue()) : null;
        return result;
    }

    public static TimePoint loadTimePoint(Document object, FieldNames field) {
        return DomainObjectFactoryImpl.loadTimePoint(object, field.name());
    }

    public static TimeRange loadTimeRange(Document object, FieldNames field) {
        TimeRangeImpl result;
        Document timeRangeObj = (Document)object.get((Object)field.name());
        if (timeRangeObj == null) {
            result = null;
        } else {
            TimePoint from = DomainObjectFactoryImpl.loadTimePoint(timeRangeObj, FieldNames.FROM_MILLIS);
            TimePoint to = DomainObjectFactoryImpl.loadTimePoint(timeRangeObj, FieldNames.TO_MILLIS);
            result = new TimeRangeImpl(from, to);
        }
        return result;
    }

    public TimePoint loadTimePoint(Document object) {
        return DomainObjectFactoryImpl.loadTimePoint(object, FieldNames.TIME_AS_MILLIS);
    }

    public SpeedWithBearing loadSpeedWithBearing(Document object) {
        return new KnotSpeedWithBearingImpl(((Number)object.get((Object)FieldNames.KNOT_SPEED.name())).doubleValue(), (Bearing)new DegreeBearingImpl(((Number)object.get((Object)FieldNames.DEGREE_BEARING.name())).doubleValue()));
    }

    public Bearing loadOptionalTrueHeading(Document object) {
        DegreeBearingImpl result = object.containsKey((Object)FieldNames.TRUE_HEADING_DEG.name()) ? new DegreeBearingImpl(((Number)object.get((Object)FieldNames.TRUE_HEADING_DEG.name())).doubleValue()) : null;
        return result;
    }

    @Override
    public RaceIdentifier loadRaceIdentifier(Document dbObject) {
        RegattaNameAndRaceName result = null;
        if (dbObject != null) {
            String regattaName = (String)dbObject.get((Object)FieldNames.EVENT_NAME.name());
            String raceName = (String)dbObject.get((Object)FieldNames.RACE_NAME.name());
            if (regattaName != null && raceName != null) {
                result = new RegattaNameAndRaceName(regattaName, raceName);
            }
        }
        return result;
    }

    static void addRaceIdentifierToQuery(Document query, RaceIdentifier raceIdentifier) {
        query.put(FieldNames.EVENT_NAME.name(), (Object)raceIdentifier.getRegattaName());
        query.put(FieldNames.RACE_NAME.name(), (Object)raceIdentifier.getRaceName());
    }

    static void ensureIndicesOnWindTracks(MongoCollection<Document> windTracks) {
        windTracks.createIndex((Bson)new Document(FieldNames.RACE_ID.name(), (Object)1), new IndexOptions().name("windbyrace").background(false));
        windTracks.createIndex((Bson)new Document(FieldNames.REGATTA_NAME.name(), (Object)1), new IndexOptions().name("windbyregatta").background(false));
        windTracks.createIndex((Bson)new Document().append(FieldNames.EVENT_NAME.name(), (Object)1).append(FieldNames.RACE_NAME.name(), (Object)1), new IndexOptions().name("windbyeventandrace").background(false));
        try {
            windTracks.createIndex((Bson)new Document().append(FieldNames.RACE_ID.name(), (Object)1).append(FieldNames.WIND_SOURCE_NAME.name(), (Object)1).append(FieldNames.WIND_SOURCE_ID.name(), (Object)1).append(String.valueOf(FieldNames.WIND.name()) + "." + FieldNames.TIME_AS_MILLIS.name(), (Object)1), new IndexOptions().name("windByRaceSourceAndTime").unique(true).background(false));
        }
        catch (MongoException exception) {
            if (exception.getCode() == 10092) {
                logger.warning(String.format("Setting the unique index on the %s collection failed because you have too many duplicates. This leads to the mongo error code %s and the following message: %s \nTo fix this follow the steps provided on the wiki page: http://wiki.sapsailing.com/wiki/howto/misc/cook-book#Remove-duplicates-from-WIND_TRACK-collection", CollectionNames.WIND_TRACKS.name(), exception.getCode(), exception.getMessage()));
            }
            logger.severe(String.format("Setting the unique index on the %s collection failed with error code %s and message: %s", CollectionNames.WIND_TRACKS.name(), exception.getCode(), exception.getMessage()));
        }
    }

    @Override
    public Leaderboard loadLeaderboard(String name, RegattaRegistry regattaRegistry, LeaderboardRegistry leaderboardRegistry) {
        MongoCollection leaderboardCollection = this.database.getCollection(CollectionNames.LEADERBOARDS.name());
        Leaderboard result = null;
        try {
            Document query = new Document();
            query.put(FieldNames.LEADERBOARD_NAME.name(), (Object)name);
            for (Document o : leaderboardCollection.find((Bson)query)) {
                result = this.loadLeaderboard(o, regattaRegistry, leaderboardRegistry, null);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load leaderboard " + name + ".");
            logger.log(Level.SEVERE, "loadLeaderboard", e);
        }
        return result;
    }

    @Override
    public RegattaLeaderboardWithEliminations loadRegattaLeaderboardWithEliminations(Document dbLeaderboard, String leaderboardName, String wrappedRegattaLeaderboardName, LeaderboardRegistry leaderboardRegistry) {
        Iterable eliminatedCompetitorIds = (Iterable)dbLeaderboard.get((Object)FieldNames.ELMINATED_COMPETITORS.name());
        DelegatingRegattaLeaderboardWithCompetitorElimination result = new DelegatingRegattaLeaderboardWithCompetitorElimination(() -> (RegattaLeaderboard)leaderboardRegistry.getLeaderboardByName(wrappedRegattaLeaderboardName), leaderboardName);
        for (Object eliminatedCompetitorId : eliminatedCompetitorIds) {
            Competitor eliminatedCompetitor = this.baseDomainFactory.getCompetitorAndBoatStore().getExistingCompetitorById((Serializable)eliminatedCompetitorId);
            if (eliminatedCompetitor == null) {
                logger.warning("Couldn't find eliminated competitor with ID " + eliminatedCompetitorId);
                continue;
            }
            result.setEliminated(eliminatedCompetitor, true);
        }
        return result;
    }

    private Leaderboard loadLeaderboard(Document dbLeaderboard, RegattaRegistry regattaRegistry, LeaderboardRegistry leaderboardRegistry, LeaderboardGroup groupForMetaLeaderboard) {
        Object result = null;
        String leaderboardName = (String)dbLeaderboard.get((Object)FieldNames.LEADERBOARD_NAME.name());
        if (leaderboardRegistry != null) {
            result = leaderboardRegistry.getLeaderboardByName(leaderboardName);
        }
        if (result == null) {
            String wrappedRegattaLeaderboardName = (String)dbLeaderboard.get((Object)FieldNames.WRAPPED_REGATTA_LEADERBOARD_NAME.name());
            if (wrappedRegattaLeaderboardName != null) {
                result = this.loadRegattaLeaderboardWithEliminations(dbLeaderboard, leaderboardName, wrappedRegattaLeaderboardName, leaderboardRegistry);
            } else {
                if (groupForMetaLeaderboard != null) {
                    result = new LeaderboardGroupMetaLeaderboard(groupForMetaLeaderboard, this.loadScoringScheme(dbLeaderboard), this.loadResultDiscardingRule(dbLeaderboard, FieldNames.LEADERBOARD_DISCARDING_THRESHOLDS));
                    groupForMetaLeaderboard.setOverallLeaderboard(result);
                } else {
                    String regattaName = (String)dbLeaderboard.get((Object)FieldNames.REGATTA_NAME.name());
                    ThresholdBasedResultDiscardingRule resultDiscardingRule = this.loadResultDiscardingRule(dbLeaderboard, FieldNames.LEADERBOARD_DISCARDING_THRESHOLDS);
                    result = regattaName == null ? this.loadFlexibleLeaderboard(dbLeaderboard, resultDiscardingRule) : this.loadRegattaLeaderboard(leaderboardName, regattaName, dbLeaderboard, resultDiscardingRule, regattaRegistry, leaderboardRegistry);
                }
                if (result != null) {
                    DelayedLeaderboardCorrectionsImpl loadedLeaderboardCorrections = new DelayedLeaderboardCorrectionsImpl(result, (CompetitorFactory)this.baseDomainFactory);
                    this.loadLeaderboardCorrections(dbLeaderboard, (DelayedLeaderboardCorrections)loadedLeaderboardCorrections, result.getScoreCorrection());
                    this.loadSuppressedCompetitors(dbLeaderboard, (DelayedLeaderboardCorrections)loadedLeaderboardCorrections);
                    this.loadColumnFactors(dbLeaderboard, (Leaderboard)result);
                }
            }
            if (result != null) {
                Leaderboard finalResult = result;
                finalResult.setDisplayName((String)dbLeaderboard.get((Object)FieldNames.LEADERBOARD_DISPLAY_NAME.name()));
                if (leaderboardRegistry != null) {
                    leaderboardRegistry.addLeaderboard(result);
                    logger.info("loaded leaderboard " + result.getName() + " into " + leaderboardRegistry);
                }
            }
        }
        return result;
    }

    private void loadColumnFactors(Document dbLeaderboard, Leaderboard result) {
        Document dbColumnFactors = (Document)dbLeaderboard.get((Object)FieldNames.LEADERBOARD_COLUMN_FACTORS.name());
        if (dbColumnFactors != null) {
            for (String encodedRaceColumnName : dbColumnFactors.keySet()) {
                double factor = ((Number)dbColumnFactors.get((Object)encodedRaceColumnName)).doubleValue();
                String raceColumnName = MongoUtils.unescapeDollarAndDot(encodedRaceColumnName);
                RaceColumn raceColumn = result.getRaceColumnByName(raceColumnName);
                if (raceColumn != null) {
                    raceColumn.setFactor(Double.valueOf(factor));
                    continue;
                }
                logger.warning("Expected to find race column named " + raceColumnName + " in leaderboard " + result.getName() + " to apply column factor " + factor + ", but the race column wasn't found. Ignoring factor.");
            }
        }
    }

    private void loadSuppressedCompetitors(Document dbLeaderboard, DelayedLeaderboardCorrections loadedLeaderboardCorrections) {
        Iterable dbSuppressedCompetitorIDs = (Iterable)dbLeaderboard.get((Object)FieldNames.LEADERBOARD_SUPPRESSED_COMPETITOR_IDS.name());
        if (dbSuppressedCompetitorIDs != null) {
            for (Object competitorId : dbSuppressedCompetitorIDs) {
                loadedLeaderboardCorrections.suppressCompetitorByID((Serializable)competitorId);
            }
        }
    }

    private ThresholdBasedResultDiscardingRule loadResultDiscardingRule(Document dbObject, FieldNames field) {
        ThresholdBasedResultDiscardingRuleImpl result;
        Iterable dbDiscardIndexResultsStartingWithHowManyRaces = (Iterable)dbObject.get((Object)field.name());
        if (dbDiscardIndexResultsStartingWithHowManyRaces == null) {
            result = null;
        } else {
            int[] discardIndexResultsStartingWithHowManyRaces = new int[Util.size((Iterable)dbDiscardIndexResultsStartingWithHowManyRaces)];
            int i = 0;
            for (Object discardingThresholdAsObject : dbDiscardIndexResultsStartingWithHowManyRaces) {
                discardIndexResultsStartingWithHowManyRaces[i++] = ((Number)discardingThresholdAsObject).intValue();
            }
            result = new ThresholdBasedResultDiscardingRuleImpl(discardIndexResultsStartingWithHowManyRaces);
        }
        return result;
    }

    private RegattaLeaderboard loadRegattaLeaderboard(String leaderboardName, String regattaName, Document dbLeaderboard, ThresholdBasedResultDiscardingRule resultDiscardingRule, RegattaRegistry regattaRegistry, LeaderboardRegistry leaderboardRegistry) {
        Object result;
        Regatta regatta = regattaRegistry.getRegatta((RegattaIdentifier)new RegattaName(regattaName));
        if (regatta == null) {
            logger.info("Couldn't find regatta " + regattaName + " for corresponding regatta leaderboard. Not loading regatta leaderboard.");
            result = null;
        } else {
            String otherTieBreakingLeaderboardName = (String)dbLeaderboard.get((Object)FieldNames.OTHER_TIEBREAKING_LEADERBOARD_NAME.name());
            result = otherTieBreakingLeaderboardName == null ? new RegattaLeaderboardImpl(regatta, resultDiscardingRule) : new RegattaLeaderboardWithOtherTieBreakingLeaderboardImpl(regatta, resultDiscardingRule, () -> (RegattaLeaderboard)leaderboardRegistry.getLeaderboardByName(otherTieBreakingLeaderboardName));
        }
        return result;
    }

    private RaceLogStore getRaceLogStore() {
        return MongoRaceLogStoreFactory.INSTANCE.getMongoRaceLogStore(new MongoObjectFactoryImpl(this.database, this.serviceFinderFactory), this);
    }

    private RegattaLogStore getRegattaLogStore() {
        return MongoRegattaLogStoreFactory.INSTANCE.getMongoRegattaLogStore(new MongoObjectFactoryImpl(this.database, this.serviceFinderFactory), this);
    }

    private FlexibleLeaderboard loadFlexibleLeaderboard(Document dbLeaderboard, ThresholdBasedResultDiscardingRule resultDiscardingRule) {
        FlexibleLeaderboardImpl result;
        Iterable dbRaceColumns = (Iterable)dbLeaderboard.get((Object)FieldNames.LEADERBOARD_COLUMNS.name());
        if (dbRaceColumns == null) {
            logger.warning("Probably found orphan overall leaderboard named " + dbLeaderboard.get((Object)FieldNames.LEADERBOARD_NAME.name()) + ". Ignoring.");
            result = null;
        } else {
            ScoringScheme scoringScheme = this.loadScoringScheme(dbLeaderboard);
            Iterable<CourseArea> courseAreas = this.loadCourseAreas(dbLeaderboard);
            result = new FlexibleLeaderboardImpl(this.getRaceLogStore(), this.getRegattaLogStore(), (String)dbLeaderboard.get((Object)FieldNames.LEADERBOARD_NAME.name()), resultDiscardingRule, scoringScheme, courseAreas);
            for (Object dbRaceColumnAsObject : dbRaceColumns) {
                Document dbRaceColumn = (Document)dbRaceColumnAsObject;
                String columnName = (String)dbRaceColumn.get((Object)FieldNames.LEADERBOARD_COLUMN_NAME.name());
                FlexibleRaceColumn raceColumn = result.addRaceColumn(columnName, ((Boolean)dbRaceColumn.get((Object)FieldNames.LEADERBOARD_IS_MEDAL_RACE_COLUMN.name())).booleanValue());
                Map<String, RaceIdentifier> raceIdentifiers = this.loadRaceIdentifiers(dbRaceColumn);
                RaceIdentifier defaultFleetRaceIdentifier = raceIdentifiers.get(result.getFleet(null).getName());
                if (defaultFleetRaceIdentifier == null) {
                    defaultFleetRaceIdentifier = raceIdentifiers.get(null);
                }
                if (defaultFleetRaceIdentifier == null) continue;
                Fleet defaultFleet = result.getFleet(null);
                if (defaultFleet != null) {
                    raceColumn.setRaceIdentifier(defaultFleet, defaultFleetRaceIdentifier);
                    continue;
                }
                logger.warning("Discarding RaceIdentifier " + defaultFleetRaceIdentifier + " for default fleet for leaderboard " + result.getName() + " because no default fleet was found in leaderboard");
            }
        }
        return result;
    }

    private Iterable<CourseArea> loadCourseAreas(Document documentContainingCourseAreaIds) {
        List courseAreaIds;
        HashSet<CourseArea> courseAreas = new HashSet<CourseArea>();
        String courseAreaId = (String)documentContainingCourseAreaIds.get((Object)FieldNames.COURSE_AREA_ID.name());
        if (courseAreaId != null) {
            this.lookupCourseAreaAndAddIfFound(courseAreas, courseAreaId);
        }
        if ((courseAreaIds = (List)documentContainingCourseAreaIds.get((Object)FieldNames.COURSE_AREA_IDS.name())) != null) {
            for (Object courseAreaIdAsString : courseAreaIds) {
                this.lookupCourseAreaAndAddIfFound(courseAreas, courseAreaIdAsString.toString());
            }
        }
        return courseAreas;
    }

    private void lookupCourseAreaAndAddIfFound(Set<CourseArea> courseAreas, String courseAreaIdAsString) {
        UUID courseAreaUuid = UUID.fromString(courseAreaIdAsString);
        CourseArea lookupResult = this.baseDomainFactory.getExistingCourseAreaById((Serializable)courseAreaUuid);
        if (lookupResult != null) {
            courseAreas.add(lookupResult);
        }
    }

    private ScoringScheme loadScoringScheme(Document dbLeaderboard) {
        ScoringSchemeType scoringSchemeType = this.getScoringSchemeType(dbLeaderboard);
        ScoringScheme scoringScheme = this.baseDomainFactory.createScoringScheme(scoringSchemeType);
        return scoringScheme;
    }

    private void loadLeaderboardCorrections(Document dbLeaderboard, DelayedLeaderboardCorrections correctionsToUpdate, SettableScoreCorrection scoreCorrectionToUpdate) {
        Document dbScoreCorrection;
        Iterable carriedPointsById = (Iterable)dbLeaderboard.get((Object)FieldNames.LEADERBOARD_CARRIED_POINTS_BY_ID.name());
        if (carriedPointsById != null) {
            for (Object o : carriedPointsById) {
                Document competitorIdAndCarriedPoints = (Document)o;
                Serializable competitorId = (Serializable)competitorIdAndCarriedPoints.get((Object)FieldNames.COMPETITOR_ID.name());
                Double carriedPointsForCompetitor = ((Number)competitorIdAndCarriedPoints.get((Object)FieldNames.LEADERBOARD_CARRIED_POINTS.name())).doubleValue();
                if (carriedPointsForCompetitor == null) continue;
                correctionsToUpdate.setCarriedPointsByID(competitorId, carriedPointsForCompetitor.doubleValue());
            }
        }
        if ((dbScoreCorrection = (Document)dbLeaderboard.get((Object)FieldNames.LEADERBOARD_SCORE_CORRECTIONS.name())).containsKey((Object)FieldNames.LEADERBOARD_SCORE_CORRECTION_TIMESTAMP.name())) {
            scoreCorrectionToUpdate.setTimePointOfLastCorrectionsValidity((TimePoint)new MillisecondsTimePoint(((Long)dbScoreCorrection.get((Object)FieldNames.LEADERBOARD_SCORE_CORRECTION_TIMESTAMP.name())).longValue()));
            dbScoreCorrection.remove((Object)FieldNames.LEADERBOARD_SCORE_CORRECTION_TIMESTAMP.name());
        }
        if (dbScoreCorrection.containsKey((Object)FieldNames.LEADERBOARD_SCORE_CORRECTION_COMMENT.name())) {
            scoreCorrectionToUpdate.setComment((String)dbScoreCorrection.get((Object)FieldNames.LEADERBOARD_SCORE_CORRECTION_COMMENT.name()));
            dbScoreCorrection.remove((Object)FieldNames.LEADERBOARD_SCORE_CORRECTION_COMMENT.name());
        }
        for (String escapedRaceColumnName : dbScoreCorrection.keySet()) {
            Iterable dbScoreCorrectionForRace = (Iterable)dbScoreCorrection.get((Object)escapedRaceColumnName);
            RaceColumn raceColumn = correctionsToUpdate.getLeaderboard().getRaceColumnByName(MongoUtils.unescapeDollarAndDot(escapedRaceColumnName));
            if (raceColumn != null) {
                for (Document dbScoreCorrectionForCompetitorInRace : dbScoreCorrectionForRace) {
                    Serializable competitorId = (Serializable)dbScoreCorrectionForCompetitorInRace.get((Object)FieldNames.COMPETITOR_ID.name());
                    if (dbScoreCorrectionForCompetitorInRace.containsKey((Object)FieldNames.LEADERBOARD_SCORE_CORRECTION_MAX_POINTS_REASON.name())) {
                        correctionsToUpdate.setMaxPointsReasonByID(competitorId, raceColumn, MaxPointsReason.valueOf((String)((String)dbScoreCorrectionForCompetitorInRace.get((Object)FieldNames.LEADERBOARD_SCORE_CORRECTION_MAX_POINTS_REASON.name()))));
                    }
                    if (dbScoreCorrectionForCompetitorInRace.containsKey((Object)FieldNames.LEADERBOARD_CORRECTED_SCORE.name())) {
                        Number dbScoreCorrectionForCompetitorInRaceAsNumber = (Number)dbScoreCorrectionForCompetitorInRace.get((Object)FieldNames.LEADERBOARD_CORRECTED_SCORE.name());
                        Double leaderboardCorrectedScore = dbScoreCorrectionForCompetitorInRaceAsNumber == null ? null : Double.valueOf(dbScoreCorrectionForCompetitorInRaceAsNumber.doubleValue());
                        correctionsToUpdate.correctScoreByID(competitorId, raceColumn, leaderboardCorrectedScore.doubleValue());
                    }
                    if (!dbScoreCorrectionForCompetitorInRace.containsKey((Object)FieldNames.LEADERBOARD_INCREMENTAL_SCORE_CORRECTION_IN_POINTS.name())) continue;
                    Number dbIncrementalScoreCorrectionForCompetitorInRaceAsNumberInPoints = (Number)dbScoreCorrectionForCompetitorInRace.get((Object)FieldNames.LEADERBOARD_INCREMENTAL_SCORE_CORRECTION_IN_POINTS.name());
                    Double leaderboardIncrementalCorrectedScoreInPoints = dbIncrementalScoreCorrectionForCompetitorInRaceAsNumberInPoints == null ? null : Double.valueOf(dbIncrementalScoreCorrectionForCompetitorInRaceAsNumberInPoints.doubleValue());
                    correctionsToUpdate.correctScoreIncrementallyByID(competitorId, raceColumn, leaderboardIncrementalCorrectedScoreInPoints.doubleValue());
                }
                continue;
            }
            logger.warning("Couldn't find race column " + MongoUtils.unescapeDollarAndDot(escapedRaceColumnName) + " in leaderboard " + correctionsToUpdate.getLeaderboard().getName());
        }
        Iterable competitorDisplayNames = (Iterable)dbLeaderboard.get((Object)FieldNames.LEADERBOARD_COMPETITOR_DISPLAY_NAMES.name());
        if (competitorDisplayNames != null) {
            if (competitorDisplayNames instanceof Iterable) {
                for (Object o : competitorDisplayNames) {
                    Document competitorDisplayName = (Document)o;
                    Serializable competitorId = (Serializable)competitorDisplayName.get((Object)FieldNames.COMPETITOR_ID.name());
                    String displayName = (String)competitorDisplayName.get((Object)FieldNames.COMPETITOR_DISPLAY_NAME.name());
                    correctionsToUpdate.setDisplayNameByID(competitorId, displayName);
                }
            } else {
                logger.severe("Deprecated, now unreadable format of the " + FieldNames.LEADERBOARD_COMPETITOR_DISPLAY_NAMES.name() + " field for leaderboard " + dbLeaderboard.get((Object)FieldNames.LEADERBOARD_NAME.name()) + ". You will have to update the competitor display names manually: " + competitorDisplayNames);
            }
        }
    }

    private Map<String, RaceIdentifier> loadRaceIdentifiers(Document dbRaceColumn) {
        Document raceIdentifiersPerFleet;
        HashMap<String, RaceIdentifier> result = new HashMap<String, RaceIdentifier>();
        RaceIdentifier singleLegacyRaceIdentifier = this.loadRaceIdentifier(dbRaceColumn);
        if (singleLegacyRaceIdentifier != null) {
            result.put(null, singleLegacyRaceIdentifier);
        }
        if ((raceIdentifiersPerFleet = (Document)dbRaceColumn.get((Object)FieldNames.RACE_IDENTIFIERS.name())) != null) {
            for (String escapedFleetName : raceIdentifiersPerFleet.keySet()) {
                String fleetName = MongoUtils.unescapeDollarAndDot(escapedFleetName);
                result.put(fleetName, this.loadRaceIdentifier((Document)raceIdentifiersPerFleet.get((Object)escapedFleetName)));
            }
        }
        return result;
    }

    @Override
    public LeaderboardGroup loadLeaderboardGroup(String name, RegattaRegistry regattaRegistry, LeaderboardRegistry leaderboardRegistry) {
        MongoCollection leaderboardGroupCollection = this.database.getCollection(CollectionNames.LEADERBOARD_GROUPS.name());
        LeaderboardGroup leaderboardGroup = null;
        try {
            Document query = new Document();
            query.put(FieldNames.LEADERBOARD_GROUP_NAME.name(), (Object)name);
            leaderboardGroup = this.loadLeaderboardGroup((Document)leaderboardGroupCollection.find((Bson)query).first(), regattaRegistry, leaderboardRegistry);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load leaderboard group " + name + ".");
            logger.log(Level.SEVERE, "loadLeaderboardGroup", e);
        }
        return leaderboardGroup;
    }

    @Override
    public Iterable<LeaderboardGroup> getAllLeaderboardGroups(RegattaRegistry regattaRegistry, LeaderboardRegistry leaderboardRegistry) {
        MongoCollection leaderboardGroupCollection = this.database.getCollection(CollectionNames.LEADERBOARD_GROUPS.name());
        HashSet<LeaderboardGroup> leaderboardGroups = new HashSet<LeaderboardGroup>();
        try {
            for (Document o : leaderboardGroupCollection.find()) {
                boolean hasUUID = o.containsKey((Object)FieldNames.LEADERBOARD_GROUP_UUID.name());
                LeaderboardGroup leaderboardGroup = this.loadLeaderboardGroup(o, regattaRegistry, leaderboardRegistry);
                leaderboardGroups.add(leaderboardGroup);
                if (hasUUID) continue;
                logger.info("Existing LeaderboardGroup " + leaderboardGroup.getName() + " received a UUID during migration; updating the leaderboard group in the database");
                new MongoObjectFactoryImpl(this.database).storeLeaderboardGroup(leaderboardGroup);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load leaderboard groups.");
            logger.log(Level.SEVERE, "loadLeaderboardGroup", e);
        }
        return leaderboardGroups;
    }

    private LeaderboardGroup loadLeaderboardGroup(Document o, RegattaRegistry regattaRegistry, LeaderboardRegistry leaderboardRegistry) {
        Document dbOverallLeaderboard;
        MongoCollection leaderboardCollection = this.database.getCollection(CollectionNames.LEADERBOARDS.name());
        String name = (String)o.get((Object)FieldNames.LEADERBOARD_GROUP_NAME.name());
        UUID uuid = (UUID)o.get((Object)FieldNames.LEADERBOARD_GROUP_UUID.name());
        if (uuid == null) {
            uuid = UUID.randomUUID();
            logger.info("Leaderboard group " + name + " receives UUID " + uuid + " in a migration effort");
        }
        String description = (String)o.get((Object)FieldNames.LEADERBOARD_GROUP_DESCRIPTION.name());
        String displayName = (String)o.get((Object)FieldNames.LEADERBOARD_GROUP_DISPLAY_NAME.name());
        boolean displayGroupsInReverseOrder = false;
        Object displayGroupsInReverseOrderObj = o.get((Object)FieldNames.LEADERBOARD_GROUP_DISPLAY_IN_REVERSE_ORDER.name());
        if (displayGroupsInReverseOrderObj != null) {
            displayGroupsInReverseOrder = (Boolean)displayGroupsInReverseOrderObj;
        }
        ArrayList<Leaderboard> leaderboards = new ArrayList<Leaderboard>();
        Iterable dbLeaderboardIds = (Iterable)o.get((Object)FieldNames.LEADERBOARD_GROUP_LEADERBOARDS.name());
        for (Object object : dbLeaderboardIds) {
            ObjectId dbLeaderboardId = (ObjectId)object;
            Document dbLeaderboard = (Document)leaderboardCollection.find(Filters.eq((String)"_id", (Object)dbLeaderboardId)).first();
            if (dbLeaderboard != null) {
                Leaderboard loadedLeaderboard = this.loadLeaderboard(dbLeaderboard, regattaRegistry, leaderboardRegistry, null);
                if (loadedLeaderboard == null) continue;
                leaderboards.add(loadedLeaderboard);
                continue;
            }
            logger.warning("couldn't find leaderboard with ID " + dbLeaderboardId + " referenced by leaderboard group " + name);
        }
        logger.info("loaded leaderboard group " + name);
        LeaderboardGroupImpl result = new LeaderboardGroupImpl(uuid, name, description, displayName, displayGroupsInReverseOrder, leaderboards);
        Object overallLeaderboardIdOrName = o.get((Object)FieldNames.LEADERBOARD_GROUP_OVERALL_LEADERBOARD.name());
        if (overallLeaderboardIdOrName != null && (dbOverallLeaderboard = overallLeaderboardIdOrName instanceof ObjectId ? (Document)leaderboardCollection.find(Filters.eq((String)"_id", (Object)overallLeaderboardIdOrName)).first() : (Document)overallLeaderboardIdOrName) != null) {
            this.loadLeaderboard(dbOverallLeaderboard, regattaRegistry, leaderboardRegistry, (LeaderboardGroup)result);
        }
        return result;
    }

    @Override
    public Iterable<Leaderboard> getLeaderboardsNotInGroup(RegattaRegistry regattaRegistry, LeaderboardRegistry leaderboardRegistry) {
        MongoCollection leaderboardCollection = this.database.getCollection(CollectionNames.LEADERBOARDS.name());
        HashSet<Leaderboard> result = new HashSet<Leaderboard>();
        try {
            FindIterable allLeaderboards = leaderboardCollection.find();
            for (Document leaderboardFromDB : allLeaderboards) {
                Leaderboard loadedLeaderboard;
                boolean inLeaderboardGroupOverallName;
                Document inLeaderboardGroupsQuery = new Document();
                inLeaderboardGroupsQuery.put(FieldNames.LEADERBOARD_GROUP_LEADERBOARDS.name(), (Object)((ObjectId)leaderboardFromDB.get((Object)"_id")).toString());
                boolean inLeaderboardGroups = this.database.getCollection(CollectionNames.LEADERBOARD_GROUPS.name()).find((Bson)inLeaderboardGroupsQuery).first() != null;
                Document inLeaderboardGroupOverallQuery = new Document();
                inLeaderboardGroupOverallQuery.put(FieldNames.LEADERBOARD_GROUP_OVERALL_LEADERBOARD.name(), (Object)((ObjectId)leaderboardFromDB.get((Object)"_id")).toString());
                boolean inLeaderboardGroupOverall = this.database.getCollection(CollectionNames.LEADERBOARD_GROUPS.name()).find((Bson)inLeaderboardGroupOverallQuery).first() != null;
                Document inLeaderboardGroupOverallQueryName = new Document();
                inLeaderboardGroupOverallQueryName.put(FieldNames.LEADERBOARD_GROUP_OVERALL_LEADERBOARD.name(), leaderboardFromDB.get((Object)FieldNames.LEADERBOARD_NAME.name()));
                boolean bl = inLeaderboardGroupOverallName = this.database.getCollection(CollectionNames.LEADERBOARD_GROUPS.name()).find((Bson)inLeaderboardGroupOverallQueryName).first() != null;
                if (inLeaderboardGroups || inLeaderboardGroupOverall || inLeaderboardGroupOverallName || (loadedLeaderboard = this.loadLeaderboard(leaderboardFromDB, regattaRegistry, leaderboardRegistry, null)) == null) continue;
                result.add(loadedLeaderboard);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load leaderboards.");
            logger.log(Level.SEVERE, "getAllLeaderboards", e);
        }
        return result;
    }

    @Override
    public WindTrack loadWindTrack(String regattaName, RaceDefinition race, WindSource windSource, long millisecondsOverWhichToAverage) {
        Map<WindSource, WindTrack> resultMap = this.loadWindTracks(regattaName, race, windSource, millisecondsOverWhichToAverage);
        Object result = resultMap.containsKey(windSource) ? resultMap.get(windSource) : new WindTrackImpl(millisecondsOverWhichToAverage, windSource.getType().getBaseConfidence(), windSource.getType().useSpeed(), String.valueOf(WindTrackImpl.class.getSimpleName()) + " for source " + windSource.toString());
        return result;
    }

    @Override
    public Map<? extends WindSource, ? extends WindTrack> loadWindTracks(String regattaName, RaceDefinition race, long millisecondsOverWhichToAverageWind) {
        Map<WindSource, WindTrack> result = this.loadWindTracks(regattaName, race, null, millisecondsOverWhichToAverageWind);
        return result;
    }

    private Map<WindSource, WindTrack> loadWindTracks(String regattaName, RaceDefinition race, WindSource constrainToWindSource, long millisecondsOverWhichToAverageWind) {
        HashMap<WindSource, WindTrack> result = new HashMap<WindSource, WindTrack>();
        try {
            FindIterable windFixesFoundByName;
            MongoCollection windTracks = this.database.getCollection(CollectionNames.WIND_TRACKS.name());
            DomainObjectFactoryImpl.ensureIndicesOnWindTracks((MongoCollection<Document>)windTracks);
            Document queryById = new Document();
            queryById.put(FieldNames.RACE_ID.name(), (Object)race.getId());
            if (constrainToWindSource != null) {
                queryById.put(FieldNames.WIND_SOURCE_NAME.name(), (Object)constrainToWindSource.name());
            }
            for (Document dbWind : windTracks.find((Bson)queryById)) {
                this.loadWindFix(result, dbWind, millisecondsOverWhichToAverageWind);
            }
            Document queryByName = new Document();
            queryByName.put(FieldNames.EVENT_NAME.name(), (Object)regattaName);
            queryByName.put(FieldNames.RACE_NAME.name(), (Object)race.getName());
            if (constrainToWindSource != null) {
                queryByName.put(FieldNames.WIND_SOURCE_NAME.name(), (Object)constrainToWindSource.name());
            }
            if ((windFixesFoundByName = windTracks.find((Bson)queryByName).batchSize(100000)).iterator().hasNext()) {
                ArrayList<Document> windFixesToMigrate = new ArrayList<Document>();
                for (Document dbWind : windFixesFoundByName) {
                    Util.Pair<Wind, WindSource> wind = this.loadWindFix(result, dbWind, millisecondsOverWhichToAverageWind);
                    windFixesToMigrate.add(new MongoObjectFactoryImpl(this.database).storeWindTrackEntry(race, regattaName, (WindSource)wind.getB(), (Wind)wind.getA()));
                }
                long size = windTracks.countDocuments((Bson)queryByName);
                logger.info("Migrating " + size + " wind fixes of regatta " + regattaName + " and race " + race.getName() + " to ID-based keys");
                windTracks.insertMany(windFixesToMigrate);
                logger.info("Removing " + size + " wind fixes that were keyed by the names of regatta " + regattaName + " and race " + race.getName());
                windTracks.deleteMany((Bson)queryByName);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load recorded wind data. Check MongoDB settings.");
            logger.log(Level.SEVERE, "loadWindTrack", e);
        }
        return result;
    }

    private Util.Pair<Wind, WindSource> loadWindFix(Map<WindSource, WindTrack> result, Document dbWind, long millisecondsOverWhichToAverageWind) {
        Wind wind = this.loadWind((Document)dbWind.get((Object)FieldNames.WIND.name()));
        WindSourceType windSourceType = WindSourceType.valueOf((String)((String)dbWind.get((Object)FieldNames.WIND_SOURCE_NAME.name())));
        Object windSource = dbWind.containsKey((Object)FieldNames.WIND_SOURCE_ID.name()) ? new WindSourceWithAdditionalID(windSourceType, (String)dbWind.get((Object)FieldNames.WIND_SOURCE_ID.name())) : new WindSourceImpl(windSourceType);
        WindTrack track = result.get(windSource);
        if (track == null) {
            track = new WindTrackImpl(millisecondsOverWhichToAverageWind, windSource.getType().getBaseConfidence(), windSource.getType().useSpeed(), String.valueOf(WindTrackImpl.class.getSimpleName()) + " for source " + windSource.toString());
            result.put((WindSource)windSource, track);
        }
        track.add((Timed)wind);
        return new Util.Pair((Object)wind, windSource);
    }

    @Override
    public void loadLeaderboardGroupLinksForEvents(EventResolver eventResolver, LeaderboardGroupResolver leaderboardGroupResolver) {
        MongoCollection links = this.database.getCollection(CollectionNames.LEADERBOARD_GROUP_LINKS_FOR_EVENTS.name());
        for (Object o : links.find()) {
            Document dbLink = (Document)o;
            UUID eventId = (UUID)dbLink.get((Object)FieldNames.EVENT_ID.name());
            Event event = eventResolver.getEvent((Serializable)eventId);
            if (event == null) {
                logger.info("Found leaderboard group IDs for event with ID " + eventId + " but couldn't find that event.");
                continue;
            }
            List leaderboardGroupIDs = (List)dbLink.get((Object)FieldNames.LEADERBOARD_GROUP_UUID.name());
            for (UUID leaderboardGroupID : leaderboardGroupIDs) {
                LeaderboardGroup leaderboardGroup = leaderboardGroupResolver.getLeaderboardGroupByID(leaderboardGroupID);
                if (leaderboardGroup == null) continue;
                event.addLeaderboardGroup(leaderboardGroup);
            }
        }
    }

    @Override
    public Event loadEvent(String name) {
        Document query = new Document();
        query.put(FieldNames.EVENT_NAME.name(), (Object)name);
        MongoCollection eventCollection = this.database.getCollection(CollectionNames.EVENTS.name());
        Document eventDBObject = (Document)eventCollection.find((Bson)query).first();
        Event result = eventDBObject != null ? this.loadEvent(eventDBObject) : null;
        return result;
    }

    @Override
    public Iterable<Util.Pair<Event, Boolean>> loadAllEvents() {
        ArrayList<Util.Pair<Event, Boolean>> result = new ArrayList<Util.Pair<Event, Boolean>>();
        MongoCollection eventCollection = this.database.getCollection(CollectionNames.EVENTS.name());
        try {
            for (Document object : eventCollection.find()) {
                Event event = this.loadEvent(object);
                boolean requiresStoreAfterMigration = this.loadLegacyImageAndVideoURLs(event, object);
                result.add((Util.Pair<Event, Boolean>)new Util.Pair((Object)event, (Object)(requiresStoreAfterMigration |= this.loadLegacySailorsInfoWebsiteURL(event, object))));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load events.");
            logger.log(Level.SEVERE, "loadAllEvents", e);
        }
        return result;
    }

    @Override
    public SailingServerConfiguration loadServerConfiguration() {
        MongoCollection serverCollection = this.database.getCollection(CollectionNames.SERVER_CONFIGURATION.name());
        Document theServer = (Document)serverCollection.find().first();
        Object result = theServer != null ? this.loadServerConfiguration(theServer) : new SailingServerConfigurationImpl(false);
        return result;
    }

    private SailingServerConfiguration loadServerConfiguration(Document serverDBObject) {
        boolean isStandaloneServer = (Boolean)serverDBObject.get((Object)FieldNames.SERVER_IS_STANDALONE.name());
        return new SailingServerConfigurationImpl(isStandaloneServer);
    }

    private RemoteSailingServerReference loadRemoteSailingSever(Document serverDBObject) {
        RemoteSailingServerReferenceImpl result = null;
        String name = (String)serverDBObject.get((Object)FieldNames.SERVER_NAME.name());
        Boolean include = (Boolean)serverDBObject.get((Object)FieldNames.INCLUDE.name());
        List selectedEventIds = (List)serverDBObject.get((Object)FieldNames.SELECTED_EVENT_IDS.name());
        String urlAsString = (String)serverDBObject.get((Object)FieldNames.SERVER_URL.name());
        try {
            URL serverUrl = new URL(urlAsString);
            result = new RemoteSailingServerReferenceImpl(name, serverUrl, include == null ? false : include, selectedEventIds == null ? Collections.emptySet() : selectedEventIds);
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, "Can't load the sailing server with URL " + urlAsString, e);
        }
        return result;
    }

    @Override
    public Iterable<RemoteSailingServerReference> loadAllRemoteSailingServerReferences() {
        ArrayList<RemoteSailingServerReference> result = new ArrayList<RemoteSailingServerReference>();
        MongoCollection serverCollection = this.database.getCollection(CollectionNames.SAILING_SERVERS.name());
        try {
            for (Document o : serverCollection.find()) {
                if (this.loadRemoteSailingSever(o) == null) continue;
                result.add(this.loadRemoteSailingSever(o));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load sailing server instances URLs.");
            logger.log(Level.SEVERE, "loadAllSailingServers", e);
        }
        return result;
    }

    private Event loadEvent(Document eventDBObject) {
        Iterable sailorsInfoWebsiteURLs;
        Iterable videos;
        Iterable images;
        String baseURLAsString;
        String officialWebSiteURLAsString;
        String name = (String)eventDBObject.get((Object)FieldNames.EVENT_NAME.name());
        String description = (String)eventDBObject.get((Object)FieldNames.EVENT_DESCRIPTION.name());
        UUID id = (UUID)eventDBObject.get((Object)FieldNames.EVENT_ID.name());
        TimePoint startDate = DomainObjectFactoryImpl.loadTimePoint(eventDBObject, FieldNames.EVENT_START_DATE);
        TimePoint endDate = DomainObjectFactoryImpl.loadTimePoint(eventDBObject, FieldNames.EVENT_END_DATE);
        if (endDate != null && startDate != null && endDate.before(startDate)) {
            logger.warning("End date " + endDate + " of event " + name + " with ID " + id + " is before its start date " + startDate + "; adjusting such that end date equals start date.");
            endDate = startDate;
        }
        boolean isPublic = eventDBObject.get((Object)FieldNames.EVENT_IS_PUBLIC.name()) != null ? (Boolean)eventDBObject.get((Object)FieldNames.EVENT_IS_PUBLIC.name()) : false;
        Venue venue = this.loadVenue((Document)eventDBObject.get((Object)FieldNames.VENUE.name()));
        EventImpl result = new EventImpl(name, startDate, endDate, venue, isPublic, id);
        result.setDescription(description);
        List windFinderReviewedSpotCollectionIds = (List)eventDBObject.get((Object)FieldNames.EVENT_WINDFINDER_SPOT_COLLECTION_IDS.name());
        if (windFinderReviewedSpotCollectionIds != null) {
            result.setWindFinderReviewedSpotsCollection((Iterable)windFinderReviewedSpotCollectionIds);
        }
        if ((officialWebSiteURLAsString = (String)eventDBObject.get((Object)FieldNames.EVENT_OFFICIAL_WEBSITE_URL.name())) != null) {
            try {
                result.setOfficialWebsiteURL(new URL(officialWebSiteURLAsString));
            }
            catch (MalformedURLException e) {
                logger.severe("Error parsing official website URL " + officialWebSiteURLAsString + " for event " + name + ". Ignoring this URL.");
            }
        }
        if ((baseURLAsString = (String)eventDBObject.get((Object)FieldNames.EVENT_BASE_URL.name())) != null) {
            try {
                result.setBaseURL(new URL(baseURLAsString));
            }
            catch (MalformedURLException e) {
                logger.severe("Error parsing base URL " + baseURLAsString + " for event " + name + ". Ignoring this URL.");
            }
        }
        if ((images = (Iterable)eventDBObject.get((Object)FieldNames.EVENT_IMAGES.name())) != null) {
            for (Object imageObject : images) {
                ImageDescriptor image = this.loadImage((Document)imageObject);
                if (image == null) continue;
                result.addImage(image);
            }
        }
        if ((videos = (Iterable)eventDBObject.get((Object)FieldNames.EVENT_VIDEOS.name())) != null) {
            for (Object videoObject : videos) {
                VideoDescriptor video = this.loadVideo((Document)videoObject);
                if (video == null) continue;
                result.addVideo(video);
            }
        }
        if ((sailorsInfoWebsiteURLs = (Iterable)eventDBObject.get((Object)FieldNames.EVENT_SAILORS_INFO_WEBSITES.name())) != null) {
            for (Object sailorsInfoWebsiteObject : sailorsInfoWebsiteURLs) {
                Document sailorsInfoWebsiteDBObject = (Document)sailorsInfoWebsiteObject;
                URL url = this.loadURL(sailorsInfoWebsiteDBObject, FieldNames.SAILORS_INFO_URL);
                String localeRaw = (String)sailorsInfoWebsiteDBObject.get((Object)FieldNames.SAILORS_INFO_LOCALE.name());
                if (url == null) continue;
                Locale locale = localeRaw != null ? Locale.forLanguageTag(localeRaw) : null;
                result.setSailorsInfoWebsiteURL(locale, url);
            }
        }
        return result;
    }

    private Venue loadVenue(Document dbObject) {
        String name = (String)dbObject.get((Object)FieldNames.VENUE_NAME.name());
        Iterable dbCourseAreas = (Iterable)dbObject.get((Object)FieldNames.COURSE_AREAS.name());
        VenueImpl result = new VenueImpl(name);
        for (Object courseAreaDBObject : dbCourseAreas) {
            CourseArea courseArea = this.loadCourseArea((Document)courseAreaDBObject);
            result.addCourseArea(courseArea);
        }
        return result;
    }

    private CourseArea loadCourseArea(Document courseAreaDBObject) {
        String name = (String)courseAreaDBObject.get((Object)FieldNames.COURSE_AREA_NAME.name());
        UUID id = (UUID)courseAreaDBObject.get((Object)FieldNames.COURSE_AREA_ID.name());
        Document centerPositionDoc = (Document)courseAreaDBObject.get((Object)FieldNames.COURSE_AREA_CENTER_POSITION.name());
        Position centerPosition = centerPositionDoc != null ? com.sap.sailing.shared.persistence.impl.DomainObjectFactoryImpl.loadPosition((Document)centerPositionDoc) : null;
        Number radiusNumber = (Number)courseAreaDBObject.get((Object)FieldNames.COURSE_AREA_RADIUS_IN_METERS.name());
        MeterDistance radius = radiusNumber != null ? new MeterDistance(radiusNumber.doubleValue()) : null;
        CourseArea result = this.baseDomainFactory.getOrCreateCourseArea(id, name, centerPosition, (Distance)radius);
        return result;
    }

    @Override
    public Iterable<Regatta> loadAllRegattas(TrackedRegattaRegistry trackedRegattaRegistry) {
        ArrayList<Regatta> result = new ArrayList<Regatta>();
        MongoCollection regattaCollection = this.database.getCollection(CollectionNames.REGATTAS.name());
        for (Document dbRegatta : regattaCollection.find()) {
            result.add(this.loadRegatta(dbRegatta, trackedRegattaRegistry));
        }
        return result;
    }

    @Override
    public Regatta loadRegatta(String name, TrackedRegattaRegistry trackedRegattaRegistry) {
        Document query = new Document(FieldNames.REGATTA_NAME.name(), (Object)name);
        MongoCollection regattaCollection = this.database.getCollection(CollectionNames.REGATTAS.name());
        Document dbRegatta = (Document)regattaCollection.find((Bson)query).first();
        Regatta result = this.loadRegatta(dbRegatta, trackedRegattaRegistry);
        assert (result == null || result.getName().equals(name));
        return result;
    }

    private Regatta loadRegatta(Document dbRegatta, TrackedRegattaRegistry trackedRegattaRegistry) {
        RegattaImpl result = null;
        if (dbRegatta != null) {
            Number buoyZoneRadiusInHullLengthsAsNumber;
            String name = (String)dbRegatta.get((Object)FieldNames.REGATTA_NAME.name());
            String boatClassName = (String)dbRegatta.get((Object)FieldNames.BOAT_CLASS_NAME.name());
            TimePoint startDate = DomainObjectFactoryImpl.loadTimePoint(dbRegatta, FieldNames.REGATTA_START_DATE);
            TimePoint endDate = DomainObjectFactoryImpl.loadTimePoint(dbRegatta, FieldNames.REGATTA_END_DATE);
            Object id = (Serializable)dbRegatta.get((Object)FieldNames.REGATTA_ID.name());
            if (id == null) {
                id = name;
            }
            BoatClass boatClass = null;
            if (boatClassName != null) {
                boolean typicallyStartsUpwind = (Boolean)dbRegatta.get((Object)FieldNames.BOAT_CLASS_TYPICALLY_STARTS_UPWIND.name());
                boatClass = this.baseDomainFactory.getOrCreateBoatClass(boatClassName, typicallyStartsUpwind);
            }
            Iterable dbSeries = (Iterable)dbRegatta.get((Object)FieldNames.REGATTA_SERIES.name());
            Iterable<Series> series = this.loadSeries(dbSeries, trackedRegattaRegistry);
            Iterable<CourseArea> courseAreas = this.loadCourseAreas(dbRegatta);
            RegattaConfiguration configuration = null;
            if (dbRegatta.containsKey((Object)FieldNames.REGATTA_REGATTA_CONFIGURATION.name())) {
                JsonWriterSettings writerSettings = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build();
                try {
                    JSONObject json = Helpers.toJSONObjectSafe((Object)new JSONParser().parse(((Document)dbRegatta.get((Object)FieldNames.REGATTA_REGATTA_CONFIGURATION.name())).toJson(writerSettings)));
                    configuration = RegattaConfigurationJsonDeserializer.create().deserialize(json);
                }
                catch (JsonDeserializationException | ParseException e) {
                    logger.log(Level.WARNING, "Error loading racing procedure configration for regatta.", e);
                }
            }
            Double buoyZoneRadiusInHullLengths = (buoyZoneRadiusInHullLengthsAsNumber = (Number)dbRegatta.get((Object)FieldNames.REGATTA_BUOY_ZONE_RADIUS_IN_HULL_LENGTHS.name())) == null ? null : Double.valueOf(buoyZoneRadiusInHullLengthsAsNumber.doubleValue());
            Boolean useStartTimeInference = (Boolean)dbRegatta.get((Object)FieldNames.REGATTA_USE_START_TIME_INFERENCE.name());
            Boolean controlTrackingFromStartAndFinishTimes = (Boolean)dbRegatta.get((Object)FieldNames.REGATTA_CONTROL_TRACKING_FROM_START_AND_FINISH_TIMES.name());
            Boolean autoRestartTrackingUponCompetitorSetChange = (Boolean)dbRegatta.get((Object)FieldNames.REGATTA_AUTO_RESTART_TRACKING_UPON_COMPETITOR_SET_CHANGE.name());
            Boolean canBoatsOfCompetitorsChangePerRace = (Boolean)dbRegatta.get((Object)FieldNames.REGATTA_CAN_BOATS_OF_COMPETITORS_CHANGE_PER_RACE.name());
            boolean createMigratableRegatta = false;
            if (canBoatsOfCompetitorsChangePerRace == null) {
                canBoatsOfCompetitorsChangePerRace = false;
                createMigratableRegatta = true;
            }
            CompetitorRegistrationType competitorRegistrationType = CompetitorRegistrationType.valueOfOrDefault((String)((String)dbRegatta.get((Object)FieldNames.REGATTA_COMPETITOR_REGISTRATION_TYPE.name())));
            RankingMetricConstructor rankingMetricConstructor = this.loadRankingMetricConstructor(dbRegatta);
            String registrationLinkSecret = (String)dbRegatta.get((Object)FieldNames.REGATTA_REGISTRATION_LINK_SECRET.name());
            result = createMigratableRegatta ? new MigratableRegattaImpl(this.getRaceLogStore(), this.getRegattaLogStore(), name, boatClass, canBoatsOfCompetitorsChangePerRace, competitorRegistrationType, startDate, endDate, series, true, this.loadScoringScheme(dbRegatta), (Serializable)id, courseAreas, buoyZoneRadiusInHullLengths == null ? 3.0 : buoyZoneRadiusInHullLengths, useStartTimeInference == null ? true : useStartTimeInference, controlTrackingFromStartAndFinishTimes == null ? false : controlTrackingFromStartAndFinishTimes, autoRestartTrackingUponCompetitorSetChange == null ? false : autoRestartTrackingUponCompetitorSetChange, rankingMetricConstructor, new MongoObjectFactoryImpl(this.database), registrationLinkSecret) : new RegattaImpl(this.getRaceLogStore(), this.getRegattaLogStore(), name, boatClass, canBoatsOfCompetitorsChangePerRace.booleanValue(), competitorRegistrationType, startDate, endDate, series, true, this.loadScoringScheme(dbRegatta), (Serializable)id, courseAreas, Double.valueOf(buoyZoneRadiusInHullLengths == null ? 3.0 : buoyZoneRadiusInHullLengths), useStartTimeInference == null ? true : useStartTimeInference, controlTrackingFromStartAndFinishTimes == null ? false : controlTrackingFromStartAndFinishTimes, autoRestartTrackingUponCompetitorSetChange == null ? false : autoRestartTrackingUponCompetitorSetChange, rankingMetricConstructor, registrationLinkSecret);
            result.setRegattaConfiguration(configuration);
        }
        if (result.getRegistrationLinkSecret() == null) {
            logger.info("Added missing RegistrationLinkSecret to " + result + " and stored to database");
            result.setRegistrationLinkSecret(UUID.randomUUID().toString());
            new MongoObjectFactoryImpl(this.database).storeRegatta((Regatta)result);
        }
        return result;
    }

    private RankingMetricConstructor loadRankingMetricConstructor(Document dbRegatta) {
        RankingMetricConstructor result;
        Document rankingMetricJson = (Document)dbRegatta.get((Object)FieldNames.REGATTA_RANKING_METRIC.name());
        if (rankingMetricJson == null) {
            result = OneDesignRankingMetric::new;
        } else {
            String rankingMetricTypeName = (String)rankingMetricJson.get((Object)FieldNames.REGATTA_RANKING_METRIC_TYPE.name());
            result = RankingMetricsFactory.getRankingMetricConstructor((RankingMetrics)RankingMetrics.valueOf((String)rankingMetricTypeName));
        }
        return result;
    }

    private ScoringSchemeType getScoringSchemeType(Document dbObject) {
        ScoringSchemeType scoringSchemeType;
        String scoringSchemeTypeName = (String)dbObject.get((Object)FieldNames.SCORING_SCHEME_TYPE.name());
        if (scoringSchemeTypeName == null) {
            scoringSchemeType = ScoringSchemeType.LOW_POINT;
        } else {
            try {
                scoringSchemeType = ScoringSchemeType.valueOf((String)scoringSchemeTypeName);
            }
            catch (IllegalArgumentException ila) {
                scoringSchemeType = ScoringSchemeType.LOW_POINT;
                logger.warning("Could not find scoring scheme " + scoringSchemeTypeName + "! Most probably this has not yet been implemented or even been removed.");
            }
        }
        return scoringSchemeType;
    }

    private Iterable<Series> loadSeries(Iterable<Document> dbSeries, TrackedRegattaRegistry trackedRegattaRegistry) {
        ArrayList<Series> result = new ArrayList<Series>();
        for (Document oneDBSeries : dbSeries) {
            Series series = this.loadSeries(oneDBSeries, trackedRegattaRegistry);
            result.add(series);
        }
        return result;
    }

    private Series loadSeries(Document dbSeries, TrackedRegattaRegistry trackedRegattaRegistry) {
        Number maximumNumberOfDiscardsAsObject;
        String name = (String)dbSeries.get((Object)FieldNames.SERIES_NAME.name());
        boolean isMedal = (Boolean)dbSeries.get((Object)FieldNames.SERIES_IS_MEDAL.name());
        boolean isFleetsCanRunInParallel = true;
        Object isFleetCanRunInParallelObject = dbSeries.get((Object)FieldNames.SERIES_IS_FLEETS_CAN_RUN_IN_PARALLEL.name());
        if (isFleetCanRunInParallelObject != null) {
            isFleetsCanRunInParallel = (Boolean)dbSeries.get((Object)FieldNames.SERIES_IS_FLEETS_CAN_RUN_IN_PARALLEL.name());
        }
        Integer maximumNumberOfDiscards = (maximumNumberOfDiscardsAsObject = (Number)dbSeries.get((Object)FieldNames.SERIES_MAXIMUM_NUMBER_OF_DISCARDS.name())) == null ? null : Integer.valueOf(maximumNumberOfDiscardsAsObject.intValue());
        Boolean startsWithZeroScore = (Boolean)dbSeries.get((Object)FieldNames.SERIES_STARTS_WITH_ZERO_SCORE.name());
        Boolean hasSplitFleetContiguousScoring = (Boolean)dbSeries.get((Object)FieldNames.SERIES_HAS_SPLIT_FLEET_CONTIGUOUS_SCORING.name());
        Boolean hasCrossFleetMergedRankingObject = (Boolean)dbSeries.get((Object)FieldNames.SERIES_HAS_CROSS_FLEET_MERGED_RANKING.name());
        Boolean firstColumnIsNonDiscardableCarryForward = (Boolean)dbSeries.get((Object)FieldNames.SERIES_STARTS_WITH_NON_DISCARDABLE_CARRY_FORWARD.name());
        Boolean oneAlwaysStaysOne = (Boolean)dbSeries.get((Object)FieldNames.SERIES_ONE_ALWAYS_STAYS_ONE.name());
        Iterable dbFleets = (Iterable)dbSeries.get((Object)FieldNames.SERIES_FLEETS.name());
        List<Fleet> fleets = this.loadFleets(dbFleets);
        Iterable dbRaceColumns = (Iterable)dbSeries.get((Object)FieldNames.SERIES_RACE_COLUMNS.name());
        Iterable<String> raceColumnNames = this.loadRaceColumnNames(dbRaceColumns);
        SeriesImpl series = new SeriesImpl(name, isMedal, isFleetsCanRunInParallel, fleets, raceColumnNames, trackedRegattaRegistry);
        if (dbSeries.get((Object)FieldNames.SERIES_DISCARDING_THRESHOLDS.name()) != null) {
            ThresholdBasedResultDiscardingRule resultDiscardingRule = this.loadResultDiscardingRule(dbSeries, FieldNames.SERIES_DISCARDING_THRESHOLDS);
            series.setResultDiscardingRule(resultDiscardingRule);
        }
        if (startsWithZeroScore != null) {
            series.setStartsWithZeroScore(startsWithZeroScore.booleanValue());
        }
        if (hasSplitFleetContiguousScoring != null) {
            series.setSplitFleetContiguousScoring(hasSplitFleetContiguousScoring.booleanValue());
        }
        if (hasCrossFleetMergedRankingObject != null) {
            series.setCrossFleetMergedRanking(hasCrossFleetMergedRankingObject.booleanValue());
        }
        series.setMaximumNumberOfDiscards(maximumNumberOfDiscards);
        if (firstColumnIsNonDiscardableCarryForward != null) {
            series.setFirstColumnIsNonDiscardableCarryForward(firstColumnIsNonDiscardableCarryForward.booleanValue());
        }
        if (oneAlwaysStaysOne != null) {
            series.setOneAlwaysStaysOne(oneAlwaysStaysOne.booleanValue());
        }
        this.loadRaceColumnRaceLinks(dbRaceColumns, (Series)series);
        return series;
    }

    private Iterable<String> loadRaceColumnNames(Iterable<Document> dbRaceColumns) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<Document> iterator = dbRaceColumns.iterator();
        while (iterator.hasNext()) {
            Document o;
            Document dbRaceColumn = o = iterator.next();
            result.add((String)dbRaceColumn.get((Object)FieldNames.LEADERBOARD_COLUMN_NAME.name()));
        }
        return result;
    }

    private void loadRaceColumnRaceLinks(Iterable<Document> dbRaceColumns, Series series) {
        Iterator<Document> iterator = dbRaceColumns.iterator();
        while (iterator.hasNext()) {
            Document o;
            Document dbRaceColumn = o = iterator.next();
            String name = (String)dbRaceColumn.get((Object)FieldNames.LEADERBOARD_COLUMN_NAME.name());
            Map<String, RaceIdentifier> raceIdentifiersPerFleetName = this.loadRaceIdentifiers(dbRaceColumn);
            for (Map.Entry<String, RaceIdentifier> e : raceIdentifiersPerFleetName.entrySet()) {
                if (e.getKey() == null) {
                    logger.warning("Ignoring null fleet name while loading RaceColumn " + name);
                    continue;
                }
                series.getRaceColumnByName(name).setRaceIdentifier(series.getFleetByName(e.getKey()), e.getValue());
            }
        }
    }

    private List<Fleet> loadFleets(Iterable<Document> dbFleets) {
        ArrayList<Fleet> result = new ArrayList<Fleet>();
        for (Document dbFleet : dbFleets) {
            Fleet fleet = this.loadFleet(dbFleet);
            result.add(fleet);
        }
        return result;
    }

    private Fleet loadFleet(Document dbFleet) {
        Number colorAsNumber;
        Integer ordering;
        String name = (String)dbFleet.get((Object)FieldNames.FLEET_NAME.name());
        Number orderingAsNumber = (Number)dbFleet.get((Object)FieldNames.FLEET_ORDERING.name());
        Integer n = ordering = orderingAsNumber == null ? null : Integer.valueOf(orderingAsNumber.intValue());
        if (ordering == null) {
            ordering = 0;
        }
        Integer colorAsInt = (colorAsNumber = (Number)dbFleet.get((Object)FieldNames.FLEET_COLOR.name())) == null ? null : Integer.valueOf(colorAsNumber.intValue());
        RGBColor color = null;
        if (colorAsInt != null) {
            int r = colorAsInt % 256;
            int g = colorAsInt / 256 % 256;
            int b = colorAsInt / 256 / 256 % 256;
            color = new RGBColor(r, g, b);
        }
        FleetImpl result = new FleetImpl(name, ordering.intValue(), color);
        return result;
    }

    @Override
    public Map<String, Regatta> loadRaceIDToRegattaAssociations(RegattaRegistry regattaRegistry) {
        MongoCollection raceIDToRegattaCollection = this.database.getCollection(CollectionNames.REGATTA_FOR_RACE_ID.name());
        HashMap<String, Regatta> result = new HashMap<String, Regatta>();
        for (Document o : raceIDToRegattaCollection.find()) {
            Regatta regatta = regattaRegistry.getRegattaByName((String)o.get((Object)FieldNames.REGATTA_NAME.name()));
            if (regatta != null) {
                result.put((String)o.get((Object)FieldNames.RACE_ID_AS_STRING.name()), regatta);
                continue;
            }
            logger.warning("Couldn't find regatta " + o.get((Object)FieldNames.REGATTA_NAME.name()) + ". Cannot restore race associations with this regatta.");
        }
        return result;
    }

    @Override
    public RaceLog loadRaceLog(RaceLogIdentifier identifier) {
        RaceLogImpl result = new RaceLogImpl(RaceLogImpl.class.getSimpleName(), (Serializable)identifier.getIdentifier());
        try {
            Document query = new Document();
            query.put(FieldNames.RACE_LOG_IDENTIFIER.name(), (Object)TripleSerializer.serialize((Util.Triple<String, String, String>)identifier.getIdentifier()));
            this.loadRaceLogEvents((RaceLog)result, query);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load recorded race log data. Check MongoDB settings.");
            logger.log(Level.SEVERE, "loadRaceLog", t);
        }
        return result;
    }

    private List<RaceLogEvent> loadRaceLogEvents(RaceLog targetRaceLog, Document query) throws JsonDeserializationException, ParseException {
        ArrayList<RaceLogEvent> result = new ArrayList<RaceLogEvent>();
        MongoCollection raceLog = this.database.getCollection(CollectionNames.RACE_LOGS.name());
        for (Document o : raceLog.find((Bson)query)) {
            try {
                Util.Pair<RaceLogEvent, Optional<Document>> raceLogEventAndOptionalUpdateInstructions = this.loadRaceLogEvent((Document)o.get((Object)FieldNames.RACE_LOG_EVENT.name()));
                RaceLogEvent raceLogEvent = (RaceLogEvent)raceLogEventAndOptionalUpdateInstructions.getA();
                if (raceLogEvent != null) {
                    targetRaceLog.load((AbstractLogEvent)raceLogEvent);
                    result.add(raceLogEvent);
                }
                ((Optional)raceLogEventAndOptionalUpdateInstructions.getB()).ifPresent(dbObjectForUpdate -> {
                    Document q = new Document("_id", o.get((Object)"_id"));
                    o.put(FieldNames.RACE_LOG_EVENT.name(), dbObjectForUpdate);
                    raceLog.replaceOne((Bson)q, (Object)o);
                });
            }
            catch (IllegalStateException e) {
                logger.log(Level.SEVERE, "Couldn't load race log event " + o + ": " + e.getMessage(), e);
            }
        }
        return result;
    }

    public Util.Pair<RaceLogEvent, Optional<Document>> loadRaceLogEvent(Document dbObject) throws JsonDeserializationException, ParseException {
        RaceLogStartTimeEvent resultEvent;
        TimePoint logicalTimePoint = this.loadTimePoint(dbObject);
        TimePoint createdAt = DomainObjectFactoryImpl.loadTimePoint(dbObject, FieldNames.RACE_LOG_EVENT_CREATED_AT);
        Serializable id = (Serializable)dbObject.get((Object)FieldNames.RACE_LOG_EVENT_ID.name());
        Integer passId = (Integer)dbObject.get((Object)FieldNames.RACE_LOG_EVENT_PASS_ID.name());
        Iterable dbCompetitors = (Iterable)dbObject.get((Object)FieldNames.RACE_LOG_EVENT_INVOLVED_BOATS.name());
        List<Competitor> competitors = this.loadCompetitorsForRaceLogEvent(dbCompetitors);
        String authorName = (String)dbObject.get((Object)FieldNames.RACE_LOG_EVENT_AUTHOR_NAME.name());
        Number authorPriority = (Number)dbObject.get((Object)FieldNames.RACE_LOG_EVENT_AUTHOR_PRIORITY.name());
        Object author = authorName != null && authorPriority != null ? new LogEventAuthorImpl(authorName, authorPriority.intValue()) : LogEventAuthorImpl.createCompatibilityAuthor();
        String eventClass = (String)dbObject.get((Object)FieldNames.RACE_LOG_EVENT_CLASS.name());
        Optional dbObjectForUpdate = Optional.empty();
        if (eventClass.equals(RaceLogStartTimeEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogStartTimeEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogStartOfTrackingEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogStartOfTrackingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogEndOfTrackingEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogEndOfTrackingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogDependentStartTimeEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogDependentStartTimeEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogRaceStatusEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogRaceStatusEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogFlagEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogFlagEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogPassChangeEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogPassChangeEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors);
        } else if (eventClass.equals(RaceLogCourseDesignChangedEvent.class.getSimpleName())) {
            Util.Pair<RaceLogCourseDesignChangedEvent, Optional<Document>> resultPair = this.loadRaceLogCourseDesignChangedEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
            resultEvent = (RaceLogEvent)resultPair.getA();
            dbObjectForUpdate = (Optional)resultPair.getB();
        } else if (eventClass.equals(RaceLogFinishPositioningListChangedEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogFinishPositioningListChangedEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogFinishPositioningConfirmedEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogFinishPositioningConfirmedEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogPathfinderEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogPathfinderEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogGateLineOpeningTimeEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogGateLineOpeningTimeEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogStartProcedureChangedEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogStartProcedureChangedEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogProtestStartTimeEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogProtestStartTimeEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogWindFixEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogWindFixEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogDenoteForTrackingEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogDenoteForTrackingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogStartTrackingEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogStartTrackingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogRevokeEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogRevokeEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogRegisterCompetitorEvent.class.getSimpleName())) {
            Util.Pair<RaceLogEvent, Optional<Document>> resultPair = this.loadRaceLogRegisterCompetitorEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
            resultEvent = (RaceLogEvent)resultPair.getA();
            dbObjectForUpdate = (Optional)resultPair.getB();
        } else if (eventClass.equals(RaceLogAdditionalScoringInformationEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogAdditionalScoringInformationEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogFixedMarkPassingEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogFixedMarkPassingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogSuppressedMarkPassingsEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogSuppressedMarkPassingsEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogUseCompetitorsFromRaceLogEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogUseCompetitorsFromRaceLogEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogTagEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogTagEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, dbObject);
        } else if (eventClass.equals(RaceLogORCLegDataEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogORCLegDataEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, dbObject);
        } else if (eventClass.equals(RaceLogORCCertificateAssignmentEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogORCCertificateAssignmentEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, dbObject);
        } else if (eventClass.equals(RaceLogORCScratchBoatEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogORCScratchBoatEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogORCImpliedWindSourceEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogORCSetImpliedWindEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogResultsAreOfficialEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogResultsAreOfficialEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, passId, competitors, dbObject);
        } else if (eventClass.equals(RaceLogExcludeWindSourcesEvent.class.getSimpleName())) {
            resultEvent = this.loadRaceLogExcludeWindSourceEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, passId, passId, dbObject);
        } else {
            throw new IllegalStateException(String.format("Unknown RaceLogEvent type %s", eventClass));
        }
        return new Util.Pair((Object)resultEvent, dbObjectForUpdate);
    }

    private RaceLogEvent loadRaceLogORCScratchBoatEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        return new RaceLogORCScratchBoatEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), competitors.get(0));
    }

    private RaceLogEvent loadRaceLogORCSetImpliedWindEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) throws JsonDeserializationException, ParseException {
        ImpliedWindSource impliedWindSource;
        Document impliedWindSourceDocument = (Document)dbObject.get((Object)FieldNames.ORC_IMPLIED_WIND_SOURCE.name());
        if (impliedWindSourceDocument == null) {
            impliedWindSource = null;
        } else {
            JsonWriterSettings writerSettings = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build();
            JSONObject json = Helpers.toJSONObjectSafe((Object)new JSONParser().parse(impliedWindSourceDocument.toJson(writerSettings)));
            impliedWindSource = new ImpliedWindSourceDeserializer().deserialize(json);
        }
        return new RaceLogORCImpliedWindSourceEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), impliedWindSource);
    }

    private RaceLogEvent loadRaceLogResultsAreOfficialEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) throws JsonDeserializationException, ParseException {
        return new RaceLogResultsAreOfficialEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue());
    }

    private RaceLogEvent loadRaceLogUseCompetitorsFromRaceLogEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        return new RaceLogUseCompetitorsFromRaceLogEventImpl(createdAt, author, logicalTimePoint, id, passId.intValue());
    }

    private RaceLogEvent loadRaceLogWindFixEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        Wind wind = this.loadWind((Document)dbObject.get((Object)FieldNames.WIND.name()));
        Boolean isMagnetic = (Boolean)dbObject.get((Object)FieldNames.IS_MAGNETIC.name());
        return new RaceLogWindFixEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), wind, isMagnetic == null ? true : isMagnetic);
    }

    private RaceLogEvent loadRaceLogDenoteForTrackingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        String raceName = (String)dbObject.get((Object)FieldNames.RACE_NAME.name());
        BoatClass boatClass = this.baseDomainFactory.getOrCreateBoatClass((String)dbObject.get((Object)FieldNames.BOAT_CLASS_NAME.name()));
        Serializable raceId = (Serializable)dbObject.get((Object)FieldNames.RACE_ID.name());
        return new RaceLogDenoteForTrackingEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), raceName, boatClass, raceId);
    }

    private RaceLogEvent loadRaceLogStartTrackingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        return new RaceLogStartTrackingEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue());
    }

    private RaceLogEvent loadRaceLogRevokeEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        Serializable revokedEventId = UUIDHelper.tryUuidConversion((Serializable)((Serializable)dbObject.get((Object)FieldNames.RACE_LOG_REVOKED_EVENT_ID.name())));
        String revokedEventType = (String)dbObject.get((Object)FieldNames.RACE_LOG_REVOKED_EVENT_TYPE.name());
        String revokedEventShortInfo = (String)dbObject.get((Object)FieldNames.RACE_LOG_REVOKED_EVENT_SHORT_INFO.name());
        String reason = (String)dbObject.get((Object)FieldNames.RACE_LOG_REVOKED_REASON.name());
        return new RaceLogRevokeEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), revokedEventId, revokedEventType, revokedEventShortInfo, reason);
    }

    private Util.Pair<RaceLogEvent, Optional<Document>> loadRaceLogRegisterCompetitorEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        Optional<Object> dbObjectForUpdate;
        RaceLogRegisterCompetitorEvent result;
        Serializable competitorId = (Serializable)dbObject.get((Object)FieldNames.RACE_LOG_COMPETITOR_ID.name());
        Serializable boatId = (Serializable)dbObject.get((Object)FieldNames.RACE_LOG_BOAT_ID.name());
        DynamicBoat boat = this.baseDomainFactory.getCompetitorAndBoatStore().getExistingBoatById(boatId);
        Competitor competitor = this.baseDomainFactory.getCompetitorAndBoatStore().getExistingCompetitorById(competitorId);
        if (competitor == null) {
            logger.severe("Competitor with ID " + competitorId + " not found; can't register with boat with ID " + boatId + " for race");
            result = null;
            dbObjectForUpdate = Optional.empty();
        } else if (boatId == null) {
            if (competitor.hasBoat()) {
                result = new RaceLogRegisterCompetitorEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), competitor, ((CompetitorWithBoat)competitor).getBoat());
            } else {
                logger.warning("Bug2822: Competitor with ID " + competitorId + " already seems to have been migrated to one without boat." + " But the RaceLogRegisterCompetitorEventImpl event loaded does not specify one either. We'll try to find a boat...");
                result = this.createBoatForSecondGermanLeague2017(createdAt, author, logicalTimePoint, id, passId, competitor);
            }
            dbObjectForUpdate = this.requestBoatIdUpdateInDB(dbObject, result);
        } else if (boat == null) {
            logger.warning("Bug2822: Competitor with ID " + competitorId + " references boat with ID " + boatId + " which wasn't found; assigning a boat from the 2nd German Sailing League 2017 season and updating this " + this.getClass().getName() + " event with ID " + id + " in the DB");
            result = this.createBoatForSecondGermanLeague2017(createdAt, author, logicalTimePoint, id, passId, competitor);
            dbObjectForUpdate = this.requestBoatIdUpdateInDB(dbObject, result);
        } else {
            result = this.createRaceLogRegisterCompetitorEventImpl(createdAt, author, logicalTimePoint, id, passId, (Boat)boat, competitor);
            dbObjectForUpdate = Optional.empty();
        }
        return new Util.Pair((Object)result, dbObjectForUpdate);
    }

    private Optional<Document> requestBoatIdUpdateInDB(Document dbObject, RaceLogRegisterCompetitorEvent result) {
        dbObject.put(FieldNames.RACE_LOG_BOAT_ID.name(), (Object)result.getBoat().getId());
        Optional<Document> dbObjectForUpdate = Optional.of(dbObject);
        return dbObjectForUpdate;
    }

    private RaceLogRegisterCompetitorEvent createBoatForSecondGermanLeague2017(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, Competitor competitor) {
        String sailId = "" + (this.secondLeagueBoatCounter++ % 6 + 1);
        String auxiliaryBoatId = "b2567e08-26d9-45c1-b5e0-8c410c8db18b#" + sailId;
        DynamicBoat auxiliaryBoat = this.baseDomainFactory.getCompetitorAndBoatStore().getOrCreateBoat((Serializable)((Object)auxiliaryBoatId), sailId, this.baseDomainFactory.getOrCreateBoatClass(BoatClassMasterdata.J70.getDisplayName()), sailId, null, true);
        return this.createRaceLogRegisterCompetitorEventImpl(createdAt, author, logicalTimePoint, id, passId, (Boat)auxiliaryBoat, competitor);
    }

    private RaceLogRegisterCompetitorEvent createRaceLogRegisterCompetitorEventImpl(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, Boat boat, Competitor competitor) {
        RaceLogRegisterCompetitorEventImpl result = boat != null ? new RaceLogRegisterCompetitorEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), competitor, boat) : null;
        return result;
    }

    private RaceLogEvent loadRaceLogAdditionalScoringInformationEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        Object additionalScoringInformationTypeInfo = dbObject.get((Object)FieldNames.RACE_LOG_ADDITIONAL_SCORING_INFORMATION_TYPE.name());
        AdditionalScoringInformationType informationType = AdditionalScoringInformationType.UNKNOWN;
        if (additionalScoringInformationTypeInfo != null) {
            informationType = AdditionalScoringInformationType.valueOf((String)additionalScoringInformationTypeInfo.toString());
        } else {
            logger.warning("Could not find additional scoring information attached to db log for " + dbObject.toString());
        }
        return new RaceLogAdditionalScoringInformationEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), informationType);
    }

    private RaceLogEvent loadRaceLogProtestStartTimeEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        TimePoint protestStartTime = DomainObjectFactoryImpl.loadTimePoint(dbObject, FieldNames.RACE_LOG_PROTEST_START_TIME);
        TimePoint protestEndTime = DomainObjectFactoryImpl.loadTimePoint(dbObject, FieldNames.RACE_LOG_PROTEST_END_TIME);
        if (protestEndTime == null) {
            protestEndTime = protestStartTime.plus(Duration.ONE_MINUTE.times(90L));
        }
        TimeRangeImpl protestTime = new TimeRangeImpl(protestStartTime, protestEndTime);
        return new RaceLogProtestStartTimeEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), (TimeRange)protestTime);
    }

    private RaceLogEvent loadRaceLogStartProcedureChangedEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        RacingProcedureType type = RacingProcedureType.valueOf((String)dbObject.get((Object)FieldNames.RACE_LOG_START_PROCEDURE_TYPE.name()).toString());
        return new RaceLogStartProcedureChangedEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), type);
    }

    private RaceLogEvent loadRaceLogTagEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, Document dbObject) {
        String tag = (String)dbObject.get((Object)FieldNames.RACE_LOG_TAG.name());
        String comment = (String)dbObject.get((Object)FieldNames.RACE_LOG_COMMENT.name());
        String hiddenInfo = (String)dbObject.get((Object)FieldNames.RACE_LOG_HIDDEN_INFO.name());
        String imageUrl = (String)dbObject.get((Object)FieldNames.RACE_LOG_IMAGE_URL.name());
        String resizedImageURL = (String)dbObject.get((Object)FieldNames.RACE_LOG_RESIZED_IMAGE_URL.name());
        return new RaceLogTagEventImpl(tag, comment, hiddenInfo, imageUrl, resizedImageURL, createdAt, logicalTimePoint, author, id, passId.intValue());
    }

    private RaceLogEvent loadRaceLogGateLineOpeningTimeEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        Number gateLaunchStopTime = (Number)dbObject.get((Object)FieldNames.RACE_LOG_GATE_LINE_OPENING_TIME.name());
        Number golfDownTime = 0;
        if (dbObject.containsKey((Object)FieldNames.RACE_LOG_GOLF_DOWN_TIME.name())) {
            golfDownTime = (Number)dbObject.get((Object)FieldNames.RACE_LOG_GOLF_DOWN_TIME.name());
        }
        return new RaceLogGateLineOpeningTimeEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), (gateLaunchStopTime == null ? null : Long.valueOf(gateLaunchStopTime.longValue())).longValue(), golfDownTime.longValue());
    }

    private RaceLogEvent loadRaceLogPathfinderEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        String pathfinderId = dbObject.get((Object)FieldNames.RACE_LOG_PATHFINDER_ID.name()).toString();
        return new RaceLogPathfinderEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), pathfinderId);
    }

    private RaceLogEvent loadRaceLogFinishPositioningConfirmedEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        Iterable dbPositionedCompetitorList = (Iterable)dbObject.get((Object)FieldNames.RACE_LOG_POSITIONED_COMPETITORS.name());
        CompetitorResults positionedCompetitors = null;
        if (dbPositionedCompetitorList != null) {
            positionedCompetitors = this.loadPositionedCompetitors(dbPositionedCompetitorList);
        }
        return new RaceLogFinishPositioningConfirmedEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), positionedCompetitors);
    }

    private RaceLogEvent loadRaceLogFinishPositioningListChangedEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        Iterable dbPositionedCompetitorList = (Iterable)dbObject.get((Object)FieldNames.RACE_LOG_POSITIONED_COMPETITORS.name());
        CompetitorResults positionedCompetitors = this.loadPositionedCompetitors(dbPositionedCompetitorList);
        return new RaceLogFinishPositioningListChangedEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), positionedCompetitors);
    }

    private RaceLogEvent loadRaceLogPassChangeEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors) {
        return new RaceLogPassChangeEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue());
    }

    private Util.Pair<RaceLogCourseDesignChangedEvent, Optional<Document>> loadRaceLogCourseDesignChangedEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        String courseDesignerModeName;
        String courseName = (String)dbObject.get((Object)FieldNames.RACE_LOG_COURSE_DESIGN_NAME.name());
        UUID courseOriginatingTemplateId = (UUID)dbObject.get((Object)FieldNames.RACE_LOG_COURSE_ORIGINATING_TEMPLATE_ID.name());
        Util.Pair<CourseBase, Boolean> courseData = this.loadCourseData((Iterable)dbObject.get((Object)FieldNames.RACE_LOG_COURSE_DESIGN.name()), courseName, courseOriginatingTemplateId);
        ArrayList markList = (ArrayList)dbObject.get((Object)FieldNames.RACE_LOG_COURSE_ASSOCIATED_ROLES.name(), ArrayList.class);
        if (markList != null) {
            for (Object entry : markList) {
                if (entry instanceof Document) {
                    Document entryObject = (Document)entry;
                    UUID markUUID = UUID.fromString(entryObject.getString((Object)FieldNames.RACE_LOG_COURSE_ASSOCIATED_ROLES_MARK_ID.name()));
                    Mark mark = this.baseDomainFactory.getExistingMarkById((Serializable)markUUID);
                    if (mark != null) {
                        String roleIdAsStringOrNull = entryObject.getString((Object)FieldNames.RACE_LOG_COURSE_ASSOCIATED_ROLES_ROLE_ID.name());
                        if (roleIdAsStringOrNull == null) continue;
                        ((CourseBase)courseData.getA()).addRoleMapping(mark, UUID.fromString(roleIdAsStringOrNull));
                        continue;
                    }
                    logger.warning(String.format("Could not resolve mark with id %s for course %s.", markUUID, id));
                    continue;
                }
                logger.warning(String.format("Unexpected mark entry found for course %s.", id));
            }
        }
        CourseDesignerMode courseDesignerMode = (courseDesignerModeName = (String)dbObject.get((Object)FieldNames.RACE_LOG_COURSE_DESIGNER_MODE.name())) == null ? null : CourseDesignerMode.valueOf((String)courseDesignerModeName);
        return new Util.Pair((Object)new RaceLogCourseDesignChangedEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), (CourseBase)courseData.getA(), courseDesignerMode), (Boolean)courseData.getB() != false ? Optional.of(dbObject) : Optional.empty());
    }

    private RaceLogEvent loadRaceLogFixedMarkPassingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        TimePoint ofFixedPassing = DomainObjectFactoryImpl.loadTimePoint(dbObject, FieldNames.TIMEPOINT_OF_FIXED_MARKPASSING);
        Integer zeroBasedIndexOfWaypoint = (Integer)dbObject.get((Object)FieldNames.INDEX_OF_PASSED_WAYPOINT.name());
        return new RaceLogFixedMarkPassingEventImpl(createdAt, logicalTimePoint, author, id, competitors, passId.intValue(), ofFixedPassing, zeroBasedIndexOfWaypoint);
    }

    private RaceLogEvent loadRaceLogSuppressedMarkPassingsEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        Integer zeroBasedIndexOfFirstSuppressedWaypoint = (Integer)dbObject.get((Object)FieldNames.INDEX_OF_FIRST_SUPPRESSED_WAYPOINT.name());
        return new RaceLogSuppressedMarkPassingsEventImpl(createdAt, logicalTimePoint, author, id, competitors, passId.intValue(), zeroBasedIndexOfFirstSuppressedWaypoint);
    }

    private CompetitorResults loadPositionedCompetitors(Iterable<?> dbPositionedCompetitorList) {
        CompetitorResultsImpl positionedCompetitors = new CompetitorResultsImpl();
        int rankCounter = 1;
        for (Object object : dbPositionedCompetitorList) {
            Document dbObject = (Document)object;
            Serializable competitorId = (Serializable)dbObject.get((Object)FieldNames.COMPETITOR_ID.name());
            String competitorDisplayName = (String)dbObject.get((Object)FieldNames.COMPETITOR_DISPLAY_NAME.name());
            String competitorShortName = (String)dbObject.get((Object)FieldNames.COMPETITOR_SHORT_NAME.name());
            String competitorBoatName = (String)dbObject.get((Object)FieldNames.COMPETITOR_BOAT_NAME.name());
            String competitorBoatSailId = (String)dbObject.get((Object)FieldNames.COMPETITOR_BOAT_SAIL_ID.name());
            Integer rank = (Integer)dbObject.get((Object)FieldNames.LEADERBOARD_RANK.name());
            String maxPointsReasonString = (String)dbObject.get((Object)FieldNames.LEADERBOARD_SCORE_CORRECTION_MAX_POINTS_REASON.name());
            MaxPointsReason maxPointsReason = maxPointsReasonString == null ? MaxPointsReason.NONE : MaxPointsReason.valueOf((String)maxPointsReasonString);
            Number scoreAsNumber = (Number)dbObject.get((Object)FieldNames.LEADERBOARD_CORRECTED_SCORE.name());
            Double score = scoreAsNumber == null ? null : Double.valueOf(scoreAsNumber.doubleValue());
            Number finishingTimePointAsMillisAsNumber = (Number)dbObject.get((Object)FieldNames.RACE_LOG_FINISHING_TIME_AS_MILLIS.name());
            Long finishingTimePointAsMillis = finishingTimePointAsMillisAsNumber == null ? null : Long.valueOf(finishingTimePointAsMillisAsNumber.longValue());
            MillisecondsTimePoint finishingTime = finishingTimePointAsMillis == null ? null : new MillisecondsTimePoint(finishingTimePointAsMillis.longValue());
            String comment = (String)dbObject.get((Object)FieldNames.LEADERBOARD_SCORE_CORRECTION_COMMENT.name());
            String mergeStateAsString = (String)dbObject.get((Object)FieldNames.LEADERBOARD_SCORE_CORRECTION_MERGE_STATE.name());
            CompetitorResult.MergeState mergeState = mergeStateAsString == null ? CompetitorResult.MergeState.OK : CompetitorResult.MergeState.valueOf((String)mergeStateAsString);
            CompetitorResultImpl positionedCompetitor = new CompetitorResultImpl(competitorId, competitorDisplayName, competitorShortName, competitorBoatName, competitorBoatSailId, rank == null ? rankCounter : rank, maxPointsReason, score, (TimePoint)finishingTime, comment, mergeState);
            positionedCompetitors.add((Object)positionedCompetitor);
            ++rankCounter;
        }
        return positionedCompetitors;
    }

    private List<Competitor> loadCompetitorsForRaceLogEvent(Iterable<Document> dbCompetitorList) {
        ArrayList<Competitor> competitors = new ArrayList<Competitor>();
        for (Document object : dbCompetitorList) {
            Serializable competitorId = (Serializable)object;
            Competitor competitor = this.baseDomainFactory.getCompetitorAndBoatStore().getExistingCompetitorById(competitorId);
            competitors.add(competitor);
        }
        return competitors;
    }

    private RaceLogFlagEvent loadRaceLogFlagEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        Flags upperFlag = Flags.valueOf((String)((String)dbObject.get((Object)FieldNames.RACE_LOG_EVENT_FLAG_UPPER.name())));
        Flags lowerFlag = Flags.valueOf((String)((String)dbObject.get((Object)FieldNames.RACE_LOG_EVENT_FLAG_LOWER.name())));
        Boolean displayed = Boolean.valueOf((String)dbObject.get((Object)FieldNames.RACE_LOG_EVENT_FLAG_DISPLAYED.name()));
        if (upperFlag == null || lowerFlag == null || displayed == null) {
            return null;
        }
        return new RaceLogFlagEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), upperFlag, lowerFlag, displayed.booleanValue());
    }

    private RaceLogStartTimeEvent loadRaceLogStartTimeEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        TimePoint startTime = DomainObjectFactoryImpl.loadTimePoint(dbObject, FieldNames.RACE_LOG_EVENT_START_TIME);
        UUID courseAreaId = this.loadCourseAreaId(dbObject);
        RaceLogRaceStatus nextStatus = RaceLogRaceStatus.valueOf((String)((String)dbObject.get((Object)FieldNames.RACE_LOG_EVENT_NEXT_STATUS.name())));
        return new RaceLogStartTimeEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), startTime, nextStatus, courseAreaId);
    }

    private UUID loadCourseAreaId(Document dbObject) {
        String courseAreaIdAsString = (String)dbObject.get((Object)FieldNames.RACE_LOG_EVENT_COURSE_AREA_ID_AS_STRING.name());
        UUID courseAreaId = courseAreaIdAsString == null ? null : UUID.fromString(courseAreaIdAsString);
        return courseAreaId;
    }

    private RaceLogStartOfTrackingEvent loadRaceLogStartOfTrackingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        return new RaceLogStartOfTrackingEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue());
    }

    private RaceLogEndOfTrackingEvent loadRaceLogEndOfTrackingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        return new RaceLogEndOfTrackingEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue());
    }

    private RaceLogDependentStartTimeEvent loadRaceLogDependentStartTimeEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        Object regattaLikeNameObject = dbObject.get((Object)FieldNames.RACE_LOG_DEPDENDENT_ON_REGATTALIKE.name());
        String regattaLikeName = regattaLikeNameObject == null ? null : regattaLikeNameObject.toString();
        Object raceColumnNameObject = dbObject.get((Object)FieldNames.RACE_LOG_DEPDENDENT_ON_RACECOLUMN.name());
        String raceColumnName = raceColumnNameObject == null ? null : raceColumnNameObject.toString();
        Object fleetNameObject = dbObject.get((Object)FieldNames.RACE_LOG_DEPDENDENT_ON_FLEET.name());
        String fleetName = fleetNameObject == null ? null : fleetNameObject.toString();
        SimpleRaceLogIdentifierImpl dependentRaceLog = new SimpleRaceLogIdentifierImpl(regattaLikeName, raceColumnName, fleetName);
        Object startTimeDifferenceObject = dbObject.get((Object)FieldNames.RACE_LOG_START_TIME_DIFFERENCE_IN_MS.name());
        MillisecondsDurationImpl startTimeDifference = startTimeDifferenceObject == null ? null : new MillisecondsDurationImpl(((Number)startTimeDifferenceObject).longValue());
        RaceLogRaceStatus nextStatus = RaceLogRaceStatus.valueOf((String)((String)dbObject.get((Object)FieldNames.RACE_LOG_EVENT_NEXT_STATUS.name())));
        UUID courseAreaId = this.loadCourseAreaId(dbObject);
        return new RaceLogDependentStartTimeEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), (SimpleRaceLogIdentifier)dependentRaceLog, (Duration)startTimeDifference, nextStatus, courseAreaId);
    }

    private RaceLogRaceStatusEvent loadRaceLogRaceStatusEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, List<Competitor> competitors, Document dbObject) {
        RaceLogRaceStatus nextStatus = RaceLogRaceStatus.valueOf((String)((String)dbObject.get((Object)FieldNames.RACE_LOG_EVENT_NEXT_STATUS.name())));
        return new RaceLogRaceStatusEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), nextStatus);
    }

    private RaceLogORCLegDataEvent loadRaceLogORCLegDataEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Integer passId, Document dbObject) {
        int legNr = ((Number)dbObject.get((Object)FieldNames.ORC_LEG_NR.name())).intValue();
        Number twaInDegrees = (Number)dbObject.get((Object)FieldNames.ORC_LEG_TWA_IN_DEG.name());
        DegreeBearingImpl twa = twaInDegrees == null ? null : new DegreeBearingImpl(twaInDegrees.doubleValue());
        Number lengthInNauticalMiles = (Number)dbObject.get((Object)FieldNames.ORC_LEG_LENGTH_IN_NAUTICAL_MILES.name());
        NauticalMileDistance length = lengthInNauticalMiles == null ? null : new NauticalMileDistance(lengthInNauticalMiles.doubleValue());
        ORCPerformanceCurveLegTypes type = ORCPerformanceCurveLegTypes.valueOf((String)dbObject.getString((Object)FieldNames.ORC_LEG_TYPE.name()));
        return new RaceLogORCLegDataEventImpl(createdAt, logicalTimePoint, author, id, passId.intValue(), legNr, (Bearing)twa, (Distance)length, type);
    }

    private RaceLogORCCertificateAssignmentEvent loadRaceLogORCCertificateAssignmentEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, int passId, Document dbObject) throws JsonDeserializationException, ParseException {
        Document certificateDbObject = (Document)dbObject.get((Object)FieldNames.ORC_CERTIFICATE.name());
        JsonWriterSettings writerSettings = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build();
        JSONObject json = Helpers.toJSONObjectSafe((Object)new JSONParser().parse(certificateDbObject.toJson(writerSettings)));
        ORCCertificate certificate = new ORCCertificateJsonDeserializer().deserialize(json);
        Serializable boatId = (Serializable)dbObject.get((Object)FieldNames.RACE_LOG_BOAT_ID.name());
        return new RaceLogORCCertificateAssignmentEventImpl(createdAt, logicalTimePoint, author, id, passId, certificate, boatId);
    }

    private RaceLogExcludeWindSourcesEvent loadRaceLogExcludeWindSourceEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, int passId, Document dbObject) throws JsonDeserializationException, ParseException {
        HashSet<WindSourceImpl> windSourcesToExclude = new HashSet<WindSourceImpl>();
        Iterable dbWindSourcesToExclude = (Iterable)dbObject.get((Object)FieldNames.WIND_SOURCES_TO_EXCLUDE.name());
        for (Object dbWindSourceToExcludeObject : dbWindSourcesToExclude) {
            Document dbWindSourceToExclude = (Document)dbWindSourceToExcludeObject;
            WindSourceType windSourceType = WindSourceType.valueOf((String)((String)dbWindSourceToExclude.get((Object)FieldNames.WIND_SOURCE_NAME.name())));
            Object windSourceToExclude = dbWindSourceToExclude.containsKey((Object)FieldNames.WIND_SOURCE_ID.name()) ? new WindSourceWithAdditionalID(windSourceType, (String)dbWindSourceToExclude.get((Object)FieldNames.WIND_SOURCE_ID.name())) : new WindSourceImpl(windSourceType);
            windSourcesToExclude.add((WindSourceImpl)windSourceToExclude);
        }
        return new RaceLogExcludeWindSourcesEventImpl(createdAt, logicalTimePoint, author, id, passId, windSourcesToExclude);
    }

    @Override
    public RegattaLog loadRegattaLog(RegattaLikeIdentifier identifier) {
        RegattaLogImpl result = new RegattaLogImpl(RegattaLogImpl.class.getSimpleName(), (Serializable)identifier);
        try {
            Document query = new Document();
            query.put(FieldNames.REGATTA_LOG_IDENTIFIER_TYPE.name(), (Object)identifier.getIdentifierType());
            query.put(FieldNames.REGATTA_LOG_IDENTIFIER_NAME.name(), (Object)identifier.getName());
            this.loadRegattaLogEvents((RegattaLog)result, query, identifier);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load recorded regatta log data for " + identifier + ". Check MongoDB settings.", t);
        }
        return result;
    }

    private void loadRegattaLogEvents(RegattaLog targetRegattaLog, Document query, RegattaLikeIdentifier regattaLogIdentifier) throws JsonDeserializationException, ParseException {
        MongoCollection collection = this.database.getCollection(CollectionNames.REGATTA_LOGS.name());
        for (Document o : collection.find((Bson)query)) {
            try {
                RegattaLogEvent event = this.loadRegattaLogEvent(o, regattaLogIdentifier);
                if (event == null) continue;
                targetRegattaLog.load((AbstractLogEvent)event);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Couldn't load regatta log event " + o + ": " + e.getMessage(), e);
            }
        }
    }

    public RegattaLogEvent loadRegattaLogEvent(Document o, RegattaLikeIdentifier regattaLogIdentifier) throws JsonDeserializationException, ParseException {
        Document dbObject = (Document)o.get((Object)FieldNames.REGATTA_LOG_EVENT.name());
        TimePoint logicalTimePoint = this.loadTimePoint(dbObject);
        TimePoint createdAt = DomainObjectFactoryImpl.loadTimePoint(dbObject, FieldNames.REGATTA_LOG_EVENT_CREATED_AT);
        Serializable id = (Serializable)dbObject.get((Object)FieldNames.REGATTA_LOG_EVENT_ID.name());
        String authorName = (String)dbObject.get((Object)FieldNames.REGATTA_LOG_EVENT_AUTHOR_NAME.name());
        Number authorPriority = (Number)dbObject.get((Object)FieldNames.REGATTA_LOG_EVENT_AUTHOR_PRIORITY.name());
        Object author = authorName != null && authorPriority != null ? new LogEventAuthorImpl(authorName, authorPriority.intValue()) : LogEventAuthorImpl.createCompatibilityAuthor();
        String eventClass = (String)dbObject.get((Object)FieldNames.REGATTA_LOG_EVENT_CLASS.name());
        if (eventClass.equals(RegattaLogDeviceCompetitorMappingEvent.class.getSimpleName())) {
            return this.loadRegattaLogDeviceCompetitorMappingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject, regattaLogIdentifier, o);
        }
        if (eventClass.equals(RegattaLogDeviceBoatMappingEvent.class.getSimpleName())) {
            return this.loadRegattaLogDeviceBoatMappingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject, regattaLogIdentifier, o);
        }
        if (eventClass.equals(RegattaLogDeviceCompetitorBravoMappingEventImpl.class.getSimpleName())) {
            return this.loadRegattaLogDeviceCompetitorBravoMappingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject, regattaLogIdentifier, o);
        }
        if (eventClass.equals(RegattaLogDeviceCompetitorBravoExtendedMappingEventImpl.class.getSimpleName())) {
            return this.loadRegattaLogDeviceCompetitorBravoExtendedMappingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject, regattaLogIdentifier, o);
        }
        if (eventClass.equals(RegattaLogDeviceCompetitorExpeditionExtendedMappingEventImpl.class.getSimpleName())) {
            return this.loadRegattaLogDeviceCompetitorExpeditionExtendedMappingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject, regattaLogIdentifier, o);
        }
        if (eventClass.equals(RegattaLogDeviceBoatBravoMappingEventImpl.class.getSimpleName())) {
            return this.loadRegattaLogDeviceBoatBravoMappingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject, regattaLogIdentifier, o);
        }
        if (eventClass.equals(RegattaLogDeviceBoatBravoExtendedMappingEventImpl.class.getSimpleName())) {
            return this.loadRegattaLogDeviceBoatBravoExtendedMappingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject, regattaLogIdentifier, o);
        }
        if (eventClass.equals(RegattaLogDeviceBoatExpeditionExtendedMappingEventImpl.class.getSimpleName())) {
            return this.loadRegattaLogDeviceBoatExpeditionExtendedMappingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject, regattaLogIdentifier, o);
        }
        if (eventClass.equals(RegattaLogDeviceMarkMappingEvent.class.getSimpleName())) {
            return this.loadRegattaLogDeviceMarkMappingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject, regattaLogIdentifier, o);
        }
        if (eventClass.equals(RegattaLogCloseOpenEndedDeviceMappingEvent.class.getSimpleName())) {
            return this.loadRegattaLogCloseOpenEndedDeviceMappingEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject);
        }
        if (eventClass.equals(RegattaLogRegisterBoatEvent.class.getSimpleName())) {
            return this.loadRegattaLogRegisterBoatEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject);
        }
        if (eventClass.equals(RegattaLogRegisterCompetitorEvent.class.getSimpleName())) {
            return this.loadRegattaLogRegisterCompetitorEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject);
        }
        if (eventClass.equals(RegattaLogSetCompetitorTimeOnTimeFactorEvent.class.getSimpleName())) {
            return this.loadRegattaLogSetCompetitorTimeOnTimeFactorEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject);
        }
        if (eventClass.equals(RegattaLogSetCompetitorTimeOnDistanceAllowancePerNauticalMileEvent.class.getSimpleName())) {
            return this.loadRegattaLogSetCompetitorTimeOnDistanceAllowancePerNauticalMileEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject);
        }
        if (eventClass.equals(RegattaLogDefineMarkEvent.class.getSimpleName())) {
            return this.loadRegattaLogDefineMarkEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject);
        }
        if (eventClass.equals(RegattaLogRevokeEvent.class.getSimpleName())) {
            return this.loadRegattaLogRevokeEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject);
        }
        if (eventClass.equals(RegattaLogORCCertificateAssignmentEvent.class.getSimpleName())) {
            return this.loadRegattaLogORCCertificateAssignmentEvent(createdAt, (AbstractLogEventAuthor)author, logicalTimePoint, id, dbObject);
        }
        throw new IllegalStateException(String.format("Unknown RegattaLogEvent type %s", eventClass));
    }

    private Competitor getCompetitorByID(Document dbObject) {
        Serializable competitorId = (Serializable)dbObject.get((Object)FieldNames.REGATTA_LOG_COMPETITOR_ID.name());
        Competitor comp = this.baseDomainFactory.getCompetitorAndBoatStore().getExistingCompetitorById(competitorId);
        return comp;
    }

    private Boat getBoatByID(Document dbObject) {
        Serializable boatId = (Serializable)dbObject.get((Object)FieldNames.REGATTA_LOG_BOAT_ID.name());
        DynamicBoat boat = this.baseDomainFactory.getCompetitorAndBoatStore().getExistingBoatById(boatId);
        return boat;
    }

    private RegattaLogEvent loadRegattaLogSetCompetitorTimeOnTimeFactorEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject) {
        Competitor comp = this.getCompetitorByID(dbObject);
        Number timeOnTimeFactorAsNumber = (Number)dbObject.get((Object)FieldNames.REGATTA_LOG_TIME_ON_TIME_FACTOR.name());
        Double timeOnTimeFactor = timeOnTimeFactorAsNumber == null ? null : Double.valueOf(timeOnTimeFactorAsNumber.doubleValue());
        return new RegattaLogSetCompetitorTimeOnTimeFactorEventImpl(createdAt, logicalTimePoint, author, id, comp, timeOnTimeFactor);
    }

    private RegattaLogEvent loadRegattaLogSetCompetitorTimeOnDistanceAllowancePerNauticalMileEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject) {
        Competitor comp = this.getCompetitorByID(dbObject);
        Number timeOnDistanceSecondsAllowancePerNauticalMileAsNumber = (Number)dbObject.get((Object)FieldNames.REGATTA_LOG_TIME_ON_DISTANCE_SECONDS_ALLOWANCE_PER_NAUTICAL_MILE.name());
        Double timeOnDistanceSecondsAllowancePerNauticalMile = timeOnDistanceSecondsAllowancePerNauticalMileAsNumber == null ? null : Double.valueOf(timeOnDistanceSecondsAllowancePerNauticalMileAsNumber.doubleValue());
        MillisecondsDurationImpl timeOnDistanceAllowancePerNauticalMile = timeOnDistanceSecondsAllowancePerNauticalMile == null ? null : new MillisecondsDurationImpl((long)(timeOnDistanceSecondsAllowancePerNauticalMile * 1000.0));
        return new RegattaLogSetCompetitorTimeOnDistanceAllowancePerNauticalMileEventImpl(createdAt, logicalTimePoint, author, id, comp, (Duration)timeOnDistanceAllowancePerNauticalMile);
    }

    private RegattaLogRevokeEvent loadRegattaLogRevokeEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject) {
        Serializable revokedEventId = UUIDHelper.tryUuidConversion((Serializable)((Serializable)dbObject.get((Object)FieldNames.REGATTA_LOG_REVOKED_EVENT_ID.name())));
        String revokedEventType = (String)dbObject.get((Object)FieldNames.REGATTA_LOG_REVOKED_EVENT_TYPE.name());
        String revokedEventShortInfo = (String)dbObject.get((Object)FieldNames.REGATTA_LOG_REVOKED_EVENT_SHORT_INFO.name());
        String reason = (String)dbObject.get((Object)FieldNames.REGATTA_LOG_REVOKED_REASON.name());
        return new RegattaLogRevokeEventImpl(createdAt, logicalTimePoint, author, id, revokedEventId, revokedEventType, revokedEventShortInfo, reason);
    }

    private RegattaLogEvent loadRegattaLogDefineMarkEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject) {
        Mark mark = this.loadMark((Document)dbObject.get((Object)FieldNames.REGATTA_LOG_MARK.name()));
        return new RegattaLogDefineMarkEventImpl(createdAt, author, logicalTimePoint, id, mark);
    }

    private RegattaLogRegisterCompetitorEvent loadRegattaLogRegisterCompetitorEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject) {
        RegattaLogRegisterCompetitorEventImpl result;
        Competitor comp = this.getCompetitorByID(dbObject);
        if (comp == null) {
            result = null;
            logger.log(Level.SEVERE, "Couldn't resolve competitor with ID " + dbObject.get((Object)FieldNames.REGATTA_LOG_COMPETITOR_ID.name()) + " from registration event with ID " + id + ". Skipping this competitor registration.");
        } else {
            result = new RegattaLogRegisterCompetitorEventImpl(createdAt, logicalTimePoint, author, id, comp);
        }
        return result;
    }

    private RegattaLogRegisterBoatEvent loadRegattaLogRegisterBoatEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject) {
        RegattaLogRegisterBoatEventImpl result;
        Boat boat = this.getBoatByID(dbObject);
        if (boat == null) {
            result = null;
            logger.log(Level.SEVERE, "Couldn't resolve boat with ID " + dbObject.get((Object)FieldNames.REGATTA_LOG_BOAT_ID.name()) + " from registration event with ID " + id + ". Skipping this boat registration.");
        } else {
            result = new RegattaLogRegisterBoatEventImpl(createdAt, logicalTimePoint, author, id, boat);
        }
        return result;
    }

    private RegattaLogCloseOpenEndedDeviceMappingEvent loadRegattaLogCloseOpenEndedDeviceMappingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject) {
        Serializable deviceMappingEventId = UUIDHelper.tryUuidConversion((Serializable)((Serializable)dbObject.get((Object)FieldNames.REGATTA_LOG_DEVICE_MAPPING_EVENT_ID.name())));
        TimePoint closingTimePointInclusive = DomainObjectFactoryImpl.loadTimePoint(dbObject, FieldNames.REGATTA_LOG_CLOSING_TIMEPOINT);
        return new RegattaLogCloseOpenEndedDeviceMappingEventImpl(createdAt, author, logicalTimePoint, id, deviceMappingEventId, closingTimePointInclusive);
    }

    private RegattaLogDeviceMarkMappingEvent loadRegattaLogDeviceMarkMappingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject, RegattaLikeIdentifier regattaLogIdentifier, Document outerDBObject) {
        return (RegattaLogDeviceMarkMappingEvent)this.loadRegattaLogDeviceMappingEvent(createdAt, author, logicalTimePoint, id, dbObject, regattaLogIdentifier, outerDBObject, () -> this.loadMark((Document)dbObject.get((Object)FieldNames.MARK.name())), RegattaLogDeviceMarkMappingEventImpl::new, result -> {
            Document document = new MongoObjectFactoryImpl(this.database, this.serviceFinderFactory).storeRegattaLogEvent(regattaLogIdentifier, (RegattaLogDeviceMarkMappingEvent)result);
        });
    }

    private RegattaLogORCCertificateAssignmentEvent loadRegattaLogORCCertificateAssignmentEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject) throws JsonDeserializationException, ParseException {
        Document certificateDbObject = (Document)dbObject.get((Object)FieldNames.ORC_CERTIFICATE.name());
        JsonWriterSettings writerSettings = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build();
        JSONObject json = Helpers.toJSONObjectSafe((Object)new JSONParser().parse(certificateDbObject.toJson(writerSettings)));
        ORCCertificate certificate = new ORCCertificateJsonDeserializer().deserialize(json);
        Serializable boatId = (Serializable)dbObject.get((Object)FieldNames.RACE_LOG_BOAT_ID.name());
        return new RegattaLogORCCertificateAssignmentEventImpl(createdAt, logicalTimePoint, author, id, certificate, boatId);
    }

    private Util.Triple<TimePoint, TimePoint, Boolean> loadFromToTimePoint(Document dbObject, FieldNames fromField, FieldNames fromFieldDeprecated, FieldNames toField, FieldNames toFieldDeprecated) {
        TimePoint to;
        boolean needsMigration = false;
        TimePoint from = DomainObjectFactoryImpl.loadTimePoint(dbObject, fromField);
        if (from == null && (from = DomainObjectFactoryImpl.loadTimePoint(dbObject, fromFieldDeprecated)) != null) {
            needsMigration = true;
        }
        if ((to = DomainObjectFactoryImpl.loadTimePoint(dbObject, toField)) == null && (to = DomainObjectFactoryImpl.loadTimePoint(dbObject, toFieldDeprecated)) != null) {
            needsMigration = true;
        }
        return new Util.Triple((Object)from, (Object)to, (Object)needsMigration);
    }

    private RegattaLogDeviceCompetitorMappingEvent loadRegattaLogDeviceCompetitorMappingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject, RegattaLikeIdentifier regattaLogIdentifier, Document outerDBObject) {
        return (RegattaLogDeviceCompetitorMappingEvent)this.loadRegattaLogDeviceMappingEvent(createdAt, author, logicalTimePoint, id, dbObject, regattaLogIdentifier, outerDBObject, () -> this.baseDomainFactory.getExistingCompetitorById((Serializable)dbObject.get((Object)FieldNames.COMPETITOR_ID.name())), RegattaLogDeviceCompetitorMappingEventImpl::new, result -> {
            Document document = new MongoObjectFactoryImpl(this.database, this.serviceFinderFactory).storeRegattaLogEvent(regattaLogIdentifier, (RegattaLogDeviceCompetitorMappingEvent)result);
        });
    }

    private RegattaLogDeviceBoatMappingEvent loadRegattaLogDeviceBoatMappingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject, RegattaLikeIdentifier regattaLogIdentifier, Document outerDBObject) {
        return (RegattaLogDeviceBoatMappingEvent)this.loadRegattaLogDeviceMappingEvent(createdAt, author, logicalTimePoint, id, dbObject, regattaLogIdentifier, outerDBObject, () -> this.baseDomainFactory.getCompetitorAndBoatStore().getExistingBoatById((Serializable)dbObject.get((Object)FieldNames.RACE_LOG_BOAT_ID.name())), RegattaLogDeviceBoatMappingEventImpl::new, result -> {
            Document document = new MongoObjectFactoryImpl(this.database, this.serviceFinderFactory).storeRegattaLogEvent(regattaLogIdentifier, (RegattaLogDeviceBoatMappingEvent)result);
        });
    }

    private RegattaLogDeviceCompetitorBravoMappingEventImpl loadRegattaLogDeviceCompetitorBravoMappingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject, RegattaLikeIdentifier regattaLogIdentifier, Document outerDBObject) {
        return (RegattaLogDeviceCompetitorBravoMappingEventImpl)this.loadRegattaLogDeviceCompetitorSensorDataMappingEvent(createdAt, author, logicalTimePoint, id, dbObject, regattaLogIdentifier, outerDBObject, RegattaLogDeviceCompetitorBravoMappingEventImpl::new);
    }

    private RegattaLogDeviceCompetitorBravoExtendedMappingEventImpl loadRegattaLogDeviceCompetitorBravoExtendedMappingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject, RegattaLikeIdentifier regattaLogIdentifier, Document outerDBObject) {
        return (RegattaLogDeviceCompetitorBravoExtendedMappingEventImpl)this.loadRegattaLogDeviceCompetitorSensorDataMappingEvent(createdAt, author, logicalTimePoint, id, dbObject, regattaLogIdentifier, outerDBObject, RegattaLogDeviceCompetitorBravoExtendedMappingEventImpl::new);
    }

    private RegattaLogDeviceCompetitorExpeditionExtendedMappingEventImpl loadRegattaLogDeviceCompetitorExpeditionExtendedMappingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject, RegattaLikeIdentifier regattaLogIdentifier, Document outerDBObject) {
        return (RegattaLogDeviceCompetitorExpeditionExtendedMappingEventImpl)this.loadRegattaLogDeviceCompetitorSensorDataMappingEvent(createdAt, author, logicalTimePoint, id, dbObject, regattaLogIdentifier, outerDBObject, RegattaLogDeviceCompetitorExpeditionExtendedMappingEventImpl::new);
    }

    private <MappingT extends RegattaLogDeviceCompetitorSensorDataMappingEvent> MappingT loadRegattaLogDeviceCompetitorSensorDataMappingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject, RegattaLikeIdentifier regattaLogIdentifier, Document outerDBObject, RegattaLogDeviceMappingEventImpl.Factory<Competitor, MappingT> factory) {
        return (MappingT)this.loadRegattaLogDeviceMappingEvent(createdAt, author, logicalTimePoint, id, dbObject, regattaLogIdentifier, outerDBObject, () -> this.baseDomainFactory.getExistingCompetitorById((Serializable)dbObject.get((Object)FieldNames.COMPETITOR_ID.name())), factory, result -> {
            Document document = new MongoObjectFactoryImpl(this.database, this.serviceFinderFactory).storeRegattaLogEvent(regattaLogIdentifier, (RegattaLogDeviceCompetitorSensorDataMappingEvent)result);
        });
    }

    private RegattaLogDeviceBoatBravoMappingEventImpl loadRegattaLogDeviceBoatBravoMappingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject, RegattaLikeIdentifier regattaLogIdentifier, Document outerDBObject) {
        return (RegattaLogDeviceBoatBravoMappingEventImpl)this.loadRegattaLogDeviceBoatSensorDataMappingEvent(createdAt, author, logicalTimePoint, id, dbObject, regattaLogIdentifier, outerDBObject, RegattaLogDeviceBoatBravoMappingEventImpl::new);
    }

    private RegattaLogDeviceBoatBravoExtendedMappingEventImpl loadRegattaLogDeviceBoatBravoExtendedMappingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject, RegattaLikeIdentifier regattaLogIdentifier, Document outerDBObject) {
        return (RegattaLogDeviceBoatBravoExtendedMappingEventImpl)this.loadRegattaLogDeviceBoatSensorDataMappingEvent(createdAt, author, logicalTimePoint, id, dbObject, regattaLogIdentifier, outerDBObject, RegattaLogDeviceBoatBravoExtendedMappingEventImpl::new);
    }

    private RegattaLogDeviceBoatExpeditionExtendedMappingEventImpl loadRegattaLogDeviceBoatExpeditionExtendedMappingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject, RegattaLikeIdentifier regattaLogIdentifier, Document outerDBObject) {
        return (RegattaLogDeviceBoatExpeditionExtendedMappingEventImpl)this.loadRegattaLogDeviceBoatSensorDataMappingEvent(createdAt, author, logicalTimePoint, id, dbObject, regattaLogIdentifier, outerDBObject, RegattaLogDeviceBoatExpeditionExtendedMappingEventImpl::new);
    }

    private <MappingT extends RegattaLogDeviceBoatSensorDataMappingEvent> MappingT loadRegattaLogDeviceBoatSensorDataMappingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject, RegattaLikeIdentifier regattaLogIdentifier, Document outerDBObject, RegattaLogDeviceMappingEventImpl.Factory<Boat, MappingT> factory) {
        return (MappingT)this.loadRegattaLogDeviceMappingEvent(createdAt, author, logicalTimePoint, id, dbObject, regattaLogIdentifier, outerDBObject, () -> this.baseDomainFactory.getExistingBoatById((Serializable)dbObject.get((Object)FieldNames.RACE_LOG_BOAT_ID.name())), factory, result -> {
            Document document = new MongoObjectFactoryImpl(this.database, this.serviceFinderFactory).storeRegattaLogEvent(regattaLogIdentifier, (RegattaLogDeviceBoatSensorDataMappingEvent)result);
        });
    }

    private <ItemType extends WithID, MappingT extends RegattaLogDeviceMappingEvent<ItemType>> MappingT loadRegattaLogDeviceMappingEvent(TimePoint createdAt, AbstractLogEventAuthor author, TimePoint logicalTimePoint, Serializable id, Document dbObject, RegattaLikeIdentifier regattaLogIdentifier, Document outerDBObject, Supplier<ItemType> itemResolver, RegattaLogDeviceMappingEventImpl.Factory<ItemType, MappingT> factory, Consumer<MappingT> storeCallback) {
        DeviceIdentifier device = null;
        try {
            device = com.sap.sailing.shared.persistence.impl.DomainObjectFactoryImpl.loadDeviceId(this.deviceIdentifierServiceFinder, (Document)((Document)dbObject.get((Object)FieldNames.DEVICE_ID.name())));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not load deviceId for RaceLogEvent", e);
        }
        WithID mappedTo = (WithID)itemResolver.get();
        FieldNames deprecatedFromFieldName = FieldNames.RACE_LOG_FROM;
        FieldNames deprecatedToFieldName = FieldNames.RACE_LOG_TO;
        Util.Triple<TimePoint, TimePoint, Boolean> times = this.loadFromToTimePoint(dbObject, FieldNames.REGATTA_LOG_FROM, deprecatedFromFieldName, FieldNames.REGATTA_LOG_TO, deprecatedToFieldName);
        TimePoint from = (TimePoint)times.getA();
        TimePoint to = (TimePoint)times.getB();
        boolean needsMigration = (Boolean)times.getC();
        RegattaLogDeviceMappingEvent result = factory.create(createdAt, logicalTimePoint, author, id, mappedTo, device, from, to);
        if (needsMigration) {
            DeleteResult removeResult = this.database.getCollection(CollectionNames.REGATTA_LOGS.name()).deleteMany((Bson)outerDBObject);
            assert (removeResult.getDeletedCount() == 1L);
            storeCallback.accept(result);
        }
        return (MappingT)result;
    }

    private Util.Pair<CourseBase, Boolean> loadCourseData(Iterable<?> dbCourseList, String courseName, UUID originatingCourseTemplateId) {
        boolean migrated = false;
        if (courseName == null) {
            courseName = "Course";
        }
        CourseDataImpl courseData = new CourseDataImpl(courseName, originatingCourseTemplateId);
        int i = 0;
        for (Object object : dbCourseList) {
            Document dbObject = (Document)object;
            WaypointImpl waypoint = null;
            PassingInstruction passingInstructions = null;
            String waypointPassingInstruction = (String)dbObject.get((Object)FieldNames.WAYPOINT_PASSINGINSTRUCTIONS.name());
            if (waypointPassingInstruction == null && (waypointPassingInstruction = (String)dbObject.get((Object)FieldNames.WAYPOINT_PASSINGSIDE.name())) != null) {
                logger.info("Migrating PassingInstruction " + waypointPassingInstruction + " to field name WAYPOINT_PASSINGINSTRUCTIONS");
                if ((i == 0 || i == Util.size(dbCourseList) - 1) && waypointPassingInstruction.toLowerCase().equals("gate")) {
                    logger.warning("Changing PassingInstructions of first or last Waypoint from Gate to Line.");
                    waypointPassingInstruction = "Line";
                }
                dbObject.put(FieldNames.WAYPOINT_PASSINGINSTRUCTIONS.name(), (Object)waypointPassingInstruction);
                dbObject.remove((Object)FieldNames.WAYPOINT_PASSINGSIDE.name());
                migrated = true;
            }
            if (waypointPassingInstruction != null) {
                passingInstructions = PassingInstruction.valueOfIgnoringCase((String)waypointPassingInstruction);
            }
            Util.Pair<ControlPoint, Boolean> controlPoint = this.loadControlPoint((Document)dbObject.get((Object)FieldNames.CONTROLPOINT.name()));
            migrated = migrated || (Boolean)controlPoint.getB() != false;
            waypoint = passingInstructions == null ? new WaypointImpl((ControlPoint)controlPoint.getA()) : new WaypointImpl((ControlPoint)controlPoint.getA(), passingInstructions);
            courseData.addWaypoint(i++, (Waypoint)waypoint);
        }
        return new Util.Pair((Object)courseData, (Object)migrated);
    }

    private Util.Pair<ControlPoint, Boolean> loadControlPoint(Document dbObject) {
        String controlPointClass = (String)dbObject.get((Object)FieldNames.CONTROLPOINT_CLASS.name());
        Mark controlPoint = null;
        boolean migrated = false;
        if (controlPointClass != null) {
            if (controlPointClass.equals(Mark.class.getSimpleName())) {
                Mark mark;
                controlPoint = mark = this.loadMark((Document)dbObject.get((Object)FieldNames.CONTROLPOINT_VALUE.name()));
            } else if (controlPointClass.equals("Gate")) {
                ControlPointWithTwoMarks cpwtm = this.loadControlPointWithTwoMarks((Document)dbObject.get((Object)FieldNames.CONTROLPOINT_VALUE.name()));
                dbObject.put(FieldNames.CONTROLPOINT_CLASS.name(), (Object)ControlPointWithTwoMarks.class.getSimpleName());
                controlPoint = cpwtm;
                migrated = true;
            } else if (controlPointClass.equals(ControlPointWithTwoMarks.class.getSimpleName())) {
                ControlPointWithTwoMarks cpwtm = this.loadControlPointWithTwoMarks((Document)dbObject.get((Object)FieldNames.CONTROLPOINT_VALUE.name()));
                controlPoint = cpwtm;
            }
        }
        return new Util.Pair(controlPoint, (Object)migrated);
    }

    private ControlPointWithTwoMarks loadControlPointWithTwoMarks(Document dbObject) {
        Document dbLeft;
        Serializable controlPointId;
        String controlPointName = (String)dbObject.get((Object)FieldNames.CONTROLPOINTWITHTWOMARKS_NAME.name());
        if (controlPointName == null) {
            controlPointName = (String)dbObject.get((Object)FieldNames.GATE_NAME.name());
            logger.info("Migrating name of ControlPointWithTwoMarks " + controlPointName + " from GATE_NAME to new field CONTROLPOINTWITHTWOMARKS_NAME.");
            dbObject.put(FieldNames.CONTROLPOINTWITHTWOMARKS_NAME.name(), (Object)controlPointName);
            dbObject.remove((Object)FieldNames.GATE_NAME.name());
        }
        if ((controlPointId = (Serializable)dbObject.get((Object)FieldNames.CONTROLPOINTWITHTWOMARKS_ID.name())) == null) {
            controlPointId = (Serializable)dbObject.get((Object)FieldNames.GATE_ID.name());
            logger.info("Migrating id of ControlPointWithTwoMarks " + controlPointName + " from old field GATE_ID to CONTROLPOINTWITHTWOMARKS_ID.");
            dbObject.put(FieldNames.CONTROLPOINTWITHTWOMARKS_ID.name(), (Object)controlPointId);
            dbObject.remove((Object)FieldNames.GATE_ID.name());
        }
        if ((dbLeft = (Document)dbObject.get((Object)FieldNames.CONTROLPOINTWITHTWOMARKS_LEFT.name())) == null) {
            dbLeft = (Document)dbObject.get((Object)FieldNames.GATE_LEFT.name());
            logger.info("Migrating left Mark of ControlPointWithTwoMarks " + controlPointName + " from old field GATE_LEFT to CONTROLPOINTWITHTWOMARKS_LEFT");
            dbObject.put(FieldNames.CONTROLPOINTWITHTWOMARKS_LEFT.name(), (Object)dbLeft);
            dbObject.remove((Object)FieldNames.GATE_LEFT.name());
        }
        Mark leftMark = this.loadMark(dbLeft);
        Document dbRight = (Document)dbObject.get((Object)FieldNames.CONTROLPOINTWITHTWOMARKS_RIGHT.name());
        if (dbRight == null) {
            dbRight = (Document)dbObject.get((Object)FieldNames.GATE_RIGHT.name());
            logger.info("Migrating right Mark of ControlPointWithTwoMarks " + controlPointName + " from old field GATE_RIGHT to CONTROLPOINTWITHTWOMARKS_RIGHT");
            dbObject.put(FieldNames.CONTROLPOINTWITHTWOMARKS_RIGHT.name(), (Object)dbRight);
            dbObject.remove((Object)FieldNames.GATE_RIGHT.name());
        }
        Mark rightMark = this.loadMark(dbRight);
        String shortName = (String)dbObject.get((Object)FieldNames.CONTROLPOINTWITHTWOMARKS_SHORT_NAME.name());
        if (shortName == null || shortName.isEmpty()) {
            shortName = controlPointName;
        }
        ControlPointWithTwoMarks gate = this.baseDomainFactory.createControlPointWithTwoMarks(controlPointId, leftMark, rightMark, controlPointName, shortName);
        return gate;
    }

    private Mark loadMark(Document dbObject) {
        Serializable markId = (Serializable)dbObject.get((Object)FieldNames.MARK_ID.name());
        String markColorAsString = (String)dbObject.get((Object)FieldNames.MARK_COLOR.name());
        Color markColor = AbstractColor.getCssColor((String)markColorAsString);
        String markName = (String)dbObject.get((Object)FieldNames.MARK_NAME.name());
        String markShortName = (String)dbObject.get((Object)FieldNames.MARK_SHORT_NAME.name());
        String markPattern = (String)dbObject.get((Object)FieldNames.MARK_PATTERN.name());
        String markShape = (String)dbObject.get((Object)FieldNames.MARK_SHAPE.name());
        Object markTypeRaw = dbObject.get((Object)FieldNames.MARK_TYPE.name());
        Object originatingMarkTemplateIdObject = dbObject.get((Object)FieldNames.MARK_ORIGINATING_MARK_TEMPLATE_ID.name());
        UUID originatingMarkTemplateId = originatingMarkTemplateIdObject == null ? null : UUID.fromString(originatingMarkTemplateIdObject.toString());
        Object originatingMarkPropertiesIdObject = dbObject.get((Object)FieldNames.MARK_ORIGINATING_MARK_PROPERTIES_ID.name());
        UUID originatingMarkPropertiesId = originatingMarkPropertiesIdObject == null ? null : UUID.fromString(originatingMarkPropertiesIdObject.toString());
        MarkType markType = markTypeRaw == null ? null : MarkType.valueOf((String)((String)markTypeRaw));
        Mark mark = this.baseDomainFactory.getOrCreateMark(markId, markName, markShortName, markType, markColor, markShape, markPattern, originatingMarkTemplateId, originatingMarkPropertiesId);
        return mark;
    }

    @Override
    public Collection<DynamicCompetitor> loadAllCompetitors() {
        HashMap<Serializable, DynamicCompetitor> competitorsById = new HashMap<Serializable, DynamicCompetitor>();
        MongoCollection collection = this.database.getCollection(CollectionNames.COMPETITORS.name());
        JsonWriterSettings writerSettings = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build();
        for (Document o : collection.find()) {
            try {
                JSONObject json = Helpers.toJSONObjectSafe((Object)new JSONParser().parse(o.toJson(writerSettings)));
                DynamicCompetitor c = this.competitorWithBoatRefDeserializer.deserialize(json);
                if (competitorsById.containsKey(c.getId())) {
                    collection.deleteOne((Bson)o);
                    continue;
                }
                competitorsById.put(c.getId(), c);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load competitors: " + o.toString());
                logger.log(Level.SEVERE, "loadCompetitors", e);
            }
        }
        return competitorsById.values();
    }

    @Override
    public Iterable<CompetitorWithBoat> migrateLegacyCompetitorsIfRequired() {
        Document oneCompetitorDbObject;
        Object boatObject;
        long competitorCount;
        HashMap<Serializable, CompetitorWithBoat> competitorsById = null;
        boolean competitorsCollectionExist = false;
        boolean boatsCollectionCollectionExist = false;
        for (String collectionName : this.database.listCollectionNames()) {
            if (collectionName.equals(CollectionNames.COMPETITORS.name())) {
                competitorsCollectionExist = true;
            }
            if (!collectionName.equals(CollectionNames.BOATS.name())) continue;
            boatsCollectionCollectionExist = true;
        }
        MongoCollection orginalCompetitorCollection = this.database.getCollection(CollectionNames.COMPETITORS.name());
        if (competitorsCollectionExist && !boatsCollectionCollectionExist && (competitorCount = orginalCompetitorCollection.countDocuments()) > 0L && (boatObject = (oneCompetitorDbObject = (Document)orginalCompetitorCollection.find().first()).get((Object)"boat")) != null) {
            logger.log(Level.INFO, "Bug2822 DB-Migration: Rename COMPETITORS collection to COMPETITORS_BAK.");
            competitorsById = new HashMap<Serializable, CompetitorWithBoat>();
            orginalCompetitorCollection.renameCollection(new MongoNamespace(this.database.getName(), CollectionNames.COMPETITORS_BAK.name()), new RenameCollectionOptions().dropTarget(true));
            MongoCollection collection = this.database.getCollection(CollectionNames.COMPETITORS_BAK.name());
            try {
                logger.log(Level.INFO, "Bug2822 DB-Migration: Load old competitors with embedded boats from COMPETITORS_BAK.");
                JsonWriterSettings writerSettings = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build();
                for (Document o : collection.find()) {
                    JSONObject json = Helpers.toJSONObjectSafe((Object)new JSONParser().parse(o.toJson(writerSettings)));
                    CompetitorWithBoat c = this.legacyCompetitorWithBoatDeserializer.deserialize(json);
                    if (competitorsById.containsKey(c.getId())) continue;
                    competitorsById.put(c.getId(), c);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Bug2822 DB-Migration: Error connecting to MongoDB, unable to load competitors.");
                logger.log(Level.SEVERE, "Bug2822 DB-Migration: renameCompetitorsCollectionAndloadAllLegacyCompetitors", e);
            }
        }
        return competitorsById == null ? null : competitorsById.values();
    }

    @Override
    public Collection<DynamicBoat> loadAllBoats() {
        ArrayList<DynamicBoat> result = new ArrayList<DynamicBoat>();
        MongoCollection collection = this.database.getCollection(CollectionNames.BOATS.name());
        try {
            JsonWriterSettings writerSettings = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build();
            for (Document o : collection.find()) {
                JSONObject json = Helpers.toJSONObjectSafe((Object)new JSONParser().parse(o.toJson(writerSettings)));
                DynamicBoat b = this.boatDeserializer.deserialize(json);
                result.add(b);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load boats.");
            logger.log(Level.SEVERE, "loadBoats", e);
        }
        return result;
    }

    @Override
    public Iterable<DeviceConfiguration> loadAllDeviceConfigurations() {
        ArrayList<DeviceConfiguration> result = new ArrayList<DeviceConfiguration>();
        MongoCollection configurationCollection = this.database.getCollection(CollectionNames.CONFIGURATIONS.name());
        try {
            for (Document dbObject : configurationCollection.find()) {
                DeviceConfiguration entry = this.loadConfigurationEntry(dbObject);
                result.add(entry);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load configurations.");
            logger.log(Level.SEVERE, "loadAllDeviceConfigurations", e);
        }
        return result;
    }

    private DeviceConfiguration loadConfigurationEntry(Document dbObject) throws JsonDeserializationException, ParseException {
        DeviceConfiguration configuration;
        String idAsString = dbObject.getString((Object)FieldNames.CONFIGURATION_ID_AS_STRING.name());
        if (idAsString == null) {
            String oldCombinedName = dbObject.getString((Object)FieldNames.CONFIGURATION_MATCHER_ID.name());
            String name = oldCombinedName.substring("DeviceConfigurationMatcherSingle".length());
            UUID id = UUID.randomUUID();
            logger.info("Migrating configuration with old matcher ID " + oldCombinedName + " to config with ID " + id + " with name " + name);
            Document configObject = (Document)dbObject.get((Object)FieldNames.CONFIGURATION_CONFIG.name());
            configObject.put("idAsString", (Object)id.toString());
            configObject.put("name", (Object)name);
            configuration = this.loadConfiguration(configObject);
            DeleteResult deleteResult = this.database.getCollection(CollectionNames.CONFIGURATIONS.name()).deleteOne((Bson)new Document(FieldNames.CONFIGURATION_MATCHER_ID.name(), (Object)oldCombinedName));
            if (deleteResult.getDeletedCount() != 1L) {
                logger.warning("Expected to delete device configuration " + oldCombinedName + ", but couldn't delete any");
            }
            new MongoObjectFactoryImpl(this.database).storeDeviceConfiguration(configuration);
        } else {
            configuration = this.loadConfiguration(dbObject);
        }
        return configuration;
    }

    private DeviceConfiguration loadConfiguration(Document configObject) throws JsonDeserializationException, ParseException {
        DeviceConfiguration configuration = null;
        JsonWriterSettings writerSettings = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build();
        DeviceConfigurationJsonDeserializer deserializer = DeviceConfigurationJsonDeserializer.create();
        JSONObject json = Helpers.toJSONObjectSafe((Object)new JSONParser().parse(configObject.toJson(writerSettings)));
        configuration = (DeviceConfiguration)deserializer.deserialize(json);
        return configuration;
    }

    @Override
    public Map<String, Set<URL>> loadResultUrls() {
        HashMap<String, Set<URL>> resultUrls = new HashMap<String, Set<URL>>();
        MongoCollection resultUrlCollection = this.database.getCollection(CollectionNames.RESULT_URLS.name());
        for (Document dbObject : resultUrlCollection.find()) {
            URL url;
            String providerName = (String)dbObject.get((Object)FieldNames.RESULT_PROVIDERNAME.name());
            String urlString = (String)dbObject.get((Object)FieldNames.RESULT_URL.name());
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, "Failed to parse result Url String: " + urlString + ". Did not load url!");
                continue;
            }
            if (!resultUrls.containsKey(providerName)) {
                resultUrls.put(providerName, new HashSet());
            }
            Set set = (Set)resultUrls.get(providerName);
            set.add(url);
        }
        return resultUrls;
    }

    private ImageDescriptor loadImage(Document dbObject) {
        ImageDescriptorImpl image = null;
        URL imageURL = this.loadURL(dbObject, FieldNames.IMAGE_URL);
        if (imageURL != null) {
            String title = (String)dbObject.get((Object)FieldNames.IMAGE_TITLE.name());
            String subtitle = (String)dbObject.get((Object)FieldNames.IMAGE_SUBTITLE.name());
            String copyright = (String)dbObject.get((Object)FieldNames.IMAGE_COPYRIGHT.name());
            String localeRaw = (String)dbObject.get((Object)FieldNames.IMAGE_LOCALE.name());
            Locale locale = localeRaw != null ? Locale.forLanguageTag(localeRaw) : null;
            Number imageWidth = (Number)dbObject.get((Object)FieldNames.IMAGE_WIDTH_IN_PX.name());
            Number imageHeight = (Number)dbObject.get((Object)FieldNames.IMAGE_HEIGHT_IN_PX.name());
            TimePoint createdAtDate = DomainObjectFactoryImpl.loadTimePoint(dbObject, FieldNames.IMAGE_CREATEDATDATE);
            Iterable tags = (Iterable)dbObject.get((Object)FieldNames.IMAGE_TAGS.name());
            ArrayList<String> imageTags = new ArrayList<String>();
            if (tags != null) {
                for (Object tagObject : tags) {
                    imageTags.add((String)tagObject);
                }
            }
            image = new ImageDescriptorImpl(imageURL, createdAtDate);
            image.setCopyright(copyright);
            image.setTitle(title);
            image.setSubtitle(subtitle);
            image.setLocale(locale);
            image.setTags(imageTags);
            if (imageWidth != null && imageHeight != null) {
                image.setSize(Integer.valueOf(imageWidth.intValue()), Integer.valueOf(imageHeight.intValue()));
            }
        }
        return image;
    }

    private VideoDescriptor loadVideo(Document dbObject) {
        VideoDescriptorImpl video = null;
        URL videoURL = this.loadURL(dbObject, FieldNames.VIDEO_URL);
        if (videoURL != null) {
            String title = (String)dbObject.get((Object)FieldNames.VIDEO_TITLE.name());
            String subtitle = (String)dbObject.get((Object)FieldNames.VIDEO_SUBTITLE.name());
            String copyright = (String)dbObject.get((Object)FieldNames.VIDEO_COPYRIGHT.name());
            Object mimeTypeRaw = dbObject.get((Object)FieldNames.VIDEO_MIMETYPE.name());
            MimeType mimeType = mimeTypeRaw == null ? null : MimeType.valueOf((String)((String)mimeTypeRaw));
            String localeRaw = (String)dbObject.get((Object)FieldNames.VIDEO_LOCALE.name());
            Locale locale = localeRaw != null ? Locale.forLanguageTag(localeRaw) : null;
            TimePoint createdAtDate = DomainObjectFactoryImpl.loadTimePoint(dbObject, FieldNames.VIDEO_CREATEDATDATE);
            Iterable tags = (Iterable)dbObject.get((Object)FieldNames.VIDEO_TAGS.name());
            Number lengthInSeconds = (Number)dbObject.get((Object)FieldNames.VIDEO_LENGTH_IN_SECONDS.name());
            URL thumbnailURL = this.loadURL(dbObject, FieldNames.VIDEO_THUMBNAIL_URL);
            ArrayList<String> videoTags = new ArrayList<String>();
            if (tags != null) {
                for (Object tagObject : tags) {
                    videoTags.add((String)tagObject);
                }
            }
            video = new VideoDescriptorImpl(videoURL, mimeType, createdAtDate);
            video.setCopyright(copyright);
            video.setTitle(title);
            video.setSubtitle(subtitle);
            video.setLocale(locale);
            video.setTags(videoTags);
            video.setLengthInSeconds(lengthInSeconds == null ? null : Integer.valueOf(lengthInSeconds.intValue()));
            video.setThumbnailURL(thumbnailURL);
        }
        return video;
    }

    private URL loadURL(Document dbObject, FieldNames field) {
        URL result = null;
        String urlAsString = (String)dbObject.get((Object)field.name());
        if (urlAsString != null) {
            try {
                result = new URL(urlAsString);
            }
            catch (MalformedURLException e) {
                logger.severe("Error parsing URL '" + urlAsString + "' in field " + field.name() + ".");
            }
        }
        return result;
    }

    private boolean loadLegacyImageAndVideoURLs(Event event, Document eventDBObject) {
        Iterable sponsorImageURLsJson;
        Iterable videoURLsJson;
        Iterable imageURLsJson;
        URL logoImageURL = null;
        ArrayList<URL> imageURLs = new ArrayList<URL>();
        ArrayList<URL> sponsorImageURLs = new ArrayList<URL>();
        ArrayList<URL> videoURLs = new ArrayList<URL>();
        String logoImageURLAsString = (String)eventDBObject.get((Object)FieldNames.EVENT_LOGO_IMAGE_URL.name());
        if (logoImageURLAsString != null) {
            try {
                logoImageURL = new URL(logoImageURLAsString);
            }
            catch (MalformedURLException e) {
                logger.severe("Error parsing logo image URL " + logoImageURLAsString + " for event " + event.getName() + ". Ignoring this URL.");
            }
        }
        if ((imageURLsJson = (Iterable)eventDBObject.get((Object)FieldNames.EVENT_IMAGE_URLS.name())) != null) {
            for (Object imageURL : imageURLsJson) {
                try {
                    imageURLs.add(new URL((String)imageURL));
                }
                catch (MalformedURLException e) {
                    logger.severe("Error parsing image URL " + imageURL + " for event " + event.getName() + ". Ignoring this image URL.");
                }
            }
        }
        if ((videoURLsJson = (Iterable)eventDBObject.get((Object)FieldNames.EVENT_VIDEO_URLS.name())) != null) {
            for (Object videoURL : videoURLsJson) {
                try {
                    videoURLs.add(new URL((String)videoURL));
                }
                catch (MalformedURLException e) {
                    logger.severe("Error parsing video URL " + videoURL + " for event " + event.getName() + ". Ignoring this video URL.");
                }
            }
        }
        if ((sponsorImageURLsJson = (Iterable)eventDBObject.get((Object)FieldNames.EVENT_SPONSOR_IMAGE_URLS.name())) != null) {
            for (Object sponsorImageURL : sponsorImageURLsJson) {
                try {
                    sponsorImageURLs.add(new URL((String)sponsorImageURL));
                }
                catch (MalformedURLException e) {
                    logger.severe("Error parsing sponsor image URL " + sponsorImageURL + " for event " + event.getName() + ". Ignoring this sponsor image URL.");
                }
            }
        }
        return event.setMediaURLs(imageURLs, sponsorImageURLs, videoURLs, logoImageURL, Collections.emptyMap());
    }

    private boolean loadLegacySailorsInfoWebsiteURL(Event event, Document eventDBObject) {
        boolean modified;
        String sailorsInfoWebSiteURLAsString = (String)eventDBObject.get((Object)FieldNames.EVENT_SAILORS_INFO_WEBSITE_URL.name());
        if (sailorsInfoWebSiteURLAsString != null) {
            try {
                if (!event.hasSailorsInfoWebsiteURL(null)) {
                    String englishURL = String.valueOf(sailorsInfoWebSiteURLAsString) + (sailorsInfoWebSiteURLAsString.endsWith("/") ? "" : "/") + "en";
                    event.setSailorsInfoWebsiteURL(null, new URL(englishURL));
                }
                if (!event.hasSailorsInfoWebsiteURL(Locale.GERMAN)) {
                    event.setSailorsInfoWebsiteURL(Locale.GERMAN, new URL(sailorsInfoWebSiteURLAsString));
                }
            }
            catch (MalformedURLException e) {
                logger.severe("Error parsing sailors info website URL " + sailorsInfoWebSiteURLAsString + " for event " + event.getName() + ". Ignoring this URL.");
            }
            modified = true;
        } else {
            modified = false;
        }
        return modified;
    }

    @Override
    public DomainObjectFactory.ConnectivityParametersLoadingResult loadConnectivityParametersForRacesToRestore(Consumer<RaceTrackingConnectivityParameters> callback) {
        MongoCollection collection = this.database.getCollection(CollectionNames.CONNECTIVITY_PARAMS_FOR_RACES_TO_BE_RESTORED.name());
        FindIterable cursor = collection.find();
        final long count = collection.countDocuments();
        logger.info("Restoring " + count + " races");
        ArrayList restoreParameters = new ArrayList();
        Util.addAll((Iterable)cursor, restoreParameters);
        logger.info("Obtained " + restoreParameters.size() + " race parameters to restore");
        ScheduledExecutorService backgroundExecutor = ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor();
        final HashSet<FutureTask<Object>> waiters = new HashSet<FutureTask<Object>>();
        logger.info("Starting to restore races");
        AtomicInteger i = new AtomicInteger();
        for (Document o : restoreParameters) {
            FutureTask<Object> waiter = new FutureTask<Object>(() -> {
                String type = (String)o.get((Object)"type");
                int finalI = i.incrementAndGet();
                logger.info("Applying to restore race #" + finalI + "/" + count + " of type " + type);
                this.raceTrackingConnectivityParamsServiceFinder.applyServiceWhenAvailable(type, connectivityParamsPersistenceService -> {
                    logger.info("Restoring race #" + finalI + "/" + count + " of type " + type);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String key : o.keySet()) {
                        if (key.equals("type")) continue;
                        map.put(key, o.get((Object)key));
                    }
                    try {
                        RaceTrackingConnectivityParameters params = connectivityParamsPersistenceService.mapTo(map);
                        if (params != null) {
                            callback.accept(params);
                            logger.info("Done restoring race #" + finalI + "/" + count + " of type " + type);
                        } else {
                            logger.warning("Couldn't restore race #" + finalI + "/" + count + " of type " + type + " with parameters " + o + " because the parameters loaded from the DB couldn't be mapped. Maybe the owning leaderboard was removed?" + " Removing this parameter set from the list of races to restore. The server will make no further attempt to restore this race.");
                            collection.deleteOne((Bson)o);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Exception trying to load race #" + finalI + "/" + count + " of type " + type + " from restore connectivity parameters " + o + " with handler " + connectivityParamsPersistenceService + ". Removing this parameter set from the list of races to restore." + " The server will make no further attempt to restore this race: " + o, e);
                        collection.deleteOne((Bson)o);
                    }
                });
            }, null);
            waiters.add(waiter);
            backgroundExecutor.execute(waiter);
        }
        logger.info("Done restoring races; restored " + i + " of " + count + " races");
        return new DomainObjectFactory.ConnectivityParametersLoadingResult(){

            @Override
            public long getNumberOfParametersToLoad() {
                return count;
            }

            @Override
            public void waitForCompletionOfCallbacksForAllParameters() throws InterruptedException, ExecutionException {
                for (FutureTask waiter : waiters) {
                    waiter.get();
                }
            }
        };
    }

    public Map<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>> getAnniversaryData() throws MalformedURLException {
        HashMap<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>> fromDb = new HashMap<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>>();
        MongoCollection anniversarysStored = this.database.getCollection(CollectionNames.ANNIVERSARIES.name());
        for (Document toLoad : anniversarysStored.find()) {
            String leaderboardName = toLoad.get((Object)FieldNames.LEADERBOARD_NAME.name()).toString();
            String eventID = toLoad.get((Object)FieldNames.EVENT_ID.name()).toString();
            Object mongoDisplayName = toLoad.get((Object)FieldNames.LEADERBOARD_DISPLAY_NAME.name());
            String leaderboardDisplayName = mongoDisplayName == null ? null : mongoDisplayName.toString();
            Object mongoEventName = toLoad.get((Object)FieldNames.EVENT_NAME.name());
            String eventName = mongoEventName == null ? null : mongoEventName.toString();
            MillisecondsTimePoint startOfRace = new MillisecondsTimePoint(((Number)toLoad.get((Object)FieldNames.START_OF_RACE.name())).longValue());
            String race = toLoad.get((Object)FieldNames.RACE_NAME.name()).toString();
            String regatta = toLoad.get((Object)FieldNames.REGATTA_NAME.name()).toString();
            Object rurl = toLoad.get((Object)FieldNames.REMOTE_URL.name());
            URL remoteUrlOrNull = rurl != null ? new URL(rurl.toString()) : null;
            Object typeJson = toLoad.get((Object)FieldNames.EVENT_TYPE.name());
            EventType eventType = typeJson == null ? null : EventType.valueOf((String)typeJson.toString());
            DetailedRaceInfo loadedAnniversary = new DetailedRaceInfo((RegattaAndRaceIdentifier)new RegattaNameAndRaceName(regatta, race), leaderboardName, leaderboardDisplayName, (TimePoint)startOfRace, UUID.fromString(eventID), eventName, eventType, remoteUrlOrNull);
            int anniversary = ((Number)toLoad.get((Object)FieldNames.ANNIVERSARY_NUMBER.name())).intValue();
            String type = toLoad.get((Object)FieldNames.ANNIVERSARY_TYPE.name()).toString();
            fromDb.put(anniversary, (Util.Pair<DetailedRaceInfo, AnniversaryType>)new Util.Pair((Object)loadedAnniversary, (Object)AnniversaryType.valueOf((String)type)));
        }
        return fromDb;
    }

    @Override
    public TypeBasedServiceFinder<RaceTrackingConnectivityParametersHandler> getRaceTrackingConnectivityParamsServiceFinder() {
        return this.raceTrackingConnectivityParamsServiceFinder;
    }

    @Override
    public Map<RaceIdentifier, MarkPassingRaceFingerprint> loadFingerprintsForMarkPassingHashes() {
        MongoCollection markPassingsCollection = this.database.getCollection(CollectionNames.MARKPASSINGS.name());
        markPassingsCollection.createIndex((Bson)new Document().append(FieldNames.EVENT_NAME.name(), (Object)1).append(FieldNames.RACE_NAME.name(), (Object)1), new IndexOptions().unique(true).name("markpassingsbyeventandrace").background(false));
        HashMap<RaceIdentifier, MarkPassingRaceFingerprint> fingerprintHashMap = new HashMap<RaceIdentifier, MarkPassingRaceFingerprint>();
        for (Document currentDocument : markPassingsCollection.find()) {
            Util.Pair<RaceIdentifier, MarkPassingRaceFingerprint> fingerprint = this.loadMarkPassingsFingerprint(currentDocument);
            if (fingerprint == null || fingerprint.getB() == null) continue;
            fingerprintHashMap.put((RaceIdentifier)fingerprint.getA(), (MarkPassingRaceFingerprint)fingerprint.getB());
        }
        return fingerprintHashMap;
    }

    private Util.Pair<RaceIdentifier, MarkPassingRaceFingerprint> loadMarkPassingsFingerprint(Document currentDocument) {
        MarkPassingRaceFingerprint fingerprint;
        RaceIdentifier raceIdentifier = this.loadRaceIdentifier(currentDocument);
        try {
            JSONObject json = Helpers.toJSONObjectSafe((Object)new JSONParser().parse(((Document)currentDocument.get((Object)FieldNames.MARK_PASSINGS_FINGERPRINT.name())).toJson()));
            fingerprint = (MarkPassingRaceFingerprint)MarkPassingRaceFingerprintFactory.INSTANCE.fromJson(json);
        }
        catch (JsonDeserializationException | ParseException e) {
            logger.log(Level.WARNING, "Problem de-serializing mark passings from document; ignoring", e);
            fingerprint = null;
        }
        return new Util.Pair((Object)raceIdentifier, fingerprint);
    }

    @Override
    public Map<Competitor, Map<Waypoint, MarkPassing>> loadMarkPassings(RaceIdentifier raceIdentifier, Course course) {
        HashMap<Competitor, Map<Waypoint, MarkPassing>> result;
        Document query = new Document();
        DomainObjectFactoryImpl.addRaceIdentifierToQuery(query, raceIdentifier);
        MongoCollection markPassingsCollection = this.database.getCollection(CollectionNames.MARKPASSINGS.name());
        Document doc = (Document)markPassingsCollection.find((Bson)query).first();
        if (doc != null) {
            result = new HashMap<Competitor, Map<Waypoint, MarkPassing>>();
            List markPassingsDoc = doc.getList((Object)FieldNames.MARK_PASSINGS.name(), Document.class);
            for (Document markPassingsForOneCompetitorDoc : markPassingsDoc) {
                Serializable competitorId = (Serializable)markPassingsForOneCompetitorDoc.get((Object)FieldNames.COMPETITOR_ID.name(), Serializable.class);
                Competitor competitor = this.baseDomainFactory.getExistingCompetitorById(competitorId);
                for (Document markPassingForWaypoint : markPassingsForOneCompetitorDoc.getList((Object)FieldNames.MARK_PASSINGS.name(), Document.class)) {
                    Util.Pair<Waypoint, MarkPassing> waypointAndMarkPassing = this.loadWaypointAndMarkPassing(competitor, markPassingForWaypoint, course);
                    result.computeIfAbsent(competitor, c -> new HashMap()).put((Waypoint)waypointAndMarkPassing.getA(), (MarkPassing)waypointAndMarkPassing.getB());
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    private Util.Pair<Waypoint, MarkPassing> loadWaypointAndMarkPassing(Competitor competitor, Document markPassingForWaypoint, Course course) {
        int waypointIndex = markPassingForWaypoint.getInteger((Object)FieldNames.INDEX_OF_PASSED_WAYPOINT.name());
        Waypoint waypoint = (Waypoint)Util.get((Iterable)course.getWaypoints(), (int)waypointIndex);
        TimePoint timePoint = TimePoint.of((Long)markPassingForWaypoint.getLong((Object)FieldNames.TIME_AS_MILLIS.name()));
        MarkPassingImpl markPassing = new MarkPassingImpl(timePoint, waypoint, competitor);
        return new Util.Pair((Object)waypoint, (Object)markPassing);
    }

    private Util.Pair<RaceIdentifier, ManeuverRaceFingerprint> loadManeuversFingerprint(Document currentDocument) {
        ManeuverRaceFingerprint fingerprint;
        RaceIdentifier raceIdentifier = this.loadRaceIdentifier(currentDocument);
        try {
            JSONObject json = Helpers.toJSONObjectSafe((Object)new JSONParser().parse(((Document)currentDocument.get((Object)FieldNames.MANEUVER_FINGERPRINT.name())).toJson()));
            fingerprint = (ManeuverRaceFingerprint)ManeuverRaceFingerprintFactory.INSTANCE.fromJson(json);
        }
        catch (JsonDeserializationException | ParseException e) {
            logger.log(Level.WARNING, "Problem de-serializing maneuvers from document; ignoring", e);
            fingerprint = null;
        }
        return new Util.Pair((Object)raceIdentifier, fingerprint);
    }

    @Override
    public Map<RaceIdentifier, ManeuverRaceFingerprint> loadFingerprintsForManeuverHashes() {
        MongoCollection maneuversCollection = this.database.getCollection(CollectionNames.MANEUVERS.name());
        maneuversCollection.createIndex((Bson)new Document().append(FieldNames.EVENT_NAME.name(), (Object)1).append(FieldNames.RACE_NAME.name(), (Object)1), new IndexOptions().unique(true).name("maneuversbyeventandrace").background(false));
        HashMap<RaceIdentifier, ManeuverRaceFingerprint> fingerprintHashMap = new HashMap<RaceIdentifier, ManeuverRaceFingerprint>();
        for (Document currentDocument : maneuversCollection.find()) {
            Util.Pair<RaceIdentifier, ManeuverRaceFingerprint> fingerprint = this.loadManeuversFingerprint(currentDocument);
            if (fingerprint == null || fingerprint.getB() == null) continue;
            fingerprintHashMap.put((RaceIdentifier)fingerprint.getA(), (ManeuverRaceFingerprint)fingerprint.getB());
        }
        return fingerprintHashMap;
    }

    @Override
    public Map<Competitor, List<Maneuver>> loadManeuvers(TrackedRace trackedRace, Course course) {
        HashMap<Competitor, List<Maneuver>> result;
        Document query = new Document();
        RegattaAndRaceIdentifier raceIdentifier = trackedRace.getRaceIdentifier();
        DomainObjectFactoryImpl.addRaceIdentifierToQuery(query, (RaceIdentifier)raceIdentifier);
        MongoCollection maneuversCollection = this.database.getCollection(CollectionNames.MANEUVERS.name());
        Document doc = (Document)maneuversCollection.find((Bson)query).first();
        if (doc != null) {
            result = new HashMap<Competitor, List<Maneuver>>();
            List maneuversDoc = doc.getList((Object)FieldNames.MANEUVERS.name(), Document.class);
            for (Document maneuversForOneCompetitorDoc : maneuversDoc) {
                Serializable competitorId = (Serializable)maneuversForOneCompetitorDoc.get((Object)FieldNames.COMPETITOR_ID.name(), Serializable.class);
                Competitor competitor = this.baseDomainFactory.getExistingCompetitorById(competitorId);
                for (Document maneuverDoc : maneuversForOneCompetitorDoc.getList((Object)FieldNames.MANEUVERS.name(), Document.class)) {
                    Maneuver maneuver = this.loadManeuver(competitor, maneuverDoc, course, trackedRace);
                    result.computeIfAbsent(competitor, c -> new ArrayList()).add(maneuver);
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    private Maneuver loadManeuver(Competitor competitor, Document maneuverDoc, Course course, TrackedRace trackedRace) {
        TimePoint timePoint = TimePoint.of((Long)maneuverDoc.getLong((Object)FieldNames.TIMEPOINT.name()));
        double maxTurningRateInDegreesPerSecond = maneuverDoc.getDouble((Object)FieldNames.MAX_TURNING_RATE_IN_DEGREE_PER_SECOUND.name());
        String typeName = maneuverDoc.getString((Object)FieldNames.TYPE.name());
        ManeuverType type = ManeuverType.valueOf((String)typeName);
        String newTackName = maneuverDoc.getString((Object)FieldNames.TACK.name());
        Tack newTack = Tack.valueOf((String)newTackName);
        int waypointIndex = maneuverDoc.getInteger((Object)FieldNames.INDEX_OF_PASSED_WAYPOINT.name());
        double positionLatRad = maneuverDoc.getDouble((Object)FieldNames.POSITION_LAT_RAD.name());
        double positionLngRad = maneuverDoc.getDouble((Object)FieldNames.POSITION_LNG_RAD.name());
        RadianPosition position = new RadianPosition(positionLatRad, positionLngRad);
        ManeuverCurveBoundaries mainCurveBoundaries = this.loadManeuverCurveBoundaries((Document)maneuverDoc.get((Object)FieldNames.MAIN_CURVE_BOUNDARIES.name()));
        ManeuverCurveBoundaries maneuverCurveWithStableSpeedAndCourseBoundaries = this.loadManeuverCurveBoundaries((Document)maneuverDoc.get((Object)FieldNames.MANEUVER_CURVE_WITH_STABLE_SPEED_AND_COURSE_BOUNDERIES.name()));
        ManeuverLoss maneuverLoss = this.loadManeuverLoss((Document)maneuverDoc.get((Object)FieldNames.MANEUVER_LOSS.name()));
        MarkPassingProxy markPassing = waypointIndex == -1 ? null : new MarkPassingProxy(timePoint, waypointIndex, competitor.getId(), trackedRace);
        return new ManeuverWithMainCurveBoundariesImpl(type, newTack, (Position)position, timePoint, mainCurveBoundaries, maneuverCurveWithStableSpeedAndCourseBoundaries, maxTurningRateInDegreesPerSecond, (MarkPassing)markPassing, maneuverLoss);
    }

    private ManeuverLoss loadManeuverLoss(Document document) {
        ManeuverLoss maneuverLoss;
        if (document != null) {
            Double distanceDouble = document.getDouble((Object)FieldNames.MANEUVER_DISTANCE_SAILED_POMA.name());
            MeterDistance distance = new MeterDistance(distanceDouble.doubleValue());
            MeterDistance distanceIfNorManeuvering = new MeterDistance(document.getDouble((Object)FieldNames.MANEUVER_DISTANCE_SAILED_INMPOMA.name()).doubleValue());
            double startPositionLatRad = document.getDouble((Object)FieldNames.MANEUVER_START_POSITION_LAT_RAD.name());
            double startPositionLngRad = document.getDouble((Object)FieldNames.MANEUVER_START_POSITION_LNG_RAD.name());
            RadianPosition startPosition = new RadianPosition(startPositionLatRad, startPositionLngRad);
            double endPositionLatRad = document.getDouble((Object)FieldNames.MANEUVER_END_POSITION_LAT_RAD.name());
            double endPositionLngRad = document.getDouble((Object)FieldNames.MANEUVER_END_POSITION_LNG_RAD.name());
            RadianPosition endPosition = new RadianPosition(endPositionLatRad, endPositionLngRad);
            Duration duration = Duration.ofMillis((long)document.getLong((Object)FieldNames.MANEUVER_LOSS_DURATION.name()));
            Double SpeedWithBearingBeforeDegrees = document.getDouble((Object)FieldNames.MANEUVER_SPEED_WITH_BEARING_BEFORE_DEGREES.name());
            Double SpeedWithBearingBeforeSpeed = document.getDouble((Object)FieldNames.MANEUVER_SPEED_WITH_BEARING_BEFORE_SPEED.name());
            DegreeBearingImpl bearingBefore = new DegreeBearingImpl(SpeedWithBearingBeforeDegrees.doubleValue());
            KnotSpeedWithBearingImpl SpeedWithBearingBefore = new KnotSpeedWithBearingImpl(SpeedWithBearingBeforeSpeed.doubleValue(), (Bearing)bearingBefore);
            DegreeBearingImpl middeManeuverAngle = new DegreeBearingImpl(document.getDouble((Object)FieldNames.MIDDLE_MAEUVER_ANGLE.name()).doubleValue());
            maneuverLoss = new ManeuverLoss((Distance)distance, (Distance)distanceIfNorManeuvering, (Position)startPosition, (Position)endPosition, duration, (SpeedWithBearing)SpeedWithBearingBefore, (Bearing)middeManeuverAngle);
        } else {
            maneuverLoss = null;
        }
        return maneuverLoss;
    }

    private ManeuverCurveBoundaries loadManeuverCurveBoundaries(Document document) {
        TimePoint timePointBefore = TimePoint.of((Long)document.getLong((Object)FieldNames.MANEUVER_TIMEPOINT_BEFORE.name()));
        TimePoint timePointAfter = TimePoint.of((Long)document.getLong((Object)FieldNames.MANEUVER_TIMEPOINT_AFTER.name()));
        Double SpeedWithBearingBeforeDegrees = document.getDouble((Object)FieldNames.MANEUVER_SPEED_WITH_BEARING_BEFORE_DEGREES.name());
        Double SpeedWithBearingBeforeSpeed = document.getDouble((Object)FieldNames.MANEUVER_SPEED_WITH_BEARING_BEFORE_SPEED.name());
        DegreeBearingImpl bearingBefore = new DegreeBearingImpl(SpeedWithBearingBeforeDegrees.doubleValue());
        KnotSpeedWithBearingImpl SpeedWithBearingBefore = new KnotSpeedWithBearingImpl(SpeedWithBearingBeforeSpeed.doubleValue(), (Bearing)bearingBefore);
        Double SpeedWithBearingAfterDegrees = document.getDouble((Object)FieldNames.MANEUVER_SPEED_WITH_BEARING_AFTER_DEGREES.name());
        Double SpeedWithBearingAfterSpeed = document.getDouble((Object)FieldNames.MANEUVER_SPEED_WITH_BEARING_AFTER_SPEED.name());
        DegreeBearingImpl bearingAfter = new DegreeBearingImpl(SpeedWithBearingAfterSpeed.doubleValue());
        KnotSpeedWithBearingImpl SpeedWithBearingAfter = new KnotSpeedWithBearingImpl(SpeedWithBearingAfterDegrees.doubleValue(), (Bearing)bearingAfter);
        double directionChangeInDegrees = document.getDouble((Object)FieldNames.MANEUVER_DIRECTION_CHANGE_IN_DEGREES.name());
        double lowestSpeedDouble = document.getDouble((Object)FieldNames.MANEUVER_LOWEST_SPEED.name());
        KnotSpeedImpl lowestSpeed = new KnotSpeedImpl(lowestSpeedDouble);
        double highestSpeedDouble = document.getDouble((Object)FieldNames.MANEUVER_HIGHEST_SPEED.name());
        KnotSpeedImpl highestSpeed = new KnotSpeedImpl(highestSpeedDouble);
        ManeuverCurveBoundariesImpl maneuverCurveBoundaries = new ManeuverCurveBoundariesImpl(timePointBefore, timePointAfter, (SpeedWithBearing)SpeedWithBearingBefore, (SpeedWithBearing)SpeedWithBearingAfter, directionChangeInDegrees, (Speed)lowestSpeed, (Speed)highestSpeed);
        return maneuverCurveBoundaries;
    }
}

