/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.util;

public class ShipType {
    private static final String[] SPECIAL = new String[]{"Pilot vessel", "Search and rescue vessel", "Tug", "Port tender", "Vessel with anti-pollution capability", "Law enforcement vessel", "Spare - for local vessels", "Spare - for local vessels", "Medical transport", "Ship not party to an armed conflict"};
    private static final String[] FIRST_DIGIT = new String[]{"Not specified", "Reserved for future use", "WIG", "Vessel", "HSC", "See above", "Passenger ship", "Cargo ship", "Tanker", "Other types of ship"};
    private static final String[] SECOND_DIGIT = new String[]{"General", "Category X", "Category Y", "Category Z", "Category OS", "Reserved for future use", "Reserved for future use", "Reserved for future use", "Reserved for future use", "No additional information"};
    private static final String[] VESSEL = new String[]{"Fishing", "Towing", "Towing and exceeding", "Engaged in dredging or underwater operations", "Engaged in diving operations", "Engaged in military operations", "Sailing", "Pleasure craft", "Reserved for future use", "Reserved for future use"};

    public static String shipTypeToString(int type) {
        String typeStr = "N/A";
        if (type >= 0 && type <= 255) {
            if (type >= 200) {
                return "Reserved for future use";
            }
            if (type >= 100) {
                return "Reserved for regional use";
            }
            if (type == 0) {
                return "Not available / no ship";
            }
            int d1 = type / 10;
            int d2 = type % 10;
            if (d1 >= 0 && d1 <= 9 && d2 >= 0 && d2 <= 9) {
                switch (d1) {
                    case 0: {
                        return String.valueOf(FIRST_DIGIT[0]) + " " + Integer.toString(type);
                    }
                    case 3: {
                        return String.valueOf(FIRST_DIGIT[3]) + ", " + VESSEL[d2];
                    }
                    case 5: {
                        return SPECIAL[d2];
                    }
                }
                return String.valueOf(FIRST_DIGIT[d1]) + ", " + SECOND_DIGIT[d2];
            }
        }
        return typeStr;
    }
}

