/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.carousel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.media.AbstractMediaDTO;
import com.sap.sse.gwt.client.media.ImageDTO;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ImageCarousel<TYPE extends ImageDTO>
extends Widget {
    private static SlickSliderUiBinder ourUiBinder = (SlickSliderUiBinder)GWT.create(SlickSliderUiBinder.class);
    private final LinkedList<TYPE> currentImages = new LinkedList();
    private final Map<String, TYPE> imageDataMap = new HashMap<String, TYPE>();
    private boolean showDots = true;
    private boolean centerMode = true;
    private boolean variableWidth = true;
    private boolean infiniteScrolling = true;
    private int contentMarginInPixels = 10;
    private String lazyload = LAZYLOAD.ONDEMAND.getPropertyValue();
    private static final int IMAGES_HEIGHT = 300;
    private int currentSlideIndex = 0;
    private final String uniqueId;
    private FullscreenViewer<TYPE> fsViewer;

    public ImageCarousel() {
        this.setElement((Element)ourUiBinder.createAndBindUi((Object)this));
        this.uniqueId = "slider_" + Document.get().createUniqueId();
        this.getElement().addClassName(this.uniqueId);
    }

    protected void onLoad() {
        super.onLoad();
        this.init();
    }

    public void onClick(EventTarget eventTarget) {
        String key;
        ImageDTO imageData;
        if (this.fsViewer != null && Element.is((JavaScriptObject)eventTarget) && (imageData = (ImageDTO)this.imageDataMap.get(key = ((Element)eventTarget.cast()).getAttribute("src"))) != null) {
            this.fsViewer.show(imageData, this.currentImages);
        }
    }

    native void setupSlider(ImageCarousel<?> var1);

    public void addImage(TYPE image) {
        this.currentImages.add(image);
        String url = ((AbstractMediaDTO)image).getSourceRef();
        int height = ((ImageDTO)image).getHeightInPx();
        int width = ((ImageDTO)image).getWidthInPx();
        DivElement imageHolder = Document.get().createDivElement();
        ImageElement imageElement = Document.get().createImageElement();
        imageElement.setAttribute("data-lazy", UriUtils.fromString((String)url).asString());
        if (this.fsViewer != null) {
            imageElement.getStyle().setCursor(Style.Cursor.POINTER);
        }
        imageHolder.getStyle().setHeight(300.0, Style.Unit.PX);
        imageHolder.getStyle().setWidth((double)Math.round((double)width * (300.0 / (double)height)), Style.Unit.PX);
        imageHolder.appendChild((Node)imageElement);
        this.imageDataMap.put(((AbstractMediaDTO)image).getSourceRef(), image);
        this.getElement().appendChild((Node)imageHolder);
        if (this.getElement().getChildCount() > 20) {
            this.setInfiniteScrolling(false);
            this.setShowDots(false);
        }
    }

    public void setContentMarginInPixels(int contentMarginInPixels) {
        this.contentMarginInPixels = contentMarginInPixels;
    }

    public void setLazyload(LAZYLOAD lazyload) {
        this.lazyload = lazyload.getPropertyValue();
    }

    public void setInfiniteScrolling(boolean infiniteScrolling) {
        this.infiniteScrolling = infiniteScrolling;
    }

    public void setVariableWidth(boolean variableWidth) {
        this.variableWidth = variableWidth;
    }

    public void setCenterMode(boolean centerMode) {
        this.centerMode = centerMode;
    }

    public void setShowDots(boolean showDots) {
        this.showDots = showDots;
    }

    private void init() {
        final ImageCarousel reference = this;
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                try {
                    ImageCarousel.this.setupSlider(reference);
                }
                catch (Exception e) {
                    GWT.log((String)"Catched Exception on slider init", (Throwable)e);
                }
            }
        });
    }

    public void registerFullscreenViewer(FullscreenViewer<TYPE> fsViewer) {
        this.fsViewer = fsViewer;
    }

    public static interface FullscreenViewer<TYPE> {
        public void show(TYPE var1, Collection<TYPE> var2);
    }

    public static enum LAZYLOAD {
        ONDEMAND("ondemand"),
        PROGRESSIVE("progressive");

        String propertyValue;

        private LAZYLOAD(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }
    }

    static interface SlickSliderUiBinder
    extends UiBinder<DivElement, ImageCarousel<?>> {
    }
}

