/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.async;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.async.TimeRangeAsyncAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TimeRangeResultCache<SubResult> {
    private static final int TRIM_MAX_ITERATIONS = 20;
    private static final int CACHE_SIZE = 32;
    private final Map<TimeRangeAsyncAction<?, ?>, Request> requestCache = new HashMap(32);

    private void evictRequestFromCache(TimeRangeAsyncAction<?, ?> action) {
        this.requestCache.remove(action);
    }

    private void evictRequestFromCache(Request request) {
        this.evictRequestFromCache(request.action);
    }

    int getCacheSize() {
        return this.requestCache.size();
    }

    public TimeRange trimAndRegisterRequest(TimeRange toTrim, boolean forceTimeRange, TimeRangeAsyncAction<?, ?> action, AsyncCallback<Void> callback) {
        Request request = this.trimTimeRangeAndAttachDeps(toTrim, callback, action, forceTimeRange);
        this.requestCache.put(action, request);
        return request.getTrimmedTimeRange();
    }

    public void registerResult(TimeRangeAsyncAction<?, ?> action, SubResult subResult) {
        Request request = this.requestCache.get(action);
        if (request == null) {
            throw new IllegalArgumentException("Attempted to register result for non-existent request: " + action.toString());
        }
        request.onSuccess(subResult);
    }

    public void registerFailure(TimeRangeAsyncAction<?, ?> action, Throwable cause) {
        Request request = this.requestCache.get(action);
        if (request != null) {
            request.onFailure(cause);
        }
    }

    public List<Util.Pair<TimeRange, SubResult>> getResults(TimeRangeAsyncAction<?, ?> action) throws IllegalArgumentException {
        Request request = this.requestCache.get(action);
        if (request == null) {
            throw new IllegalArgumentException("No request found for action: " + action.toString());
        }
        return request.getActionResult();
    }

    public void removeRequest(TimeRangeAsyncAction<?, ?> action) throws IllegalArgumentException {
        Request request = this.requestCache.get(action);
        if (request == null) {
            throw new IllegalArgumentException("No request found for action: " + action.toString());
        }
        request.releaseChildrenAndEvictSelf();
    }

    private Request trimTimeRangeAndAttachDeps(TimeRange toTrim, AsyncCallback<Void> callback, TimeRangeAsyncAction<?, ?> action, boolean forceTimeRange) {
        TimeRange potentiallyTrimmed = toTrim;
        LinkedList<Request> rangesToTrimWithAsList = new LinkedList<Request>(this.requestCache.values());
        ArrayList<Request> childrenList = new ArrayList<Request>();
        int i = 0;
        block0: while (i < 20) {
            boolean rangeWasTrimmedThisIteration = false;
            Iterator iter = rangesToTrimWithAsList.iterator();
            while (iter.hasNext()) {
                Request element = (Request)iter.next();
                TimeRange trimWith = element.getTrimmedTimeRange();
                if (trimWith != null && !element.hasFailed()) {
                    boolean toIncluded;
                    boolean rangeAfter = potentiallyTrimmed.from().after(trimWith.to()) || potentiallyTrimmed.from().equals(trimWith.to());
                    boolean fromAfter = potentiallyTrimmed.from().after(trimWith.from());
                    boolean fromIncluded = fromAfter || potentiallyTrimmed.from().equals(trimWith.from());
                    boolean rangeBefore = potentiallyTrimmed.to().before(trimWith.from()) || potentiallyTrimmed.to().equals(trimWith.from());
                    boolean toBefore = potentiallyTrimmed.to().before(trimWith.to());
                    boolean bl = toIncluded = toBefore || potentiallyTrimmed.to().equals(trimWith.to());
                    if (rangeAfter || rangeBefore) {
                        iter.remove();
                        continue;
                    }
                    if (fromIncluded && toIncluded) {
                        childrenList.add(element);
                        potentiallyTrimmed = null;
                        break block0;
                    }
                    if (!fromIncluded && !toIncluded) continue;
                    childrenList.add(element);
                    potentiallyTrimmed = (TimeRange)potentiallyTrimmed.subtract(trimWith).iterator().next();
                    iter.remove();
                    rangeWasTrimmedThisIteration = true;
                    continue;
                }
                iter.remove();
            }
            if (!rangeWasTrimmedThisIteration) break;
            ++i;
        }
        Request request = new Request(toTrim, potentiallyTrimmed, callback, action, childrenList);
        return request;
    }

    protected class Request {
        private final TimeRangeAsyncAction<?, ?> action;
        private final AsyncCallback<Void> callback;
        private boolean callbackWasCalled = false;
        private final TimeRange actionTimeRange;
        private TimeRange trimmedTimeRange;
        private final Set<Request> parentSet = new HashSet<Request>();
        private final Set<Request> childrenSet = new HashSet<Request>();
        private int childrenWithoutResultCounter = 0;
        private boolean hasResult = false;
        private SubResult result = null;
        private boolean actionResultRetrieved = false;

        public Request(TimeRange timeRange, TimeRange trimmedTimeRange, AsyncCallback<Void> callback, TimeRangeAsyncAction<?, ?> action, Iterable<Request> childrenList) {
            this.actionTimeRange = timeRange;
            this.trimmedTimeRange = trimmedTimeRange;
            this.callback = callback;
            this.action = action;
            this.addChildren(childrenList);
        }

        private void addChildren(Iterable<Request> requests) throws IllegalStateException {
            if (this.callbackWasCalled) {
                throw new IllegalStateException("Children may not be added after results have been submitted!");
            }
            ++this.childrenWithoutResultCounter;
            for (Request request : requests) {
                if (this.equals(request)) {
                    throw new IllegalArgumentException("Cannot add myself as my own child!");
                }
                boolean notPresentBefore = this.childrenSet.add(request);
                if (notPresentBefore) {
                    ++this.childrenWithoutResultCounter;
                }
                request.addParent(this);
            }
            --this.childrenWithoutResultCounter;
        }

        public Set<Request> getChildrenSet() {
            return Collections.unmodifiableSet(this.childrenSet);
        }

        private void releaseChildren() {
            for (Request child : this.childrenSet) {
                child.removeParent(this);
                if (!child.canBeEvicted()) continue;
                TimeRangeResultCache.this.evictRequestFromCache(child);
            }
            this.childrenSet.clear();
        }

        public Set<Request> getParentSet() {
            return this.parentSet;
        }

        private void addParent(Request parent) {
            if (this.equals(parent)) {
                throw new IllegalArgumentException("Cannot add itself as parent!");
            }
            boolean notPresentBefore = this.parentSet.add(parent);
            if (notPresentBefore && this.hasResult) {
                parent.onChildSuccess();
            }
        }

        private void removeParent(Request parent) {
            this.parentSet.remove(parent);
        }

        public void onSuccess(SubResult result) {
            this.setResult(result);
            this.notifyActionSuccessIfHasAllResults();
            HashSet<Request> parents = new HashSet<Request>(this.parentSet);
            parents.forEach(parent -> parent.onChildSuccess());
        }

        public void onFailure(Throwable caught) {
            this.notifyActionFailure(caught);
            HashSet<Request> parents = new HashSet<Request>(this.parentSet);
            parents.forEach(parent -> parent.onChildFailure(caught));
        }

        private void onChildSuccess() {
            --this.childrenWithoutResultCounter;
            this.notifyActionSuccessIfHasAllResults();
        }

        private void onChildFailure(Throwable caught) {
            this.notifyActionFailure(new Throwable("Child encountered an error", caught));
        }

        private void notifyActionSuccessIfHasAllResults() {
            if (!this.callbackWasCalled && this.hasResult && this.childrenWithoutResultCounter <= 0) {
                this.callbackWasCalled = true;
                this.callback.onSuccess(null);
            }
        }

        private void notifyActionFailure(Throwable caught) {
            if (!this.callbackWasCalled) {
                this.callbackWasCalled = true;
                this.callback.onFailure(caught);
                this.releaseChildrenAndEvictSelf();
            }
        }

        protected boolean canBeEvicted() {
            return this.callbackWasCalled && this.parentSet.isEmpty();
        }

        protected void releaseChildrenAndEvictSelf() {
            this.releaseChildren();
            if (this.canBeEvicted()) {
                TimeRangeResultCache.this.evictRequestFromCache(this);
            }
        }

        public List<Util.Pair<TimeRange, SubResult>> getActionResult() throws IllegalStateException {
            ArrayList actionResults;
            if (!this.callbackWasCalled) {
                throw new IllegalStateException("Callback was not called yet");
            }
            if (this.actionResultRetrieved) {
                throw new IllegalStateException("Results have been retrieved already and the dependencies have been released");
            }
            if (this.getTrimmedTimeRange() == null) {
                actionResults = new ArrayList(this.childrenSet.size());
            } else {
                actionResults = new ArrayList(this.childrenSet.size() + 1);
                actionResults.add(new Util.Pair((Object)this.getTrimmedTimeRange(), this.getResult()));
            }
            for (Request child : this.childrenSet) {
                if (!child.hasResult()) {
                    throw new IllegalStateException("Child request has no result although one is expected to be there.");
                }
                actionResults.add(new Util.Pair((Object)child.getTrimmedTimeRange(), child.getResult()));
            }
            this.releaseChildrenAndEvictSelf();
            this.actionResultRetrieved = true;
            return actionResults;
        }

        public SubResult getResult() {
            return this.result;
        }

        private void setResult(SubResult result) {
            this.hasResult = true;
            this.result = result;
        }

        public boolean hasResult() {
            return this.hasResult;
        }

        public boolean hasFailed() {
            return this.callbackWasCalled && !this.hasResult;
        }

        public TimeRange getActionTimeRange() {
            return this.actionTimeRange;
        }

        public TimeRange getTrimmedTimeRange() {
            return this.trimmedTimeRange;
        }
    }
}

