/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.StringFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONArray;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferentialPrice
extends Resource<DifferentialPrice> {
    public DifferentialPrice(String jsonStr) {
        super(jsonStr);
    }

    public DifferentialPrice(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String itemPriceId() {
        return this.reqString("item_price_id");
    }

    public String parentItemId() {
        return this.reqString("parent_item_id");
    }

    public Integer price() {
        return this.optInteger("price");
    }

    public String priceInDecimal() {
        return this.optString("price_in_decimal");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Timestamp modifiedAt() {
        return this.reqTimestamp("modified_at");
    }

    public List<Tier> tiers() {
        return this.optList("tiers", Tier.class);
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public List<ParentPeriod> parentPeriods() {
        return this.optList("parent_periods", ParentPeriod.class);
    }

    public static CreateRequest create(String id) {
        String uri = DifferentialPrice.uri("item_prices", DifferentialPrice.nullCheck(id), "differential_prices");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static RetrieveRequest retrieve(String id) {
        String uri = DifferentialPrice.uri("differential_prices", DifferentialPrice.nullCheck(id));
        return new RetrieveRequest(HttpUtil.Method.GET, uri);
    }

    public static UpdateRequest update(String id) {
        String uri = DifferentialPrice.uri("differential_prices", DifferentialPrice.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static DeleteRequest delete(String id) {
        String uri = DifferentialPrice.uri("differential_prices", DifferentialPrice.nullCheck(id), "delete");
        return new DeleteRequest(HttpUtil.Method.POST, uri);
    }

    public static DifferentialPriceListRequest list() {
        String uri = DifferentialPrice.uri("differential_prices");
        return new DifferentialPriceListRequest(uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DifferentialPriceListRequest
    extends ListRequest<DifferentialPriceListRequest> {
        private DifferentialPriceListRequest(String uri) {
            super(uri);
        }

        public StringFilter<DifferentialPriceListRequest> itemPriceId() {
            return new StringFilter<DifferentialPriceListRequest>("item_price_id", this).supportsMultiOperators(true);
        }

        public StringFilter<DifferentialPriceListRequest> itemId() {
            return new StringFilter<DifferentialPriceListRequest>("item_id", this).supportsMultiOperators(true);
        }

        public StringFilter<DifferentialPriceListRequest> id() {
            return new StringFilter<DifferentialPriceListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<DifferentialPriceListRequest> parentItemId() {
            return new StringFilter<DifferentialPriceListRequest>("parent_item_id", this).supportsMultiOperators(true);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteRequest
    extends Request<DeleteRequest> {
        private DeleteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeleteRequest itemPriceId(String itemPriceId) {
            this.params.add("item_price_id", itemPriceId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest itemPriceId(String itemPriceId) {
            this.params.add("item_price_id", itemPriceId);
            return this;
        }

        public UpdateRequest price(Integer price) {
            this.params.addOpt("price", price);
            return this;
        }

        public UpdateRequest priceInDecimal(String priceInDecimal) {
            this.params.addOpt("price_in_decimal", priceInDecimal);
            return this;
        }

        public UpdateRequest parentPeriodPeriodUnit(int index, ParentPeriod.PeriodUnit parentPeriodPeriodUnit) {
            this.params.add("parent_periods[period_unit][" + index + "]", (Object)parentPeriodPeriodUnit);
            return this;
        }

        public UpdateRequest parentPeriodPeriod(int index, JSONArray parentPeriodPeriod) {
            this.params.addOpt("parent_periods[period][" + index + "]", parentPeriodPeriod);
            return this;
        }

        public UpdateRequest tierStartingUnit(int index, Integer tierStartingUnit) {
            this.params.addOpt("tiers[starting_unit][" + index + "]", tierStartingUnit);
            return this;
        }

        public UpdateRequest tierEndingUnit(int index, Integer tierEndingUnit) {
            this.params.addOpt("tiers[ending_unit][" + index + "]", tierEndingUnit);
            return this;
        }

        public UpdateRequest tierPrice(int index, Integer tierPrice) {
            this.params.addOpt("tiers[price][" + index + "]", tierPrice);
            return this;
        }

        public UpdateRequest tierStartingUnitInDecimal(int index, String tierStartingUnitInDecimal) {
            this.params.addOpt("tiers[starting_unit_in_decimal][" + index + "]", tierStartingUnitInDecimal);
            return this;
        }

        public UpdateRequest tierEndingUnitInDecimal(int index, String tierEndingUnitInDecimal) {
            this.params.addOpt("tiers[ending_unit_in_decimal][" + index + "]", tierEndingUnitInDecimal);
            return this;
        }

        public UpdateRequest tierPriceInDecimal(int index, String tierPriceInDecimal) {
            this.params.addOpt("tiers[price_in_decimal][" + index + "]", tierPriceInDecimal);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RetrieveRequest
    extends Request<RetrieveRequest> {
        private RetrieveRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RetrieveRequest itemPriceId(String itemPriceId) {
            this.params.add("item_price_id", itemPriceId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest parentItemId(String parentItemId) {
            this.params.add("parent_item_id", parentItemId);
            return this;
        }

        public CreateRequest price(Integer price) {
            this.params.addOpt("price", price);
            return this;
        }

        public CreateRequest priceInDecimal(String priceInDecimal) {
            this.params.addOpt("price_in_decimal", priceInDecimal);
            return this;
        }

        public CreateRequest parentPeriodPeriodUnit(int index, ParentPeriod.PeriodUnit parentPeriodPeriodUnit) {
            this.params.add("parent_periods[period_unit][" + index + "]", (Object)parentPeriodPeriodUnit);
            return this;
        }

        public CreateRequest parentPeriodPeriod(int index, JSONArray parentPeriodPeriod) {
            this.params.addOpt("parent_periods[period][" + index + "]", parentPeriodPeriod);
            return this;
        }

        public CreateRequest tierStartingUnit(int index, Integer tierStartingUnit) {
            this.params.addOpt("tiers[starting_unit][" + index + "]", tierStartingUnit);
            return this;
        }

        public CreateRequest tierEndingUnit(int index, Integer tierEndingUnit) {
            this.params.addOpt("tiers[ending_unit][" + index + "]", tierEndingUnit);
            return this;
        }

        public CreateRequest tierPrice(int index, Integer tierPrice) {
            this.params.addOpt("tiers[price][" + index + "]", tierPrice);
            return this;
        }

        public CreateRequest tierStartingUnitInDecimal(int index, String tierStartingUnitInDecimal) {
            this.params.addOpt("tiers[starting_unit_in_decimal][" + index + "]", tierStartingUnitInDecimal);
            return this;
        }

        public CreateRequest tierEndingUnitInDecimal(int index, String tierEndingUnitInDecimal) {
            this.params.addOpt("tiers[ending_unit_in_decimal][" + index + "]", tierEndingUnitInDecimal);
            return this;
        }

        public CreateRequest tierPriceInDecimal(int index, String tierPriceInDecimal) {
            this.params.addOpt("tiers[price_in_decimal][" + index + "]", tierPriceInDecimal);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParentPeriod
    extends Resource<ParentPeriod> {
        public ParentPeriod(JSONObject jsonObj) {
            super(jsonObj);
        }

        public PeriodUnit periodUnit() {
            return this.reqEnum("period_unit", PeriodUnit.class);
        }

        public JSONArray period() {
            return this.optJSONArray("period");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum PeriodUnit {
            DAY,
            WEEK,
            MONTH,
            YEAR,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tier
    extends Resource<Tier> {
        public Tier(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer startingUnit() {
            return this.reqInteger("starting_unit");
        }

        public Integer endingUnit() {
            return this.optInteger("ending_unit");
        }

        public Integer price() {
            return this.reqInteger("price");
        }

        public String startingUnitInDecimal() {
            return this.optString("starting_unit_in_decimal");
        }

        public String endingUnitInDecimal() {
            return this.optString("ending_unit_in_decimal");
        }

        public String priceInDecimal() {
            return this.optString("price_in_decimal");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ACTIVE,
        DELETED,
        _UNKNOWN;

    }
}

