/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication;

import com.sap.sse.replication.OperationExecutionListener;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.OperationsToMasterSender;
import com.sap.sse.replication.OperationsToMasterSendingQueue;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import com.sap.sse.replication.Replicator;
import com.sap.sse.util.ThreadLocalTransporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.logging.Logger;

public interface Replicable<S, O extends OperationWithResult<S, ?>>
extends OperationsToMasterSender<S, O>,
Replicator<S, O> {
    public static final Logger logger = Logger.getLogger(Replicable.class.getName());
    public static final String OSGi_Service_Registry_ID_Property_Name = "ID";
    public static final /* synthetic */ boolean $assertionsDisabled;

    public <T> T apply(O var1);

    public <T> T applyReplicated(O var1);

    public void startedReplicatingFrom(ReplicationMasterDescriptor var1);

    public void stoppedReplicatingFrom(ReplicationMasterDescriptor var1);

    public void addOperationExecutionListener(OperationExecutionListener<S> var1);

    public void removeOperationExecutionListener(OperationExecutionListener<S> var1);

    public void clearReplicaState() throws MalformedURLException, IOException, InterruptedException;

    public ObjectInputStream createObjectInputStreamResolvingAgainstCache(InputStream var1, Map<String, Class<?>> var2) throws IOException;

    public void initiallyFillFrom(InputStream var1) throws IOException, ClassNotFoundException, InterruptedException;

    public void serializeForInitialReplication(OutputStream var1) throws IOException;

    default public ClassLoader getDeserializationClassLoader() {
        return this.getClass().getClassLoader();
    }

    default public O readOperationFromObjectInputStream(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ClassLoader oldContextClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getDeserializationClassLoader());
        try {
            OperationWithResult operationWithResult = (OperationWithResult)ois.readObject();
            return (O)operationWithResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassloader);
        }
    }

    public O readOperation(InputStream var1, Map<String, Class<?>> var2) throws IOException, ClassNotFoundException;

    default public void applyReceivedReplicated(O operation) {
        if (!this.hasSentOperationToMaster(operation)) {
            assert (!this.isCurrentlyFillingFromInitialLoadOrApplyingOperationReceivedFromMaster());
            try {
                this.setCurrentlyApplyingOperationReceivedFromMaster(true);
                this.applyReplicated(operation);
            }
            finally {
                this.setCurrentlyApplyingOperationReceivedFromMaster(false);
            }
        } else {
            logger.fine("Ignoring operation " + operation + " received back from master after having sent it there for execution and replication earlier");
        }
    }

    default public boolean isCurrentlyFillingFromInitialLoadOrApplyingOperationReceivedFromMaster() {
        return this.isCurrentlyFillingFromInitialLoad() || this.isCurrentlyApplyingOperationReceivedFromMaster();
    }

    public boolean isCurrentlyFillingFromInitialLoad();

    public boolean isCurrentlyApplyingOperationReceivedFromMaster();

    public void setCurrentlyFillingFromInitialLoad(boolean var1);

    public void setCurrentlyApplyingOperationReceivedFromMaster(boolean var1);

    default public ThreadLocalTransporter getThreadLocalTransporterForCurrentlyFillingFromInitialLoadOrApplyingOperationReceivedFromMaster() {
        return new ThreadLocalTransporter(){
            private boolean currentlyFillingFromInitialLoad;
            private boolean currentlyFillingFromInitialLoadAtBeginningOfTask;
            private boolean currentlyApplyingOperationReceivedFromMaster;
            private boolean currentlyApplyingOperationReceivedFromMasterAtBeginningOfTask;

            public void rememberThreadLocalStates() {
                this.currentlyFillingFromInitialLoad = Replicable.this.isCurrentlyFillingFromInitialLoad();
                this.currentlyApplyingOperationReceivedFromMasterAtBeginningOfTask = Replicable.this.isCurrentlyApplyingOperationReceivedFromMaster();
            }

            public void pushThreadLocalStates() {
                this.currentlyFillingFromInitialLoadAtBeginningOfTask = Replicable.this.isCurrentlyFillingFromInitialLoad();
                Replicable.this.setCurrentlyFillingFromInitialLoad(this.currentlyFillingFromInitialLoad);
                this.currentlyApplyingOperationReceivedFromMasterAtBeginningOfTask = Replicable.this.isCurrentlyFillingFromInitialLoad();
                Replicable.this.setCurrentlyFillingFromInitialLoad(this.currentlyApplyingOperationReceivedFromMaster);
            }

            public void popThreadLocalStates() {
                Replicable.this.setCurrentlyFillingFromInitialLoad(this.currentlyFillingFromInitialLoadAtBeginningOfTask);
                Replicable.this.setCurrentlyApplyingOperationReceivedFromMaster(this.currentlyApplyingOperationReceivedFromMasterAtBeginningOfTask);
            }
        };
    }

    public void setUnsentOperationToMasterSender(OperationsToMasterSendingQueue var1);
}

