/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingreplayadapter.impl;

import java.util.Arrays;

public class MarkType {
    public static byte IS_VISIBLE = 1;
    public static byte IS_COUPLE = (byte)2;
    public static byte IS_TURN = (byte)4;
    public static byte IS_FINISH = (byte)8;
    public static byte IS_START = (byte)16;
    public static byte IS_MEASURE = (byte)32;
    public static byte IS_BOAT = (byte)64;
    public static byte IS_BUOY = (byte)-128;
    static String[] AS_STRING = new String[]{"VISIBLE", "COUPLE", "TURN", "FINISH", "START", "MEASURE", "BOAT", "BUOY"};
    private final byte bitCode;

    public MarkType(byte bitCode) {
        this.bitCode = bitCode;
    }

    public boolean isVisible() {
        return this.testFlag(IS_VISIBLE);
    }

    public boolean isCouple() {
        return this.testFlag(IS_COUPLE);
    }

    public boolean isTurn() {
        return this.testFlag(IS_TURN);
    }

    public boolean isStraight() {
        return !this.isTurn();
    }

    public boolean isFinish() {
        return this.testFlag(IS_FINISH);
    }

    public boolean isStartOrCourse() {
        return !this.isFinish();
    }

    public boolean isStart() {
        return this.testFlag(IS_START);
    }

    public boolean isFinishOrCourse() {
        return !this.isStart();
    }

    public boolean isMeasure() {
        return this.testFlag(IS_MEASURE);
    }

    public boolean isBoat() {
        return this.testFlag(IS_BOAT);
    }

    public boolean isBuoy() {
        return this.testFlag(IS_BUOY);
    }

    public boolean isPin() {
        return !this.isBuoy();
    }

    public String toString() {
        Object[] toString = new String[AS_STRING.length];
        int i = 0;
        while (i < toString.length) {
            byte mask = (byte)(1 << i);
            toString[i] = this.testFlag(mask) ? AS_STRING[i] : AS_STRING[i].toLowerCase();
            ++i;
        }
        return Arrays.toString(toString);
    }

    private boolean testFlag(byte mask) {
        return (this.bitCode & mask) == mask;
    }
}

