/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.server.gateway.serialization.impl.BoatClassJsonSerializer;
import com.sap.sse.common.Color;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.simple.JSONObject;

public class BoatJsonSerializer
implements JsonSerializer<Boat> {
    public static final String FIELD_ID = "id";
    public static final String FIELD_ID_TYPE = "idtype";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_SAIL_ID = "sailId";
    public static final String FIELD_BOAT_CLASS = "boatClass";
    public static final String FIELD_COLOR = "color";
    private final JsonSerializer<BoatClass> boatClassJsonSerializer;

    public static BoatJsonSerializer create() {
        return new BoatJsonSerializer(new BoatClassJsonSerializer());
    }

    public BoatJsonSerializer(JsonSerializer<BoatClass> boatClassJsonSerializer) {
        this.boatClassJsonSerializer = boatClassJsonSerializer;
    }

    public static JSONObject getBoatIdQuery(Boat boat) {
        JSONObject result = new JSONObject();
        Object competitorId = boat.getId() instanceof UUID ? boat.getId().toString() : boat.getId();
        result.put((Object)FIELD_ID, competitorId);
        return result;
    }

    public JSONObject serialize(Boat boat) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_ID_TYPE, (Object)boat.getId().getClass().getName());
        Set entries = BoatJsonSerializer.getBoatIdQuery(boat).entrySet();
        for (Map.Entry idKeyAndValue : entries) {
            result.put(idKeyAndValue.getKey(), idKeyAndValue.getValue());
        }
        result.put((Object)FIELD_NAME, (Object)boat.getName());
        result.put((Object)FIELD_SAIL_ID, (Object)boat.getSailID());
        Color color = boat.getColor();
        result.put((Object)FIELD_COLOR, (Object)(color != null ? color.getAsHtml() : null));
        if (this.boatClassJsonSerializer != null) {
            result.put((Object)FIELD_BOAT_CLASS, (Object)this.boatClassJsonSerializer.serialize((Object)boat.getBoatClass()));
        }
        return result;
    }
}

