/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.coursedata.impl;

import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.ControlPointWithTwoMarks;
import com.sap.sailing.domain.base.Mark;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONObject;

public class ControlPointJsonSerializer
implements JsonSerializer<ControlPoint> {
    private JsonSerializer<ControlPoint> markSerializer;
    private JsonSerializer<ControlPoint> gateSerializer;

    public ControlPointJsonSerializer(JsonSerializer<ControlPoint> markSerializer, JsonSerializer<ControlPoint> gateSerializer) {
        this.markSerializer = markSerializer;
        this.gateSerializer = gateSerializer;
    }

    protected JsonSerializer<ControlPoint> getSerializer(ControlPoint controlPoint) {
        if (controlPoint instanceof Mark) {
            return this.markSerializer;
        }
        if (controlPoint instanceof ControlPointWithTwoMarks) {
            return this.gateSerializer;
        }
        throw new UnsupportedOperationException(String.format("There is no serializer defined for control point type %s", controlPoint.getClass().getName()));
    }

    public JSONObject serialize(ControlPoint object) {
        return this.getSerializer(object).serialize((Object)object);
    }
}

