/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.racegroup.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.base.racegroup.RaceCell;
import com.sap.sailing.domain.base.racegroup.impl.RaceCellImpl;
import com.sap.sailing.domain.common.TargetTimeInfo;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import org.json.simple.JSONObject;

public class RaceCellDeserializer
implements JsonDeserializer<RaceCell> {
    private final JsonDeserializer<RaceLog> logDeserializer;
    private final JsonDeserializer<TargetTimeInfo> targetTimeDeserializer;

    public RaceCellDeserializer(JsonDeserializer<RaceLog> logDeserializer, JsonDeserializer<TargetTimeInfo> targetTimeDeserializer) {
        this.logDeserializer = logDeserializer;
        this.targetTimeDeserializer = targetTimeDeserializer;
    }

    public RaceCell deserialize(JSONObject object) throws JsonDeserializationException {
        String name = object.get((Object)"name").toString();
        Object factorJson = object.get((Object)"factor");
        double factor = factorJson == null ? 1.0 : ((Number)factorJson).doubleValue();
        Double explicitFactor = (Double)object.get((Object)"explicitfactor");
        Number zeroBasedIndexInFleet = (Number)object.get((Object)"zerobasedindexinfleet");
        JSONObject targetTimeInfoJson = (JSONObject)object.get((Object)"targettimeinfo");
        TargetTimeInfo targetTime = targetTimeInfoJson == null ? null : (TargetTimeInfo)this.targetTimeDeserializer.deserialize(targetTimeInfoJson);
        JSONObject logJson = Helpers.getNestedObjectSafe(object, "raceLog");
        RaceLog log = (RaceLog)this.logDeserializer.deserialize(logJson);
        return new RaceCellImpl(name, log, factor, explicitFactor, zeroBasedIndexInFleet == null ? -1 : zeroBasedIndexInFleet.intValue(), targetTime);
    }
}

