/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.datamining.data.impl;

import com.sap.sailing.datamining.data.HasLeaderboardContext;
import com.sap.sailing.datamining.data.HasLeaderboardGroupContext;
import com.sap.sailing.datamining.data.HasTrackedRaceContext;
import com.sap.sailing.datamining.impl.data.TrackedRaceWithContext;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.BravoFixTrack;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.polars.datamining.data.HasCompetitorPolarContext;
import com.sap.sailing.polars.datamining.data.HasFleetPolarContext;
import com.sap.sailing.polars.datamining.data.HasGPSFixPolarContext;
import com.sap.sailing.polars.datamining.data.HasLeaderboardPolarContext;
import com.sap.sailing.polars.datamining.data.impl.PolarStatisticImpl;
import com.sap.sailing.polars.datamining.shared.PolarDataMiningSettings;
import com.sap.sailing.polars.datamining.shared.PolarStatistic;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.datamining.data.Cluster;
import com.sap.sse.datamining.data.ClusterGroup;
import com.sap.sse.datamining.shared.impl.dto.ClusterDTO;
import java.io.Serializable;

public class GPSFixWithPolarContext
implements HasGPSFixPolarContext {
    private final GPSFixMoving fix;
    private final TrackedRace trackedRace;
    private final ClusterGroup<Speed> windSpeedRangeGroup;
    private final Competitor competitor;
    private final PolarDataMiningSettings settings;
    private final HasCompetitorPolarContext competitorPolarContext;
    private final WindWithConfidence<Util.Pair<Position, TimePoint>> wind;

    public GPSFixWithPolarContext(GPSFixMoving fix, TrackedRace trackedRace, ClusterGroup<Speed> windSpeedRangeGroup, Competitor competitor, PolarDataMiningSettings settings, WindWithConfidence<Util.Pair<Position, TimePoint>> wind, HasCompetitorPolarContext competitorPolarContext) {
        this.fix = fix;
        this.trackedRace = trackedRace;
        this.windSpeedRangeGroup = windSpeedRangeGroup;
        this.competitor = competitor;
        this.settings = settings;
        this.competitorPolarContext = competitorPolarContext;
        this.wind = wind;
    }

    @Override
    public HasTrackedRaceContext getTrackedRaceContext() {
        HasFleetPolarContext fleetPolarContext = this.getCompetitorPolarContext().getLegPolarContext().getFleetPolarContext();
        RaceColumn raceColumn = fleetPolarContext.getRaceColumn();
        final HasLeaderboardPolarContext leaderboardPolarContext = fleetPolarContext.getRaceColumnPolarContext().getLeaderboardPolarContext();
        final Leaderboard leaderboard = leaderboardPolarContext.getLeaderboard();
        HasLeaderboardContext leaderboardContext = new HasLeaderboardContext(){

            public HasLeaderboardGroupContext getLeaderboardGroupContext() {
                return leaderboardPolarContext.getLeaderboardGroupContext();
            }

            public Leaderboard getLeaderboard() {
                return leaderboard;
            }
        };
        return new TrackedRaceWithContext(leaderboardContext, this.trackedRace.getTrackedRegatta().getRegatta(), raceColumn, fleetPolarContext.getFleet(), this.trackedRace);
    }

    @Override
    public ClusterDTO getWindSpeedRange() {
        Cluster cluster;
        String signifier = this.wind == null || this.wind.getObject() == null ? "null" : ((cluster = this.windSpeedRangeGroup.getClusterFor((Serializable)((Speed)this.wind.getObject()))) == null ? "null" : cluster.toString());
        return new ClusterDTO(signifier);
    }

    @Override
    public PolarStatistic getPolarStatistics() {
        return new PolarStatisticImpl(this.trackedRace, this.competitor, this.fix, this.settings, (Wind)this.wind.getObject());
    }

    @Override
    public HasCompetitorPolarContext getCompetitorPolarContext() {
        return this.competitorPolarContext;
    }

    @Override
    public boolean isFoiling() {
        BravoFixTrack competitorBravoFixTrack = (BravoFixTrack)this.trackedRace.getSensorTrack(this.competitor, "BravoFixTrack");
        boolean result = competitorBravoFixTrack != null ? competitorBravoFixTrack.isFoiling(this.fix.getTimePoint()) : false;
        return result;
    }
}

