/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.domain.anniversary.DetailedRaceInfo;
import com.sap.sailing.domain.anniversary.SimpleRaceInfo;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.RemoteSailingServerReference;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.statistics.Statistics;
import com.sap.sailing.server.gateway.deserialization.impl.CourseAreaJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.EventBaseJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.LeaderboardGroupBaseJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.StatisticsByYearJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.StatisticsJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.TrackingConnectorInfoJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.VenueJsonDeserializer;
import com.sap.sailing.server.gateway.serialization.impl.DetailedRaceInfoJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.SimpleRaceInfoJsonSerializer;
import com.sap.sse.common.Duration;
import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.common.Util;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.util.HttpUrlConnectionHelper;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class RemoteSailingServerSet {
    private static final int POLLING_INTERVAL_IN_SECONDS = 60;
    private NamedReentrantReadWriteLock lock = new NamedReentrantReadWriteLock("lock for RemoteSailingServerSet", true);
    private static final Logger logger = Logger.getLogger(RemoteSailingServerSet.class.getName());
    private final ConcurrentMap<String, RemoteSailingServerReference> remoteSailingServers;
    private final ConcurrentMap<RemoteSailingServerReference, Util.Pair<Iterable<EventBase>, Exception>> cachedEventsForRemoteSailingServers;
    private final ConcurrentMap<RemoteSailingServerReference, Util.Pair<Map<Integer, Statistics>, Exception>> cachedStatisticsByYearForRemoteSailingServers;
    private final StatisticsJsonDeserializer statisticsJsonDeserializer;
    private final ConcurrentMap<RemoteSailingServerReference, Util.Pair<Iterable<SimpleRaceInfo>, Exception>> cachedTrackedRacesForRemoteSailingServers;
    private final Set<Runnable> remoteRaceResultReceivedCallbacks = ConcurrentHashMap.newKeySet();
    private final AtomicBoolean retrieveRemoteRaceResult = new AtomicBoolean(true);
    private final ConcurrentMap<RemoteSailingServerReference, Future<?>> runningUpdateTasksPerServerReference;

    public RemoteSailingServerSet(ScheduledExecutorService scheduler, SharedDomainFactory<?> baseDomainFactory) {
        this.statisticsJsonDeserializer = StatisticsJsonDeserializer.create(baseDomainFactory);
        this.remoteSailingServers = new ConcurrentHashMap<String, RemoteSailingServerReference>();
        this.cachedEventsForRemoteSailingServers = new ConcurrentHashMap<RemoteSailingServerReference, Util.Pair<Iterable<EventBase>, Exception>>();
        this.cachedStatisticsByYearForRemoteSailingServers = new ConcurrentHashMap<RemoteSailingServerReference, Util.Pair<Map<Integer, Statistics>, Exception>>();
        this.cachedTrackedRacesForRemoteSailingServers = new ConcurrentHashMap<RemoteSailingServerReference, Util.Pair<Iterable<SimpleRaceInfo>, Exception>>();
        this.runningUpdateTasksPerServerReference = new ConcurrentHashMap();
        scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                RemoteSailingServerSet.this.updateRemoteSailingServerReferenceEventCaches();
            }
        }, 0L, 60L, TimeUnit.SECONDS);
    }

    public void clear() {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lock, () -> {
            this.remoteSailingServers.clear();
            this.cachedEventsForRemoteSailingServers.clear();
            this.cachedStatisticsByYearForRemoteSailingServers.clear();
            this.cachedTrackedRacesForRemoteSailingServers.clear();
        });
    }

    public void add(RemoteSailingServerReference remoteSailingServerReference) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lock, () -> {
            if (this.remoteSailingServers.containsKey(remoteSailingServerReference.getName())) {
                this.remove(remoteSailingServerReference.getName());
            }
            this.remoteSailingServers.put(remoteSailingServerReference.getName(), remoteSailingServerReference);
            this.triggerAsynchronousEventCacheUpdate(remoteSailingServerReference);
        });
    }

    private void updateRemoteSailingServerReferenceEventCaches() {
        LockUtil.executeWithReadLock((NamedReentrantReadWriteLock)this.lock, () -> {
            for (RemoteSailingServerReference ref : this.remoteSailingServers.values()) {
                this.triggerAsynchronousEventCacheUpdate(ref);
            }
        });
    }

    public RemoteSailingServerReference getServerReferenceByName(String name) {
        return (RemoteSailingServerReference)this.remoteSailingServers.get(name);
    }

    public RemoteSailingServerReference getServerReferenceByUrl(URL url) {
        return this.remoteSailingServers.values().stream().filter(r -> this.equalIgnoringTrailingSlash(r.getURL(), url)).findAny().orElse(null);
    }

    private boolean equalIgnoringTrailingSlash(URL url1, URL url2) {
        String url1AsString = String.valueOf(url1.toString()) + (url1.toString().endsWith("/") ? "" : "/");
        String url2AsString = String.valueOf(url2.toString()) + (url2.toString().endsWith("/") ? "" : "/");
        return url1AsString.equals(url2AsString);
    }

    public Map<String, RemoteSailingServerReference> getAllRemoteServerReferences() {
        return new HashMap<String, RemoteSailingServerReference>(this.remoteSailingServers);
    }

    private void triggerAsynchronousEventCacheUpdate(RemoteSailingServerReference ref) {
        Future lastJobForRef = (Future)this.runningUpdateTasksPerServerReference.get(ref);
        if (lastJobForRef == null || lastJobForRef.isDone()) {
            this.runningUpdateTasksPerServerReference.put(ref, ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor().submit(() -> {
                this.updateRemoteServerEventCacheSynchronously(ref);
                this.updateRemoteServerStatisticsCacheSynchronously(ref);
                if (this.retrieveRemoteRaceResult.get()) {
                    this.updateRemoteServerTrackedRacesCacheSynchronously(ref);
                }
            }));
        } else {
            logger.warning("Not re-scheduling update for remote reference " + ref + " because a previous job for it is still not done yet.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRetrieveRemoteRaceResult(boolean retrieveRemoteRaceResult) {
        this.retrieveRemoteRaceResult.set(retrieveRemoteRaceResult);
        ConcurrentMap<RemoteSailingServerReference, Util.Pair<Iterable<EventBase>, Exception>> concurrentMap = this.cachedEventsForRemoteSailingServers;
        synchronized (concurrentMap) {
            if (!this.retrieveRemoteRaceResult.get()) {
                this.cachedTrackedRacesForRemoteSailingServers.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRemoteServerTrackedRacesCacheSynchronously(RemoteSailingServerReference ref) {
        Util.Pair result;
        try {
            logger.fine("Updating racelist for remote server " + ref + " from URL " + ref.getURL());
            SimpleRaceInfoJsonSerializer deserializer = new SimpleRaceInfoJsonSerializer();
            HashSet<SimpleRaceInfo> races = new HashSet<SimpleRaceInfo>();
            for (Object remoteWithRaces : this.getJSONFromRemoteRacesListSynchronously(ref)) {
                JSONObject remoteWithRacesAsJson = (JSONObject)remoteWithRaces;
                String remoteUrlAsString = (String)remoteWithRacesAsJson.get((Object)"remoteUrl");
                URL remoteUrl = remoteUrlAsString != null && !remoteUrlAsString.isEmpty() ? new URL(remoteUrlAsString) : ref.getURL();
                JSONArray raceListForOneRemote = (JSONArray)remoteWithRacesAsJson.get((Object)"races");
                for (Object remoteRace : raceListForOneRemote) {
                    JSONObject remoteRaceAsJson = (JSONObject)remoteRace;
                    SimpleRaceInfo event = deserializer.deserialize(remoteRaceAsJson, remoteUrl);
                    races.add(event);
                }
            }
            result = new Util.Pair(races, null);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception trying to fetch AnniversaryRaceData from remote server " + ref + ": " + e.getMessage(), e);
            result = new Util.Pair(null, (Object)e);
        }
        ConcurrentMap<RemoteSailingServerReference, Util.Pair<Iterable<SimpleRaceInfo>, Exception>> concurrentMap = this.cachedTrackedRacesForRemoteSailingServers;
        synchronized (concurrentMap) {
            if (this.retrieveRemoteRaceResult.get()) {
                this.updateCache(ref, result, this.cachedTrackedRacesForRemoteSailingServers::put);
            }
        }
        this.notifyRemoteRaceResultReceivedCallbacks();
    }

    private void notifyRemoteRaceResultReceivedCallbacks() {
        new HashSet<Runnable>(this.remoteRaceResultReceivedCallbacks).forEach(Runnable::run);
    }

    private URL getRaceListURL(RemoteSailingServerReference ref) throws MalformedURLException {
        URL remoteServerBaseURL = ref.getURL();
        String endpoint = "/trackedRaces/getRaces?transitive=true";
        return this.getEndpointUrl(remoteServerBaseURL, endpoint);
    }

    private URL getEndpointUrl(URL remoteServerBaseURL, String endpoint) throws MalformedURLException {
        return this.getURL(remoteServerBaseURL, "sailingserver/api/v1" + endpoint);
    }

    private Util.Pair<Iterable<EventBase>, Exception> updateRemoteServerEventCacheSynchronously(RemoteSailingServerReference ref) {
        Util.Pair<Iterable<EventBase>, Exception> result;
        Util.Pair<Iterable<EventBase>, Exception> finalResult = result = this.loadEventsForRemoteServerReference(ref.getName(), ref.isInclude(), ref.getSelectedEventIds(), ref.getURL());
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lock, () -> {
            if (this.remoteSailingServers.containsValue(ref)) {
                this.cachedEventsForRemoteSailingServers.put(ref, finalResult);
            } else {
                logger.fine("Omitted update for " + ref + " as it was removed");
            }
        });
        return result;
    }

    private Util.Pair<Iterable<EventBase>, Exception> loadEventsForRemoteServerReference(String serverName, boolean include, Set<UUID> selectedEvents, URL url) {
        Util.Pair result;
        BufferedReader bufferedReader = null;
        try {
            try {
                URL eventsURL = this.getEventsURL(include, selectedEvents, url);
                logger.fine("Updating events for remote server " + serverName + " from URL " + eventsURL);
                URLConnection urlConnection = HttpUrlConnectionHelper.redirectConnection((URL)eventsURL);
                bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
                JSONParser parser = new JSONParser();
                Object eventsAsObject = parser.parse((Reader)bufferedReader);
                EventBaseJsonDeserializer deserializer = new EventBaseJsonDeserializer((JsonDeserializer)new VenueJsonDeserializer((JsonDeserializer)new CourseAreaJsonDeserializer((SharedDomainFactory)DomainFactory.INSTANCE)), (JsonDeserializer)new LeaderboardGroupBaseJsonDeserializer(), (JsonDeserializer)new TrackingConnectorInfoJsonDeserializer());
                JSONArray eventsAsJsonArray = (JSONArray)eventsAsObject;
                HashSet<EventBase> events = new HashSet<EventBase>();
                for (Object eventAsObject : eventsAsJsonArray) {
                    JSONObject eventAsJson = (JSONObject)eventAsObject;
                    EventBase event = deserializer.deserialize(eventAsJson);
                    events.add(event);
                }
                if (selectedEvents != null) {
                    Set filteredEvents = events.stream().filter(element -> include ? selectedEvents.contains(element.getId()) : !selectedEvents.contains(element.getId())).collect(Collectors.toSet());
                    result = new Util.Pair(filteredEvents, null);
                } else {
                    result = new Util.Pair(events, null);
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        catch (IOException | ParseException e) {
            logger.log(Level.INFO, "Exception trying to fetch events from remote server " + serverName + ": " + e.getMessage(), e);
            result = new Util.Pair(null, (Object)e);
        }
        return result;
    }

    private void updateRemoteServerStatisticsCacheSynchronously(RemoteSailingServerReference ref) {
        Util.Pair result;
        try {
            URL statisticsByYearURL = this.getStatisticsByYearURL(ref.getURL());
            logger.fine("Updating by-year statistics for remote server " + ref + " from URL " + statisticsByYearURL);
            JSONArray statisticsByYear = this.getJsonFromRemoteServerSynchronously(ref, statisticsByYearURL);
            StatisticsByYearJsonDeserializer deserializer = new StatisticsByYearJsonDeserializer(this.statisticsJsonDeserializer);
            HashMap<Integer, Statistics> statisticsByYearMap = new HashMap<Integer, Statistics>();
            for (Object entry : statisticsByYear) {
                JSONObject jsonEntry = (JSONObject)entry;
                Util.Pair pair = deserializer.deserialize(jsonEntry);
                statisticsByYearMap.put((Integer)pair.getA(), (Statistics)pair.getB());
            }
            result = new Util.Pair(statisticsByYearMap, null);
        }
        catch (IOException | ParseException e) {
            logger.log(Level.INFO, "Exception trying to fetch by-year statistics from remote server " + ref + ": " + e.getMessage(), e);
            result = new Util.Pair(null, (Object)e);
        }
        this.updateCache(ref, result, this.cachedStatisticsByYearForRemoteSailingServers::put);
    }

    private JSONArray getJSONFromRemoteRacesListSynchronously(RemoteSailingServerReference ref) throws MalformedURLException, IOException, ParseException {
        JSONArray data;
        block12: {
            HttpURLConnection urlConnection;
            int responseCode;
            URL url = this.getRaceListURL(ref);
            StringBuffer formParams = new StringBuffer("transitive=true");
            if (!ref.getSelectedEventIds().isEmpty()) {
                formParams.append("&events=");
                Iterator iter = ref.getSelectedEventIds().iterator();
                while (iter.hasNext()) {
                    formParams.append(URLEncoder.encode(((UUID)iter.next()).toString(), "utf-8"));
                    if (!iter.hasNext()) continue;
                    formParams.append(URLEncoder.encode(",", "utf-8"));
                }
                formParams.append("&pred=" + (ref.isInclude() ? "incl" : "excl"));
            }
            if ((responseCode = (urlConnection = (HttpURLConnection)HttpUrlConnectionHelper.redirectConnection((URL)url, (Duration)Duration.ONE_SECOND.times(1000L), (String)"POST", connection -> {
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty((String)HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA.getA(), (String)HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA.getB());
            }, null, Optional.of(outputStream -> {
                Throwable throwable = null;
                Object var3_4 = null;
                try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, "utf-8");){
                    writer.write(formParams.toString());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }))).getResponseCode()) == 200) {
                Throwable throwable = null;
                Object var8_8 = null;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "utf-8"));){
                    JSONParser parser = new JSONParser();
                    data = (JSONArray)parser.parse((Reader)bufferedReader);
                    break block12;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            data = this.getJsonFromRemoteServerSynchronously(ref, url);
        }
        return data;
    }

    private JSONArray getJsonFromRemoteServerSynchronously(RemoteSailingServerReference ref, URL url) throws IOException, ParseException {
        logger.fine("Updating data for remote server " + ref + " from URL " + url);
        URLConnection urlConnection = HttpUrlConnectionHelper.redirectConnection((URL)url);
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));){
            JSONParser parser = new JSONParser();
            return (JSONArray)parser.parse((Reader)bufferedReader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private <T> void updateCache(RemoteSailingServerReference ref, Util.Pair<T, Exception> result, BiConsumer<RemoteSailingServerReference, Util.Pair<T, Exception>> updateCacheCallback) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lock, () -> {
            if (this.remoteSailingServers.containsValue(ref)) {
                updateCacheCallback.accept(ref, result);
            } else {
                logger.fine("Omitted update for " + ref + " as it was removed");
            }
        });
    }

    private URL getEventsURL(boolean include, Set<UUID> selectedEvents, URL url) throws MalformedURLException {
        String basePath = "/events";
        StringBuilder eventsEndpointName = new StringBuilder("/events");
        eventsEndpointName.append("?include=").append(include);
        if (selectedEvents != null) {
            for (UUID eventId : selectedEvents) {
                eventsEndpointName.append("&id=").append(eventId.toString());
            }
        }
        return this.getEndpointUrl(url, eventsEndpointName.toString());
    }

    private URL getStatisticsByYearURL(URL remoteServerBaseURL) throws MalformedURLException {
        return this.getEndpointUrl(remoteServerBaseURL, "/statistics/years");
    }

    private URL getURL(URL remoteServerBaseURL, String subURL) throws MalformedURLException {
        String baseURL = remoteServerBaseURL.toExternalForm();
        if (!baseURL.endsWith("/")) {
            baseURL = String.valueOf(baseURL) + "/";
        }
        return new URL(String.valueOf(baseURL) + subURL);
    }

    public Map<RemoteSailingServerReference, Util.Pair<Iterable<EventBase>, Exception>> getCachedEventsForRemoteSailingServers() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            Map<RemoteSailingServerReference, Util.Pair<Iterable<EventBase>, Exception>> map = Collections.unmodifiableMap(this.cachedEventsForRemoteSailingServers);
            return map;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    public RemoteSailingServerReference remove(String name) {
        RemoteSailingServerReference ref = null;
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            ref = (RemoteSailingServerReference)this.remoteSailingServers.remove(name);
            if (ref != null) {
                this.cachedEventsForRemoteSailingServers.remove(ref);
                this.cachedStatisticsByYearForRemoteSailingServers.remove(ref);
                this.cachedTrackedRacesForRemoteSailingServers.remove(ref);
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
        this.notifyRemoteRaceResultReceivedCallbacks();
        return ref;
    }

    public Util.Pair<Iterable<EventBase>, Exception> getEventsOrException(RemoteSailingServerReference ref, boolean forceUpdate) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            if (forceUpdate || !this.remoteSailingServers.containsKey(ref.getName())) {
                this.remoteSailingServers.put(ref.getName(), ref);
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
        return this.updateRemoteServerEventCacheSynchronously(ref);
    }

    public Util.Pair<Iterable<EventBase>, Exception> getEventsComplete(RemoteSailingServerReference ref) {
        return this.loadEventsForRemoteServerReference(ref.getName(), false, null, ref.getURL());
    }

    public Iterable<RemoteSailingServerReference> getLiveRemoteServerReferences() {
        ArrayList<RemoteSailingServerReference> result = new ArrayList<RemoteSailingServerReference>();
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            for (Map.Entry e : this.cachedEventsForRemoteSailingServers.entrySet()) {
                if (((Util.Pair)e.getValue()).getB() != null) continue;
                result.add((RemoteSailingServerReference)e.getKey());
            }
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
        return result;
    }

    public Map<RemoteSailingServerReference, Util.Pair<Map<Integer, Statistics>, Exception>> getCachedStatisticsForRemoteSailingServers() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            Map<RemoteSailingServerReference, Util.Pair<Map<Integer, Statistics>, Exception>> map = Collections.unmodifiableMap(this.cachedStatisticsByYearForRemoteSailingServers);
            return map;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    public Map<RemoteSailingServerReference, Util.Pair<Iterable<SimpleRaceInfo>, Exception>> getCachedRaceList() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            Map<RemoteSailingServerReference, Util.Pair<Iterable<SimpleRaceInfo>, Exception>> map = Collections.unmodifiableMap(this.cachedTrackedRacesForRemoteSailingServers);
            return map;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    public DetailedRaceInfo getDetailedInfoBlocking(SimpleRaceInfo matching) {
        try {
            URL remoteRequestUrl = this.getDetailRaceInfoURL(matching.getRemoteUrl(), matching);
            logger.fine("Loading DetailedRace data for remote server from URL " + remoteRequestUrl);
            URLConnection urlConnection = HttpUrlConnectionHelper.redirectConnection((URL)remoteRequestUrl);
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));){
                JSONParser parser = new JSONParser();
                JSONObject detailedInfoAsJson = (JSONObject)parser.parse((Reader)bufferedReader);
                DetailedRaceInfoJsonSerializer detailedRaceListJsonSerializer = new DetailedRaceInfoJsonSerializer();
                DetailedRaceInfo detailedInfoAsJava = detailedRaceListJsonSerializer.deserialize(detailedInfoAsJson);
                if (detailedInfoAsJava.getRemoteUrl() == null) {
                    detailedInfoAsJava = new DetailedRaceInfo(detailedInfoAsJava, matching.getRemoteUrl());
                }
                return detailedInfoAsJava;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParseException e) {
            throw new IllegalStateException("RemoteUrl could not be called ", e);
        }
    }

    private URL getDetailRaceInfoURL(URL remoteServerBaseURL, SimpleRaceInfo matching) throws MalformedURLException, UnsupportedEncodingException {
        String raceName = URLEncoder.encode(matching.getIdentifier().getRaceName(), "UTF-8").replace("+", "%20");
        String regattaName = URLEncoder.encode(matching.getIdentifier().getRegattaName(), "UTF-8").replace("+", "%20");
        String params = "raceName=" + raceName + "&regattaName=" + regattaName;
        return this.getEndpointUrl(remoteServerBaseURL, "/trackedRaces/raceDetails?" + params);
    }

    public void addRemoteRaceResultReceivedCallback(Runnable callback) {
        this.remoteRaceResultReceivedCallbacks.add(callback);
    }

    public void removeRemoteRaceResultReceivedCallback(Runnable callback) {
        this.remoteRaceResultReceivedCallbacks.remove(callback);
    }
}

