/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.remote;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonBucket;
import org.redisson.RedissonList;
import org.redisson.RedissonMap;
import org.redisson.api.RFuture;
import org.redisson.api.RemoteInvocationOptions;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.codec.CompositeCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.executor.RemotePromise;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.remote.BaseRemoteProxy;
import org.redisson.remote.BaseRemoteService;
import org.redisson.remote.RRemoteServiceResponse;
import org.redisson.remote.RemoteServiceAck;
import org.redisson.remote.RemoteServiceAckTimeoutException;
import org.redisson.remote.RemoteServiceCancelRequest;
import org.redisson.remote.RemoteServiceCancelResponse;
import org.redisson.remote.RemoteServiceRequest;
import org.redisson.remote.RemoteServiceResponse;
import org.redisson.remote.RemoteServiceTimeoutException;

public class AsyncRemoteProxy
extends BaseRemoteProxy {
    protected final String cancelRequestMapName;

    public AsyncRemoteProxy(CommandAsyncExecutor commandExecutor, String name, String responseQueueName, Codec codec, String executorId, String cancelRequestMapName, BaseRemoteService remoteService) {
        super(commandExecutor, name, responseQueueName, codec, executorId, remoteService);
        this.cancelRequestMapName = cancelRequestMapName;
    }

    protected List<Class<?>> permittedClasses() {
        return Arrays.asList(RFuture.class);
    }

    public <T> T create(final Class<T> remoteInterface, RemoteInvocationOptions options, final Class<?> syncInterface) {
        for (Method m : remoteInterface.getMethods()) {
            try {
                syncInterface.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Method '" + m.getName() + "' with params '" + Arrays.toString(m.getParameterTypes()) + "' isn't defined in " + syncInterface);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException(e);
            }
            boolean permitted = false;
            for (Class<?> clazz : this.permittedClasses()) {
                if (!clazz.isAssignableFrom(m.getReturnType())) continue;
                permitted = true;
                break;
            }
            if (permitted) continue;
            throw new IllegalArgumentException(m.getReturnType().getClass() + " isn't allowed as return type");
        }
        final RemoteInvocationOptions optionsCopy = new RemoteInvocationOptions(options);
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                CompletableFuture responseFuture;
                if (method.getName().equals("toString")) {
                    return proxy.getClass().getName() + "-" + remoteInterface.getName();
                }
                if (method.getName().equals("equals")) {
                    return proxy == args[0];
                }
                if (method.getName().equals("hashCode")) {
                    return (proxy.getClass().getName() + "-" + remoteInterface.getName()).hashCode();
                }
                if (!(optionsCopy.isResultExpected() || method.getReturnType().equals(Void.class) || method.getReturnType().equals(Void.TYPE) || method.getReturnType().equals(RFuture.class))) {
                    throw new IllegalArgumentException("The noResult option only supports void return value");
                }
                String requestId = AsyncRemoteProxy.this.remoteService.generateRequestId(args);
                String requestQueueName = AsyncRemoteProxy.this.getRequestQueueName(syncInterface);
                Long ackTimeout = optionsCopy.getAckTimeoutInMillis();
                RemoteServiceRequest request = new RemoteServiceRequest(AsyncRemoteProxy.this.executorId, requestId, method.getName(), AsyncRemoteProxy.this.remoteService.getMethodSignature(method), args, optionsCopy, System.currentTimeMillis());
                CompletableFuture ackFuture = optionsCopy.isAckExpected() ? AsyncRemoteProxy.this.pollResponse(optionsCopy.getAckTimeoutInMillis(), requestId, false) : null;
                if (optionsCopy.isResultExpected()) {
                    long timeout = AsyncRemoteProxy.this.remoteService.getTimeout(optionsCopy.getExecutionTimeoutInMillis(), request);
                    responseFuture = AsyncRemoteProxy.this.pollResponse(timeout, requestId, false);
                } else {
                    responseFuture = null;
                }
                RemotePromise result = AsyncRemoteProxy.this.createResultPromise(optionsCopy, requestId, requestQueueName, ackTimeout);
                CompletableFuture<Boolean> addFuture = AsyncRemoteProxy.this.remoteService.addAsync(requestQueueName, request, result);
                addFuture.whenComplete((res, e) -> {
                    if (e != null) {
                        if (responseFuture != null) {
                            responseFuture.cancel(false);
                        }
                        if (ackFuture != null) {
                            ackFuture.cancel(false);
                        }
                        result.completeExceptionally((Throwable)e);
                        return;
                    }
                    if (!res.booleanValue()) {
                        result.completeExceptionally(new RedisException("Task hasn't been added"));
                        if (responseFuture != null) {
                            responseFuture.cancel(false);
                        }
                        if (ackFuture != null) {
                            ackFuture.cancel(false);
                        }
                        return;
                    }
                    if (optionsCopy.isAckExpected()) {
                        ackFuture.whenComplete((ack, ex) -> {
                            if (ex != null) {
                                if (responseFuture != null) {
                                    responseFuture.cancel(false);
                                }
                                result.completeExceptionally((Throwable)ex);
                                return;
                            }
                            if (ack == null) {
                                String ackName = AsyncRemoteProxy.this.remoteService.getAckName(requestId);
                                CompletionStage<RemoteServiceAck> ackFutureAttempt = AsyncRemoteProxy.this.tryPollAckAgainAsync(optionsCopy, ackName, requestId);
                                ackFutureAttempt.whenComplete((re, ex2) -> {
                                    if (ex2 != null) {
                                        result.completeExceptionally((Throwable)ex2);
                                        return;
                                    }
                                    if (re == null) {
                                        RemoteServiceAckTimeoutException exc = new RemoteServiceAckTimeoutException("No ACK response after " + optionsCopy.getAckTimeoutInMillis() + "ms for request: " + requestId);
                                        result.completeExceptionally(exc);
                                        return;
                                    }
                                    AsyncRemoteProxy.this.awaitResultAsync(optionsCopy, result, ackName, responseFuture);
                                });
                            } else {
                                AsyncRemoteProxy.this.awaitResultAsync(optionsCopy, result, responseFuture);
                            }
                        });
                    } else {
                        AsyncRemoteProxy.this.awaitResultAsync(optionsCopy, result, responseFuture);
                    }
                });
                return AsyncRemoteProxy.this.convertResult(result, method.getReturnType());
            }
        };
        return (T)Proxy.newProxyInstance(remoteInterface.getClassLoader(), new Class[]{remoteInterface}, handler);
    }

    protected Object convertResult(RemotePromise<Object> result, Class<?> returnType) {
        return new CompletableFutureWrapper<Object>((CompletableFuture<Object>)result);
    }

    private void awaitResultAsync(RemoteInvocationOptions optionsCopy, RemotePromise<Object> result, String ackName, CompletableFuture<RRemoteServiceResponse> responseFuture) {
        RFuture<Boolean> deleteFuture = new RedissonBucket(this.commandExecutor, ackName).deleteAsync();
        deleteFuture.whenComplete((res, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
                return;
            }
            this.awaitResultAsync(optionsCopy, result, responseFuture);
        });
    }

    protected void awaitResultAsync(RemoteInvocationOptions optionsCopy, RemotePromise<Object> result, CompletionStage<RRemoteServiceResponse> responseFuture) {
        if (!optionsCopy.isResultExpected()) {
            return;
        }
        responseFuture.whenComplete((res, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (res == null) {
                RemoteServiceTimeoutException ex = new RemoteServiceTimeoutException("No response after " + optionsCopy.getExecutionTimeoutInMillis() + "ms for request: " + result.getRequestId());
                result.completeExceptionally(ex);
                return;
            }
            if (res instanceof RemoteServiceCancelResponse) {
                result.doCancel(true);
                return;
            }
            RemoteServiceResponse response = (RemoteServiceResponse)res;
            if (response.getError() != null) {
                result.completeExceptionally(response.getError());
                return;
            }
            result.complete(response.getResult());
        });
    }

    private RemotePromise<Object> createResultPromise(final RemoteInvocationOptions optionsCopy, final String requestId, final String requestQueueName, final Long ackTimeout) {
        RemotePromise<Object> result = new RemotePromise<Object>(requestId){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (this.isCancelled()) {
                    return true;
                }
                if (this.isDone()) {
                    return false;
                }
                if (optionsCopy.isAckExpected()) {
                    String ackName = AsyncRemoteProxy.this.remoteService.getAckName(requestId);
                    RFuture future = AsyncRemoteProxy.this.commandExecutor.evalWriteAsync(AsyncRemoteProxy.this.responseQueueName, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('setnx', KEYS[1], 1) == 1 then redis.call('pexpire', KEYS[1], ARGV[1]);return 1;end;return 0;", Arrays.asList(ackName), ackTimeout);
                    boolean ackNotSent = (Boolean)AsyncRemoteProxy.this.commandExecutor.get(future);
                    if (ackNotSent) {
                        RedissonList list = new RedissonList(LongCodec.INSTANCE, AsyncRemoteProxy.this.commandExecutor, requestQueueName, null);
                        list.remove(requestId);
                        super.cancel(mayInterruptIfRunning);
                        return true;
                    }
                    return this.executeCancel(mayInterruptIfRunning);
                }
                Boolean removed = AsyncRemoteProxy.this.commandExecutor.get(AsyncRemoteProxy.this.remoteService.removeAsync(requestQueueName, requestId));
                if (removed == null || removed.booleanValue()) {
                    super.cancel(mayInterruptIfRunning);
                    return true;
                }
                return this.executeCancel(mayInterruptIfRunning);
            }

            private boolean executeCancel(boolean mayInterruptIfRunning) {
                if (this.isCancelled()) {
                    return true;
                }
                if (this.isDone()) {
                    return false;
                }
                AsyncRemoteProxy.this.cancelExecution(optionsCopy, mayInterruptIfRunning, this, AsyncRemoteProxy.this.cancelRequestMapName);
                try {
                    this.toCompletableFuture().get(60L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return this.isCancelled();
            }

            @Override
            public CompletableFuture<Boolean> cancelAsync(boolean mayInterruptIfRunning) {
                return AsyncRemoteProxy.this.cancelAsync(optionsCopy, this, requestId, requestQueueName, ackTimeout, mayInterruptIfRunning);
            }
        };
        return result;
    }

    private CompletableFuture<Boolean> cancelAsync(RemoteInvocationOptions optionsCopy, RemotePromise<Object> promise, String requestId, String requestQueueName, Long ackTimeout, boolean mayInterruptIfRunning) {
        if (promise.isCancelled()) {
            return CompletableFuture.completedFuture(true);
        }
        if (promise.isDone()) {
            return CompletableFuture.completedFuture(false);
        }
        if (optionsCopy.isAckExpected()) {
            String ackName = this.remoteService.getAckName(requestId);
            RFuture f = this.commandExecutor.evalWriteNoRetryAsync(this.responseQueueName, LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('setnx', KEYS[1], 1) == 1 then redis.call('pexpire', KEYS[1], ARGV[1]);return 1;end;return 0;", Arrays.asList(ackName), ackTimeout);
            CompletableFuture future = f.toCompletableFuture();
            return future.thenCompose(ackNotSent -> {
                if (ackNotSent.booleanValue()) {
                    RedissonList list = new RedissonList(LongCodec.INSTANCE, this.commandExecutor, requestQueueName, null);
                    CompletableFuture removeFuture = list.removeAsync(requestId).toCompletableFuture();
                    return removeFuture.thenApply(res -> {
                        promise.doCancel(mayInterruptIfRunning);
                        return true;
                    });
                }
                return this.doCancelAsync(mayInterruptIfRunning, promise, optionsCopy);
            });
        }
        CompletableFuture<Boolean> removeFuture = this.remoteService.removeAsync(requestQueueName, requestId);
        return removeFuture.thenCompose(removed -> {
            if (removed == null || removed.booleanValue()) {
                promise.doCancel(mayInterruptIfRunning);
            }
            return this.doCancelAsync(mayInterruptIfRunning, promise, optionsCopy);
        });
    }

    private CompletableFuture<Boolean> doCancelAsync(boolean mayInterruptIfRunning, RemotePromise<Object> promise, RemoteInvocationOptions optionsCopy) {
        if (promise.isCancelled()) {
            return CompletableFuture.completedFuture(true);
        }
        if (promise.isDone()) {
            return CompletableFuture.completedFuture(false);
        }
        this.cancelExecution(optionsCopy, mayInterruptIfRunning, promise, this.cancelRequestMapName);
        return promise.toCompletableFuture().thenApply(r -> promise.isCancelled());
    }

    private void cancelExecution(RemoteInvocationOptions optionsCopy, boolean mayInterruptIfRunning, RemotePromise<Object> remotePromise, String cancelRequestMapName) {
        RedissonMap<String, RemoteServiceCancelRequest> canceledRequests = new RedissonMap<String, RemoteServiceCancelRequest>(new CompositeCodec(StringCodec.INSTANCE, this.codec, this.codec), this.commandExecutor, cancelRequestMapName, null, null, null);
        canceledRequests.fastPutAsync(remotePromise.getRequestId().toString(), new RemoteServiceCancelRequest(mayInterruptIfRunning, false));
        canceledRequests.expireAsync(60L, TimeUnit.SECONDS);
        if (!optionsCopy.isResultExpected()) {
            RemoteInvocationOptions options = new RemoteInvocationOptions(optionsCopy);
            options.expectResultWithin(60L, TimeUnit.SECONDS);
            CompletableFuture<RRemoteServiceResponse> responseFuture = this.pollResponse(options.getExecutionTimeoutInMillis(), remotePromise.getRequestId(), false);
            this.awaitResultAsync(options, remotePromise, responseFuture);
        }
    }
}

