/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Sideline;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprintRegistry;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.shared.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.tracking.DynamicRaceDefinitionSet;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.RaceListener;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.impl.AsynchronousRunnableExecutor;
import com.sap.sailing.domain.tracking.impl.DynamicTrackedRaceImpl;
import com.sap.sailing.domain.tracking.impl.RunnableExecutor;
import com.sap.sailing.domain.tracking.impl.SynchronousRunnableExecutor;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.metering.CPUMeter;
import com.sap.sse.util.ThreadLocalTransporter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TrackedRegattaImpl
implements TrackedRegatta {
    private static final long serialVersionUID = 6480508193567014285L;
    private static final Logger logger = Logger.getLogger(TrackedRegattaImpl.class.getName());
    private final Regatta regatta;
    private final NamedReentrantReadWriteLock trackedRacesLock;
    private final Map<RaceDefinition, TrackedRace> trackedRaces;
    private transient ConcurrentMap<RaceListener, RunnableExecutor> raceListeners;
    private final NamedReentrantReadWriteLock raceListenersLock;

    public TrackedRegattaImpl(Regatta regatta) {
        this.trackedRacesLock = new NamedReentrantReadWriteLock("trackeRaces lock for tracked regatta " + regatta.getName(), false);
        this.regatta = regatta;
        this.trackedRaces = new HashMap<RaceDefinition, TrackedRace>();
        this.raceListeners = new ConcurrentHashMap<RaceListener, RunnableExecutor>();
        this.raceListenersLock = new NamedReentrantReadWriteLock("raceListeners lock for tracked regatta " + regatta.getName(), false);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.raceListeners = new ConcurrentHashMap<RaceListener, RunnableExecutor>();
    }

    public CPUMeter getCPUMeter() {
        return this.getRegatta().getCPUMeter();
    }

    @Override
    public void lockTrackedRacesForRead() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.trackedRacesLock);
    }

    @Override
    public void unlockTrackedRacesAfterRead() {
        LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.trackedRacesLock);
    }

    @Override
    public void lockTrackedRacesForWrite() {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.trackedRacesLock);
    }

    @Override
    public void unlockTrackedRacesAfterWrite() {
        LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.trackedRacesLock);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.lockTrackedRacesForRead();
        try {
            oos.defaultWriteObject();
        }
        finally {
            this.unlockTrackedRacesAfterRead();
        }
    }

    @Override
    public void addTrackedRace(TrackedRace trackedRace, Optional<ThreadLocalTransporter> threadLocalTransporter) {
        this.lockTrackedRacesForWrite();
        try {
            logger.info("adding tracked race for " + trackedRace.getRace() + " to tracked regatta " + this.getRegatta().getName() + " with regatta hash code " + this.getRegatta().hashCode());
            TrackedRace oldTrackedRace = this.trackedRaces.put(trackedRace.getRace(), trackedRace);
            if (oldTrackedRace != trackedRace) {
                this.notifyListenersAboutTrackedRaceAdded(trackedRace, threadLocalTransporter);
            }
        }
        finally {
            this.unlockTrackedRacesAfterWrite();
        }
    }

    protected void notifyListenersAboutTrackedRaceAdded(TrackedRace trackedRace, Optional<ThreadLocalTransporter> threadLocalTransporter) {
        this.enqueEvent(listener -> listener.raceAdded(trackedRace), threadLocalTransporter);
    }

    protected void enqueEvent(Consumer<RaceListener> fireEventCallback, Optional<ThreadLocalTransporter> threadLocalTransporter) {
        threadLocalTransporter.ifPresent(ThreadLocalTransporter::rememberThreadLocalStates);
        LockUtil.executeWithReadLock((NamedReentrantReadWriteLock)this.raceListenersLock, () -> this.raceListeners.forEach((listener, eventQueue) -> eventQueue.addWork(() -> this.withBeforeAndAfterHandling(threadLocalTransporter, () -> fireEventCallback.accept((RaceListener)listener)))));
    }

    private void withBeforeAndAfterHandling(Optional<ThreadLocalTransporter> threadLocalTransporter, Runnable action) {
        threadLocalTransporter.ifPresent(ThreadLocalTransporter::pushThreadLocalStates);
        try {
            action.run();
        }
        finally {
            threadLocalTransporter.ifPresent(ThreadLocalTransporter::popThreadLocalStates);
        }
    }

    @Override
    public void removeTrackedRace(TrackedRace trackedRace, Optional<ThreadLocalTransporter> threadLocalTransporter) {
        this.lockTrackedRacesForWrite();
        try {
            this.trackedRaces.remove(trackedRace.getRace());
            this.notifyListenersAboutTrackedRaceRemoved(trackedRace, threadLocalTransporter);
        }
        finally {
            this.unlockTrackedRacesAfterWrite();
        }
    }

    protected void notifyListenersAboutTrackedRaceRemoved(TrackedRace trackedRace, Optional<ThreadLocalTransporter> threadLocalTransporter) {
        this.enqueEvent(listener -> listener.raceRemoved(trackedRace), threadLocalTransporter);
    }

    @Override
    public Regatta getRegatta() {
        return this.regatta;
    }

    @Override
    public Iterable<? extends TrackedRace> getTrackedRaces() {
        if (this.trackedRacesLock.getReadHoldCount() <= 0 && this.trackedRacesLock.getWriteHoldCount() <= 0) {
            throw new IllegalStateException("Callers of TrackedRegatta.getTrackedRaces() must hold the read lock; see TrackedRegatta.lockTrackedRacesForRead()");
        }
        return this.trackedRaces.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrackedRace getTrackedRace(RaceDefinition race) {
        boolean interrupted = false;
        TrackedRace result = this.getExistingTrackedRace(race);
        if (!interrupted && result == null) {
            final Object mutex = new Object();
            RaceListener listener = new RaceListener(){

                @Override
                public void raceRemoved(TrackedRace trackedRace) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void raceAdded(TrackedRace trackedRace) {
                    Object object = mutex;
                    synchronized (object) {
                        mutex.notifyAll();
                    }
                }
            };
            this.addRaceListener(listener, Optional.empty(), false);
            try {
                Object object = mutex;
                synchronized (object) {
                    if (this.getRegatta().getRaceByName(race.getName()) == null) {
                        throw new IllegalStateException("Race " + race.getName() + " not in regatta " + this.getRegatta().getName() + "; not blocking for it to appear. It most likely won't");
                    }
                    result = this.getExistingTrackedRace(race);
                    while (!interrupted && result == null) {
                        try {
                            mutex.wait();
                            result = this.getExistingTrackedRace(race);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
            }
            finally {
                this.removeRaceListener(listener);
            }
        }
        return result;
    }

    @Override
    public TrackedRace getExistingTrackedRace(RaceDefinition race) {
        this.lockTrackedRacesForRead();
        try {
            TrackedRace trackedRace = this.trackedRaces.get(race);
            return trackedRace;
        }
        finally {
            this.unlockTrackedRacesAfterRead();
        }
    }

    @Override
    public void addRaceListener(RaceListener listener, Optional<ThreadLocalTransporter> threadLocalTransporter, boolean synchronous) {
        assert (!synchronous || !threadLocalTransporter.isPresent());
        this.lockTrackedRacesForRead();
        try {
            LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.raceListenersLock, () -> this.raceListeners.computeIfAbsent(listener, listenerToAdd -> {
                RunnableExecutor eventQueue = synchronous ? new SynchronousRunnableExecutor() : new AsynchronousRunnableExecutor();
                ArrayList trackedRacesCopy = new ArrayList();
                Util.addAll(this.getTrackedRaces(), trackedRacesCopy);
                threadLocalTransporter.ifPresent(ThreadLocalTransporter::rememberThreadLocalStates);
                eventQueue.addWork(() -> this.withBeforeAndAfterHandling(threadLocalTransporter, () -> {
                    for (TrackedRace trackedRace : trackedRacesCopy) {
                        listenerToAdd.raceAdded(trackedRace);
                    }
                }));
                return eventQueue;
            }));
        }
        finally {
            this.unlockTrackedRacesAfterRead();
        }
    }

    @Override
    public Future<Boolean> removeRaceListener(RaceListener listener) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        this.lockTrackedRacesForRead();
        try {
            RunnableExecutor eventQueue = (RunnableExecutor)LockUtil.executeWithWriteLockAndResult((NamedReentrantReadWriteLock)this.raceListenersLock, () -> (RunnableExecutor)this.raceListeners.remove(listener));
            if (eventQueue != null) {
                eventQueue.addWork(() -> result.complete(Boolean.TRUE));
            } else {
                result.complete(Boolean.TRUE);
            }
        }
        finally {
            this.unlockTrackedRacesAfterRead();
        }
        return result;
    }

    @Override
    public int getTotalPoints(Competitor competitor, TimePoint timePoint) throws NoWindException {
        int result = 0;
        this.lockTrackedRacesForRead();
        try {
            for (TrackedRace trackedRace : this.getTrackedRaces()) {
                result += trackedRace.getRank(competitor, timePoint);
            }
            int n = result;
            return n;
        }
        finally {
            this.unlockTrackedRacesAfterRead();
        }
    }

    @Override
    public DynamicTrackedRace createTrackedRace(RaceDefinition raceDefinition, Iterable<Sideline> sidelines, WindStore windStore, long delayToLiveInMillis, long millisecondsOverWhichToAverageWind, long millisecondsOverWhichToAverageSpeed, DynamicRaceDefinitionSet raceDefinitionSetToUpdate, boolean useInternalMarkPassingAlgorithm, RaceLogAndTrackedRaceResolver raceLogResolver, Optional<ThreadLocalTransporter> threadLocalTransporter, TrackingConnectorInfo trackingConnectorInfo, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry, ManeuverRaceFingerprintRegistry maneuverRaceFingerprintRegistry) {
        logger.log(Level.INFO, "Creating DynamicTrackedRaceImpl for RaceDefinition " + raceDefinition.getName());
        DynamicTrackedRaceImpl result = new DynamicTrackedRaceImpl((TrackedRegatta)this, raceDefinition, sidelines, windStore, delayToLiveInMillis, millisecondsOverWhichToAverageWind, millisecondsOverWhichToAverageSpeed, useInternalMarkPassingAlgorithm, this.getRegatta().getRankingMetricConstructor(), raceLogResolver, trackingConnectorInfo, markPassingRaceFingerprintRegistry, maneuverRaceFingerprintRegistry);
        if (raceDefinitionSetToUpdate != null) {
            raceDefinitionSetToUpdate.addRaceDefinition(raceDefinition, result);
        }
        this.addTrackedRace(result, threadLocalTransporter);
        return result;
    }
}

