/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.maneuverhash.impl;

import com.sap.sailing.domain.base.CPUMeteringType;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.maneuverdetection.ManeuverDetector;
import com.sap.sailing.domain.maneuverhash.ManeuverCache;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.impl.DynamicTrackedRaceImpl;
import com.sap.sse.common.Duration;
import com.sap.sse.util.SmartFutureCache;
import java.util.Collections;
import java.util.List;

public class ManeuversFromSmartFutureCache
implements ManeuverCache {
    private final SmartFutureCache<Competitor, List<Maneuver>, SmartFutureCache.EmptyUpdateInterval> smartFutureCache;

    public ManeuversFromSmartFutureCache(final DynamicTrackedRaceImpl race) {
        this.smartFutureCache = new SmartFutureCache((SmartFutureCache.CacheUpdater)new SmartFutureCache.AbstractCacheUpdater<Competitor, List<Maneuver>, SmartFutureCache.EmptyUpdateInterval>(){

            public List<Maneuver> computeCacheUpdate(Competitor competitor, SmartFutureCache.EmptyUpdateInterval updateInterval) throws NoWindException {
                return (List)race.getTrackedRegatta().callWithCPUMeterWithException(() -> {
                    Duration averageIntervalBetweenRawFixes = race.getTrack(competitor).getAverageIntervalBetweenRawFixes();
                    if (averageIntervalBetweenRawFixes != null) {
                        ManeuverDetector maneuverDetector = race.getManeuverDetectorPerCompetitorCache().getValue(competitor);
                        List<Maneuver> maneuvers = race.computeManeuvers(competitor, maneuverDetector);
                        return maneuvers;
                    }
                    return Collections.emptyList();
                }, CPUMeteringType.MANEUVER_DETECTION.name());
            }
        }, "Maneuver cache for race " + race.getRace().getName());
    }

    @Override
    public boolean canBeUpdated() {
        return true;
    }

    @Override
    public void resume() {
        this.smartFutureCache.resume();
    }

    @Override
    public List<Maneuver> get(Competitor key, boolean waitForLatest) {
        return (List)this.smartFutureCache.get((Object)key, waitForLatest);
    }

    @Override
    public void suspend() {
        this.smartFutureCache.suspend();
    }

    @Override
    public void triggerUpdate(Competitor key) {
        this.smartFutureCache.triggerUpdate((Object)key, null);
    }
}

