/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.maneuverdetection;

import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.Positioned;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.maneuverdetection.ManeuverCurveWithUnstableCourseAndSpeedWithEstimationData;
import com.sap.sailing.domain.maneuverdetection.ManeuverMainCurveWithEstimationData;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.datamining.annotations.Connector;
import com.sap.sse.datamining.annotations.Dimension;

public interface CompleteManeuverCurveWithEstimationData
extends Timed,
Positioned {
    @Dimension(messageKey="ManeuverType")
    default public ManeuverType getManeuverTypeForCompleteManeuverCurve() {
        if (this.getJibingCount() > 0 && this.getTackingCount() > 0) {
            return ManeuverType.PENALTY_CIRCLE;
        }
        if (this.getTackingCount() > 0) {
            return ManeuverType.TACK;
        }
        if (this.getJibingCount() > 0) {
            return ManeuverType.JIBE;
        }
        if (this.getWind() == null) {
            return ManeuverType.UNKNOWN;
        }
        return this.isManeuverStartsByRunningAwayFromWind() ? ManeuverType.BEAR_AWAY : ManeuverType.HEAD_UP;
    }

    default public TimePoint getTimePoint() {
        return this.getMainCurve().getTimePointOfMaxTurningRate();
    }

    @Connector
    public ManeuverMainCurveWithEstimationData getMainCurve();

    public ManeuverCurveWithUnstableCourseAndSpeedWithEstimationData getCurveWithUnstableCourseAndSpeed();

    public Wind getWind();

    public int getTackingCount();

    public int getJibingCount();

    @Dimension(messageKey="ManeuverStartsByRunningAwayFromTheWind")
    public boolean isManeuverStartsByRunningAwayFromWind();

    public Bearing getRelativeBearingToNextMarkBeforeManeuver();

    public Bearing getRelativeBearingToNextMarkAfterManeuver();

    public Distance getDistanceToClosestMark();

    public Double getTargetTackAngleInDegrees();

    public Double getTargetJibeAngleInDegrees();

    @Dimension(messageKey="MarkPassing")
    public boolean isMarkPassing();

    default public boolean isManeuverEndClean(CompleteManeuverCurveWithEstimationData nextManeuver) {
        ManeuverCurveWithUnstableCourseAndSpeedWithEstimationData curveWithUnstableCourseAndSpeed = this.getCurveWithUnstableCourseAndSpeed();
        double secondsToNextManeuver = curveWithUnstableCourseAndSpeed.getDurationFromManeuverEndToNextManeuverStart().asSeconds();
        return curveWithUnstableCourseAndSpeed.getSpeedWithBearingAfter().getKnots() > 2.0 && curveWithUnstableCourseAndSpeed.getIntervalBetweenLastFixOfCurveAndNextFix().asSeconds() <= 4.0 && secondsToNextManeuver * 1.0 / (double)curveWithUnstableCourseAndSpeed.getGpsFixesCountFromManeuverEndToNextManeuverStart() >= 8.0 && (secondsToNextManeuver >= 4.0 || nextManeuver != null && Math.abs(nextManeuver.getMainCurve().getDirectionChangeInDegrees()) < Math.abs(this.getMainCurve().getDirectionChangeInDegrees()) * 0.3);
    }

    default public boolean isManeuverBeginningClean(CompleteManeuverCurveWithEstimationData previousManeuver) {
        ManeuverCurveWithUnstableCourseAndSpeedWithEstimationData curveWithUnstableCourseAndSpeed = this.getCurveWithUnstableCourseAndSpeed();
        double secondsToPreviousManeuver = curveWithUnstableCourseAndSpeed.getDurationFromPreviousManeuverEndToManeuverStart().asSeconds();
        return curveWithUnstableCourseAndSpeed.getSpeedWithBearingBefore().getKnots() > 2.0 && curveWithUnstableCourseAndSpeed.getIntervalBetweenFirstFixOfCurveAndPreviousFix().asSeconds() <= 4.0 && secondsToPreviousManeuver * 1.0 / (double)curveWithUnstableCourseAndSpeed.getGpsFixesCountFromPreviousManeuverEndToManeuverStart() >= 8.0 && (secondsToPreviousManeuver >= 4.0 || previousManeuver != null && Math.abs(previousManeuver.getMainCurve().getDirectionChangeInDegrees()) < Math.abs(this.getMainCurve().getDirectionChangeInDegrees()) * 0.3);
    }

    default public boolean isManeuverClean(CompleteManeuverCurveWithEstimationData previousManeuver, CompleteManeuverCurveWithEstimationData nextManeuver) {
        double speedInSpeedOutRatio;
        double d = speedInSpeedOutRatio = this.getCurveWithUnstableCourseAndSpeed().getSpeedWithBearingAfter().getKnots() < 0.1 ? 0.0 : this.getCurveWithUnstableCourseAndSpeed().getSpeedWithBearingBefore().getKnots() / this.getCurveWithUnstableCourseAndSpeed().getSpeedWithBearingAfter().getKnots();
        return (Math.abs(this.getMainCurve().getDirectionChangeInDegrees()) >= 120.0 || speedInSpeedOutRatio < 3.0 && speedInSpeedOutRatio > 0.33333333) && this.getCurveWithUnstableCourseAndSpeed().getLongestIntervalBetweenTwoFixes().asSeconds() <= 4.0 && this.isManeuverBeginningClean(previousManeuver) && this.isManeuverEndClean(nextManeuver);
    }
}

