/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared.dto;

import com.sap.sse.common.Named;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.AccountDTO;
import com.sap.sse.security.shared.dto.OwnershipDTO;
import com.sap.sse.security.shared.dto.RoleDTO;
import com.sap.sse.security.shared.dto.RoleWithSecurityDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.SecurityInformationDTO;
import com.sap.sse.security.shared.dto.StrippedRoleDefinitionDTO;
import com.sap.sse.security.shared.dto.StrippedUserDTO;
import com.sap.sse.security.shared.dto.StrippedUserGroupDTO;
import com.sap.sse.security.shared.dto.WildcardPermissionWithSecurityDTO;
import com.sap.sse.security.shared.impl.SecurityUserImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UserDTO
extends SecurityUserImpl<StrippedRoleDefinitionDTO, RoleWithSecurityDTO, StrippedUserGroupDTO, WildcardPermissionWithSecurityDTO>
implements Named,
Serializable,
SecuredDTO {
    private static final long serialVersionUID = 7556217539893146187L;
    private String email;
    private String fullName;
    private String company;
    private String locale;
    private List<AccountDTO> accounts;
    private boolean emailValidated;
    private List<StrippedUserGroupDTO> groups;
    private TimePoint lockedUntil;
    private SecurityInformationDTO securityInformation = new SecurityInformationDTO();
    private StrippedUserGroupDTO defaultTenantForCurrentServer;
    private Set<RoleWithSecurityDTO> roles;

    @Deprecated
    UserDTO() {
        super(null);
    }

    public UserDTO(String name, String email, String fullName, String company, String locale, boolean emailValidated, List<AccountDTO> accounts, Iterable<RoleWithSecurityDTO> roles, StrippedUserGroupDTO defaultTenant, Iterable<WildcardPermissionWithSecurityDTO> permissions, Iterable<StrippedUserGroupDTO> groups, TimePoint lockedUntil) {
        super(name, permissions);
        this.defaultTenantForCurrentServer = defaultTenant;
        this.email = email;
        this.fullName = fullName;
        this.company = company;
        this.locale = locale;
        this.emailValidated = emailValidated;
        this.accounts = accounts;
        this.groups = new ArrayList<StrippedUserGroupDTO>();
        Util.addAll(groups, this.groups);
        this.roles = new HashSet<RoleWithSecurityDTO>();
        Util.addAll(roles, this.getRolesInternal());
        this.lockedUntil = lockedUntil;
    }

    public UserDTO copyWithTimePoint(TimePoint lockedUntil) {
        ArrayList<AccountDTO> accountsCopy = new ArrayList<AccountDTO>();
        Util.addAll(this.accounts, accountsCopy);
        HashSet<RoleWithSecurityDTO> rolesCopy = new HashSet<RoleWithSecurityDTO>();
        Util.addAll(this.roles, rolesCopy);
        ArrayList<WildcardPermissionWithSecurityDTO> permissionsCopy = new ArrayList<WildcardPermissionWithSecurityDTO>();
        for (WildcardPermission wp : this.getPermissions()) {
            permissionsCopy.add((WildcardPermissionWithSecurityDTO)wp);
        }
        ArrayList<StrippedUserGroupDTO> groupsCopy = new ArrayList<StrippedUserGroupDTO>();
        Util.addAll(this.groups, groupsCopy);
        return new UserDTO(this.getName(), this.email, this.fullName, this.company, this.locale, this.emailValidated, accountsCopy, rolesCopy, this.defaultTenantForCurrentServer, permissionsCopy, groupsCopy, lockedUntil);
    }

    @Override
    protected Set<RoleWithSecurityDTO> getRolesInternal() {
        return this.roles;
    }

    public StrippedUserGroupDTO getDefaultTenant() {
        return this.defaultTenantForCurrentServer;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getCompany() {
        return this.company;
    }

    public String getLocale() {
        return this.locale;
    }

    public Iterable<String> getStringRoles() {
        ArrayList<String> result = new ArrayList<String>();
        for (RoleDTO role : this.getRoles()) {
            result.add(role.toString());
        }
        return result;
    }

    public Iterable<String> getStringPermissions() {
        ArrayList<String> result = new ArrayList<String>();
        for (WildcardPermission wp : this.getPermissions()) {
            result.add(wp.toString());
        }
        return result;
    }

    @Override
    public List<StrippedUserGroupDTO> getUserGroups() {
        return this.groups;
    }

    public List<AccountDTO> getAccounts() {
        return this.accounts;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isEmailValidated() {
        return this.emailValidated;
    }

    @Override
    public final AccessControlListDTO getAccessControlList() {
        return this.securityInformation.getAccessControlList();
    }

    @Override
    public final OwnershipDTO getOwnership() {
        return this.securityInformation.getOwnership();
    }

    @Override
    public final void setAccessControlList(AccessControlListDTO accessControlList) {
        this.securityInformation.setAccessControlList(accessControlList);
    }

    @Override
    public final void setOwnership(OwnershipDTO ownership) {
        this.securityInformation.setOwnership(ownership);
    }

    public void setDefaultTenantForCurrentServer(StrippedUserGroupDTO defaultTenant) {
        this.defaultTenantForCurrentServer = defaultTenant;
    }

    public StrippedUserDTO asStrippedUser() {
        return new StrippedUserDTO(this.getName());
    }

    @Override
    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return new TypeRelativeObjectIdentifier(new String[]{this.getName()});
    }

    public void clearNonPublicFields() {
        this.email = null;
    }

    public TimePoint getLockedUntil() {
        return this.lockedUntil;
    }
}

