/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.vakarosadapter;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.domain.trackimport.GPSFixImporter;
import com.sap.sailing.domain.vakarosadapter.VakarosExtendedDataImporterImpl;
import com.sap.sailing.server.trackfiles.impl.CompressedStreamsUtil;
import com.sap.sailing.server.trackfiles.impl.ExpeditionImportFileHandler;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VakarosGPSFixImporter
implements GPSFixImporter {
    private static final Logger logger = Logger.getLogger(VakarosGPSFixImporter.class.getName());
    private static final List<String> supportedExpeditionLogFileExtensions = Arrays.asList("csv", "vak", "zip", "gz");
    static final String TIMESTAMP_COLUMN_HEADING = "timestamp";
    private static final String LAT_COLUMN_HEADING = "latitude";
    private static final String LON_COLUMN_HEADING = "longitude";
    private static final String SOG_COLUMN_HEADING = "sog_kts";
    private static final String COG_COLUMN_HEADING = "cog";
    private static final String HDG_COLUMN_HEADING = "hdg_true";
    private static final String VAKAROS_TYPE = "Vakaros";

    public boolean importFixes(InputStream inputStream, Charset charset, final GPSFixImporter.Callback callback, boolean inferSpeedAndBearing, String sourceName) throws FormatNotSupportedException, IOException {
        TrackFileImportDeviceIdentifierImpl gpsDevice = new TrackFileImportDeviceIdentifierImpl(sourceName, String.valueOf(this.getType()) + "@" + new Date());
        AtomicBoolean importedFixes = new AtomicBoolean(false);
        CompressedStreamsUtil.handlePotentiallyCompressedFiles((String)sourceName, (InputStream)inputStream, (Charset)charset, (CompressedStreamsUtil.FileHandler)new ExpeditionImportFileHandler(Arrays.asList("vak", "csv", "log", "txt"), (TrackFileImportDeviceIdentifier)gpsDevice, importedFixes){
            private final /* synthetic */ TrackFileImportDeviceIdentifier val$gpsDevice;
            private final /* synthetic */ AtomicBoolean val$importedFixes;
            {
                this.val$gpsDevice = trackFileImportDeviceIdentifier;
                this.val$importedFixes = atomicBoolean;
                super($anonymous0);
            }

            protected void handleExpeditionFile(String fileName, InputStream stream, Charset charset) throws IOException {
                BufferedReader br = new BufferedReader(new InputStreamReader(stream, charset));
                String headerLine = br.readLine();
                VakarosExtendedDataImporterImpl importer = new VakarosExtendedDataImporterImpl();
                Map columnDefinitions = importer.parseHeader(headerLine);
                AtomicInteger lineNr = new AtomicInteger(0);
                br.lines().forEach(line -> {
                    if (!line.trim().isEmpty()) {
                        importer.parseLine(lineNr.incrementAndGet(), fileName, (String)line, columnDefinitions, (timePoint, columnValues, columns) -> {
                            DegreeBearingImpl optionalTrueHeading;
                            double latDeg = Double.parseDouble(columnValues[(Integer)columns.get(VakarosGPSFixImporter.LAT_COLUMN_HEADING)]);
                            double lonDeg = Double.parseDouble(columnValues[(Integer)columns.get(VakarosGPSFixImporter.LON_COLUMN_HEADING)]);
                            double cogDeg = Double.parseDouble(columnValues[(Integer)columns.get(VakarosGPSFixImporter.COG_COLUMN_HEADING)]);
                            double sogKnots = Double.parseDouble(columnValues[(Integer)columns.get(VakarosGPSFixImporter.SOG_COLUMN_HEADING)]);
                            DegreePosition position = new DegreePosition(latDeg, lonDeg);
                            if (columns.containsKey(VakarosGPSFixImporter.HDG_COLUMN_HEADING)) {
                                try {
                                    optionalTrueHeading = new DegreeBearingImpl(Double.parseDouble(columnValues[(Integer)columns.get(VakarosGPSFixImporter.HDG_COLUMN_HEADING)]));
                                }
                                catch (NumberFormatException e) {
                                    logger.log(Level.WARNING, "Problem obtaining declination for Expedition fix heading", e);
                                    optionalTrueHeading = null;
                                }
                            } else {
                                optionalTrueHeading = null;
                            }
                            GPSFixMovingImpl fix = new GPSFixMovingImpl((Position)position, timePoint, (SpeedWithBearing)new KnotSpeedWithBearingImpl(sogKnots, (Bearing)new DegreeBearingImpl(cogDeg)), (Bearing)optionalTrueHeading);
                            callback.addFix((GPSFix)fix, this.val$gpsDevice);
                            this.val$importedFixes.set(true);
                        });
                    }
                });
            }
        });
        return importedFixes.get();
    }

    public Iterable<String> getSupportedFileExtensions() {
        return supportedExpeditionLogFileExtensions;
    }

    public String getType() {
        return VAKAROS_TYPE;
    }
}

