/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.vakarosadapter;

import com.sap.sailing.domain.common.sensordata.ExpeditionExtendedSensorDataMetadata;
import com.sap.sailing.domain.common.tracking.DoubleVectorFix;
import com.sap.sailing.domain.common.tracking.impl.DoubleVectorFixImpl;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.domain.trackimport.BaseDoubleVectorFixImporter;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.server.trackfiles.impl.ExpeditionExtendedDataImporterImpl;
import com.sap.sailing.server.trackfiles.impl.ExpeditionImportFileHandler;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VakarosExtendedDataImporterImpl
extends ExpeditionExtendedDataImporterImpl {
    private static final Logger logger = Logger.getLogger(VakarosExtendedDataImporterImpl.class.getName());
    private static final DateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    private static final String VAKAROS_EXTENDED = "VAKAROS_EXTENDED";
    private static final String HEEL_COLUMN_HEADING = "roll";
    private static final String PITCH_COLUMN_HEADING = "pitch";
    private static final String LOAD_GDF1_COLUMN_HEADING = "load_gdf1";
    private static final double LOAD_GDF1_CONVERSION_FACTOR_TO_FORESTAY_LOAD_IN_TONS = 0.001;
    private static final String LOAD_GDF2_COLUMN_HEADING = "load_gdf2";

    public VakarosExtendedDataImporterImpl() {
        super(VAKAROS_EXTENDED);
    }

    protected ExpeditionImportFileHandler getFileHandler(final TrackFileImportDeviceIdentifier trackIdentifier, final AtomicBoolean importedFixes, final BaseDoubleVectorFixImporter.Callback callback) {
        final Map<String, Integer> columnNamesToIndexInDoubleFix = this.getColumnNamesToIndexInDoubleFix();
        return new ExpeditionImportFileHandler(Arrays.asList("vak", "csv", "log", "txt")){

            protected void handleExpeditionFile(String fileName, InputStream inputStream, Charset charset) throws IOException, FormatNotSupportedException {
                BaseDoubleVectorFixImporter.Callback unitConvertingCallback = new BaseDoubleVectorFixImporter.Callback(){

                    public void addFixes(Iterable<DoubleVectorFix> fixes, TrackFileImportDeviceIdentifier device) {
                        callback.addFixes(Util.map(fixes, fix -> {
                            DoubleVectorFix newFix;
                            if (fix.get(((Integer)columnNamesToIndexInDoubleFix.get(VakarosExtendedDataImporterImpl.LOAD_GDF1_COLUMN_HEADING)).intValue()) != null) {
                                Double[] values = fix.get();
                                values[((Integer)map.get((Object)VakarosExtendedDataImporterImpl.LOAD_GDF1_COLUMN_HEADING)).intValue()] = values[(Integer)columnNamesToIndexInDoubleFix.get(VakarosExtendedDataImporterImpl.LOAD_GDF1_COLUMN_HEADING)] * 0.001;
                                newFix = new DoubleVectorFixImpl(fix.getTimePoint(), values);
                            } else {
                                newFix = fix;
                            }
                            return newFix;
                        }), device);
                    }
                };
                VakarosExtendedDataImporterImpl.this.handleExpeditionFile(fileName, inputStream, charset, trackIdentifier, importedFixes, unitConvertingCallback);
            }
        };
    }

    protected Map<String, Integer> getColumnNamesToIndexInDoubleFix() {
        return Util.mapBuilder().put((Object)HEEL_COLUMN_HEADING, (Object)ExpeditionExtendedSensorDataMetadata.HEEL.getColumnIndex()).put((Object)PITCH_COLUMN_HEADING, (Object)ExpeditionExtendedSensorDataMetadata.TRIM.getColumnIndex()).put((Object)LOAD_GDF1_COLUMN_HEADING, (Object)ExpeditionExtendedSensorDataMetadata.FORESTAY_LOAD.getColumnIndex()).put((Object)LOAD_GDF2_COLUMN_HEADING, (Object)ExpeditionExtendedSensorDataMetadata.EXPEDITION_KICKER_TENSION.getColumnIndex()).build();
    }

    protected TrackFileImportDeviceIdentifierImpl getTrackIdentifier(String filename, String sourceName) {
        return new TrackFileImportDeviceIdentifierImpl(UUID.randomUUID(), String.valueOf(filename) + "-SENSORS", sourceName, MillisecondsTimePoint.now());
    }

    public TimePoint getTimePointFromLine(Map<String, Integer> columnsInFileFromHeader, String[] lineContentTokens) throws ParseException {
        return TimePoint.of((Date)timestampFormat.parse(String.valueOf(lineContentTokens[columnsInFileFromHeader.get("timestamp")]) + "Z"));
    }

    public void validateHeader(Map<String, Integer> colIndicesInFile) throws FormatNotSupportedException {
        boolean dateTimeFormatOk = colIndicesInFile.containsKey("timestamp");
        if (!dateTimeFormatOk) {
            String msg = "Missing timestamp header; expected timestamp";
            logger.log(Level.SEVERE, "Missing timestamp header; expected timestamp");
            throw new FormatNotSupportedException("Missing timestamp header; expected timestamp");
        }
    }
}

