/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.impl.LogEventAuthorImpl;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogCourseDesignChangedEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEndOfTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogRaceStatusEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartOfTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.LastPublishedCourseDesignFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.TrackingTimesFinder;
import com.sap.sailing.domain.abstractlog.race.impl.BaseRaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogEndOfTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogStartOfTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogDenoteForTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogRegisterCompetitorEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogStartTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.analyzing.impl.RaceInformationFinder;
import com.sap.sailing.domain.abstractlog.race.tracking.analyzing.impl.RaceLogTrackingStateAnalyzer;
import com.sap.sailing.domain.abstractlog.race.tracking.analyzing.impl.RegisteredCompetitorsAndBoatsAnalyzer;
import com.sap.sailing.domain.abstractlog.race.tracking.impl.RaceLogRegisterCompetitorEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDefineMarkEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRegisterCompetitorEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogRegisterCompetitorEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.impl.BaseRegattaLogEventVisitor;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.impl.CourseDataImpl;
import com.sap.sailing.domain.base.impl.CourseImpl;
import com.sap.sailing.domain.base.impl.RaceColumnListenerWithDefaultAction;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.abstractlog.NotRevokableException;
import com.sap.sailing.domain.common.abstractlog.TimePointSpecificationFoundInLog;
import com.sap.sailing.domain.common.racelog.RaceLogRaceStatus;
import com.sap.sailing.domain.common.racelog.tracking.RaceLogTrackingState;
import com.sap.sailing.domain.common.racelog.tracking.RaceNotCreatedException;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprintRegistry;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.racelogtracking.RaceLogTrackingAdapter;
import com.sap.sailing.domain.racelogtracking.impl.RaceLogConnectivityParams;
import com.sap.sailing.domain.racelogtracking.impl.RaceLogRacesHandle;
import com.sap.sailing.domain.shared.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.shared.tracking.impl.TrackingConnectorInfoImpl;
import com.sap.sailing.domain.tracking.AbstractRaceTrackerBaseImpl;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.RaceTracker;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RaceLogRaceTracker
extends AbstractRaceTrackerBaseImpl<RaceLogConnectivityParams> {
    private static final String LOGGER_AND_LOGAUTHOR_NAME = RaceLogRaceTracker.class.getName();
    private static final Logger logger = Logger.getLogger(LOGGER_AND_LOGAUTHOR_NAME);
    private final AbstractLogEventAuthor raceLogEventAuthor = new LogEventAuthorImpl(LOGGER_AND_LOGAUTHOR_NAME, 0);
    private final Map<AbstractLog<?, ?>, Object> visitors = new HashMap();
    private final RaceLogConnectivityParams params;
    private final WindStore windStore;
    private final DynamicTrackedRegatta trackedRegatta;
    private final RaceLogAndTrackedRaceResolver raceLogResolver;
    private final TrackedRegattaRegistry trackedRegattaRegistry;
    private final MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry;
    private final ManeuverRaceFingerprintRegistry maneuverRaceFingerprintRegistry;
    private volatile DynamicTrackedRace trackedRace;
    private final RaceTrackingHandler raceTrackingHandler;

    public RaceLogRaceTracker(DynamicTrackedRegatta regatta, RaceLogConnectivityParams params, WindStore windStore, RaceLogAndTrackedRaceResolver raceLogResolver, RaceLogConnectivityParams connectivityParams, TrackedRegattaRegistry trackedRegattaRegistry, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry, ManeuverRaceFingerprintRegistry maneuverRaceFingerprintRegistry) {
        super((RaceTrackingConnectivityParameters)params);
        this.trackedRegattaRegistry = trackedRegattaRegistry;
        this.params = params;
        this.windStore = windStore;
        this.trackedRegatta = regatta;
        this.raceLogResolver = raceLogResolver;
        this.markPassingRaceFingerprintRegistry = markPassingRaceFingerprintRegistry;
        this.maneuverRaceFingerprintRegistry = maneuverRaceFingerprintRegistry;
        this.raceTrackingHandler = raceTrackingHandler;
        for (final AbstractLog<?, ?> log : params.getLogHierarchy()) {
            Object visitor;
            if (log instanceof RaceLog) {
                visitor = new BaseRaceLogEventVisitor(){

                    public void visit(RaceLogStartTrackingEvent event) {
                        RaceLogRaceTracker.this.onStartTrackingEvent(event);
                    }

                    public void visit(RaceLogCourseDesignChangedEvent event) {
                        RaceLogRaceTracker.this.onCourseDesignChangedEvent(event, (RaceLog)log, ((RaceLogConnectivityParams)RaceLogRaceTracker.this.getConnectivityParams()).getDomainFactory(), (TrackedRace)RaceLogRaceTracker.this.trackedRace);
                    }

                    public void visit(RaceLogStartOfTrackingEvent event) {
                        RaceLogRaceTracker.this.onStartOfTrackingEvent(event);
                    }

                    public void visit(RaceLogEndOfTrackingEvent event) {
                        RaceLogRaceTracker.this.onEndOfTrackingEvent(event);
                    }

                    public void visit(RaceLogStartTimeEvent event) {
                        RaceLogRaceTracker.this.trackedRace.updateStartAndEndOfTracking(false);
                    }

                    public void visit(RaceLogRaceStatusEvent event) {
                        if (event.getNextStatus().equals((Object)RaceLogRaceStatus.FINISHED)) {
                            RaceLogRaceTracker.this.trackedRace.updateStartAndEndOfTracking(false);
                        }
                    }

                    public void visit(RaceLogRevokeEvent event) {
                        if (event.getRevokedEventType().equals(RaceLogRegisterCompetitorEventImpl.class.getName())) {
                            try {
                                RaceLogRaceTracker.this.checkForChangeOfCompetitorSet();
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }

                    public void visit(RaceLogRegisterCompetitorEvent event) {
                        try {
                            RaceLogRaceTracker.this.checkForChangeOfCompetitorSet();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                this.visitors.put(log, visitor);
                ((RaceLog)log).addListener(visitor);
                continue;
            }
            if (!(log instanceof RegattaLog)) continue;
            visitor = new BaseRegattaLogEventVisitor(){

                public void visit(RegattaLogDefineMarkEvent event) {
                    RaceLogRaceTracker.this.onDefineMarkEvent(event);
                }

                public void visit(RegattaLogRevokeEvent event) {
                    if (event.getRevokedEventType().equals(RegattaLogRegisterCompetitorEventImpl.class.getName())) {
                        try {
                            RaceLogRaceTracker.this.checkForChangeOfCompetitorSet();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }

                public void visit(RegattaLogRegisterCompetitorEvent event) {
                    try {
                        RaceLogRaceTracker.this.checkForChangeOfCompetitorSet();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            this.visitors.put(log, visitor);
            ((RegattaLog)log).addListener(visitor);
        }
        logger.info(String.format("Created race-log tracker for: %s %s %s", params.getLeaderboard(), params.getRaceColumn(), params.getFleet()));
        if (new RaceLogTrackingStateAnalyzer(params.getRaceLog()).analyze() == RaceLogTrackingState.TRACKING) {
            this.startTracking(null);
        }
    }

    private void checkForChangeOfCompetitorSet() throws Exception {
        Map competitorsAndTheirBoats = (Map)new RegisteredCompetitorsAndBoatsAnalyzer(this.params.getRaceLog(), this.params.getRegattaLog()).analyze();
        if (!Util.setEquals(competitorsAndTheirBoats.keySet(), (Iterable)this.getRace().getCompetitors())) {
            this.trackedRegattaRegistry.updateRaceCompetitors(this.getRegatta(), this.getRace());
        }
    }

    protected void onStop(boolean preemptive, boolean willBeRemoved) {
        RaceLog raceLog = this.params.getRaceLog();
        Util.Pair trackingTimes = (Util.Pair)new TrackingTimesFinder(raceLog).analyze();
        if (!(this.trackedRegatta.getRegatta().isControlTrackingFromStartAndFinishTimes() || trackingTimes != null && trackingTimes.getB() != null && ((TimePointSpecificationFoundInLog)trackingTimes.getB()).getTimePoint() != null)) {
            raceLog.add((AbstractLogEvent)new RaceLogEndOfTrackingEventImpl(MillisecondsTimePoint.now(), this.raceLogEventAuthor, raceLog.getCurrentPassId()));
        }
        for (Map.Entry<AbstractLog<?, ?>, Object> visitor : this.visitors.entrySet()) {
            this.removeLogListener(visitor.getKey(), visitor.getValue());
        }
        logger.info(String.format("Stopped tracking race-log race %s %s %s", this.params.getLeaderboard(), this.params.getRaceColumn(), this.params.getFleet()));
    }

    private <EventT extends AbstractLogEvent<VisitorT>, VisitorT> void removeLogListener(AbstractLog<?, ?> log, Object visitor) {
        AbstractLog<?, ?> abstractLog = log;
        Object castVisitor = visitor;
        abstractLog.removeListener(castVisitor);
    }

    public Regatta getRegatta() {
        return this.trackedRegatta.getRegatta();
    }

    public RaceDefinition getRace() {
        return this.trackedRace == null ? null : this.trackedRace.getRace();
    }

    public RegattaAndRaceIdentifier getRaceIdentifier() {
        return this.trackedRace == null ? null : this.trackedRace.getRaceIdentifier();
    }

    public RaceHandle getRaceHandle() {
        return new RaceLogRacesHandle(this);
    }

    public DynamicTrackedRegatta getTrackedRegatta() {
        return this.trackedRegatta;
    }

    public WindStore getWindStore() {
        return this.windStore;
    }

    public Object getID() {
        return this.params.getRaceLog().getId();
    }

    private void onDefineMarkEvent(RegattaLogDefineMarkEvent event) {
        if (this.trackedRace != null) {
            this.trackedRace.getOrCreateTrack(event.getMark());
        }
    }

    private void onStartTrackingEvent(RaceLogStartTrackingEvent event) {
        if (this.trackedRace == null) {
            this.startTracking(event);
        }
    }

    private void onStartOfTrackingEvent(RaceLogStartOfTrackingEvent event) {
        if (this.trackedRace != null) {
            this.trackedRace.updateStartAndEndOfTracking(false);
        }
    }

    private void onEndOfTrackingEvent(RaceLogEndOfTrackingEvent event) {
        if (this.trackedRace != null) {
            this.trackedRace.updateStartAndEndOfTracking(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTracking(RaceLogStartTrackingEvent event) {
        RaceLog raceLog = this.params.getRaceLog();
        RaceColumn raceColumn = this.params.getRaceColumn();
        Fleet fleet = this.params.getFleet();
        RaceLogDenoteForTrackingEvent denoteEvent = (RaceLogDenoteForTrackingEvent)new RaceInformationFinder(raceLog).analyze();
        Util.Pair trackingTimes = (Util.Pair)new TrackingTimesFinder(raceLog).analyze();
        if (!(this.trackedRegatta.getRegatta().isControlTrackingFromStartAndFinishTimes() || trackingTimes != null && trackingTimes.getA() != null && ((TimePointSpecificationFoundInLog)trackingTimes.getA()).getTimePoint() != null)) {
            raceLog.add((AbstractLogEvent)new RaceLogStartOfTrackingEventImpl(MillisecondsTimePoint.now(), this.raceLogEventAuthor, raceLog.getCurrentPassId()));
        }
        BoatClass boatClass = denoteEvent.getBoatClass();
        String raceName = denoteEvent.getRaceName();
        CourseBase courseBase = (CourseBase)new LastPublishedCourseDesignFinder(raceLog, true).analyze();
        if (courseBase == null) {
            courseBase = new CourseDataImpl("Default course for " + raceName + " in regatta " + this.trackedRegatta.getRegatta().getName());
            logger.log(Level.FINE, "Using empty course in creation of race " + raceName);
        }
        CourseImpl course = new CourseImpl(courseBase.getName() == null ? String.valueOf(raceName) + " course" : courseBase.getName(), courseBase.getWaypoints(), courseBase.getOriginatingCourseTemplateIdOrNull());
        if (raceColumn.getTrackedRace(fleet) != null) {
            if (event != null) {
                try {
                    raceLog.revokeEvent(this.params.getServerAuthor(), (AbstractLogEvent)event, "could not start tracking because tracked race already exists");
                }
                catch (NotRevokableException e) {
                    logger.log(Level.WARNING, "Couldn't revoke event " + event, e);
                }
            }
            throw new RaceNotCreatedException(String.format("Race for racelog (%s) has already been created", raceLog));
        }
        Map competitorsAndTheirBoats = raceColumn.getAllCompetitorsAndTheirBoats(this.params.getFleet());
        Serializable raceId = denoteEvent.getRaceId();
        try {
            RaceDefinition raceDef = this.raceTrackingHandler.createRaceDefinition(this.trackedRegatta.getRegatta(), raceName, (Course)course, boatClass, competitorsAndTheirBoats, raceId);
            List sidelines = Collections.emptyList();
            this.trackedRegatta.getRegatta().addRace(raceDef);
            raceColumn.setRaceIdentifier(fleet, (RaceIdentifier)this.trackedRegatta.getRegatta().getRaceIdentifier(raceDef));
            this.trackedRace = this.raceTrackingHandler.createTrackedRace((TrackedRegatta)this.trackedRegatta, raceDef, sidelines, this.windStore, this.params.getDelayToLiveInMillis(), 30000L, boatClass.getApproximateManeuverDurationInMilliseconds(), null, true, this.raceLogResolver, Optional.empty(), (TrackingConnectorInfo)new TrackingConnectorInfoImpl("RaceLog", RaceLogTrackingAdapter.DEFAULT_URL, null), this.markPassingRaceFingerprintRegistry, this.maneuverRaceFingerprintRegistry);
            this.notifyRaceCreationListeners();
            logger.info(String.format("Started tracking race-log race (%s)", raceLog));
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Error while creating race " + raceName + " for regatta " + this.trackedRegatta.getRegatta(), exception);
            try {
                this.trackedRegattaRegistry.stopTracker(this.trackedRegatta.getRegatta(), (RaceTracker)this);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Something else went wrong while trying to notify the TrackedRegattaRegistry that the race  could not be added to the the regatta " + this.trackedRegatta.getRegatta(), e);
            }
        }
        RaceLogRaceTracker raceLogRaceTracker = this;
        synchronized (raceLogRaceTracker) {
            ((Object)((Object)this)).notifyAll();
        }
        this.registerListenerThatWillRemoveThisRaceWhenTheRaceColumnIsRemoved();
    }

    private void registerListenerThatWillRemoveThisRaceWhenTheRaceColumnIsRemoved() {
        this.getRegatta().addRaceColumnListener((RaceColumnListener)new RaceColumnListenerWithDefaultAction(){
            private static final long serialVersionUID = -2924864263579432528L;

            public void defaultAction() {
            }

            public void raceColumnRemovedFromContainer(RaceColumn raceColumn) {
                try {
                    RaceDefinition race = RaceLogRaceTracker.this.getRace();
                    for (Fleet fleet : raceColumn.getFleets()) {
                        if (!race.equals(raceColumn.getRaceDefinition(fleet))) continue;
                        RaceLogRaceTracker.this.trackedRegattaRegistry.removeRace(RaceLogRaceTracker.this.getRegatta(), race);
                        break;
                    }
                }
                catch (IOException | InterruptedException e) {
                    logger.log(Level.WARNING, "Error trying to remove smart phone / race log tracked race whose race column was deleted: " + e.getMessage(), e);
                }
            }

            public boolean isTransient() {
                return true;
            }
        });
    }
}

