/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies that WAF should block the request and optionally defines additional custom handling for the response to the
 * web request.
 * </p>
 * <p>
 * This is used in the context of other settings, for example to specify values for <a>RuleAction</a> and web ACL
 * <a>DefaultAction</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockAction implements SdkPojo, Serializable, ToCopyableBuilder<BlockAction.Builder, BlockAction> {
    private static final SdkField<CustomResponse> CUSTOM_RESPONSE_FIELD = SdkField
            .<CustomResponse> builder(MarshallingType.SDK_POJO).memberName("CustomResponse")
            .getter(getter(BlockAction::customResponse)).setter(setter(Builder::customResponse))
            .constructor(CustomResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomResponse customResponse;

    private BlockAction(BuilderImpl builder) {
        this.customResponse = builder.customResponse;
    }

    /**
     * <p>
     * Defines a custom response for the web request.
     * </p>
     * <p>
     * For information about customizing web requests and responses, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web
     * requests and responses in WAF</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * 
     * @return Defines a custom response for the web request.</p>
     *         <p>
     *         For information about customizing web requests and responses, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing
     *         web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>.
     */
    public final CustomResponse customResponse() {
        return customResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockAction)) {
            return false;
        }
        BlockAction other = (BlockAction) obj;
        return Objects.equals(customResponse(), other.customResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlockAction").add("CustomResponse", customResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomResponse":
            return Optional.ofNullable(clazz.cast(customResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomResponse", CUSTOM_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlockAction, T> g) {
        return obj -> g.apply((BlockAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockAction> {
        /**
         * <p>
         * Defines a custom response for the web request.
         * </p>
         * <p>
         * For information about customizing web requests and responses, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web
         * requests and responses in WAF</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * 
         * @param customResponse
         *        Defines a custom response for the web request.</p>
         *        <p>
         *        For information about customizing web requests and responses, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html"
         *        >Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customResponse(CustomResponse customResponse);

        /**
         * <p>
         * Defines a custom response for the web request.
         * </p>
         * <p>
         * For information about customizing web requests and responses, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web
         * requests and responses in WAF</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomResponse.Builder} avoiding the need
         * to create one manually via {@link CustomResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #customResponse(CustomResponse)}.
         * 
         * @param customResponse
         *        a consumer that will call methods on {@link CustomResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customResponse(CustomResponse)
         */
        default Builder customResponse(Consumer<CustomResponse.Builder> customResponse) {
            return customResponse(CustomResponse.builder().applyMutation(customResponse).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomResponse customResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockAction model) {
            customResponse(model.customResponse);
        }

        public final CustomResponse.Builder getCustomResponse() {
            return customResponse != null ? customResponse.toBuilder() : null;
        }

        public final void setCustomResponse(CustomResponse.BuilderImpl customResponse) {
            this.customResponse = customResponse != null ? customResponse.build() : null;
        }

        @Override
        public final Builder customResponse(CustomResponse customResponse) {
            this.customResponse = customResponse;
            return this;
        }

        @Override
        public BlockAction build() {
            return new BlockAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
