/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The public DNS names of the endpoint, including IPv4-only and dualstack DNS names.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceConnectEndpointPublicDnsNames implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceConnectEndpointPublicDnsNames.Builder, InstanceConnectEndpointPublicDnsNames> {
    private static final SdkField<InstanceConnectEndpointDnsNames> IPV4_FIELD = SdkField
            .<InstanceConnectEndpointDnsNames> builder(MarshallingType.SDK_POJO)
            .memberName("Ipv4")
            .getter(getter(InstanceConnectEndpointPublicDnsNames::ipv4))
            .setter(setter(Builder::ipv4))
            .constructor(InstanceConnectEndpointDnsNames::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4")
                    .unmarshallLocationName("ipv4").build()).build();

    private static final SdkField<InstanceConnectEndpointDnsNames> DUALSTACK_FIELD = SdkField
            .<InstanceConnectEndpointDnsNames> builder(MarshallingType.SDK_POJO)
            .memberName("Dualstack")
            .getter(getter(InstanceConnectEndpointPublicDnsNames::dualstack))
            .setter(setter(Builder::dualstack))
            .constructor(InstanceConnectEndpointDnsNames::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dualstack")
                    .unmarshallLocationName("dualstack").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV4_FIELD, DUALSTACK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InstanceConnectEndpointDnsNames ipv4;

    private final InstanceConnectEndpointDnsNames dualstack;

    private InstanceConnectEndpointPublicDnsNames(BuilderImpl builder) {
        this.ipv4 = builder.ipv4;
        this.dualstack = builder.dualstack;
    }

    /**
     * <p>
     * The IPv4-only DNS name of the EC2 Instance Connect Endpoint.
     * </p>
     * 
     * @return The IPv4-only DNS name of the EC2 Instance Connect Endpoint.
     */
    public final InstanceConnectEndpointDnsNames ipv4() {
        return ipv4;
    }

    /**
     * <p>
     * The dualstack DNS name of the EC2 Instance Connect Endpoint. A dualstack DNS name supports connections from both
     * IPv4 and IPv6 clients.
     * </p>
     * 
     * @return The dualstack DNS name of the EC2 Instance Connect Endpoint. A dualstack DNS name supports connections
     *         from both IPv4 and IPv6 clients.
     */
    public final InstanceConnectEndpointDnsNames dualstack() {
        return dualstack;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipv4());
        hashCode = 31 * hashCode + Objects.hashCode(dualstack());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceConnectEndpointPublicDnsNames)) {
            return false;
        }
        InstanceConnectEndpointPublicDnsNames other = (InstanceConnectEndpointPublicDnsNames) obj;
        return Objects.equals(ipv4(), other.ipv4()) && Objects.equals(dualstack(), other.dualstack());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceConnectEndpointPublicDnsNames").add("Ipv4", ipv4()).add("Dualstack", dualstack())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv4":
            return Optional.ofNullable(clazz.cast(ipv4()));
        case "Dualstack":
            return Optional.ofNullable(clazz.cast(dualstack()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Ipv4", IPV4_FIELD);
        map.put("Dualstack", DUALSTACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceConnectEndpointPublicDnsNames, T> g) {
        return obj -> g.apply((InstanceConnectEndpointPublicDnsNames) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceConnectEndpointPublicDnsNames> {
        /**
         * <p>
         * The IPv4-only DNS name of the EC2 Instance Connect Endpoint.
         * </p>
         * 
         * @param ipv4
         *        The IPv4-only DNS name of the EC2 Instance Connect Endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4(InstanceConnectEndpointDnsNames ipv4);

        /**
         * <p>
         * The IPv4-only DNS name of the EC2 Instance Connect Endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceConnectEndpointDnsNames.Builder}
         * avoiding the need to create one manually via {@link InstanceConnectEndpointDnsNames#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceConnectEndpointDnsNames.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv4(InstanceConnectEndpointDnsNames)}.
         * 
         * @param ipv4
         *        a consumer that will call methods on {@link InstanceConnectEndpointDnsNames.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv4(InstanceConnectEndpointDnsNames)
         */
        default Builder ipv4(Consumer<InstanceConnectEndpointDnsNames.Builder> ipv4) {
            return ipv4(InstanceConnectEndpointDnsNames.builder().applyMutation(ipv4).build());
        }

        /**
         * <p>
         * The dualstack DNS name of the EC2 Instance Connect Endpoint. A dualstack DNS name supports connections from
         * both IPv4 and IPv6 clients.
         * </p>
         * 
         * @param dualstack
         *        The dualstack DNS name of the EC2 Instance Connect Endpoint. A dualstack DNS name supports connections
         *        from both IPv4 and IPv6 clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dualstack(InstanceConnectEndpointDnsNames dualstack);

        /**
         * <p>
         * The dualstack DNS name of the EC2 Instance Connect Endpoint. A dualstack DNS name supports connections from
         * both IPv4 and IPv6 clients.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceConnectEndpointDnsNames.Builder}
         * avoiding the need to create one manually via {@link InstanceConnectEndpointDnsNames#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceConnectEndpointDnsNames.Builder#build()} is called
         * immediately and its result is passed to {@link #dualstack(InstanceConnectEndpointDnsNames)}.
         * 
         * @param dualstack
         *        a consumer that will call methods on {@link InstanceConnectEndpointDnsNames.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dualstack(InstanceConnectEndpointDnsNames)
         */
        default Builder dualstack(Consumer<InstanceConnectEndpointDnsNames.Builder> dualstack) {
            return dualstack(InstanceConnectEndpointDnsNames.builder().applyMutation(dualstack).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InstanceConnectEndpointDnsNames ipv4;

        private InstanceConnectEndpointDnsNames dualstack;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceConnectEndpointPublicDnsNames model) {
            ipv4(model.ipv4);
            dualstack(model.dualstack);
        }

        public final InstanceConnectEndpointDnsNames.Builder getIpv4() {
            return ipv4 != null ? ipv4.toBuilder() : null;
        }

        public final void setIpv4(InstanceConnectEndpointDnsNames.BuilderImpl ipv4) {
            this.ipv4 = ipv4 != null ? ipv4.build() : null;
        }

        @Override
        public final Builder ipv4(InstanceConnectEndpointDnsNames ipv4) {
            this.ipv4 = ipv4;
            return this;
        }

        public final InstanceConnectEndpointDnsNames.Builder getDualstack() {
            return dualstack != null ? dualstack.toBuilder() : null;
        }

        public final void setDualstack(InstanceConnectEndpointDnsNames.BuilderImpl dualstack) {
            this.dualstack = dualstack != null ? dualstack.build() : null;
        }

        @Override
        public final Builder dualstack(InstanceConnectEndpointDnsNames dualstack) {
            this.dualstack = dualstack;
            return this;
        }

        @Override
        public InstanceConnectEndpointPublicDnsNames build() {
            return new InstanceConnectEndpointPublicDnsNames(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
