/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the CloudWatch math expression that provides the time series the anomaly detector uses as input. The
 * designated math expression must return a single time series.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricMathAnomalyDetector implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricMathAnomalyDetector.Builder, MetricMathAnomalyDetector> {
    private static final SdkField<List<MetricDataQuery>> METRIC_DATA_QUERIES_FIELD = SdkField
            .<List<MetricDataQuery>> builder(MarshallingType.LIST)
            .memberName("MetricDataQueries")
            .getter(getter(MetricMathAnomalyDetector::metricDataQueries))
            .setter(setter(Builder::metricDataQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDataQueries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDataQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDataQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DATA_QUERIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<MetricDataQuery> metricDataQueries;

    private MetricMathAnomalyDetector(BuilderImpl builder) {
        this.metricDataQueries = builder.metricDataQueries;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricDataQueries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricDataQueries() {
        return metricDataQueries != null && !(metricDataQueries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of metric data query structures that enables you to create an anomaly detector based on the result of a
     * metric math expression. Each item in <code>MetricDataQueries</code> gets a metric or performs a math expression.
     * One item in <code>MetricDataQueries</code> is the expression that provides the time series that the anomaly
     * detector uses as input. Designate the expression by setting <code>ReturnData</code> to <code>true</code> for this
     * object in the array. For all other expressions and metrics, set <code>ReturnData</code> to <code>false</code>.
     * The designated expression must return a single time series.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricDataQueries} method.
     * </p>
     * 
     * @return An array of metric data query structures that enables you to create an anomaly detector based on the
     *         result of a metric math expression. Each item in <code>MetricDataQueries</code> gets a metric or performs
     *         a math expression. One item in <code>MetricDataQueries</code> is the expression that provides the time
     *         series that the anomaly detector uses as input. Designate the expression by setting
     *         <code>ReturnData</code> to <code>true</code> for this object in the array. For all other expressions and
     *         metrics, set <code>ReturnData</code> to <code>false</code>. The designated expression must return a
     *         single time series.
     */
    public final List<MetricDataQuery> metricDataQueries() {
        return metricDataQueries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricDataQueries() ? metricDataQueries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricMathAnomalyDetector)) {
            return false;
        }
        MetricMathAnomalyDetector other = (MetricMathAnomalyDetector) obj;
        return hasMetricDataQueries() == other.hasMetricDataQueries()
                && Objects.equals(metricDataQueries(), other.metricDataQueries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricMathAnomalyDetector")
                .add("MetricDataQueries", hasMetricDataQueries() ? metricDataQueries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricDataQueries":
            return Optional.ofNullable(clazz.cast(metricDataQueries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricDataQueries", METRIC_DATA_QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricMathAnomalyDetector, T> g) {
        return obj -> g.apply((MetricMathAnomalyDetector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricMathAnomalyDetector> {
        /**
         * <p>
         * An array of metric data query structures that enables you to create an anomaly detector based on the result
         * of a metric math expression. Each item in <code>MetricDataQueries</code> gets a metric or performs a math
         * expression. One item in <code>MetricDataQueries</code> is the expression that provides the time series that
         * the anomaly detector uses as input. Designate the expression by setting <code>ReturnData</code> to
         * <code>true</code> for this object in the array. For all other expressions and metrics, set
         * <code>ReturnData</code> to <code>false</code>. The designated expression must return a single time series.
         * </p>
         * 
         * @param metricDataQueries
         *        An array of metric data query structures that enables you to create an anomaly detector based on the
         *        result of a metric math expression. Each item in <code>MetricDataQueries</code> gets a metric or
         *        performs a math expression. One item in <code>MetricDataQueries</code> is the expression that provides
         *        the time series that the anomaly detector uses as input. Designate the expression by setting
         *        <code>ReturnData</code> to <code>true</code> for this object in the array. For all other expressions
         *        and metrics, set <code>ReturnData</code> to <code>false</code>. The designated expression must return
         *        a single time series.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDataQueries(Collection<MetricDataQuery> metricDataQueries);

        /**
         * <p>
         * An array of metric data query structures that enables you to create an anomaly detector based on the result
         * of a metric math expression. Each item in <code>MetricDataQueries</code> gets a metric or performs a math
         * expression. One item in <code>MetricDataQueries</code> is the expression that provides the time series that
         * the anomaly detector uses as input. Designate the expression by setting <code>ReturnData</code> to
         * <code>true</code> for this object in the array. For all other expressions and metrics, set
         * <code>ReturnData</code> to <code>false</code>. The designated expression must return a single time series.
         * </p>
         * 
         * @param metricDataQueries
         *        An array of metric data query structures that enables you to create an anomaly detector based on the
         *        result of a metric math expression. Each item in <code>MetricDataQueries</code> gets a metric or
         *        performs a math expression. One item in <code>MetricDataQueries</code> is the expression that provides
         *        the time series that the anomaly detector uses as input. Designate the expression by setting
         *        <code>ReturnData</code> to <code>true</code> for this object in the array. For all other expressions
         *        and metrics, set <code>ReturnData</code> to <code>false</code>. The designated expression must return
         *        a single time series.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDataQueries(MetricDataQuery... metricDataQueries);

        /**
         * <p>
         * An array of metric data query structures that enables you to create an anomaly detector based on the result
         * of a metric math expression. Each item in <code>MetricDataQueries</code> gets a metric or performs a math
         * expression. One item in <code>MetricDataQueries</code> is the expression that provides the time series that
         * the anomaly detector uses as input. Designate the expression by setting <code>ReturnData</code> to
         * <code>true</code> for this object in the array. For all other expressions and metrics, set
         * <code>ReturnData</code> to <code>false</code>. The designated expression must return a single time series.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #metricDataQueries(List<MetricDataQuery>)}.
         * 
         * @param metricDataQueries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDataQueries(java.util.Collection<MetricDataQuery>)
         */
        Builder metricDataQueries(Consumer<MetricDataQuery.Builder>... metricDataQueries);
    }

    static final class BuilderImpl implements Builder {
        private List<MetricDataQuery> metricDataQueries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricMathAnomalyDetector model) {
            metricDataQueries(model.metricDataQueries);
        }

        public final List<MetricDataQuery.Builder> getMetricDataQueries() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.metricDataQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDataQueries(Collection<MetricDataQuery.BuilderImpl> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copyFromBuilder(metricDataQueries);
        }

        @Override
        public final Builder metricDataQueries(Collection<MetricDataQuery> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copy(metricDataQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataQueries(MetricDataQuery... metricDataQueries) {
            metricDataQueries(Arrays.asList(metricDataQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataQueries(Consumer<MetricDataQuery.Builder>... metricDataQueries) {
            metricDataQueries(Stream.of(metricDataQueries).map(c -> MetricDataQuery.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public MetricMathAnomalyDetector build() {
            return new MetricMathAnomalyDetector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
