/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance reuse policy for a warm pool.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for Amazon
 * EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceReusePolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceReusePolicy.Builder, InstanceReusePolicy> {
    private static final SdkField<Boolean> REUSE_ON_SCALE_IN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReuseOnScaleIn").getter(getter(InstanceReusePolicy::reuseOnScaleIn))
            .setter(setter(Builder::reuseOnScaleIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReuseOnScaleIn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REUSE_ON_SCALE_IN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean reuseOnScaleIn;

    private InstanceReusePolicy(BuilderImpl builder) {
        this.reuseOnScaleIn = builder.reuseOnScaleIn;
    }

    /**
     * <p>
     * Specifies whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
     * </p>
     * 
     * @return Specifies whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
     */
    public final Boolean reuseOnScaleIn() {
        return reuseOnScaleIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reuseOnScaleIn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceReusePolicy)) {
            return false;
        }
        InstanceReusePolicy other = (InstanceReusePolicy) obj;
        return Objects.equals(reuseOnScaleIn(), other.reuseOnScaleIn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceReusePolicy").add("ReuseOnScaleIn", reuseOnScaleIn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReuseOnScaleIn":
            return Optional.ofNullable(clazz.cast(reuseOnScaleIn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReuseOnScaleIn", REUSE_ON_SCALE_IN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceReusePolicy, T> g) {
        return obj -> g.apply((InstanceReusePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceReusePolicy> {
        /**
         * <p>
         * Specifies whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
         * </p>
         * 
         * @param reuseOnScaleIn
         *        Specifies whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reuseOnScaleIn(Boolean reuseOnScaleIn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean reuseOnScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceReusePolicy model) {
            reuseOnScaleIn(model.reuseOnScaleIn);
        }

        public final Boolean getReuseOnScaleIn() {
            return reuseOnScaleIn;
        }

        public final void setReuseOnScaleIn(Boolean reuseOnScaleIn) {
            this.reuseOnScaleIn = reuseOnScaleIn;
        }

        @Override
        public final Builder reuseOnScaleIn(Boolean reuseOnScaleIn) {
            this.reuseOnScaleIn = reuseOnScaleIn;
            return this;
        }

        @Override
        public InstanceReusePolicy build() {
            return new InstanceReusePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
