/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.datamining.components.aggregators;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.polars.datamining.data.HasBackendPolarBoatClassContext;
import com.sap.sailing.polars.datamining.shared.PolarBackendData;
import com.sap.sailing.polars.datamining.shared.PolarBackendDataImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.SimpleAggregationProcessorDefinition;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;

public class PolarBackendDataAggregationProcessor
extends AbstractParallelGroupedDataAggregationProcessor<HasBackendPolarBoatClassContext, PolarBackendData> {
    private static final String POLARS_MESSAGE_KEY = "Polars";
    private final ConcurrentHashMap<GroupKey, PolarBackendData> resultMap = new ConcurrentHashMap();
    private static final AggregationProcessorDefinition<HasBackendPolarBoatClassContext, PolarBackendData> DEFINITION = new SimpleAggregationProcessorDefinition(HasBackendPolarBoatClassContext.class, PolarBackendData.class, "Polars", PolarBackendDataAggregationProcessor.class);

    public PolarBackendDataAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, PolarBackendData>, ?>> resultReceivers) {
        super(executor, resultReceivers, POLARS_MESSAGE_KEY);
    }

    public static AggregationProcessorDefinition<HasBackendPolarBoatClassContext, PolarBackendData> getDefinition() {
        return DEFINITION;
    }

    protected boolean needsSynchronization() {
        return false;
    }

    protected void handleElement(GroupedDataEntry<HasBackendPolarBoatClassContext> element) {
        PolarBackendData polarAggregation = this.createPolarBackendAggregation((HasBackendPolarBoatClassContext)element.getDataEntry());
        this.resultMap.put(element.getKey(), polarAggregation);
    }

    private PolarBackendData createPolarBackendAggregation(HasBackendPolarBoatClassContext dataEntry) {
        PolynomialFunction downwind;
        PolynomialFunction upwind;
        boolean hasUpwindSpeedData = true;
        double[] upwindBoatSpeedOverWindSpeed = new double[30];
        boolean hasDownwindSpeedData = true;
        double[] downwindBoatSpeedOverWindSpeed = new double[30];
        boolean hasUpwindAngleData = true;
        double[] upwindBoatAngleOverWindSpeed = new double[30];
        boolean hasDownwindAngleData = true;
        double[] downwindBoatAngleOverWindSpeed = new double[30];
        boolean[] hasDataForAngle = new boolean[360];
        double[][] speedPerAnglePerWindSpeed = new double[360][30];
        PolarDataService polarDataService = dataEntry.getPolarDataService();
        BoatClass boatClass = dataEntry.getBoatClass();
        try {
            upwind = polarDataService.getSpeedRegressionFunction(boatClass, LegType.UPWIND);
            this.setArrayValuesForFunction(upwind, upwindBoatSpeedOverWindSpeed);
        }
        catch (NotEnoughDataHasBeenAddedException e) {
            hasUpwindSpeedData = false;
        }
        try {
            downwind = polarDataService.getSpeedRegressionFunction(boatClass, LegType.DOWNWIND);
            this.setArrayValuesForFunction(downwind, downwindBoatSpeedOverWindSpeed);
        }
        catch (NotEnoughDataHasBeenAddedException e) {
            hasDownwindSpeedData = false;
        }
        try {
            upwind = polarDataService.getAngleRegressionFunction(boatClass, LegType.UPWIND);
            this.setArrayValuesForFunction(upwind, upwindBoatAngleOverWindSpeed);
        }
        catch (NotEnoughDataHasBeenAddedException e) {
            hasUpwindAngleData = false;
        }
        try {
            downwind = polarDataService.getAngleRegressionFunction(boatClass, LegType.DOWNWIND);
            this.setArrayValuesForFunction(downwind, downwindBoatAngleOverWindSpeed);
        }
        catch (NotEnoughDataHasBeenAddedException e) {
            hasDownwindAngleData = false;
        }
        int angleInDeg = 0;
        while (angleInDeg < 360) {
            if (this.isAborted()) break;
            int convertedAngle = angleInDeg > 180 ? angleInDeg - 360 : angleInDeg;
            try {
                int x = 0;
                while (x < 30) {
                    if (!this.isAborted()) {
                        SpeedWithConfidence speed = polarDataService.getSpeed(boatClass, (Speed)new KnotSpeedImpl((double)x), (Bearing)new DegreeBearingImpl((double)convertedAngle));
                        hasDataForAngle[angleInDeg] = speed.getConfidence() > 0.1;
                        speedPerAnglePerWindSpeed[angleInDeg][x] = ((Speed)speed.getObject()).getKnots();
                        ++x;
                        continue;
                    }
                    break;
                }
            }
            catch (NotEnoughDataHasBeenAddedException e) {
                hasDataForAngle[angleInDeg] = false;
            }
            ++angleInDeg;
        }
        return new PolarBackendDataImpl(hasUpwindSpeedData, upwindBoatSpeedOverWindSpeed, hasDownwindSpeedData, downwindBoatSpeedOverWindSpeed, hasUpwindAngleData, upwindBoatAngleOverWindSpeed, hasDownwindAngleData, downwindBoatAngleOverWindSpeed, hasDataForAngle, speedPerAnglePerWindSpeed);
    }

    protected Map<GroupKey, PolarBackendData> getResult() {
        return this.resultMap;
    }

    private void setArrayValuesForFunction(PolynomialFunction function, double[] yOverWindSpeed) {
        int x = 0;
        while (x < 30) {
            if (this.isAborted()) break;
            yOverWindSpeed[x] = function.value((double)x);
            ++x;
        }
    }
}

