/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.barbados.resultimport.impl;

import com.sap.sailing.barbados.resultimport.impl.BarbadosResultSpreadsheet;
import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.resultimport.RegattaResults;
import com.sap.sailing.resultimport.ResultDocumentDescriptor;
import com.sap.sailing.resultimport.ResultDocumentProvider;
import com.sap.sailing.resultimport.impl.AbstractDocumentBasedScoreCorrectionProvider;
import com.sap.sailing.resultimport.impl.RegattaScoreCorrectionsImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScoreCorrectionProviderImpl
extends AbstractDocumentBasedScoreCorrectionProvider {
    private static final Logger logger = Logger.getLogger(ScoreCorrectionProviderImpl.class.getName());
    public static final String BOATCLASS_NAME_METADATA_PROPERTY = "boatclassName";
    private static final long serialVersionUID = -5501186796881875686L;
    private static final String name = "Barbados 2013 505 Worlds Excel Result Importer";

    public ScoreCorrectionProviderImpl(ResultDocumentProvider resultDocumentProvider) {
        super(resultDocumentProvider);
    }

    public String getName() {
        return name;
    }

    public Map<String, Set<Util.Pair<String, TimePoint>>> getHasResultsForBoatClassFromDateByEventName() throws Exception {
        HashMap<String, Set<Util.Pair<String, TimePoint>>> result = new HashMap<String, Set<Util.Pair<String, TimePoint>>>();
        for (ResultDocumentDescriptor resultDocDescr : this.getResultDocumentProvider().getResultDocumentDescriptors()) {
            try {
                RegattaResults regattaResults = new BarbadosResultSpreadsheet(resultDocDescr.getInputStream()).getRegattaResults();
                TimePoint lastModified = resultDocDescr.getLastModified();
                String boatClassName = this.getBoatClassName(regattaResults);
                HashSet<Util.Pair> set = (HashSet<Util.Pair>)result.get(boatClassName);
                if (set == null) {
                    set = new HashSet<Util.Pair>();
                    result.put(resultDocDescr.getDocumentName(), set);
                }
                set.add(new Util.Pair((Object)boatClassName, (Object)lastModified));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Couldn't parse Barbados result document " + resultDocDescr.getDocumentName(), e);
            }
        }
        return result;
    }

    private String getBoatClassName(RegattaResults regattaResult) {
        Map metadata = regattaResult.getMetadata();
        return (String)metadata.get(BOATCLASS_NAME_METADATA_PROPERTY);
    }

    public RegattaScoreCorrections getScoreCorrections(String eventName, String boatClassName, TimePoint timePoint) throws Exception {
        for (ResultDocumentDescriptor resultDocDescr : this.getResultDocumentProvider().getResultDocumentDescriptors()) {
            if (!resultDocDescr.getLastModified().equals(timePoint)) continue;
            try {
                RegattaResults regattaResults = new BarbadosResultSpreadsheet(resultDocDescr.getInputStream()).getRegattaResults();
                if ((boatClassName != null || this.getBoatClassName(regattaResults) != null) && !boatClassName.equals(this.getBoatClassName(regattaResults))) continue;
                return new RegattaScoreCorrectionsImpl((ScoreCorrectionProvider)this, regattaResults);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Couldn't parse Barbados result document " + resultDocDescr.getDocumentName(), e);
            }
        }
        return null;
    }

    public RegattaScoreCorrections getScoreCorrections(InputStream inputStream) throws Exception {
        RegattaResults regattaResults = new BarbadosResultSpreadsheet(inputStream).getRegattaResults();
        return new RegattaScoreCorrectionsImpl((ScoreCorrectionProvider)this, regattaResults);
    }
}

