/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.common.shared;

import com.sap.sse.common.Util;
import com.sap.sse.landscape.aws.common.shared.EventRedirectDTO;
import com.sap.sse.landscape.aws.common.shared.EventSeriesRedirectDTO;
import com.sap.sse.landscape.aws.common.shared.HomeRedirectDTO;
import com.sap.sse.landscape.aws.common.shared.PlainRedirectDTO;
import com.sap.sse.landscape.aws.common.shared.RedirectVisitor;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;

public interface RedirectDTO
extends Serializable {
    public String getPath();

    default public Optional<String> getQuery() {
        return Optional.of("#{query}");
    }

    default public String getPathAndQuery() {
        return RedirectDTO.toString(this.getPath(), this.getQuery());
    }

    public static String toString(String path, Optional<String> query) {
        return String.valueOf(path) + query.map(q -> !Util.hasLength((String)q) ? "" : "?" + q).orElse("");
    }

    public static String getPath(String redirectPath) {
        int queryStart = redirectPath.indexOf("?");
        return queryStart < 0 ? redirectPath : redirectPath.substring(0, queryStart);
    }

    public static String getQuery(String redirectPath) {
        int queryStart = redirectPath.indexOf("?");
        return queryStart < 0 ? "" : redirectPath.substring(queryStart + 1);
    }

    public Type getType();

    public void accept(RedirectVisitor var1) throws Exception;

    public static RedirectDTO from(String redirectPath) {
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            RedirectDTO redirect = (RedirectDTO)type.getParserFromPathAndQuery().apply(redirectPath);
            if (redirect != null) {
                return redirect;
            }
            ++n2;
        }
        return null;
    }

    public static enum Type {
        PLAIN(PlainRedirectDTO::parse),
        HOME(HomeRedirectDTO::parse),
        EVENT(EventRedirectDTO::parse),
        EVENT_SERIES(EventSeriesRedirectDTO::parse);

        private Function<String, RedirectDTO> parserFromPathAndQuery;

        private Type(Function<String, RedirectDTO> parserFromPathAndQuery) {
            this.parserFromPathAndQuery = parserFromPathAndQuery;
        }

        private Function<String, RedirectDTO> getParserFromPathAndQuery() {
            return this.parserFromPathAndQuery;
        }
    }
}

