/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.xrr.resultimport.impl;

import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.resultimport.ResultDocumentDescriptor;
import com.sap.sailing.resultimport.ResultDocumentProvider;
import com.sap.sailing.resultimport.impl.AbstractDocumentBasedScoreCorrectionProvider;
import com.sap.sailing.xrr.resultimport.Parser;
import com.sap.sailing.xrr.resultimport.ParserFactory;
import com.sap.sailing.xrr.resultimport.impl.XRRParserUtil;
import com.sap.sailing.xrr.schema.Division;
import com.sap.sailing.xrr.schema.Event;
import com.sap.sailing.xrr.schema.RegattaResults;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ScoreCorrectionProviderImpl
extends AbstractDocumentBasedScoreCorrectionProvider {
    private static final Logger logger = Logger.getLogger(ScoreCorrectionProviderImpl.class.getName());
    private static final long serialVersionUID = -4596215011753860781L;
    private static final String name = "ISAF XML Regatta Result (XRR) Importer";
    private final ParserFactory parserFactory;

    public ScoreCorrectionProviderImpl(ResultDocumentProvider documentProvider, ParserFactory parserFactory) {
        super(documentProvider);
        this.parserFactory = parserFactory;
    }

    public String getName() {
        return name;
    }

    public Map<String, Set<Util.Pair<String, TimePoint>>> getHasResultsForBoatClassFromDateByEventName() throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        HashMap<String, Set<Util.Pair<String, TimePoint>>> result = new HashMap<String, Set<Util.Pair<String, TimePoint>>>();
        for (Parser parser : this.getAllRegattaResults()) {
            try {
                RegattaResults regattaResult = parser.parse();
                TimePoint timePoint = XRRParserUtil.calculateTimePointForRegattaResults(regattaResult);
                for (Object o : regattaResult.getPersonOrBoatOrTeam()) {
                    if (!(o instanceof Event)) continue;
                    Event event = (Event)o;
                    for (Object eventO : event.getRaceOrDivisionOrRegattaSeriesResult()) {
                        if (!(eventO instanceof Division)) continue;
                        Division division = (Division)eventO;
                        String boatClassName = parser.getBoatClassName(division);
                        HashSet<Util.Pair> set = (HashSet<Util.Pair>)result.get(event.getTitle());
                        if (set == null) {
                            set = new HashSet<Util.Pair>();
                            result.put(event.getTitle(), set);
                        }
                        set.add(new Util.Pair((Object)boatClassName, (Object)timePoint));
                    }
                }
            }
            catch (JAXBException e) {
                logger.info("Parse error during XRR import. Ignoring document " + parser.toString());
                logger.throwing(ScoreCorrectionProviderImpl.class.getName(), "getHasResultsForBoatClassFromDateByEventName", e);
            }
        }
        return result;
    }

    public RegattaScoreCorrections getScoreCorrections(String eventName, String boatClassName, TimePoint timePointPublished) throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        for (Parser parser : this.getAllRegattaResults()) {
            try {
                RegattaResults regattaResults = parser.parse();
                TimePoint timePoint = XRRParserUtil.calculateTimePointForRegattaResults(regattaResults);
                if ((timePoint != null || timePointPublished != null) && (timePoint == null || !timePoint.equals(timePointPublished))) continue;
                return parser.getRegattaScoreCorrections(regattaResults, (ScoreCorrectionProvider)this, Optional.of(eventName), Optional.of(boatClassName));
            }
            catch (JAXBException e) {
                logger.info("Parse error during XRR import. Ignoring document " + parser.toString());
                logger.throwing(ScoreCorrectionProviderImpl.class.getName(), "getHasResultsForBoatClassFromDateByEventName", e);
            }
        }
        return null;
    }

    public RegattaScoreCorrections getScoreCorrections(InputStream inputStream) throws Exception {
        Parser parser = this.parserFactory.createParser(inputStream, inputStream.toString());
        RegattaResults regattaResults = parser.parse();
        return parser.getRegattaScoreCorrections(regattaResults, (ScoreCorrectionProvider)this, Optional.empty(), Optional.empty());
    }

    private Iterable<Parser> getAllRegattaResults() throws SAXException, IOException, ParserConfigurationException, URISyntaxException {
        ArrayList<Parser> result = new ArrayList<Parser>();
        for (ResultDocumentDescriptor resultDocDescr : this.getResultDocumentProvider().getResultDocumentDescriptors()) {
            Parser parser = this.parserFactory.createParser(resultDocDescr.getInputStream(), resultDocDescr.getDocumentName());
            result.add(parser);
        }
        return result;
    }
}

